/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.internal;

import com.sun.istack.internal.NotNull;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentLinkedQueue;

public interface Pool<T> {
    @NotNull
    public T take();

    public void recycle(@NotNull T var1);

    public static abstract class Impl<T>
    implements Pool<T> {
        private volatile WeakReference<ConcurrentLinkedQueue<T>> queue;

        @Override
        @NotNull
        public final T take() {
            T t = this.getQueue().poll();
            if (t == null) {
                return this.create();
            }
            return t;
        }

        @Override
        public final void recycle(T t) {
            this.getQueue().offer(t);
        }

        private ConcurrentLinkedQueue<T> getQueue() {
            ConcurrentLinkedQueue concurrentLinkedQueue;
            WeakReference<ConcurrentLinkedQueue<T>> weakReference = this.queue;
            if (weakReference != null && (concurrentLinkedQueue = (ConcurrentLinkedQueue)weakReference.get()) != null) {
                return concurrentLinkedQueue;
            }
            concurrentLinkedQueue = new ConcurrentLinkedQueue();
            this.queue = new WeakReference(concurrentLinkedQueue);
            return concurrentLinkedQueue;
        }

        @NotNull
        protected abstract T create();
    }
}

