/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TextInputControlBehavior;
import com.sun.javafx.scene.control.behavior.TextInputControlBindings;
import com.sun.javafx.scene.control.skin.TextAreaSkin;
import com.sun.javafx.scene.text.HitInfo;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.Screen;
import javafx.stage.Window;

public class TextAreaBehavior
extends TextInputControlBehavior<TextArea> {
    protected static final List<KeyBinding> TEXT_AREA_BINDINGS = new ArrayList<KeyBinding>();
    private TextAreaSkin skin;
    private ContextMenu contextMenu = new ContextMenu();
    private boolean focusGainedByMouseClick = false;
    private boolean shiftDown = false;
    private boolean deferClick = false;

    public TextAreaBehavior(TextArea textArea) {
        super(textArea);
        if (PlatformUtil.isEmbedded()) {
            this.contextMenu.getStyleClass().add("text-input-context-menu");
        }
        textArea.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                TextArea textArea = (TextArea)TextAreaBehavior.this.getControl();
                if (textArea.isFocused()) {
                    if (!TextAreaBehavior.this.focusGainedByMouseClick) {
                        TextAreaBehavior.this.setCaretAnimating(true);
                    }
                } else {
                    TextAreaBehavior.this.focusGainedByMouseClick = false;
                    TextAreaBehavior.this.setCaretAnimating(false);
                }
            }
        });
    }

    public void setTextAreaSkin(TextAreaSkin textAreaSkin) {
        this.skin = textAreaSkin;
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return TEXT_AREA_BINDINGS;
    }

    @Override
    public void callAction(String string) {
        TextArea textArea = (TextArea)this.getControl();
        boolean bl = false;
        if (textArea.isEditable()) {
            this.setEditing(true);
            bl = true;
            if ("InsertNewLine".equals(string)) {
                this.insertNewLine();
            } else if ("InsertTab".equals(string)) {
                this.insertTab();
            } else {
                bl = false;
            }
            this.setEditing(false);
        }
        if (!bl) {
            bl = true;
            if ("LineStart".equals(string)) {
                this.skin.lineStart(false, false);
            } else if ("LineEnd".equals(string)) {
                this.skin.lineEnd(false, false);
            } else if ("SelectLineStart".equals(string)) {
                this.skin.lineStart(true, false);
            } else if ("SelectLineStartExtend".equals(string)) {
                this.skin.lineStart(true, true);
            } else if ("SelectLineEnd".equals(string)) {
                this.skin.lineEnd(true, false);
            } else if ("SelectLineEndExtend".equals(string)) {
                this.skin.lineEnd(true, true);
            } else if ("PreviousLine".equals(string)) {
                this.skin.previousLine(false);
            } else if ("NextLine".equals(string)) {
                this.skin.nextLine(false);
            } else if ("SelectPreviousLine".equals(string)) {
                this.skin.previousLine(true);
            } else if ("SelectNextLine".equals(string)) {
                this.skin.nextLine(true);
            } else if ("ParagraphStart".equals(string)) {
                this.skin.paragraphStart(true, false);
            } else if ("ParagraphEnd".equals(string)) {
                this.skin.paragraphEnd(true, false);
            } else if ("SelectParagraphStart".equals(string)) {
                this.skin.paragraphStart(true, true);
            } else if ("SelectParagraphEnd".equals(string)) {
                this.skin.paragraphEnd(true, true);
            } else if ("PreviousPage".equals(string)) {
                this.skin.previousPage(false);
            } else if ("NextPage".equals(string)) {
                this.skin.nextPage(false);
            } else if ("SelectPreviousPage".equals(string)) {
                this.skin.previousPage(true);
            } else if ("SelectNextPage".equals(string)) {
                this.skin.nextPage(true);
            } else {
                bl = false;
            }
        }
        if (!bl) {
            super.callAction(string);
        }
    }

    private void insertNewLine() {
        TextArea textArea = (TextArea)this.getControl();
        IndexRange indexRange = textArea.getSelection();
        int n = indexRange.getStart();
        int n2 = indexRange.getEnd();
        this.getUndoManager().addChange(n, textArea.getText().substring(n, n2), "\n", false);
        textArea.replaceSelection("\n");
    }

    private void insertTab() {
        TextArea textArea = (TextArea)this.getControl();
        IndexRange indexRange = textArea.getSelection();
        int n = indexRange.getStart();
        int n2 = indexRange.getEnd();
        this.getUndoManager().addChange(n, textArea.getText().substring(n, n2), "\t", false);
        textArea.replaceSelection("\t");
    }

    @Override
    protected void deleteChar(boolean bl) {
        this.skin.deleteChar(bl);
    }

    @Override
    protected void scrollCharacterToVisible(int n) {
        this.skin.scrollCharacterToVisible(n);
    }

    @Override
    protected void replaceText(int n, int n2, String string) {
        ((TextArea)this.getControl()).replaceText(n, n2, string);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TextArea textArea = (TextArea)this.getControl();
        super.mousePressed(mouseEvent);
        if (!textArea.isDisabled()) {
            if (!textArea.isFocused()) {
                this.focusGainedByMouseClick = true;
                textArea.requestFocus();
            }
            this.setCaretAnimating(false);
            if (mouseEvent.getButton() == MouseButton.PRIMARY && !mouseEvent.isMiddleButtonDown() && !mouseEvent.isSecondaryButtonDown()) {
                HitInfo hitInfo = this.skin.getIndex(mouseEvent);
                int n = hitInfo.getInsertionIndex();
                int n2 = textArea.getAnchor();
                int n3 = textArea.getCaretPosition();
                if (mouseEvent.getClickCount() < 2 && (PlatformUtil.isEmbedded() || n2 != n3 && (n > n2 && n < n3 || n < n2 && n > n3))) {
                    this.deferClick = true;
                } else if (!(mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isShiftDown() || mouseEvent.isMetaDown())) {
                    switch (mouseEvent.getClickCount()) {
                        case 1: {
                            this.skin.positionCaret(hitInfo, false, false);
                            break;
                        }
                        case 2: {
                            this.mouseDoubleClick(hitInfo);
                            break;
                        }
                        case 3: {
                            this.mouseTripleClick(hitInfo);
                        }
                    }
                } else if (mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && !mouseEvent.isAltDown() && !mouseEvent.isMetaDown() && mouseEvent.getClickCount() == 1) {
                    this.shiftDown = true;
                    if (PlatformUtil.isMac()) {
                        textArea.extendSelection(n);
                    } else {
                        this.skin.positionCaret(hitInfo, true, false);
                    }
                }
            }
            if (this.contextMenu.isShowing()) {
                this.contextMenu.hide();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        TextArea textArea = (TextArea)this.getControl();
        if (!(textArea.isDisabled() || this.deferClick || mouseEvent.getButton() != MouseButton.PRIMARY || mouseEvent.isMiddleButtonDown() || mouseEvent.isSecondaryButtonDown() || mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isShiftDown() || mouseEvent.isMetaDown())) {
            this.skin.positionCaret(this.skin.getIndex(mouseEvent), true, false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        TextArea textArea = (TextArea)this.getControl();
        super.mouseReleased(mouseEvent);
        if (!textArea.isDisabled()) {
            this.setCaretAnimating(false);
            if (this.deferClick) {
                this.deferClick = false;
                this.skin.positionCaret(this.skin.getIndex(mouseEvent), this.shiftDown, false);
                this.shiftDown = false;
            }
            this.setCaretAnimating(true);
        }
        if (mouseEvent.getButton() == MouseButton.SECONDARY) {
            if (this.contextMenu.isShowing()) {
                this.contextMenu.hide();
            } else {
                Object object;
                double d = mouseEvent.getScreenX();
                double d2 = mouseEvent.getScreenY();
                double d3 = mouseEvent.getSceneX();
                if (PlatformUtil.isEmbedded()) {
                    Point2D point2D;
                    if (textArea.getSelection().getLength() == 0) {
                        this.skin.positionCaret(this.skin.getIndex(mouseEvent), false, false);
                        point2D = this.skin.getMenuPosition();
                    } else {
                        point2D = this.skin.getMenuPosition();
                        if (point2D != null && (point2D.getX() <= 0.0 || point2D.getY() <= 0.0)) {
                            this.skin.positionCaret(this.skin.getIndex(mouseEvent), false, false);
                            point2D = this.skin.getMenuPosition();
                        }
                    }
                    if (point2D != null) {
                        Point2D point2D2 = this.skin.localToScene(point2D);
                        Scene scene = this.skin.getScene();
                        Window window = scene.getWindow();
                        object = new Point2D(window.getX() + scene.getX() + point2D2.getX(), window.getY() + scene.getY() + point2D2.getY());
                        d = ((Point2D)object).getX();
                        d3 = point2D2.getX();
                        d2 = ((Point2D)object).getY();
                    }
                }
                this.skin.populateContextMenu(this.contextMenu);
                double d4 = this.contextMenu.prefWidth(-1.0);
                double d5 = d - (PlatformUtil.isEmbedded() ? d4 / 2.0 : 0.0);
                object = Utils.getScreenForPoint(d, 0.0);
                Rectangle2D rectangle2D = ((Screen)object).getBounds();
                if (d5 < rectangle2D.getMinX()) {
                    this.skin.getProperties().put("CONTEXT_MENU_SCREEN_X", d);
                    this.skin.getProperties().put("CONTEXT_MENU_SCENE_X", d3);
                    this.contextMenu.show((Node)this.getControl(), rectangle2D.getMinX(), d2);
                } else if (d + d4 > rectangle2D.getMaxX()) {
                    double d6 = d4 - (rectangle2D.getMaxX() - d);
                    this.skin.getProperties().put("CONTEXT_MENU_SCREEN_X", d);
                    this.skin.getProperties().put("CONTEXT_MENU_SCENE_X", d3);
                    this.contextMenu.show((Node)this.getControl(), d - d6, d2);
                } else {
                    this.skin.getProperties().put("CONTEXT_MENU_SCREEN_X", 0);
                    this.skin.getProperties().put("CONTEXT_MENU_SCENE_X", 0);
                    this.contextMenu.show((Node)this.getControl(), d5, d2);
                }
            }
        }
    }

    @Override
    protected void setCaretAnimating(boolean bl) {
        this.skin.setCaretAnimating(bl);
    }

    protected void mouseDoubleClick(HitInfo hitInfo) {
        TextArea textArea = (TextArea)this.getControl();
        textArea.previousWord();
        if (PlatformUtil.isWindows()) {
            textArea.selectNextWord();
        } else {
            textArea.selectEndOfNextWord();
        }
    }

    protected void mouseTripleClick(HitInfo hitInfo) {
        this.skin.paragraphStart(false, false);
        this.skin.paragraphEnd(false, true);
    }

    static {
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.TAB, KeyEvent.KEY_PRESSED, "TraverseNext").ctrl());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.TAB, KeyEvent.KEY_PRESSED, "TraversePrevious").ctrl().shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.HOME, KeyEvent.KEY_PRESSED, "LineStart"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.END, KeyEvent.KEY_PRESSED, "LineEnd"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "PreviousLine"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "PreviousLine"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "NextLine"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "NextLine"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, KeyEvent.KEY_PRESSED, "PreviousPage"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, KeyEvent.KEY_PRESSED, "NextPage"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_PRESSED, "InsertNewLine"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.TAB, KeyEvent.KEY_PRESSED, "InsertTab"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.HOME, KeyEvent.KEY_PRESSED, "SelectLineStart").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.END, KeyEvent.KEY_PRESSED, "SelectLineEnd").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "SelectPreviousLine").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "SelectPreviousLine").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "SelectNextLine").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "SelectNextLine").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, KeyEvent.KEY_PRESSED, "SelectPreviousPage").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, KeyEvent.KEY_PRESSED, "SelectNextPage").shift());
        if (PlatformUtil.isMac()) {
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.LEFT, KeyEvent.KEY_PRESSED, "LineStart").meta());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, KeyEvent.KEY_PRESSED, "LineStart").meta());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, KeyEvent.KEY_PRESSED, "LineEnd").meta());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, KeyEvent.KEY_PRESSED, "LineEnd").meta());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "Home").meta());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "Home").meta());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "End").meta());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "End").meta());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.LEFT, KeyEvent.KEY_PRESSED, "SelectLineStartExtend").shift().meta());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, KeyEvent.KEY_PRESSED, "SelectLineStartExtend").shift().meta());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, KeyEvent.KEY_PRESSED, "SelectLineEndExtend").shift().meta());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, KeyEvent.KEY_PRESSED, "SelectLineEndExtend").shift().meta());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "SelectHomeExtend").meta().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "SelectHomeExtend").meta().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "SelectEndExtend").meta().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "SelectEndExtend").meta().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "ParagraphStart").alt());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "ParagraphStart").alt());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "ParagraphEnd").alt());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "ParagraphEnd").alt());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "SelectParagraphStart").alt().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "SelectParagraphStart").alt().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "SelectParagraphEnd").alt().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "SelectParagraphEnd").alt().shift());
        } else {
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "ParagraphStart").ctrl());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "ParagraphStart").ctrl());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "ParagraphEnd").ctrl());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "ParagraphEnd").ctrl());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "SelectParagraphStart").ctrl().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "SelectParagraphStart").ctrl().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "SelectParagraphEnd").ctrl().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "SelectParagraphEnd").ctrl().shift());
        }
        TEXT_AREA_BINDINGS.addAll(TextInputControlBindings.BINDINGS);
        TEXT_AREA_BINDINGS.add(new KeyBinding(null, KeyEvent.KEY_PRESSED, "Consume"));
    }
}

