/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.property;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.beans.property.ReadOnlyProperty;

public class PropertyReference<T> {
    private String name;
    private Method getter;
    private Method setter;
    private Method propertyGetter;
    private Class<?> clazz;
    private Class<?> type;
    private boolean reflected = false;

    public PropertyReference(Class<?> clazz, String string) {
        if (string == null) {
            throw new NullPointerException("Name must be specified");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("Name must be specified");
        }
        if (clazz == null) {
            throw new NullPointerException("Class must be specified");
        }
        this.name = string;
        this.clazz = clazz;
    }

    public boolean isWritable() {
        this.reflect();
        return this.setter != null;
    }

    public boolean isReadable() {
        this.reflect();
        return this.getter != null;
    }

    public boolean hasProperty() {
        this.reflect();
        return this.propertyGetter != null;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getContainingClass() {
        return this.clazz;
    }

    public Class<?> getType() {
        this.reflect();
        return this.type;
    }

    public void set(Object object, T t) {
        if (!this.isWritable()) {
            throw new IllegalStateException("Cannot write to readonly property " + this.name);
        }
        assert (this.setter != null);
        try {
            this.setter.invoke(object, t);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public T get(Object object) {
        if (!this.isReadable()) {
            throw new IllegalStateException("Cannot read from unreadable property " + this.name);
        }
        assert (this.getter != null);
        try {
            return (T)this.getter.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public ReadOnlyProperty<T> getProperty(Object object) {
        if (!this.hasProperty()) {
            throw new IllegalStateException("Cannot get property " + this.name);
        }
        assert (this.propertyGetter != null);
        try {
            return (ReadOnlyProperty)this.propertyGetter.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String toString() {
        return this.name;
    }

    private void reflect() {
        if (!this.reflected) {
            this.reflected = true;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    block18: {
                        try {
                            Object object;
                            Object object2;
                            String string = PropertyReference.this.name.length() == 1 ? PropertyReference.this.name.substring(0, 1).toUpperCase() : Character.toUpperCase(PropertyReference.this.name.charAt(0)) + PropertyReference.this.name.substring(1);
                            PropertyReference.this.type = null;
                            String string2 = "get" + string;
                            try {
                                object2 = PropertyReference.this.clazz.getMethod(string2, new Class[0]);
                                if (Modifier.isPublic(((Method)object2).getModifiers())) {
                                    PropertyReference.this.getter = (Method)object2;
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                            if (PropertyReference.this.getter == null) {
                                string2 = "is" + string;
                                try {
                                    object2 = PropertyReference.this.clazz.getMethod(string2, new Class[0]);
                                    if (Modifier.isPublic(((Method)object2).getModifiers())) {
                                        PropertyReference.this.getter = (Method)object2;
                                    }
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    // empty catch block
                                }
                            }
                            object2 = "set" + string;
                            if (PropertyReference.this.getter != null) {
                                PropertyReference.this.type = PropertyReference.this.getter.getReturnType();
                                try {
                                    object = PropertyReference.this.clazz.getMethod((String)object2, PropertyReference.this.type);
                                    if (Modifier.isPublic(((Method)object).getModifiers())) {
                                        PropertyReference.this.setter = (Method)object;
                                    }
                                }
                                catch (NoSuchMethodException noSuchMethodException) {}
                            } else {
                                for (Method method : object = PropertyReference.this.clazz.getMethods()) {
                                    Class<?>[] classArray = method.getParameterTypes();
                                    if (!((String)object2).equals(method.getName()) || classArray.length != 1 || !Modifier.isPublic(method.getModifiers())) continue;
                                    PropertyReference.this.setter = method;
                                    PropertyReference.this.type = classArray[0];
                                    break;
                                }
                            }
                            object = PropertyReference.this.name + "Property";
                            try {
                                Method method = PropertyReference.this.clazz.getMethod((String)object, new Class[0]);
                                if (Modifier.isPublic(method.getModifiers())) {
                                    PropertyReference.this.propertyGetter = method;
                                    break block18;
                                }
                                PropertyReference.this.propertyGetter = null;
                            }
                            catch (NoSuchMethodException noSuchMethodException) {}
                        }
                        catch (RuntimeException runtimeException) {
                            System.err.println("Failed to introspect property " + PropertyReference.this.name);
                        }
                    }
                    return null;
                }
            });
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PropertyReference)) {
            return false;
        }
        PropertyReference propertyReference = (PropertyReference)object;
        if (!(this.name == propertyReference.name || this.name != null && this.name.equals(propertyReference.name))) {
            return false;
        }
        return this.clazz == propertyReference.clazz || this.clazz != null && this.clazz.equals(propertyReference.clazz);
    }

    public int hashCode() {
        int n = 5;
        n = 97 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 97 * n + (this.clazz != null ? this.clazz.hashCode() : 0);
        return n;
    }
}

