/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.Logger;
import oracle.jrockit.jfr.MsgLevel;
import oracle.jrockit.jfr.Options;

@Deprecated
public class Repository {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
    private final File path;
    private final File lock;
    private final Logger logger;
    private final String pid;

    public Repository(JFR jFR, Options options, Logger logger) {
        File file;
        String string;
        this.logger = logger;
        this.pid = String.valueOf(jFR.getpid());
        String string2 = options.repository();
        if (string2 == null) {
            string2 = System.getProperty("java.io.tmpdir");
        }
        String string3 = string = this.repositoryName();
        int n = 0;
        while (!this.tryToUseAsRepository(file = new File(string2, string3))) {
            string3 = string + "_" + n++;
        }
        this.path = file;
        this.lock = new File(file, ".lock");
        this.logger.log(MsgLevel.INFO, "Using %s as Flight Recorder repository.", this.path.toString());
    }

    private boolean tryToUseAsRepository(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    file.getCanonicalFile().getParentFile().mkdirs();
                    if (file.exists()) {
                        return false;
                    }
                    if (!file.mkdir()) {
                        return false;
                    }
                    if (!file.exists()) {
                        return false;
                    }
                    if (new File(file, ".lock").exists()) {
                        return false;
                    }
                    return true;
                }
                catch (Exception exception) {
                    Repository.this.logger.log(MsgLevel.WARN, exception, "Could not open %s as repository.", file);
                    return false;
                }
            }
        });
    }

    final void lock() throws IOException {
        while (!this.lock.createNewFile()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    final void unlock() {
        assert (this.lock.exists());
        while (!this.lock.delete()) {
            this.logger.error("Could not unlock repository!");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    final String filenameBase() {
        return this.sdf.format(new Date()) + "_" + this.pid;
    }

    public final File getPath() {
        return this.path;
    }

    private final String repositoryName() {
        return this.filenameBase();
    }

    public void destroy() {
        this.logger.info("Deleting Flight Recorder repository");
        if (!this.path.delete()) {
            this.logger.error("Repository could not be removed at shutdown: " + this.path.getAbsoluteFile());
        }
    }
}

