/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

public final class FFT {
    private double[] w;
    private int fftFrameSize;
    private int sign;
    private int[] bitm_array;
    private int fftFrameSize2;

    public FFT(int n, int n2) {
        this.w = FFT.computeTwiddleFactors(n, n2);
        this.fftFrameSize = n;
        this.sign = n2;
        this.fftFrameSize2 = n << 1;
        this.bitm_array = new int[this.fftFrameSize2];
        for (int i = 2; i < this.fftFrameSize2; i += 2) {
            int n3 = 0;
            for (int j = 2; j < this.fftFrameSize2; j <<= 1) {
                if ((i & j) != 0) {
                    ++n3;
                }
                n3 <<= 1;
            }
            this.bitm_array[i] = n3;
        }
    }

    public void transform(double[] dArray) {
        this.bitreversal(dArray);
        FFT.calc(this.fftFrameSize, dArray, this.sign, this.w);
    }

    private static final double[] computeTwiddleFactors(int n, int n2) {
        int n3;
        int n4;
        int n5 = (int)(Math.log(n) / Math.log(2.0));
        double[] dArray = new double[(n - 1) * 4];
        int n6 = 0;
        int n7 = 2;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = n7;
            n7 <<= 1;
            double d = 1.0;
            double d2 = 0.0;
            double d3 = Math.PI / (double)(n3 >> 1);
            double d4 = Math.cos(d3);
            double d5 = (double)n2 * Math.sin(d3);
            for (int i = 0; i < n3; i += 2) {
                dArray[n6++] = d;
                dArray[n6++] = d2;
                double d6 = d;
                d = d6 * d4 - d2 * d5;
                d2 = d6 * d5 + d2 * d4;
            }
        }
        n6 = 0;
        n4 = dArray.length >> 1;
        n3 = 2;
        for (n7 = 0; n7 < n5 - 1; ++n7) {
            int n8 = n3;
            n3 *= 2;
            int n9 = n6 + n8;
            for (int i = 0; i < n8; i += 2) {
                double d = dArray[n6++];
                double d7 = dArray[n6++];
                double d8 = dArray[n9++];
                double d9 = dArray[n9++];
                dArray[n4++] = d * d8 - d7 * d9;
                dArray[n4++] = d * d9 + d7 * d8;
            }
        }
        return dArray;
    }

    private static final void calc(int n, double[] dArray, int n2, double[] dArray2) {
        int n3 = 2;
        int n4 = n << 1;
        if (n3 >= n4) {
            return;
        }
        int n5 = n3 - 2;
        if (n2 == -1) {
            FFT.calcF4F(n, dArray, n5, n3, dArray2);
        } else {
            FFT.calcF4I(n, dArray, n5, n3, dArray2);
        }
    }

    private static final void calcF2E(int n, double[] dArray, int n2, int n3, double[] dArray2) {
        int n4 = n3;
        for (int i = 0; i < n4; i += 2) {
            double d = dArray2[n2++];
            double d2 = dArray2[n2++];
            int n5 = i + n4;
            double d3 = dArray[n5];
            double d4 = dArray[n5 + 1];
            double d5 = dArray[i];
            double d6 = dArray[i + 1];
            double d7 = d3 * d - d4 * d2;
            double d8 = d3 * d2 + d4 * d;
            dArray[n5] = d5 - d7;
            dArray[n5 + 1] = d6 - d8;
            dArray[i] = d5 + d7;
            dArray[i + 1] = d6 + d8;
        }
    }

    private static final void calcF4F(int n, double[] dArray, int n2, int n3, double[] dArray2) {
        int n4 = n << 1;
        int n5 = dArray2.length >> 1;
        while (n3 < n4) {
            int n6;
            if (n3 << 2 == n4) {
                FFT.calcF4FE(n, dArray, n2, n3, dArray2);
                return;
            }
            int n7 = n3;
            int n8 = n3 << 1;
            if (n8 == n4) {
                FFT.calcF2E(n, dArray, n2, n3, dArray2);
                return;
            }
            n3 <<= 2;
            int n9 = n2 + n7;
            int n10 = n2 + n5;
            n2 += 2;
            n9 += 2;
            n10 += 2;
            for (n6 = 0; n6 < n4; n6 += n3) {
                int n11 = n6 + n7;
                double d = dArray[n11];
                double d2 = dArray[n11 + 1];
                double d3 = dArray[n6];
                double d4 = dArray[n6 + 1];
                double d5 = dArray[n11 += n8];
                double d6 = dArray[n11 + 1];
                double d7 = dArray[n6 += n8];
                double d8 = dArray[n6 + 1];
                double d9 = d;
                double d10 = d2;
                d = d3 - d9;
                d2 = d4 - d10;
                d3 += d9;
                d4 += d10;
                double d11 = d7;
                double d12 = d8;
                double d13 = d5;
                double d14 = d6;
                d9 = d13 - d11;
                d10 = d14 - d12;
                d5 = d + d10;
                d6 = d2 - d9;
                d -= d10;
                d2 += d9;
                d9 = d11 + d13;
                d10 = d12 + d14;
                d7 = d3 - d9;
                d8 = d4 - d10;
                d3 += d9;
                d4 += d10;
                dArray[n11] = d5;
                dArray[n11 + 1] = d6;
                dArray[n6] = d7;
                dArray[n6 + 1] = d8;
                dArray[n11 -= n8] = d;
                dArray[n11 + 1] = d2;
                dArray[n6 -= n8] = d3;
                dArray[n6 + 1] = d4;
            }
            for (n6 = 2; n6 < n7; n6 += 2) {
                double d = dArray2[n2++];
                double d15 = dArray2[n2++];
                double d16 = dArray2[n9++];
                double d17 = dArray2[n9++];
                double d18 = dArray2[n10++];
                double d19 = dArray2[n10++];
                for (int i = n6; i < n4; i += n3) {
                    int n12 = i + n7;
                    double d20 = dArray[n12];
                    double d21 = dArray[n12 + 1];
                    double d22 = dArray[i];
                    double d23 = dArray[i + 1];
                    double d24 = dArray[n12 += n8];
                    double d25 = dArray[n12 + 1];
                    double d26 = dArray[i += n8];
                    double d27 = dArray[i + 1];
                    double d28 = d20 * d - d21 * d15;
                    double d29 = d20 * d15 + d21 * d;
                    d20 = d22 - d28;
                    d21 = d23 - d29;
                    d22 += d28;
                    d23 += d29;
                    double d30 = d26 * d16 - d27 * d17;
                    double d31 = d26 * d17 + d27 * d16;
                    double d32 = d24 * d18 - d25 * d19;
                    double d33 = d24 * d19 + d25 * d18;
                    d28 = d32 - d30;
                    d29 = d33 - d31;
                    d24 = d20 + d29;
                    d25 = d21 - d28;
                    d20 -= d29;
                    d21 += d28;
                    d28 = d30 + d32;
                    d29 = d31 + d33;
                    d26 = d22 - d28;
                    d27 = d23 - d29;
                    d22 += d28;
                    d23 += d29;
                    dArray[n12] = d24;
                    dArray[n12 + 1] = d25;
                    dArray[i] = d26;
                    dArray[i + 1] = d27;
                    dArray[n12 -= n8] = d20;
                    dArray[n12 + 1] = d21;
                    dArray[i -= n8] = d22;
                    dArray[i + 1] = d23;
                }
            }
            n2 += n7 << 1;
        }
        FFT.calcF2E(n, dArray, n2, n3, dArray2);
    }

    private static final void calcF4I(int n, double[] dArray, int n2, int n3, double[] dArray2) {
        int n4 = n << 1;
        int n5 = dArray2.length >> 1;
        while (n3 < n4) {
            int n6;
            if (n3 << 2 == n4) {
                FFT.calcF4IE(n, dArray, n2, n3, dArray2);
                return;
            }
            int n7 = n3;
            int n8 = n3 << 1;
            if (n8 == n4) {
                FFT.calcF2E(n, dArray, n2, n3, dArray2);
                return;
            }
            n3 <<= 2;
            int n9 = n2 + n7;
            int n10 = n2 + n5;
            n2 += 2;
            n9 += 2;
            n10 += 2;
            for (n6 = 0; n6 < n4; n6 += n3) {
                int n11 = n6 + n7;
                double d = dArray[n11];
                double d2 = dArray[n11 + 1];
                double d3 = dArray[n6];
                double d4 = dArray[n6 + 1];
                double d5 = dArray[n11 += n8];
                double d6 = dArray[n11 + 1];
                double d7 = dArray[n6 += n8];
                double d8 = dArray[n6 + 1];
                double d9 = d;
                double d10 = d2;
                d = d3 - d9;
                d2 = d4 - d10;
                d3 += d9;
                d4 += d10;
                double d11 = d7;
                double d12 = d8;
                double d13 = d5;
                double d14 = d6;
                d9 = d11 - d13;
                d10 = d12 - d14;
                d5 = d + d10;
                d6 = d2 - d9;
                d -= d10;
                d2 += d9;
                d9 = d11 + d13;
                d10 = d12 + d14;
                d7 = d3 - d9;
                d8 = d4 - d10;
                d3 += d9;
                d4 += d10;
                dArray[n11] = d5;
                dArray[n11 + 1] = d6;
                dArray[n6] = d7;
                dArray[n6 + 1] = d8;
                dArray[n11 -= n8] = d;
                dArray[n11 + 1] = d2;
                dArray[n6 -= n8] = d3;
                dArray[n6 + 1] = d4;
            }
            for (n6 = 2; n6 < n7; n6 += 2) {
                double d = dArray2[n2++];
                double d15 = dArray2[n2++];
                double d16 = dArray2[n9++];
                double d17 = dArray2[n9++];
                double d18 = dArray2[n10++];
                double d19 = dArray2[n10++];
                for (int i = n6; i < n4; i += n3) {
                    int n12 = i + n7;
                    double d20 = dArray[n12];
                    double d21 = dArray[n12 + 1];
                    double d22 = dArray[i];
                    double d23 = dArray[i + 1];
                    double d24 = dArray[n12 += n8];
                    double d25 = dArray[n12 + 1];
                    double d26 = dArray[i += n8];
                    double d27 = dArray[i + 1];
                    double d28 = d20 * d - d21 * d15;
                    double d29 = d20 * d15 + d21 * d;
                    d20 = d22 - d28;
                    d21 = d23 - d29;
                    d22 += d28;
                    d23 += d29;
                    double d30 = d26 * d16 - d27 * d17;
                    double d31 = d26 * d17 + d27 * d16;
                    double d32 = d24 * d18 - d25 * d19;
                    double d33 = d24 * d19 + d25 * d18;
                    d28 = d30 - d32;
                    d29 = d31 - d33;
                    d24 = d20 + d29;
                    d25 = d21 - d28;
                    d20 -= d29;
                    d21 += d28;
                    d28 = d30 + d32;
                    d29 = d31 + d33;
                    d26 = d22 - d28;
                    d27 = d23 - d29;
                    d22 += d28;
                    d23 += d29;
                    dArray[n12] = d24;
                    dArray[n12 + 1] = d25;
                    dArray[i] = d26;
                    dArray[i + 1] = d27;
                    dArray[n12 -= n8] = d20;
                    dArray[n12 + 1] = d21;
                    dArray[i -= n8] = d22;
                    dArray[i + 1] = d23;
                }
            }
            n2 += n7 << 1;
        }
        FFT.calcF2E(n, dArray, n2, n3, dArray2);
    }

    private static final void calcF4FE(int n, double[] dArray, int n2, int n3, double[] dArray2) {
        int n4 = n << 1;
        int n5 = dArray2.length >> 1;
        while (n3 < n4) {
            int n6 = n3;
            int n7 = n3 << 1;
            if (n7 == n4) {
                FFT.calcF2E(n, dArray, n2, n3, dArray2);
                return;
            }
            n3 <<= 2;
            int n8 = n2 + n6;
            int n9 = n2 + n5;
            for (int i = 0; i < n6; i += 2) {
                double d = dArray2[n2++];
                double d2 = dArray2[n2++];
                double d3 = dArray2[n8++];
                double d4 = dArray2[n8++];
                double d5 = dArray2[n9++];
                double d6 = dArray2[n9++];
                int n10 = i + n6;
                double d7 = dArray[n10];
                double d8 = dArray[n10 + 1];
                double d9 = dArray[i];
                double d10 = dArray[i + 1];
                double d11 = dArray[n10 += n7];
                double d12 = dArray[n10 + 1];
                double d13 = dArray[i += n7];
                double d14 = dArray[i + 1];
                double d15 = d7 * d - d8 * d2;
                double d16 = d7 * d2 + d8 * d;
                d7 = d9 - d15;
                d8 = d10 - d16;
                d9 += d15;
                d10 += d16;
                double d17 = d13 * d3 - d14 * d4;
                double d18 = d13 * d4 + d14 * d3;
                double d19 = d11 * d5 - d12 * d6;
                double d20 = d11 * d6 + d12 * d5;
                d15 = d19 - d17;
                d16 = d20 - d18;
                d11 = d7 + d16;
                d12 = d8 - d15;
                d7 -= d16;
                d8 += d15;
                d15 = d17 + d19;
                d16 = d18 + d20;
                d13 = d9 - d15;
                d14 = d10 - d16;
                d9 += d15;
                d10 += d16;
                dArray[n10] = d11;
                dArray[n10 + 1] = d12;
                dArray[i] = d13;
                dArray[i + 1] = d14;
                dArray[n10 -= n7] = d7;
                dArray[n10 + 1] = d8;
                dArray[i -= n7] = d9;
                dArray[i + 1] = d10;
            }
            n2 += n6 << 1;
        }
    }

    private static final void calcF4IE(int n, double[] dArray, int n2, int n3, double[] dArray2) {
        int n4 = n << 1;
        int n5 = dArray2.length >> 1;
        while (n3 < n4) {
            int n6 = n3;
            int n7 = n3 << 1;
            if (n7 == n4) {
                FFT.calcF2E(n, dArray, n2, n3, dArray2);
                return;
            }
            n3 <<= 2;
            int n8 = n2 + n6;
            int n9 = n2 + n5;
            for (int i = 0; i < n6; i += 2) {
                double d = dArray2[n2++];
                double d2 = dArray2[n2++];
                double d3 = dArray2[n8++];
                double d4 = dArray2[n8++];
                double d5 = dArray2[n9++];
                double d6 = dArray2[n9++];
                int n10 = i + n6;
                double d7 = dArray[n10];
                double d8 = dArray[n10 + 1];
                double d9 = dArray[i];
                double d10 = dArray[i + 1];
                double d11 = dArray[n10 += n7];
                double d12 = dArray[n10 + 1];
                double d13 = dArray[i += n7];
                double d14 = dArray[i + 1];
                double d15 = d7 * d - d8 * d2;
                double d16 = d7 * d2 + d8 * d;
                d7 = d9 - d15;
                d8 = d10 - d16;
                d9 += d15;
                d10 += d16;
                double d17 = d13 * d3 - d14 * d4;
                double d18 = d13 * d4 + d14 * d3;
                double d19 = d11 * d5 - d12 * d6;
                double d20 = d11 * d6 + d12 * d5;
                d15 = d17 - d19;
                d16 = d18 - d20;
                d11 = d7 + d16;
                d12 = d8 - d15;
                d7 -= d16;
                d8 += d15;
                d15 = d17 + d19;
                d16 = d18 + d20;
                d13 = d9 - d15;
                d14 = d10 - d16;
                d9 += d15;
                d10 += d16;
                dArray[n10] = d11;
                dArray[n10 + 1] = d12;
                dArray[i] = d13;
                dArray[i + 1] = d14;
                dArray[n10 -= n7] = d7;
                dArray[n10 + 1] = d8;
                dArray[i -= n7] = d9;
                dArray[i + 1] = d10;
            }
            n2 += n6 << 1;
        }
    }

    private final void bitreversal(double[] dArray) {
        if (this.fftFrameSize < 4) {
            return;
        }
        int n = this.fftFrameSize2 - 2;
        for (int i = 0; i < this.fftFrameSize; i += 4) {
            double d;
            double d2;
            int n2;
            int n3;
            int n4 = this.bitm_array[i];
            if (i < n4) {
                n3 = i;
                n2 = n4;
                d2 = dArray[n3];
                dArray[n3] = dArray[n2];
                dArray[n2] = d2;
                d = dArray[++n3];
                dArray[n3] = dArray[++n2];
                dArray[n2] = d;
                n3 = n - i;
                n2 = n - n4;
                d2 = dArray[n3];
                dArray[n3] = dArray[n2];
                dArray[n2] = d2;
                d = dArray[++n3];
                dArray[n3] = dArray[++n2];
                dArray[n2] = d;
            }
            n3 = n4 + this.fftFrameSize;
            n2 = i + 2;
            d2 = dArray[n2];
            dArray[n2] = dArray[n3];
            dArray[n3] = d2;
            d = dArray[++n2];
            dArray[n2] = dArray[++n3];
            dArray[n3] = d;
        }
    }
}

