/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESedeKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESedeKeySpec;

public final class DESedeKeyFactory
extends SecretKeyFactorySpi {
    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        DESedeKey dESedeKey = null;
        try {
            if (!(keySpec instanceof DESedeKeySpec)) {
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            DESedeKeySpec dESedeKeySpec = (DESedeKeySpec)keySpec;
            dESedeKey = new DESedeKey(dESedeKeySpec.getKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return dESedeKey;
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class<?> clazz) throws InvalidKeySpecException {
        try {
            if (secretKey instanceof SecretKey && secretKey.getAlgorithm().equalsIgnoreCase("DESede") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                if (DESedeKeySpec.class.isAssignableFrom(clazz)) {
                    return new DESedeKeySpec(secretKey.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        try {
            if (secretKey != null && secretKey.getAlgorithm().equalsIgnoreCase("DESede") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                if (secretKey instanceof DESedeKey) {
                    return secretKey;
                }
                DESedeKeySpec dESedeKeySpec = (DESedeKeySpec)this.engineGetKeySpec(secretKey, DESedeKeySpec.class);
                return this.engineGenerateSecret(dESedeKeySpec);
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

