/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.lang.reflect.Field;

public class ObjectStreamField
implements Comparable<Object> {
    private final String name;
    private final String signature;
    private final Class<?> type;
    private final boolean unshared;
    private final Field field;
    private int offset = 0;

    public ObjectStreamField(String string, Class<?> clazz) {
        this(string, clazz, false);
    }

    public ObjectStreamField(String string, Class<?> clazz, boolean bl) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.type = clazz;
        this.unshared = bl;
        this.signature = ObjectStreamField.getClassSignature(clazz).intern();
        this.field = null;
    }

    ObjectStreamField(String string, String string2, boolean bl) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.signature = string2.intern();
        this.unshared = bl;
        this.field = null;
        switch (string2.charAt(0)) {
            case 'Z': {
                this.type = Boolean.TYPE;
                break;
            }
            case 'B': {
                this.type = Byte.TYPE;
                break;
            }
            case 'C': {
                this.type = Character.TYPE;
                break;
            }
            case 'S': {
                this.type = Short.TYPE;
                break;
            }
            case 'I': {
                this.type = Integer.TYPE;
                break;
            }
            case 'J': {
                this.type = Long.TYPE;
                break;
            }
            case 'F': {
                this.type = Float.TYPE;
                break;
            }
            case 'D': {
                this.type = Double.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                this.type = Object.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal signature");
            }
        }
    }

    ObjectStreamField(Field field, boolean bl, boolean bl2) {
        this.field = field;
        this.unshared = bl;
        this.name = field.getName();
        Class<?> clazz = field.getType();
        this.type = bl2 || clazz.isPrimitive() ? clazz : Object.class;
        this.signature = ObjectStreamField.getClassSignature(clazz).intern();
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public char getTypeCode() {
        return this.signature.charAt(0);
    }

    public String getTypeString() {
        return this.isPrimitive() ? null : this.signature;
    }

    public int getOffset() {
        return this.offset;
    }

    protected void setOffset(int n) {
        this.offset = n;
    }

    public boolean isPrimitive() {
        char c = this.signature.charAt(0);
        return c != 'L' && c != '[';
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    @Override
    public int compareTo(Object object) {
        ObjectStreamField objectStreamField = (ObjectStreamField)object;
        boolean bl = this.isPrimitive();
        if (bl != objectStreamField.isPrimitive()) {
            return bl ? -1 : 1;
        }
        return this.name.compareTo(objectStreamField.name);
    }

    public String toString() {
        return this.signature + ' ' + this.name;
    }

    Field getField() {
        return this.field;
    }

    String getSignature() {
        return this.signature;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getClassSignature(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        while (clazz.isArray()) {
            stringBuilder.append('[');
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                stringBuilder.append('I');
                return stringBuilder.toString();
            } else if (clazz == Byte.TYPE) {
                stringBuilder.append('B');
                return stringBuilder.toString();
            } else if (clazz == Long.TYPE) {
                stringBuilder.append('J');
                return stringBuilder.toString();
            } else if (clazz == Float.TYPE) {
                stringBuilder.append('F');
                return stringBuilder.toString();
            } else if (clazz == Double.TYPE) {
                stringBuilder.append('D');
                return stringBuilder.toString();
            } else if (clazz == Short.TYPE) {
                stringBuilder.append('S');
                return stringBuilder.toString();
            } else if (clazz == Character.TYPE) {
                stringBuilder.append('C');
                return stringBuilder.toString();
            } else if (clazz == Boolean.TYPE) {
                stringBuilder.append('Z');
                return stringBuilder.toString();
            } else {
                if (clazz != Void.TYPE) throw new InternalError();
                stringBuilder.append('V');
            }
            return stringBuilder.toString();
        } else {
            stringBuilder.append('L' + clazz.getName().replace('.', '/') + ';');
        }
        return stringBuilder.toString();
    }
}

