/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.policy;

import com.sun.xml.internal.ws.encoding.policy.EncodingConstants;
import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.spi.PolicyAssertionValidator;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class EncodingPolicyValidator
implements PolicyAssertionValidator {
    private static final ArrayList<QName> serverSideSupportedAssertions = new ArrayList(3);
    private static final ArrayList<QName> clientSideSupportedAssertions = new ArrayList(4);

    @Override
    public PolicyAssertionValidator.Fitness validateClientSide(PolicyAssertion policyAssertion) {
        return clientSideSupportedAssertions.contains(policyAssertion.getName()) ? PolicyAssertionValidator.Fitness.SUPPORTED : PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    @Override
    public PolicyAssertionValidator.Fitness validateServerSide(PolicyAssertion policyAssertion) {
        QName qName = policyAssertion.getName();
        if (serverSideSupportedAssertions.contains(qName)) {
            return PolicyAssertionValidator.Fitness.SUPPORTED;
        }
        if (clientSideSupportedAssertions.contains(qName)) {
            return PolicyAssertionValidator.Fitness.UNSUPPORTED;
        }
        return PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    @Override
    public String[] declareSupportedDomains() {
        return new String[]{"http://schemas.xmlsoap.org/ws/2004/09/policy/optimizedmimeserialization", "http://schemas.xmlsoap.org/ws/2004/09/policy/encoding", "http://java.sun.com/xml/ns/wsit/2006/09/policy/encoding/client", "http://java.sun.com/xml/ns/wsit/2006/09/policy/fastinfoset/service"};
    }

    static {
        serverSideSupportedAssertions.add(EncodingConstants.OPTIMIZED_MIME_SERIALIZATION_ASSERTION);
        serverSideSupportedAssertions.add(EncodingConstants.UTF816FFFE_CHARACTER_ENCODING_ASSERTION);
        serverSideSupportedAssertions.add(EncodingConstants.OPTIMIZED_FI_SERIALIZATION_ASSERTION);
        clientSideSupportedAssertions.add(EncodingConstants.SELECT_OPTIMAL_ENCODING_ASSERTION);
        clientSideSupportedAssertions.addAll(serverSideSupportedAssertions);
    }
}

