/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.ChartLayoutAnimator;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.SizeConverter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Dimension2D;
import javafx.geometry.Side;
import javafx.scene.chart.ValueAxis;
import javafx.util.Duration;
import javafx.util.StringConverter;

public final class NumberAxis
extends ValueAxis<Number> {
    private static final double[] TICK_UNIT_DEFAULTS = new double[]{1.0E-10, 2.5E-10, 5.0E-10, 1.0E-9, 2.5E-9, 5.0E-9, 1.0E-8, 2.5E-8, 5.0E-8, 1.0E-7, 2.5E-7, 5.0E-7, 1.0E-6, 2.5E-6, 5.0E-6, 1.0E-5, 2.5E-5, 5.0E-5, 1.0E-4, 2.5E-4, 5.0E-4, 0.001, 0.0025, 0.005, 0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1.0, 2.5, 5.0, 10.0, 25.0, 50.0, 100.0, 250.0, 500.0, 1000.0, 2500.0, 5000.0, 10000.0, 25000.0, 50000.0, 100000.0, 250000.0, 500000.0, 1000000.0, 2500000.0, 5000000.0, 1.0E7, 2.5E7, 5.0E7, 1.0E8, 2.5E8, 5.0E8, 1.0E9, 2.5E9, 5.0E9, 1.0E10, 2.5E10, 5.0E10, 1.0E11, 2.5E11, 5.0E11, 1.0E12, 2.5E12, 5.0E12};
    private static final String[] TICK_UNIT_FORMATTER_DEFAULTS = new String[]{"0.0000000000", "0.00000000000", "0.0000000000", "0.000000000", "0.0000000000", "0.000000000", "0.00000000", "0.000000000", "0.00000000", "0.0000000", "0.00000000", "0.0000000", "0.000000", "0.0000000", "0.000000", "0.00000", "0.000000", "0.00000", "0.0000", "0.00000", "0.0000", "0.000", "0.0000", "0.000", "0.00", "0.000", "0.00", "0.0", "0.00", "0.0", "0", "0.0", "0", "#,##0"};
    private Object currentAnimationID;
    private final ChartLayoutAnimator animator = new ChartLayoutAnimator(this);
    private IntegerProperty currentRangeIndexProperty = new SimpleIntegerProperty(this, "currentRangeIndex", -1);
    private DefaultFormatter defaultFormatter = new DefaultFormatter(this);
    private BooleanProperty forceZeroInRange = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            if (NumberAxis.this.isAutoRanging()) {
                NumberAxis.this.requestAxisLayout();
            }
        }

        @Override
        public Object getBean() {
            return NumberAxis.this;
        }

        @Override
        public String getName() {
            return "forceZeroInRange";
        }
    };
    private DoubleProperty tickUnit = new StyleableDoubleProperty(5.0){

        @Override
        protected void invalidated() {
            if (!NumberAxis.this.isAutoRanging()) {
                NumberAxis.this.invalidateRange();
                NumberAxis.this.requestAxisLayout();
            }
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.TICK_UNIT;
        }

        @Override
        public Object getBean() {
            return NumberAxis.this;
        }

        @Override
        public String getName() {
            return "tickUnit";
        }
    };

    public final boolean isForceZeroInRange() {
        return this.forceZeroInRange.getValue();
    }

    public final void setForceZeroInRange(boolean bl) {
        this.forceZeroInRange.setValue(bl);
    }

    public final BooleanProperty forceZeroInRangeProperty() {
        return this.forceZeroInRange;
    }

    public final double getTickUnit() {
        return this.tickUnit.get();
    }

    public final void setTickUnit(double d) {
        this.tickUnit.set(d);
    }

    public final DoubleProperty tickUnitProperty() {
        return this.tickUnit;
    }

    public NumberAxis() {
    }

    public NumberAxis(double d, double d2, double d3) {
        super(d, d2);
        this.setTickUnit(d3);
    }

    public NumberAxis(String string, double d, double d2, double d3) {
        super(d, d2);
        this.setTickUnit(d3);
        this.setLabel(string);
    }

    @Override
    protected String getTickMarkLabel(Number number) {
        DefaultFormatter defaultFormatter = this.getTickLabelFormatter();
        if (defaultFormatter == null) {
            defaultFormatter = this.defaultFormatter;
        }
        return ((StringConverter)defaultFormatter).toString(number);
    }

    @Override
    protected Object getRange() {
        return new double[]{this.getLowerBound(), this.getUpperBound(), this.getTickUnit(), this.getScale(), this.currentRangeIndexProperty.get()};
    }

    @Override
    protected void setRange(Object object, boolean bl) {
        double[] dArray = (double[])object;
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray[4];
        this.currentRangeIndexProperty.set((int)d5);
        double d6 = this.getLowerBound();
        this.setLowerBound(d);
        this.setUpperBound(d2);
        this.setTickUnit(d3);
        if (bl) {
            this.animator.stop(this.currentAnimationID);
            this.currentAnimationID = this.animator.animate(new KeyFrame(Duration.ZERO, new KeyValue(this.currentLowerBound, d6), new KeyValue(this.scalePropertyImpl(), this.getScale())), new KeyFrame(Duration.millis(700.0), new KeyValue(this.currentLowerBound, d), new KeyValue(this.scalePropertyImpl(), d4)));
        } else {
            this.currentLowerBound.set(d);
            this.setScale(d4);
        }
    }

    @Override
    protected List<Number> calculateTickValues(double d, Object object) {
        double[] dArray = (double[])object;
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        ArrayList<Number> arrayList = new ArrayList<Number>();
        if (d4 <= 0.0 || d2 == d3) {
            arrayList.add(d2);
        } else if (this.getTickUnit() > 0.0) {
            for (double d5 = d2; d5 <= d3; d5 += d4) {
                arrayList.add(d5);
                if (arrayList.size() <= 2000) continue;
                System.err.println("Warning we tried to create more than 2000 major tick marks on a NumberAxis. Lower Bound=" + d2 + ", Upper Bound=" + d3 + ", Tick Unit=" + d4);
                break;
            }
        }
        return arrayList;
    }

    @Override
    protected List<Number> calculateMinorTickMarks() {
        ArrayList<Number> arrayList = new ArrayList<Number>();
        double d = this.getLowerBound();
        double d2 = this.getUpperBound();
        double d3 = this.getTickUnit();
        double d4 = d3 / (double)this.getMinorTickCount();
        if (this.getTickUnit() > 0.0) {
            block0: for (double d5 = d; d5 < d2; d5 += d3) {
                for (double d6 = d5 + d4; d6 < d5 + d3; d6 += d4) {
                    arrayList.add(d6);
                    if (arrayList.size() <= 10000) continue;
                    System.err.println("Warning we tried to create more than 10000 minor tick marks on a NumberAxis. Lower Bound=" + this.getLowerBound() + ", Upper Bound=" + this.getUpperBound() + ", Tick Unit=" + d3);
                    continue block0;
                }
            }
        }
        return arrayList;
    }

    @Override
    protected Dimension2D measureTickMarkSize(Number number, Object object) {
        double[] dArray = (double[])object;
        double d = dArray[4];
        return this.measureTickMarkSize(number, this.getTickLabelRotation(), (int)d);
    }

    private Dimension2D measureTickMarkSize(Number number, double d, int n) {
        DefaultFormatter defaultFormatter = this.getTickLabelFormatter();
        if (defaultFormatter == null) {
            defaultFormatter = this.defaultFormatter;
        }
        String string = defaultFormatter instanceof DefaultFormatter ? defaultFormatter.toString(number, n) : ((StringConverter)defaultFormatter).toString(number);
        return this.measureTickMarkLabelSize(string, d);
    }

    @Override
    protected Object autoRange(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        boolean bl;
        Side side = this.getSide();
        boolean bl2 = bl = Side.LEFT.equals((Object)side) || Side.RIGHT.equals((Object)side);
        if (this.isForceZeroInRange()) {
            if (d2 < 0.0) {
                d2 = 0.0;
            } else if (d > 0.0) {
                d = 0.0;
            }
        }
        double d7 = (d6 = d2 - d) == 0.0 ? 2.0 : Math.abs(d6) * 1.02;
        double d8 = (d7 - d6) / 2.0;
        double d9 = d - d8;
        double d10 = d2 + d8;
        if (d9 < 0.0 && d >= 0.0 || d9 > 0.0 && d <= 0.0) {
            d9 = 0.0;
        }
        if (d10 < 0.0 && d2 >= 0.0 || d10 > 0.0 && d2 <= 0.0) {
            d10 = 0.0;
        }
        int n = (int)Math.floor(Math.abs(d3) / d4);
        n = Math.max(n, 2);
        double d11 = d7 / (double)n;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        int n2 = 0;
        double d15 = Double.MAX_VALUE;
        int n3 = 10;
        while (d15 > d3 || n2 > 20) {
            for (int i = 0; i < TICK_UNIT_DEFAULTS.length; ++i) {
                double d16 = TICK_UNIT_DEFAULTS[i];
                if (!(d16 > d11)) continue;
                d12 = d16;
                n3 = i;
                break;
            }
            d13 = Math.floor(d9 / d12) * d12;
            d14 = Math.ceil(d10 / d12) * d12;
            d5 = 0.0;
            double d17 = 0.0;
            n2 = 0;
            double d18 = d13;
            while (d18 <= d14) {
                double d19;
                double d20 = d19 = bl ? this.measureTickMarkSize(d18, this.getTickLabelRotation(), n3).getHeight() : this.measureTickMarkSize(d18, this.getTickLabelRotation(), n3).getWidth();
                if (d18 == d13) {
                    d17 = d19 / 2.0;
                } else {
                    d5 = Math.max(d5, d17 + 6.0 + d19 / 2.0);
                }
                d18 += d12;
                ++n2;
            }
            d15 = (double)(n2 - 1) * d5;
            d11 = d12;
            if (d12 != TICK_UNIT_DEFAULTS[TICK_UNIT_DEFAULTS.length - 1]) continue;
            break;
        }
        d5 = this.calculateNewScale(d3, d13, d14);
        return new double[]{d13, d14, d12, d5, n3};
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return NumberAxis.impl_CSS_STYLEABLES();
    }

    public static class DefaultFormatter
    extends StringConverter<Number> {
        private DecimalFormat formatter;
        private String prefix = null;
        private String suffix = null;

        private DefaultFormatter() {
        }

        public DefaultFormatter(final NumberAxis numberAxis) {
            this.formatter = DefaultFormatter.getFormatter(numberAxis.isAutoRanging() ? numberAxis.currentRangeIndexProperty.get() : -1);
            ChangeListener changeListener = new ChangeListener(){

                public void changed(ObservableValue observableValue, Object object, Object object2) {
                    DefaultFormatter.this.formatter = DefaultFormatter.getFormatter(numberAxis.isAutoRanging() ? numberAxis.currentRangeIndexProperty.get() : -1);
                }
            };
            numberAxis.currentRangeIndexProperty.addListener(changeListener);
            numberAxis.autoRangingProperty().addListener(changeListener);
        }

        public DefaultFormatter(NumberAxis numberAxis, String string, String string2) {
            this(numberAxis);
            this.prefix = string;
            this.suffix = string2;
        }

        private static DecimalFormat getFormatter(int n) {
            if (n < 0) {
                return new DecimalFormat();
            }
            if (n >= TICK_UNIT_FORMATTER_DEFAULTS.length) {
                return new DecimalFormat(TICK_UNIT_FORMATTER_DEFAULTS[TICK_UNIT_FORMATTER_DEFAULTS.length - 1]);
            }
            return new DecimalFormat(TICK_UNIT_FORMATTER_DEFAULTS[n]);
        }

        @Override
        public String toString(Number number) {
            return this.toString(number, this.formatter);
        }

        private String toString(Number number, int n) {
            return this.toString(number, DefaultFormatter.getFormatter(n));
        }

        private String toString(Number number, DecimalFormat decimalFormat) {
            if (this.prefix != null && this.suffix != null) {
                return this.prefix + decimalFormat.format(number) + this.suffix;
            }
            if (this.prefix != null) {
                return this.prefix + decimalFormat.format(number);
            }
            if (this.suffix != null) {
                return decimalFormat.format(number) + this.suffix;
            }
            return decimalFormat.format(number);
        }

        @Override
        public Number fromString(String string) {
            try {
                int n = this.prefix == null ? 0 : this.prefix.length();
                int n2 = this.suffix == null ? 0 : this.suffix.length();
                return this.formatter.parse(string.substring(n, string.length() - n2));
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty<NumberAxis, Number> TICK_UNIT = new StyleableProperty<NumberAxis, Number>("-fx-tick-unit", (StyleConverter)SizeConverter.getInstance(), (Number)5.0){

            @Override
            public boolean isSettable(NumberAxis numberAxis) {
                return numberAxis.tickUnit == null || !numberAxis.tickUnit.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(NumberAxis numberAxis) {
                return numberAxis.tickUnitProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(ValueAxis.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, TICK_UNIT);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

