/*
 * Decompiled with CFR 0.152.
 */
package javafx.fxml;

import com.sun.javafx.fxml.BeanAdapter;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.util.Builder;

final class JavaFXBuilder {
    private static final Object[] NO_ARGS = new Object[0];
    private static final Class<?>[] NO_SIG = new Class[0];
    private final Class<?> builderClass;
    private final Method createMethod;
    private final Method buildMethod;
    private final Map<String, Method> methods = new HashMap<String, Method>();
    private final Map<String, Method> getters = new HashMap<String, Method>();
    private final Map<String, Method> setters = new HashMap<String, Method>();

    JavaFXBuilder() {
        this.builderClass = null;
        this.createMethod = null;
        this.buildMethod = null;
    }

    JavaFXBuilder(Class<?> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException {
        this.builderClass = clazz;
        this.createMethod = clazz.getMethod("create", new Class[0]);
        this.buildMethod = clazz.getMethod("build", new Class[0]);
        assert (Modifier.isStatic(this.createMethod.getModifiers()));
        assert (!Modifier.isStatic(this.buildMethod.getModifiers()));
    }

    Builder<Object> createBuilder() {
        return new ObjectBuilder();
    }

    private Method findMethod(String string) {
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1))) {
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        for (Method method : this.builderClass.getMethods()) {
            if (!method.getName().equals(string)) continue;
            return method;
        }
        throw new IllegalArgumentException("Method " + string + " could not be found at class " + this.builderClass.getName());
    }

    public Class<?> getTargetClass() {
        return this.buildMethod.getReturnType();
    }

    final class ObjectBuilder
    extends AbstractMap<String, Object>
    implements Builder<Object> {
        private final Map<String, Object> containers = new HashMap<String, Object>();
        private Object builder = null;
        private Map<Object, Object> properties;

        private ObjectBuilder() {
            try {
                this.builder = JavaFXBuilder.this.createMethod.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException("Creation of the builder " + JavaFXBuilder.this.builderClass.getName() + " failed.", exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object build() {
            for (Map.Entry<String, Object> object2 : this.containers.entrySet()) {
                this.put(object2.getKey(), object2.getValue());
            }
            try {
                Object object3 = JavaFXBuilder.this.buildMethod.invoke(this.builder, NO_ARGS);
                if (this.properties != null && object3 instanceof Node) {
                    ((Node)object3).getProperties().putAll(this.properties);
                }
                Object object = object3;
                return object;
            }
            catch (Exception exception) {
                Logger.getLogger(JavaFXBuilder.class.getName()).log(Level.WARNING, "Failed to build instance of " + JavaFXBuilder.this.getTargetClass() + " using " + JavaFXBuilder.this.builderClass, exception);
                Object var2_5 = null;
                return var2_5;
            }
            finally {
                this.builder = null;
            }
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.getTemporaryContainer(object.toString()) != null;
        }

        @Override
        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object object) {
            return this.getTemporaryContainer(object.toString());
        }

        @Override
        public Object put(String string, Object object) {
            if (Node.class.isAssignableFrom(JavaFXBuilder.this.getTargetClass()) && "properties".equals(string)) {
                this.properties = (Map)object;
                return null;
            }
            try {
                Method method = (Method)JavaFXBuilder.this.methods.get(string);
                if (method == null) {
                    method = JavaFXBuilder.this.findMethod(string);
                    JavaFXBuilder.this.methods.put(string, method);
                }
                try {
                    Class<?> clazz = method.getParameterTypes()[0];
                    if (clazz.isArray()) {
                        List<String> list = object instanceof List ? (List<String>)object : Arrays.asList(object.toString().split(","));
                        Class<?> clazz2 = clazz.getComponentType();
                        Object object2 = Array.newInstance(clazz2, list.size());
                        for (int i = 0; i < list.size(); ++i) {
                            Array.set(object2, i, BeanAdapter.coerce(list.get(i), clazz2));
                        }
                        object = object2;
                    }
                    method.invoke(this.builder, BeanAdapter.coerce(object, clazz));
                }
                catch (Exception exception) {
                    Logger.getLogger(JavaFXBuilder.class.getName()).log(Level.WARNING, "Method " + method.getName() + " failed", exception);
                }
                return null;
            }
            catch (Exception exception) {
                Logger.getLogger(JavaFXBuilder.class.getName()).log(Level.WARNING, "Failed to set " + JavaFXBuilder.this.getTargetClass() + "." + string + " using " + JavaFXBuilder.this.builderClass, exception);
                return null;
            }
        }

        Object getReadOnlyProperty(String string) {
            GenericDeclaration genericDeclaration;
            Class<?> clazz;
            if (JavaFXBuilder.this.setters.get(string) != null) {
                return null;
            }
            Method method = (Method)JavaFXBuilder.this.getters.get(string);
            if (method == null) {
                clazz = null;
                genericDeclaration = JavaFXBuilder.this.getTargetClass();
                String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
                try {
                    method = ((Class)genericDeclaration).getMethod("get" + string2, NO_SIG);
                    clazz = ((Class)genericDeclaration).getMethod("set" + string2, method.getReturnType());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (method != null) {
                    JavaFXBuilder.this.getters.put(string, method);
                    JavaFXBuilder.this.setters.put(string, clazz);
                }
                if (clazz != null) {
                    return null;
                }
            }
            if (method == null) {
                genericDeclaration = JavaFXBuilder.this.findMethod(string);
                if (genericDeclaration == null) {
                    return null;
                }
                clazz = ((Method)genericDeclaration).getParameterTypes()[0];
                if (clazz.isArray()) {
                    clazz = List.class;
                }
            } else {
                clazz = method.getReturnType();
            }
            if (ObservableMap.class.isAssignableFrom(clazz)) {
                return FXCollections.observableMap(new HashMap());
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return new HashMap();
            }
            if (ObservableList.class.isAssignableFrom(clazz)) {
                return FXCollections.observableArrayList();
            }
            if (List.class.isAssignableFrom(clazz)) {
                return new ArrayList();
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new HashSet();
            }
            return null;
        }

        public Object getTemporaryContainer(String string) {
            Object object = this.containers.get(string);
            if (object == null && (object = this.getReadOnlyProperty(string)) != null) {
                this.containers.put(string, object);
            }
            return object;
        }

        @Override
        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

