/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Platform;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.ImageLoader;
import com.sun.deploy.util.PerfLogger;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.LaunchDesc;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

public class IcoEncoder {
    private static final boolean DEBUG = false;
    private Image _awtImage;
    private byte _size;
    private byte[] _andData;
    private byte[] _xorData;
    static final int[] DEFAULT_SIZES = new int[]{32, 16, 48, 64};

    public IcoEncoder(Image image, byte by) {
        this._size = by;
        this._awtImage = image;
    }

    public static String getIconPath(LaunchDesc launchDesc, boolean bl) {
        return IcoEncoder.getIconPath(launchDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIconPath(LaunchDesc launchDesc) {
        int n;
        Object object;
        IconDesc[] iconDescArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Integer n2 = new Integer(Platform.get().getSystemShortcutIconSize(true));
        Integer n3 = new Integer(Platform.get().getSystemShortcutIconSize(false));
        for (int i = 0; i < DEFAULT_SIZES.length; ++i) {
            iconDescArray = new Integer(DEFAULT_SIZES[i]);
            if (arrayList.contains(iconDescArray)) continue;
            arrayList.add(iconDescArray);
        }
        if (!arrayList.contains(n2)) {
            arrayList.add(n2);
        }
        if (!arrayList.contains(n3)) {
            arrayList.add(n3);
        }
        Iterator iterator = arrayList.iterator();
        iconDescArray = new IconDesc[6];
        byte[] byArray = new byte[6];
        int n4 = 0;
        while (iterator.hasNext()) {
            int n5;
            int n6;
            int n7 = (Integer)iterator.next();
            if (n7 < 16) {
                n7 = 16;
            }
            if (n7 > 64) {
                n7 = 64;
            }
            if ((object = launchDesc.getInformation().getIconLocation(n7, 5)) == null) {
                object = launchDesc.getInformation().getIconLocation(n7, 0);
            }
            if (object == null) continue;
            n = 0;
            for (n6 = 0; n6 < n4 && n == 0; ++n6) {
                if (!((IconDesc)object).equals(iconDescArray[n6])) continue;
                n = 1;
            }
            if (n != 0) continue;
            iconDescArray[n4] = object;
            n6 = ((IconDesc)object).getWidth();
            byArray[n4] = n6 == (n5 = ((IconDesc)object).getHeight()) && n6 >= 16 && n6 <= 64 ? (byte)n6 : (byte)n7;
            ++n4;
        }
        String string = null;
        object = new IcoEncoder[6];
        for (n = 0; n < n4; ++n) {
            String string2 = null;
            File file = null;
            try {
                File file2 = DownloadEngine.getUpdatedShortcutImage((URL)iconDescArray[n].getLocation(), (String)iconDescArray[n].getVersion());
                if (file2 == null) continue;
                if (Platform.get().isPlatformIconType(iconDescArray[n].getLocation().toString())) {
                    string2 = file2.toString();
                    file = file2;
                } else {
                    string2 = file2.getPath() + ".ico";
                    file = new File(string2);
                }
                if (file.exists()) {
                    string = string2;
                    return string;
                }
                if (string == null) {
                    string = string2;
                }
                PerfLogger.setTime((String)("before ico creation for " + string2));
                Image image = ImageLoader.getInstance().loadImage(file2.getPath());
                object[n] = new IcoEncoder(image, byArray[n]);
                super.createBitmaps();
                PerfLogger.setTime((String)("after ico creation for " + string2));
                continue;
            }
            catch (IOException iOException) {
                Trace.ignored((Throwable)iOException);
            }
        }
        FilterOutputStream filterOutputStream = null;
        if (string != null && n4 > 0) {
            int[] nArray = new int[6];
            nArray[0] = 6 + 16 * n4;
            for (int i = 1; i < n4; ++i) {
                nArray[i] = nArray[i - 1] + 40 + super.getXorData().length + super.getAndData().length;
            }
            try {
                int n8;
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string)));
                IcoStreamWriter icoStreamWriter = super.getIcoStreamWriter((BufferedOutputStream)filterOutputStream);
                icoStreamWriter.writeIcoHeader(n4);
                for (n8 = 0; n8 < n4; ++n8) {
                    super.writeIconDirEntry(icoStreamWriter, nArray[n8]);
                }
                for (n8 = 0; n8 < n4; ++n8) {
                    super.writeInfoHeader(icoStreamWriter);
                    filterOutputStream.write(super.getXorData());
                    filterOutputStream.write(super.getAndData());
                }
                ((BufferedOutputStream)filterOutputStream).flush();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIconPath(URL uRL, String string) {
        Object object;
        String string2 = null;
        IcoEncoder icoEncoder = null;
        try {
            object = DownloadEngine.getUpdatedShortcutImage((URL)uRL, (String)string);
            if (object != null) {
                File file;
                if (Platform.get().isPlatformIconType(uRL.toString())) {
                    string2 = ((File)object).toString();
                    file = object;
                } else {
                    string2 = ((File)object).getPath() + ".ico";
                    file = new File(string2);
                }
                if (file.exists()) {
                    return string2;
                }
                Image image = ImageLoader.getInstance().loadImage(((File)object).getPath());
                icoEncoder = new IcoEncoder(image, 32);
                icoEncoder.createBitmaps();
            }
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
        }
        if (string2 != null && icoEncoder != null) {
            object = null;
            int n = 22;
            try {
                object = new BufferedOutputStream(new FileOutputStream(new File(string2)));
                IcoStreamWriter icoStreamWriter = super.getIcoStreamWriter((BufferedOutputStream)object);
                icoStreamWriter.writeIcoHeader(1);
                icoEncoder.writeIconDirEntry(icoStreamWriter, n);
                icoEncoder.writeInfoHeader(icoStreamWriter);
                ((FilterOutputStream)object).write(icoEncoder.getXorData());
                ((FilterOutputStream)object).write(icoEncoder.getAndData());
                ((BufferedOutputStream)object).flush();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
            finally {
                if (object != null) {
                    try {
                        ((FilterOutputStream)object).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return string2;
    }

    private void createBitmaps() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this._size;
        int n6 = this._size;
        int n7 = IcoEncoder.getXorScanSize(this._size);
        int n8 = IcoEncoder.getAndScanSize(this._size);
        boolean bl = false;
        int[] nArray = new int[n5 * n6];
        byte[] byArray = new byte[n6 * n7];
        this._xorData = new byte[n6 * n7];
        byte[] byArray2 = new byte[n6 * n8];
        this._andData = new byte[n6 * n8];
        Image image = this._awtImage.getScaledInstance(n5, n6, 4);
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n5, n6, nArray, 0, n5);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = n4 * n8;
            n2 = 0;
            n = n4 * n7;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            for (int i = 0; i < n5; ++i) {
                int n12 = n4 * n5 + i;
                int n13 = nArray[n12] >> 24 & 0xFF;
                int n14 = nArray[n12] >> 16 & 0xFF;
                int n15 = nArray[n12] >> 8 & 0xFF;
                int n16 = nArray[n12] & 0xFF;
                if (n13 == 0) {
                    n10 = (byte)(n10 | 128 >> n11);
                }
                if (++n11 == 8 || i == n5 - 1) {
                    byArray2[n3 + n2++] = n10;
                    n10 = 0;
                    n11 = 0;
                }
                byArray[n + n9++] = (byte)n16;
                byArray[n + n9++] = (byte)n15;
                byArray[n + n9++] = (byte)n14;
            }
            while (n2 < n8) {
                byArray2[n3 + n2++] = 0;
            }
            while (n9 < n7) {
                byArray[n + n9++] = 0;
            }
        }
        for (n2 = 0; n2 < n6; ++n2) {
            n3 = n2 * n7;
            n4 = (n6 - n2 - 1) * n7;
            for (n = 0; n < n7; ++n) {
                this._xorData[n3 + n] = byArray[n4 + n];
            }
            n3 = n2 * n8;
            n4 = (n6 - n2 - 1) * n8;
            for (n = 0; n < n8; ++n) {
                this._andData[n3 + n] = byArray2[n4 + n];
            }
        }
    }

    private byte[] getXorData() {
        return this._xorData;
    }

    private byte[] getAndData() {
        return this._andData;
    }

    private void writeInfoHeader(IcoStreamWriter icoStreamWriter) throws IOException {
        icoStreamWriter.writeDWord(40);
        icoStreamWriter.writeDWord(this._size);
        icoStreamWriter.writeDWord(2 * this._size);
        icoStreamWriter.writeWord(1);
        icoStreamWriter.writeWord(24);
        icoStreamWriter.writeDWord(0);
        icoStreamWriter.writeDWord(0);
        icoStreamWriter.writeDWord(0);
        icoStreamWriter.writeDWord(0);
        icoStreamWriter.writeDWord(0);
        icoStreamWriter.writeDWord(0);
    }

    private void writeIconDirEntry(IcoStreamWriter icoStreamWriter, int n) throws IOException {
        int n2 = IcoEncoder.getAndScanSize(this._size);
        int n3 = IcoEncoder.getXorScanSize(this._size);
        try {
            icoStreamWriter.write(this._size);
            icoStreamWriter.write(this._size);
            icoStreamWriter.write((byte)0);
            icoStreamWriter.write((byte)0);
            icoStreamWriter.writeWord(1);
            icoStreamWriter.writeWord(24);
            int n4 = this._size * n3 + this._size * n2 + 40;
            icoStreamWriter.writeDWord(n4);
            icoStreamWriter.writeDWord(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private IcoStreamWriter getIcoStreamWriter(BufferedOutputStream bufferedOutputStream) {
        return new IcoStreamWriter(bufferedOutputStream);
    }

    private static int getAndScanSize(int n) {
        int n2 = (n + 7) / 8;
        int n3 = 4 * ((n2 + 3) / 4);
        return n3;
    }

    private static int getXorScanSize(int n) {
        int n2 = n * 3;
        int n3 = 4 * ((n2 + 3) / 4);
        return n3;
    }

    public static void showIconFile(File file) {
        Trace.println((String)("Icon: " + file));
        try {
            int n;
            int n2;
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[6];
            fileInputStream.read(byArray2);
            Trace.println((String)("header: " + byArray2[0] + ", " + byArray2[1] + ", " + byArray2[2] + ", " + byArray2[3] + ", " + byArray2[4] + ", " + byArray2[5]));
            int n3 = byArray2[4];
            for (n2 = 0; n2 < n3; ++n2) {
                fileInputStream.read(byArray);
                Trace.println((String)("Dir entry " + n2 + ": " + byArray[0] + ", " + byArray[1] + ", " + byArray[2] + ", " + byArray[3] + ", " + byArray[4] + ", " + byArray[5] + ", " + byArray[6] + ", " + byArray[7] + ", " + byArray[8] + ", " + byArray[9] + ", " + byArray[10] + ", " + byArray[11] + ", " + byArray[12] + ", " + byArray[13] + ", " + byArray[14] + ", " + byArray[15]));
            }
            n2 = 0;
            Trace.println((String)"InfoHeader: ");
            byte[] byArray3 = new byte[40];
            fileInputStream.read(byArray3);
            for (n2 = 0; n2 < 40; ++n2) {
                Trace.print((String)(byArray3[n2] + ","));
            }
            Trace.println((String)"\n");
            Trace.println((String)"the rest: ");
            while ((n = fileInputStream.read(byArray)) > 0) {
                Trace.println((String)(" line " + n2++ + " : " + byArray[0] + ", " + byArray[1] + ", " + byArray[2] + ", " + byArray[3] + ", " + byArray[4] + ", " + byArray[5] + ", " + byArray[6] + ", " + byArray[7] + ", " + byArray[8] + ", " + byArray[9] + ", " + byArray[10] + ", " + byArray[11] + ", " + byArray[12] + ", " + byArray[13] + ", " + byArray[14] + ", " + byArray[15]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class IcoStreamWriter {
        BufferedOutputStream _bos;

        private IcoStreamWriter(BufferedOutputStream bufferedOutputStream) {
            this._bos = bufferedOutputStream;
        }

        private void writeIcoHeader(int n) throws IOException {
            try {
                this.writeWord(0);
                this.writeWord(1);
                this.writeWord(n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void write(byte by) throws IOException {
            this._bos.write(by);
        }

        public void writeWord(int n) throws IOException {
            this._bos.write(n & 0xFF);
            this._bos.write((n & 0xFF00) >> 8);
        }

        public void writeDWord(int n) throws IOException {
            this._bos.write(n & 0xFF);
            this._bos.write((n & 0xFF00) >> 8);
            this._bos.write((n & 0xFF0000) >> 16);
            this._bos.write((n & 0xFF000000) >> 24);
        }
    }
}

