/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.DeployEmbeddedFrameIf;
import com.sun.deploy.ui.DialogInterface;
import com.sun.deploy.ui.UIFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import sun.awt.EmbeddedFrame;

class DialogHelper
implements DialogInterface {
    private boolean allowEmbed = false;
    private Component owner = null;
    private AppInfo ainfo = null;
    private String title = null;
    private JDialog dialog = null;
    private Container content = null;
    private boolean modalOnTop = false;
    private JButton defaultButton = null;
    private boolean resizable = false;
    private Component savedContent = null;
    private boolean gradientBackground = true;
    private AbstractAction cancelAction = null;
    private static final int SHADOW_WIDTH = 6;
    private Component initialFocusComponent = null;
    private WindowListener[] windowListeners = null;

    public DialogHelper(Component component, AppInfo appInfo, String string, boolean bl) {
        this.allowEmbed = bl;
        this.owner = component;
        this.ainfo = appInfo;
        this.title = string;
    }

    public Container getContentPane() {
        if (this.dialog != null) {
            this.content = this.dialog.getContentPane();
        } else if (this.content == null) {
            this.content = new JPanel();
        }
        return this.content;
    }

    public void setContentPane(Container container) {
        this.content = container;
        if (this.dialog != null) {
            this.dialog.setContentPane(this.content);
        }
    }

    public void setModalOnTop(boolean bl) {
        this.modalOnTop = bl;
    }

    public void setDefaultButton(JButton jButton) {
        this.defaultButton = jButton;
        if (this.dialog != null) {
            this.dialog.getRootPane().setDefaultButton(jButton);
        }
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
        if (this.dialog != null) {
            this.dialog.setResizable(this.resizable);
        }
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void pack() {
        if (this.dialog != null) {
            this.dialog.pack();
        }
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public void setCancelAction(AbstractAction abstractAction) {
        this.cancelAction = abstractAction;
        if (this.dialog != null) {
            this.dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            this.dialog.getRootPane().getActionMap().put("cancel", this.cancelAction);
        }
    }

    public void addWindowListener(WindowListener windowListener) {
        if (this.dialog != null) {
            this.dialog.addWindowListener(windowListener);
        } else {
            int n = 1;
            if (this.windowListeners != null) {
                n += this.windowListeners.length;
            }
            WindowListener[] windowListenerArray = new WindowListener[n];
            for (int i = 0; i < n - 1; ++i) {
                windowListenerArray[i] = this.windowListeners[i];
            }
            windowListenerArray[n - 1] = windowListener;
            this.windowListeners = windowListenerArray;
        }
    }

    public void removeWindowListener(WindowListener windowListener) {
        if (this.dialog != null) {
            this.dialog.removeWindowListener(windowListener);
        } else {
            this.windowListeners = null;
        }
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.dialog != null) {
            this.dialog.setTitle(string);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.dialog != null) {
                this.dialog.setVisible(bl);
            } else if (this.useEmbeddedFrame()) {
                JApplet jApplet = new JApplet();
                Container container = this.getContentPane();
                jApplet.setContentPane(container);
                if (container instanceof JPanel) {
                    this.setContentBorder((JPanel)container);
                }
                DeployEmbeddedFrameIf deployEmbeddedFrameIf = (DeployEmbeddedFrameIf)((Object)this.owner);
                EmbeddedFrame embeddedFrame = (EmbeddedFrame)((Object)deployEmbeddedFrameIf);
                jApplet.setVisible(true);
                if (this.cancelAction != null) {
                    jApplet.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
                    jApplet.getRootPane().getActionMap().put("cancel", this.cancelAction);
                }
                if (this.defaultButton != null) {
                    jApplet.getRootPane().setDefaultButton(this.defaultButton);
                }
                if (this.windowListeners != null) {
                    for (int i = 0; i < this.windowListeners.length; ++i) {
                        embeddedFrame.addWindowListener(this.windowListeners[i]);
                    }
                }
                deployEmbeddedFrameIf.push(jApplet);
                embeddedFrame.pack();
                if (container instanceof JPanel) {
                    this.setContentBorder((JPanel)container);
                }
                UIFactory.afterDialog();
                this.showModalComponent(jApplet, (Frame)this.owner);
                deployEmbeddedFrameIf.pop();
                UIFactory.beforeDialog(this.owner);
            } else {
                this.dialog = this.owner == null || this.owner instanceof Frame ? new JDialog((Frame)this.owner, this.title, this.modalOnTop) : new JDialog((Dialog)this.owner, this.title, this.modalOnTop);
                if (this.content != null) {
                    this.setContentPane(this.content);
                } else {
                    this.content = this.dialog.getContentPane();
                }
                if (Config.isJavaVersionAtLeast16() && this.modalOnTop) {
                    this.dialog.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
                    this.dialog.setAlwaysOnTop(true);
                }
                this.setResizable(this.resizable);
                if (this.cancelAction != null) {
                    this.dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
                    this.dialog.getRootPane().getActionMap().put("cancel", this.cancelAction);
                }
                if (this.defaultButton != null) {
                    this.dialog.getRootPane().setDefaultButton(this.defaultButton);
                }
                if (this.windowListeners != null) {
                    for (int i = 0; i < this.windowListeners.length; ++i) {
                        this.dialog.addWindowListener(this.windowListeners[i]);
                    }
                }
                this.dialog.pack();
                UIFactory.placeWindow(this.dialog);
                this.dialog.pack();
                if (this.initialFocusComponent != null) {
                    this.initialFocusComponent.requestFocusInWindow();
                }
                this.dialog.setVisible(true);
            }
        } else if (this.dialog != null) {
            this.dialog.setVisible(false);
        } else {
            this.getContentPane().setVisible(false);
        }
    }

    public void setInitialFocusComponent(JComponent jComponent) {
        this.initialFocusComponent = jComponent;
    }

    private boolean useEmbeddedFrame() {
        if (this.owner == null || !(this.owner instanceof DeployEmbeddedFrameIf)) {
            return false;
        }
        if (!this.allowEmbed) {
            Trace.println("Dialog type is not candidate for embedding", TraceLevel.BASIC);
            return false;
        }
        if (!Config.getBooleanProperty("deployment.allow.embedded.dialog")) {
            Trace.println("Embedding dialogs not enabled in Configuration", TraceLevel.BASIC);
            return false;
        }
        if (System.getProperty("javapi.noembedded.dialog") != null) {
            Trace.println("Applet specifically prohibited embedding dialogs", TraceLevel.BASIC);
            return false;
        }
        Dimension dimension = this.getContentPane().getPreferredSize();
        Dimension dimension2 = this.owner.getSize();
        if (dimension.height + 2 + 6 > dimension2.height || dimension.width + 2 + 6 > dimension2.width) {
            Trace.println("Dialog would not fit in applet area - use Dialog", TraceLevel.BASIC);
            return false;
        }
        Trace.println("Using EmbeddedFrame to show dialog in Applet Area", TraceLevel.BASIC);
        return true;
    }

    private void setContentBorder(JPanel jPanel) {
        DropShadowBorder dropShadowBorder = new DropShadowBorder(6, Color.GRAY);
        jPanel.setBorder(dropShadowBorder);
        Dimension dimension = jPanel.getPreferredSize();
        Dimension dimension2 = this.owner.getSize();
        int n = dimension2.width - dimension.width;
        int n2 = dimension2.height - dimension.height;
        int n3 = n >= 40 ? 20 : n / 2;
        int n4 = n2 >= 40 ? 20 : n2 / 2;
        EmptyBorder emptyBorder = new EmptyBorder(n4, n3, n2 - n4, n - n3);
        jPanel.setBorder(BorderFactory.createCompoundBorder(emptyBorder, dropShadowBorder));
    }

    private Color muchBrighter(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return new Color(n + (255 - n) * 30 / 100, n2 + (255 - n2) * 30 / 100, n3 + (255 - n3) * 30 / 100);
    }

    public void showModalComponent(final JApplet jApplet, Frame frame) {
        jApplet.getContentPane().setVisible(true);
        try {
            new InvocationHandler(){

                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    return jApplet.getContentPane().isVisible() ? Boolean.TRUE : Boolean.FALSE;
                }

                public void start() throws Exception {
                    Class<?> clazz = Class.forName("java.awt.Conditional");
                    Object object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
                    Method method = Class.forName("java.awt.EventDispatchThread").getDeclaredMethod("pumpEvents", clazz);
                    method.setAccessible(true);
                    method.invoke((Object)Thread.currentThread(), object);
                }
            }.start();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private class DropShadowBorder
    extends AbstractBorder {
        private int width;
        private Color color;

        public DropShadowBorder(int n, Color color) {
            this.width = n;
            this.color = color;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, this.width + 1, this.width + 1);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 1;
            insets.left = 1;
            insets.bottom = this.width;
            insets.right = this.width;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.color);
            graphics.drawRect(n, n2, n3 - this.width - 1, n4 - this.width - 1);
            graphics.setColor(this.color.darker());
            for (int i = 0; i < this.width; ++i) {
                int n5 = n + i;
                int n6 = n2 + n4 - this.width + i;
                int n7 = n + n3 - this.width + i;
                int n8 = n6;
                graphics.drawLine(n5, n6, n7, n8);
                n5 = n + n3 - this.width + i;
                n6 = n2 + i;
                n7 = n5;
                n8 = n2 + n4 - this.width + i;
                graphics.drawLine(n5, n6, n7, n8);
                graphics.setColor(DialogHelper.this.muchBrighter(graphics.getColor()));
            }
            graphics.setColor(color);
        }
    }
}

