/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.TrustedLibraries;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.misc.JavaUtilJarAccess;
import sun.misc.SharedSecrets;

public class EnhancedJarVerifier
extends JarVerifier {
    public static JarVerifier create(URL uRL, String string, File file, File file2) {
        if (CacheEntry.hasEnhancedJarAccess()) {
            return new EnhancedJarVerifier(uRL, string, file, file2);
        }
        return null;
    }

    EnhancedJarVerifier(URL uRL, String string, File file, File file2) {
        super(uRL, string, file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(DownloadEngine.DownloadDelegate downloadDelegate) throws IOException, JARSigningException {
        JarFile jarFile = new JarFile(this.jarFile);
        this.manifest = jarFile.getManifest();
        try {
            int n;
            Object object;
            Enumeration enumeration = null;
            int n2 = 0;
            int n3 = jarFile.size();
            CodeSource[] codeSourceArray = null;
            JavaUtilJarAccess javaUtilJarAccess = null;
            if (downloadDelegate != null) {
                downloadDelegate.validating(this.jarLocation, 0, n3);
            }
            JavaUtilJarAccess javaUtilJarAccess2 = javaUtilJarAccess = SharedSecrets.javaUtilJarAccess();
            codeSourceArray = javaUtilJarAccess2.getCodeSources(jarFile, this.jarLocation);
            if (BlackList.getInstance().checkJarFile(jarFile)) {
                throw new JARSigningException(this.jarLocation, this.jarVersion, 5);
            }
            if (TrustedLibraries.checkJarFile(jarFile)) {
                object = this.manifest.getMainAttributes();
                ((Attributes)object).putValue("Trusted-Library", Boolean.TRUE.toString());
            }
            if (codeSourceArray != null && codeSourceArray.length > 0) {
                object = new ArrayList();
                for (n = 0; n < codeSourceArray.length; ++n) {
                    if (codeSourceArray[n].getCertificates() == null) continue;
                    object.add(codeSourceArray[n]);
                }
                if (object.size() != codeSourceArray.length) {
                    codeSourceArray = object.toArray(new CodeSource[object.size()]);
                } else {
                    this.hasOnlySignedEntries = true;
                }
            }
            enumeration = codeSourceArray != null && codeSourceArray.length > 0 ? javaUtilJarAccess2.entryNames(jarFile, codeSourceArray) : jarFile.entries();
            if (codeSourceArray != null && codeSourceArray.length == 1) {
                object = codeSourceArray[0].getCertificates();
                this.singleSignerIndicesCert = new int[((Cloneable)object).length];
                for (n = 0; n < ((Object)object).length; ++n) {
                    this.signerCerts.add(object[n]);
                    this.singleSignerIndicesCert[n] = n;
                }
                this.codeSourceCertCache.put(this.singleSignerIndicesCert, codeSourceArray[0]);
                if (Config.isJavaVersionAtLeast15()) {
                    CodeSigner[] codeSignerArray = codeSourceArray[0].getCodeSigners();
                    this.singleSignerIndicesCS = new int[codeSignerArray.length];
                    for (int i = 0; i < codeSignerArray.length; ++i) {
                        this.signersCS.add(codeSignerArray[i]);
                        this.singleSignerIndicesCS[i] = i;
                    }
                    this.codeSourceCache.put(this.singleSignerIndicesCS, codeSourceArray[0]);
                }
                this.hasSingleCodeSource = true;
            }
            while (enumeration.hasMoreElements()) {
                ++n2;
                object = null;
                JarEntry jarEntry = null;
                if (codeSourceArray != null && codeSourceArray.length > 0) {
                    object = (String)enumeration.nextElement();
                    jarEntry = jarFile.getJarEntry((String)object);
                } else {
                    jarEntry = (JarEntry)enumeration.nextElement();
                    object = jarEntry.getName();
                }
                if (jarEntry == null) {
                    this.hasMissingSignedEntries = true;
                    Trace.println("signed entry \"" + (String)object + "\" missing from jar " + this.jarLocation, TraceLevel.CACHE);
                }
                this.authenticateJarEntry(jarFile, jarEntry);
                this.processCertificates(jarFile, jarEntry, (String)object);
                this.processSigners(jarFile, jarEntry, (String)object);
                if (downloadDelegate == null || n2 % 10 != 0 && n2 < n3) continue;
                downloadDelegate.validating(this.jarLocation, n2, n3);
            }
            if (downloadDelegate != null) {
                downloadDelegate.validating(this.jarLocation, n3, n3);
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            jarFile.close();
            throw throwable;
        }
        jarFile.close();
    }
}

