/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.DragContext;
import com.sun.deploy.uitoolkit.DragHelper;
import com.sun.deploy.uitoolkit.DragListener;
import com.sun.deploy.uitoolkit.Window;
import com.sun.deploy.uitoolkit.impl.awt.AWTAppletAdapter;
import com.sun.deploy.uitoolkit.impl.awt.OldPluginAWTUtil;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import sun.plugin2.util.SystemUtil;

public class AWTDragHelper
implements DragHelper {
    private static final boolean DEBUG;
    private static final boolean isOSX;
    private static AWTDragHelper soleInstance;
    private boolean initialized;
    private Method isSystemGeneratedMethod;
    private List perAppletInfoList = new ArrayList();
    private volatile boolean dragging;
    private Image javaLogoImage;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$awt$SunToolkit;
    static /* synthetic */ Class class$java$awt$AWTEvent;
    static /* synthetic */ Class class$java$awt$event$MouseEvent;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public static AWTDragHelper getInstance() {
        return soleInstance;
    }

    public synchronized void register(DragContext dragContext, DragListener dragListener) {
        if (!this.initialize()) {
            return;
        }
        this.perAppletInfoList.add(new PerAppletInfo(dragContext, dragListener));
    }

    public void makeDisconnected(DragContext dragContext, Window window) {
        Iterator iterator = this.perAppletInfoList.iterator();
        while (iterator.hasNext()) {
            PerAppletInfo perAppletInfo = (PerAppletInfo)iterator.next();
            if (perAppletInfo.getDragContext() != dragContext) continue;
            perAppletInfo.makeDisconnected((Frame)window.getWindowObject());
            return;
        }
    }

    public synchronized void restore(DragContext dragContext) {
        Iterator iterator = this.perAppletInfoList.iterator();
        while (iterator.hasNext()) {
            PerAppletInfo perAppletInfo = (PerAppletInfo)iterator.next();
            if (perAppletInfo.getDragContext() != dragContext) continue;
            perAppletInfo.restore();
            return;
        }
    }

    public synchronized void unregister(DragContext dragContext) {
        Iterator iterator = this.perAppletInfoList.iterator();
        while (iterator.hasNext()) {
            PerAppletInfo perAppletInfo = (PerAppletInfo)iterator.next();
            if (perAppletInfo.getDragContext() != dragContext) continue;
            if (!$assertionsDisabled && perAppletInfo.iAmDragging()) {
                throw new AssertionError();
            }
            if (perAppletInfo.iAmDragging()) {
                if (DEBUG) {
                    Trace.print((String)"Dragging applet interrupted.", (TraceLevel)TraceLevel.UI);
                }
                this.setSomeoneDragging(false);
            }
            iterator.remove();
            return;
        }
    }

    private AWTDragHelper() {
    }

    private boolean initialize() {
        if (!this.initialized) {
            this.initialized = true;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    block2: {
                        try {
                            Class clazz = class$sun$awt$SunToolkit == null ? (class$sun$awt$SunToolkit = AWTDragHelper.class$("sun.awt.SunToolkit")) : class$sun$awt$SunToolkit;
                            AWTDragHelper.this.isSystemGeneratedMethod = clazz.getMethod("isSystemGenerated", class$java$awt$AWTEvent == null ? (class$java$awt$AWTEvent = AWTDragHelper.class$("java.awt.AWTEvent")) : class$java$awt$AWTEvent);
                            AWTDragHelper.this.isSystemGeneratedMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            if (isOSX) break block2;
                            exception.printStackTrace();
                        }
                    }
                    Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                        public void eventDispatched(AWTEvent aWTEvent) {
                            AWTDragHelper.this.dispatchEvent(aWTEvent);
                        }
                    }, 48L);
                    return null;
                }
            });
        }
        return this.isSystemGeneratedMethod != null || isOSX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof InputEvent) {
            InputEvent inputEvent = (InputEvent)aWTEvent;
            if (this.isSystemGenerated(aWTEvent) && (this.dragging || AWTDragHelper.couldBeDragStartEvent(inputEvent))) {
                AWTDragHelper aWTDragHelper = this;
                synchronized (aWTDragHelper) {
                    Iterator iterator = this.perAppletInfoList.iterator();
                    while (iterator.hasNext()) {
                        PerAppletInfo perAppletInfo = (PerAppletInfo)iterator.next();
                        if (!perAppletInfo.dispatchEvent(inputEvent)) continue;
                        return;
                    }
                }
            }
        }
    }

    private boolean isSystemGenerated(AWTEvent aWTEvent) {
        if (this.isSystemGeneratedMethod == null) {
            if (!isOSX) {
                return false;
            }
            return !((InputEvent)aWTEvent).isConsumed();
        }
        try {
            return (Boolean)this.isSystemGeneratedMethod.invoke(null, aWTEvent);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isSomeoneDragging() {
        return this.dragging;
    }

    private void setSomeoneDragging(boolean bl) {
        this.dragging = bl;
    }

    private static boolean couldBeDragStartEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        return n == 501 || n == 506;
    }

    private static Point getCurrentMouseLocation() {
        return (Point)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MouseInfo.getPointerInfo().getLocation();
            }
        });
    }

    private static Dimension getDragSize(Component component) {
        Dimension dimension = null;
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            Dimension dimension2 = component2.getSize();
            if (dimension != null && dimension2.width >= dimension.width && dimension2.height >= dimension.height) continue;
            dimension = dimension2;
        }
        return dimension;
    }

    private Image getJavaLogoImage(final Component component) {
        if (this.javaLogoImage == null) {
            this.javaLogoImage = (Image)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL uRL = ClassLoader.getSystemResource("com/sun/deploy/uitoolkit/impl/awt/JavaCupLogo-161.png");
                    Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                    MediaTracker mediaTracker = new MediaTracker(component);
                    mediaTracker.addImage(image, 0);
                    try {
                        mediaTracker.waitForID(0);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return image;
                }
            });
        }
        return this.javaLogoImage;
    }

    private Canvas getJavaLogoCanvas(Dimension dimension) {
        Canvas canvas = new Canvas(){

            public void paint(Graphics graphics) {
                Image image = AWTDragHelper.this.getJavaLogoImage(this);
                if (image != null) {
                    Rectangle rectangle = AWTDragHelper.getCenteredImageBoundsWithinContainer(new Dimension(image.getWidth(this), image.getHeight(this)), this.getParent().getSize());
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    graphics2D.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
                }
            }
        };
        canvas.setSize(dimension);
        return canvas;
    }

    private static Rectangle getCenteredImageBoundsWithinContainer(Dimension dimension, Dimension dimension2) {
        float f = (float)dimension2.width / (float)dimension2.height;
        float f2 = (float)dimension.width / (float)dimension.height;
        if (f < f2) {
            if (dimension.width > dimension2.width) {
                int n = (int)((float)dimension2.width / f2);
                return new Rectangle(0, (dimension2.height - n) / 2, dimension2.width, n);
            }
        } else if (dimension.height > dimension2.height) {
            int n = (int)((float)dimension2.height * f2);
            return new Rectangle((dimension2.width - n) / 2, 0, n, dimension2.height);
        }
        return new Rectangle((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
    }

    private static boolean isSubclass(Class clazz, String string) {
        if (clazz == null) {
            return false;
        }
        if (clazz.getName().equals(string)) {
            return true;
        }
        return AWTDragHelper.isSubclass(clazz.getSuperclass(), string);
    }

    static {
        $assertionsDisabled = !AWTDragHelper.class.desiredAssertionStatus();
        DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
        isOSX = System.getProperty("os.name").startsWith("Mac OS X");
        soleInstance = new AWTDragHelper();
    }

    private class PerAppletInfo {
        private DragContext ctx;
        private Frame frame;
        private Point dragOffset;
        private Point upperLeft;
        private DragListener listener;
        private boolean notificationsSent;
        private Frame closeButtonFrame;
        private final Point closeButtonOffset = new Point(5, -5);
        private ActionListener closeListener;
        private boolean closing;
        private Dimension dragSize;
        private static final int CLOSE_BUTTON_SIZE = 10;
        private static final int CLOSE_BUTTON_OFFSET = 5;
        private boolean initializedDragStartMethod;
        private Method dragStartMethod;

        PerAppletInfo(DragContext dragContext, DragListener dragListener) {
            this.ctx = dragContext;
            this.listener = dragListener;
        }

        public DragContext getDragContext() {
            return this.ctx;
        }

        public boolean dispatchEvent(AWTEvent aWTEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            if (AWTDragHelper.this.isSomeoneDragging() && !this.iAmDragging()) {
                return false;
            }
            Applet applet = ((AWTAppletAdapter)this.ctx.getApplet2Adapter()).getApplet();
            if (applet == null) {
                return false;
            }
            if (this.ctx.getModalityLevel() != 0) {
                return false;
            }
            if (this.iAmDragging()) {
                this.dispatchEventImpl(applet, mouseEvent, this.ctx.isSignedApplet());
                return true;
            }
            boolean bl = false;
            for (Component component = mouseEvent.getComponent(); component != null; component = component.getParent()) {
                if (component != applet) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
            if (this.isDragStartEvent(applet, mouseEvent)) {
                this.dispatchEventImpl(applet, mouseEvent, this.ctx.isSignedApplet());
                return true;
            }
            return false;
        }

        public void restore() {
            Container container = (Container)this.ctx.getParentContainer().getWindowObject();
            Applet applet = ((AWTAppletAdapter)this.ctx.getApplet2Adapter()).getApplet();
            if (applet != null && container != null) {
                if (container instanceof JFrame) {
                    ((JFrame)container).getContentPane().removeAll();
                } else {
                    container.removeAll();
                }
                applet.resize(this.dragSize.width, this.dragSize.height);
                container.add(applet);
                this.sendAppletRestored(applet);
                this.notificationsSent = false;
                this.closing = false;
                applet.repaint();
            }
        }

        private boolean iAmDragging() {
            return this.dragOffset != null;
        }

        private void setFrameTitle(Frame frame) {
            String string = this.ctx.getDraggedTitle();
            int n = string.lastIndexOf(".");
            if (n > 0) {
                string = string.substring(n + 1);
            }
            frame.setTitle(string);
        }

        private void setupCloseListener(Applet applet, boolean bl) {
            this.closeListener = new CloseListener();
            if (!this.sendSetAppletCloseListener(applet, this.closeListener)) {
                this.closeButtonFrame = this.createCloseButton(this.closeListener, bl);
                this.refreshCloseButtonFrame();
                this.closeButtonFrame.setVisible(true);
            }
        }

        private void setupWindow(Frame frame) {
            DisplayMode displayMode;
            GraphicsDevice graphicsDevice;
            frame.addWindowListener(new WindowAdapter(){
                private long lastActivate;

                public void windowActivated(WindowEvent windowEvent) {
                    long l = System.currentTimeMillis();
                    if (l - this.lastActivate > 200L) {
                        if (PerAppletInfo.this.closeButtonFrame != null) {
                            PerAppletInfo.this.closeButtonFrame.toFront();
                        }
                        this.lastActivate = l;
                    }
                }

                public void windowClosing(WindowEvent windowEvent) {
                    if (PerAppletInfo.this.closeListener != null) {
                        PerAppletInfo.this.closeListener.actionPerformed(null);
                    }
                }

                public void windowIconified(WindowEvent windowEvent) {
                    if (PerAppletInfo.this.closeButtonFrame != null) {
                        PerAppletInfo.this.closeButtonFrame.setVisible(false);
                    }
                }

                public void windowDeiconified(WindowEvent windowEvent) {
                    if (PerAppletInfo.this.closeButtonFrame != null) {
                        PerAppletInfo.this.closeButtonFrame.setVisible(true);
                        PerAppletInfo.this.refreshCloseButtonFrame();
                    }
                }
            });
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (graphicsEnvironment != null && (graphicsDevice = graphicsEnvironment.getDefaultScreenDevice()) != null && (displayMode = graphicsDevice.getDisplayMode()) != null) {
                int n = 30;
                frame.setMaximizedBounds(new Rectangle(0, 0, displayMode.getWidth() - n, displayMode.getHeight() - n));
            }
        }

        private void makeDisconnected(Frame frame) {
            this.frame = frame;
            this.setupWindow(frame);
            this.setFrameTitle(frame);
            this.upperLeft = frame.getLocation();
            Applet applet = ((AWTAppletAdapter)this.ctx.getApplet2Adapter()).getApplet();
            this.sendDragStarted(applet);
            this.sendDragFinished(applet);
            this.notificationsSent = true;
            this.setupCloseListener(applet, this.ctx.isSignedApplet());
        }

        private void refreshCloseButtonFrame() {
            if (this.closeButtonFrame != null && this.frame != null) {
                int n;
                Point point = this.frame.getLocationOnScreen();
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                int n2 = (int)dimension.getWidth();
                int n3 = point.x + this.frame.getWidth() + this.closeButtonOffset.x;
                if (n3 > n2) {
                    n3 = n2 - 10;
                }
                if ((n = point.y + this.closeButtonOffset.y) < 0) {
                    n = 10;
                }
                this.closeButtonFrame.setLocation(n3, n);
            }
        }

        private void dispatchEventImpl(Applet applet, MouseEvent mouseEvent, boolean bl) {
            if (!this.iAmDragging()) {
                AWTDragHelper.this.setSomeoneDragging(true);
                this.upperLeft = applet.getLocationOnScreen();
                Point point = AWTDragHelper.getCurrentMouseLocation();
                this.dragOffset = new Point(point.x - this.upperLeft.x, point.y - this.upperLeft.y);
                this.dragSize = AWTDragHelper.getDragSize(applet);
                if (this.frame == null) {
                    this.frame = AWTDragHelper.isSubclass(applet.getClass(), "javax.swing.JApplet") ? (bl ? new JFrame() : new DraggedAppletJFrame()) : (bl ? new Frame() : new DraggedAppletFrame());
                    this.ctx.setDraggedApplet();
                    boolean bl2 = this.ctx.getUndecorated();
                    this.frame.setUndecorated(bl2);
                    this.setupWindow(this.frame);
                    this.setFrameTitle(this.frame);
                    final Container container = (Container)this.ctx.getParentContainer().getWindowObject();
                    if (container != null) {
                        container.remove(applet);
                        OldPluginAWTUtil.invokeLater((Component)container, (Runnable)new Runnable(){

                            public void run() {
                                Canvas canvas = AWTDragHelper.this.getJavaLogoCanvas(PerAppletInfo.this.dragSize);
                                container.add(canvas);
                            }
                        });
                    }
                    this.frame.add((Component)applet, "Center");
                    applet.setLocation(0, 0);
                    this.frame.setSize(this.dragSize);
                    this.frame.setResizable(false);
                }
                if (!this.notificationsSent) {
                    this.sendDragStarted(applet);
                    this.listener.appletDraggingToDesktop(this.ctx);
                }
                this.frame.setLocation(this.upperLeft);
                this.frame.setVisible(true);
                if (isOSX && !this.notificationsSent) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                Robot robot = new Robot();
                                robot.mouseRelease(16);
                                robot.mousePress(16);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            return null;
                        }
                    });
                }
            } else {
                int n = mouseEvent.getID();
                if (n == 506 || n == 505) {
                    if (this.frame != null && this.dragOffset != null) {
                        block14: {
                            try {
                                Point point = AWTDragHelper.getCurrentMouseLocation();
                                this.upperLeft.x = point.x - this.dragOffset.x;
                                this.upperLeft.y = point.y - this.dragOffset.y;
                            }
                            catch (Throwable throwable) {
                                if (n == 505) break block14;
                                int n2 = mouseEvent.getX() - this.dragOffset.x;
                                int n3 = mouseEvent.getY() - this.dragOffset.y;
                                this.upperLeft.x += n2;
                                this.upperLeft.y += n3;
                            }
                        }
                        this.frame.setLocation(this.upperLeft);
                        this.frame.toFront();
                        if (this.closeButtonFrame != null) {
                            this.refreshCloseButtonFrame();
                            this.closeButtonFrame.toFront();
                        }
                    }
                } else if (n == 502 && mouseEvent.getButton() == 1 || n == 503) {
                    this.dragOffset = null;
                    if (!this.notificationsSent) {
                        this.sendDragFinished(applet);
                        this.listener.appletDroppedOntoDesktop(this.ctx);
                        this.notificationsSent = true;
                        this.setupCloseListener(applet, bl);
                    }
                    AWTDragHelper.this.setSomeoneDragging(false);
                }
            }
            mouseEvent.consume();
        }

        private Frame createCloseButton(final ActionListener actionListener, boolean bl) {
            Canvas canvas = new Canvas(){

                public void paint(Graphics graphics) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    int n = (int)Math.max(1.0, 0.025 * (double)Math.min(this.getWidth(), this.getHeight()));
                    int n2 = this.getWidth() / 2;
                    int n3 = this.getHeight() / 2;
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.fillRect(0, 0, n, this.getHeight());
                    graphics2D.fillRect(0, 0, this.getWidth(), n);
                    graphics2D.fillRect(0, this.getHeight() - n, this.getWidth(), n);
                    graphics2D.fillRect(this.getWidth() - n, 0, n, this.getHeight());
                    graphics2D.setStroke(new BasicStroke(n, 0, 2));
                    float f = 0.15f;
                    graphics2D.drawLine((int)(f * (float)this.getWidth()), (int)(f * (float)this.getHeight()), (int)((1.0f - f) * (float)this.getWidth()), (int)((1.0f - f) * (float)this.getHeight()));
                    graphics2D.drawLine((int)((1.0f - f) * (float)this.getWidth()), (int)(f * (float)this.getHeight()), (int)(f * (float)this.getWidth()), (int)((1.0f - f) * (float)this.getHeight()));
                }
            };
            canvas.setBackground(Color.BLACK);
            canvas.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    actionListener.actionPerformed(null);
                    if (PerAppletInfo.this.closeButtonFrame != null) {
                        PerAppletInfo.this.closeButtonFrame.setVisible(false);
                        PerAppletInfo.this.closeButtonFrame.dispose();
                        PerAppletInfo.this.closeButtonFrame = null;
                    }
                }
            });
            Frame frame = new Frame();
            frame.setUndecorated(true);
            frame.setResizable(false);
            frame.setFocusableWindowState(false);
            frame.add(canvas);
            frame.setSize(10, 10);
            return frame;
        }

        private boolean isDragStartEvent(Applet applet, MouseEvent mouseEvent) {
            if (!this.initializedDragStartMethod) {
                this.initializedDragStartMethod = true;
                try {
                    this.dragStartMethod = applet.getClass().getMethod("isAppletDragStart", class$java$awt$event$MouseEvent == null ? (class$java$awt$event$MouseEvent = AWTDragHelper.class$("java.awt.event.MouseEvent")) : class$java$awt$event$MouseEvent);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.dragStartMethod != null) {
                try {
                    Boolean bl = (Boolean)this.dragStartMethod.invoke((Object)applet, mouseEvent);
                    return bl;
                }
                catch (Throwable throwable) {
                    this.dragStartMethod = null;
                }
            }
            int n = mouseEvent.getModifiersEx();
            return mouseEvent.getButton() == 1 && (n == 1536 || !isOSX && n == 1280);
        }

        private void sendDragStarted(Applet applet) {
            if (DEBUG) {
                System.out.println("DragHelper sending appletDragStarted for applet ID " + this.ctx.getAppletId());
            }
            try {
                Method method = applet.getClass().getMethod("appletDragStarted", null);
                method.invoke((Object)applet, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void sendDragFinished(Applet applet) {
            if (DEBUG) {
                System.out.println("DragHelper sending appletDragFinished for applet ID " + this.ctx.getAppletId());
            }
            try {
                Method method = applet.getClass().getMethod("appletDragFinished", null);
                method.invoke((Object)applet, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void sendAppletRestored(Applet applet) {
            if (DEBUG) {
                System.out.println("DragHelper sending appletRestored for applet ID " + this.ctx.getAppletId());
            }
            try {
                Method method = applet.getClass().getMethod("appletRestored", null);
                method.invoke((Object)applet, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private boolean sendSetAppletCloseListener(Applet applet, ActionListener actionListener) {
            if (DEBUG) {
                System.out.println("DragHelper sending setAppletCloseListener for applet ID " + this.ctx.getAppletId());
            }
            try {
                Method method = applet.getClass().getMethod("setAppletCloseListener", class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = AWTDragHelper.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
                method.invoke((Object)applet, actionListener);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        class CloseListener
        implements ActionListener {
            CloseListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (PerAppletInfo.this.closing) {
                    return;
                }
                PerAppletInfo.this.closing = true;
                if (PerAppletInfo.this.listener != null) {
                    PerAppletInfo.this.listener.appletExternalWindowClosed(PerAppletInfo.this.ctx);
                }
                if (PerAppletInfo.this.ctx.isDisconnected()) {
                    AWTDragHelper.this.unregister(PerAppletInfo.this.ctx);
                }
                PerAppletInfo.this.frame.setVisible(false);
                PerAppletInfo.this.frame.dispose();
                PerAppletInfo.this.frame = null;
                if (PerAppletInfo.this.closeButtonFrame != null) {
                    PerAppletInfo.this.closeButtonFrame.setVisible(false);
                    PerAppletInfo.this.closeButtonFrame.dispose();
                    PerAppletInfo.this.closeButtonFrame = null;
                }
            }
        }
    }

    public class DraggedAppletFrame
    extends Frame {
        DraggedAppletFrame() {
        }
    }

    public class DraggedAppletJFrame
    extends JFrame {
        DraggedAppletJFrame() {
        }
    }
}

