/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.EventInfo;
import com.oracle.jrockit.jfr.NoSuchEventException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.jrockit.jfr.MetaProducer;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.events.EventControl;
import oracle.jrockit.jfr.settings.EventDefault;
import oracle.jrockit.jfr.settings.EventDefaultSet;
import oracle.jrockit.jfr.settings.EventSetting;
import oracle.jrockit.jfr.settings.EventSettings;

@Deprecated
final class Settings
implements EventSettings {
    private final Object lock;
    private final Map<Integer, EventControl> eventControls;
    private final Collection<Recording> recordings;
    private final MetaProducer metaProducer;
    private final HashMap<Integer, EventSetting> eventSettings = new HashMap();
    private final HashMap<Integer, EventSetting> disabledSettings = new HashMap();
    private final Aggregator globalAggregator = new Aggregator();

    Settings(Object object, Map<Integer, EventControl> map, Collection<Recording> collection, MetaProducer metaProducer) {
        this.lock = object;
        this.eventControls = map;
        this.recordings = collection;
        this.metaProducer = metaProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvents(Collection<? extends EventInfo> collection) {
        Object object = this.lock;
        synchronized (object) {
            HashMap<Integer, EventSetting> hashMap = new HashMap<Integer, EventSetting>();
            for (EventInfo object2 : collection) {
                int n = object2.getId();
                hashMap.put(n, new EventSetting(n));
            }
            this.disabledSettings.putAll(hashMap);
            this.globalAggregator.updateDefaults(collection);
            for (Recording recording : this.recordings) {
                recording.settingsAggregator.updateDefaults(collection);
            }
            this.update(hashMap);
        }
    }

    private void update(HashMap<Integer, EventSetting> hashMap) {
        assert (Thread.holdsLock(this.lock));
        for (Recording object : this.recordings) {
            if (!object.isStarted() || object.isStoppingDone()) continue;
            object.settingsAggregator.mergeAll(hashMap);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            EventControl eventControl = this.eventControls.get(entry.getKey());
            assert (eventControl != null);
            eventControl.apply((EventSetting)entry.getValue());
        }
        this.metaProducer.settingsChanged(hashMap.values(), this.eventSettings);
        this.eventSettings.putAll(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update() {
        Object object = this.lock;
        synchronized (object) {
            HashMap<Integer, EventSetting> hashMap = new HashMap<Integer, EventSetting>(this.disabledSettings);
            this.update(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEvents(Collection<? extends EventInfo> collection) {
        Object object = this.lock;
        synchronized (object) {
            for (EventInfo object2 : collection) {
                int n = object2.getId();
                this.disabledSettings.remove(n);
                this.eventSettings.remove(n);
            }
            this.globalAggregator.remove(collection);
            for (Recording recording : this.recordings) {
                recording.settingsAggregator.remove(collection);
            }
        }
    }

    Aggregator subAggregator() {
        return new Aggregator(this.globalAggregator);
    }

    @Override
    public void addEventDefaultSet(EventDefaultSet eventDefaultSet) {
        this.globalAggregator.addEventDefaultSet(eventDefaultSet);
    }

    @Override
    public Collection<EventDefault> getEventDefaults() {
        return this.globalAggregator.getEventDefaults();
    }

    @Override
    public List<EventDefaultSet> getEventDefaultSets() {
        return this.globalAggregator.getEventDefaultSets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventSetting getSetting(int n) throws NoSuchEventException {
        Object object = this.lock;
        synchronized (object) {
            EventSetting eventSetting = this.eventSettings.get(n);
            if (eventSetting == null) {
                throw new NoSuchEventException(String.valueOf(n));
            }
            return eventSetting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<EventSetting> getSettings() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<EventSetting>(this.eventSettings.values());
        }
    }

    @Override
    public void putSettings(Collection<EventSetting> collection) {
        throw new IllegalStateException("No allowed");
    }

    @Override
    public void replaceEventDefaultSets(Collection<EventDefaultSet> collection) {
        this.globalAggregator.replaceEventDefaultSets(collection);
    }

    @Deprecated
    final class Aggregator
    implements EventSettings {
        private final CopyOnWriteArrayList<EventDefaultSet> defaultSets = new CopyOnWriteArrayList();
        private final HashMap<Integer, EventSetting> defaults = new HashMap();
        private final HashMap<Integer, EventSetting> settings = new HashMap();
        private final Aggregator parent;

        Aggregator() {
            this(null);
        }

        Aggregator(Aggregator aggregator) {
            this.parent = aggregator;
        }

        private void updateDefaults() {
            this.updateDefaults(Settings.this.eventControls.values());
            Settings.this.update();
        }

        void updateDefaults(Collection<? extends EventInfo> collection) {
            assert (Thread.holdsLock(Settings.this.lock));
            this.mergeDefaults(collection, this.defaults);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(Collection<? extends EventInfo> collection) {
            Object object = Settings.this.lock;
            synchronized (object) {
                for (EventInfo eventInfo : collection) {
                    int n = eventInfo.getId();
                    this.defaults.remove(n);
                    this.settings.remove(n);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void putAll(Collection<? extends EventInfo> collection, Map<Integer, EventSetting> map) {
            Object object = Settings.this.lock;
            synchronized (object) {
                for (EventInfo eventInfo : collection) {
                    int n = eventInfo.getId();
                    map.put(n, this.get(n));
                }
            }
        }

        void mergeAll(Map<Integer, EventSetting> map) {
            assert (Thread.holdsLock(Settings.this.lock));
            for (Map.Entry<Integer, EventSetting> entry : map.entrySet()) {
                int n = entry.getKey();
                EventSetting eventSetting = entry.getValue();
                EventSetting eventSetting2 = this.get0(n);
                if (eventSetting2 == null || eventSetting2 == eventSetting) continue;
                entry.setValue(new EventSetting(eventSetting2, eventSetting));
            }
        }

        public Collection<EventSetting> getSettings(Collection<? extends EventInfo> collection) {
            HashMap<Integer, EventSetting> hashMap = new HashMap<Integer, EventSetting>();
            this.putAll(collection, hashMap);
            return hashMap.values();
        }

        @Override
        public Collection<EventSetting> getSettings() {
            return this.getSettings(Settings.this.eventControls.values());
        }

        private EventSetting get0(int n) {
            EventSetting eventSetting = null;
            if (!this.settings.isEmpty()) {
                eventSetting = this.settings.get(n);
            }
            if (eventSetting == null && !this.defaults.isEmpty()) {
                eventSetting = this.defaults.get(n);
            }
            if (eventSetting == null && this.parent != null) {
                eventSetting = this.parent.get0(n);
            }
            return eventSetting;
        }

        private EventSetting get(int n) {
            EventSetting eventSetting = this.get0(n);
            if (eventSetting == null) {
                eventSetting = (EventSetting)Settings.this.disabledSettings.get(n);
            }
            return eventSetting;
        }

        private boolean exists(int n) {
            return Settings.this.disabledSettings.containsKey(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public EventSetting getSetting(int n) throws NoSuchEventException {
            Object object = Settings.this.lock;
            synchronized (object) {
                EventSetting eventSetting = this.get(n);
                if (eventSetting == null) {
                    throw new NoSuchEventException(String.valueOf(n));
                }
                return eventSetting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putSettings(Collection<EventSetting> collection) {
            HashMap<Integer, EventSetting> hashMap = new HashMap<Integer, EventSetting>();
            Object object = Settings.this.lock;
            synchronized (object) {
                for (EventSetting eventSetting : collection) {
                    int n = eventSetting.getId();
                    if (!this.exists(n)) continue;
                    hashMap.put(n, eventSetting);
                }
                this.settings.putAll(hashMap);
                Settings.this.update(hashMap);
            }
        }

        public void putSetting(EventSetting eventSetting) {
            this.putSettings(Collections.singletonList(eventSetting));
        }

        @Override
        public Collection<EventDefault> getEventDefaults() {
            ArrayList<EventDefault> arrayList = new ArrayList<EventDefault>();
            for (EventDefaultSet eventDefaultSet : this.defaultSets) {
                arrayList.addAll(eventDefaultSet.getAll());
            }
            return arrayList;
        }

        @Override
        public List<EventDefaultSet> getEventDefaultSets() {
            return this.defaultSets;
        }

        @Override
        public void addEventDefaultSet(EventDefaultSet eventDefaultSet) {
            this.defaultSets.add(eventDefaultSet);
            this.updateDefaults();
        }

        @Override
        public void replaceEventDefaultSets(Collection<EventDefaultSet> collection) {
            this.defaultSets.clear();
            this.defaultSets.addAll(collection);
            this.updateDefaults();
        }

        private void mergeDefaults(Collection<? extends EventInfo> collection, Map<Integer, EventSetting> map) {
            if (this.defaultSets.isEmpty()) {
                return;
            }
            for (EventInfo eventInfo : collection) {
                EventSetting eventSetting = this.getDefault(eventInfo);
                if (eventInfo == null) continue;
                map.put(eventInfo.getId(), eventSetting);
            }
        }

        private EventSetting getDefault(EventInfo eventInfo) {
            EventSetting eventSetting = null;
            for (EventDefaultSet eventDefaultSet : this.defaultSets) {
                EventSetting eventSetting2 = eventDefaultSet.get(eventInfo.getURI());
                if (eventSetting2 == null) continue;
                eventSetting = new EventSetting(eventInfo, eventSetting2);
            }
            return eventSetting;
        }

        public void copy(Aggregator aggregator) {
            assert (this.parent == aggregator.parent);
            this.putSettings(aggregator.settings.values());
            this.replaceEventDefaultSets(aggregator.defaultSets);
            assert (this.equals(aggregator));
        }

        public boolean equals(Aggregator aggregator) {
            if (aggregator == null) {
                return false;
            }
            return this.equals(this.settings, aggregator.settings) && this.equals(this.defaultSets, aggregator.defaultSets) && this.equals(this.defaults, aggregator.defaults) && this.equals(this.parent, aggregator.parent);
        }

        private boolean equals(Object object, Object object2) {
            if (object == null) {
                return object2 != null;
            }
            return object.equals(object2);
        }
    }
}

