/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.AdapterMethodHandle;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.CountingMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.FilterGeneric;
import java.lang.invoke.FilterOneArgument;
import java.lang.invoke.FromGeneric;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.ToGeneric;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sun.invoke.empty.Empty;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;
import sun.misc.Unsafe;

abstract class MethodHandleImpl {
    private static final MemberName.Factory LOOKUP = MemberName.Factory.INSTANCE;
    static MethodHandle SELECT_ALTERNATIVE;
    static MethodHandle THROW_EXCEPTION;

    MethodHandleImpl() {
    }

    static void initStatics() {
    }

    static MethodHandle findMethod(MemberName memberName, boolean bl, Class<?> clazz) throws IllegalAccessException {
        Class<?> clazz2;
        Object object;
        MethodType methodType = memberName.getMethodType();
        if (!memberName.isStatic()) {
            object = memberName.getDeclaringClass();
            methodType = methodType.insertParameterTypes(0, new Class[]{object});
        }
        if (!((DirectMethodHandle)(object = new DirectMethodHandle(methodType, memberName, bl, clazz))).isValid()) {
            throw memberName.makeAccessException("no direct method handle", clazz);
        }
        assert (((MethodHandle)object).type() == methodType);
        if (!memberName.isVarargs()) {
            return object;
        }
        int n = methodType.parameterCount();
        if (n != 0 && (clazz2 = methodType.parameterType(n - 1)).isArray()) {
            return AdapterMethodHandle.makeVarargsCollector((MethodHandle)object, clazz2);
        }
        throw memberName.makeAccessException("cannot make variable arity", null);
    }

    static MethodHandle makeAllocator(MethodHandle methodHandle) {
        Class<?> clazz;
        MethodType methodType = methodHandle.type();
        if (AdapterMethodHandle.canCollectArguments(methodType, MethodType.methodType(clazz = methodType.parameterType(0)), 0, true)) {
            MethodHandle methodHandle2 = MethodHandles.identity(clazz);
            MethodType methodType2 = methodType.insertParameterTypes(0, clazz).changeReturnType(clazz);
            MethodHandle methodHandle3 = AdapterMethodHandle.makeCollectArguments(methodHandle2, methodHandle, 1, false);
            assert (methodHandle3.type().equals((Object)methodType2));
            methodType2 = methodType2.dropParameterTypes(0, 1);
            methodHandle3 = AdapterMethodHandle.makeCollectArguments(methodHandle3, methodHandle2, 0, true);
            AllocateObject allocateObject = new AllocateObject(clazz);
            assert (allocateObject.type().equals((Object)MethodType.methodType(clazz)));
            methodType2 = methodType2.dropParameterTypes(0, 1);
            MethodHandle methodHandle4 = MethodHandleImpl.foldArguments(methodHandle3, methodType2, 0, allocateObject);
            return methodHandle4;
        }
        assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
        MethodHandle methodHandle5 = AllocateObject.make(clazz, methodHandle);
        assert (methodHandle5.type().equals((Object)methodType.dropParameterTypes(0, 1).changeReturnType(methodType.parameterType(0))));
        return methodHandle5;
    }

    static MethodHandle accessField(MemberName memberName, boolean bl, Class<?> clazz) {
        FieldAccessor fieldAccessor = new FieldAccessor(memberName, bl);
        return fieldAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MethodHandle accessArrayElement(Class<?> clazz, boolean bl) {
        if (!clazz.isArray()) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array: " + clazz);
        }
        Class<?> clazz2 = clazz.getComponentType();
        MethodHandle[] methodHandleArray = FieldAccessor.ARRAY_CACHE.get(clazz2);
        if (methodHandleArray == null) {
            if (!FieldAccessor.doCache(clazz2)) {
                return FieldAccessor.ahandle(clazz, bl);
            }
            methodHandleArray = new MethodHandle[]{FieldAccessor.ahandle(clazz, false), FieldAccessor.ahandle(clazz, true)};
            if (methodHandleArray[0].type().parameterType(0) == Class.class) {
                methodHandleArray[0] = methodHandleArray[0].bindTo(clazz2);
                methodHandleArray[1] = methodHandleArray[1].bindTo(clazz2);
            }
            HashMap<Class<?>, MethodHandle[]> hashMap = FieldAccessor.ARRAY_CACHE;
            synchronized (hashMap) {
            }
            FieldAccessor.ARRAY_CACHE.put(clazz2, methodHandleArray);
        }
        return methodHandleArray[bl ? 1 : 0];
    }

    static MethodHandle bindReceiver(MethodHandle methodHandle, Object object) {
        DirectMethodHandle directMethodHandle;
        Object object2;
        if (object == null) {
            return null;
        }
        if (methodHandle instanceof AdapterMethodHandle && ((AdapterMethodHandle)methodHandle).conversionOp() == 0 && (object2 = MethodHandleNatives.getTargetInfo(methodHandle)) instanceof DirectMethodHandle && (directMethodHandle = (DirectMethodHandle)object2).type().parameterType(0).isAssignableFrom(object.getClass())) {
            BoundMethodHandle boundMethodHandle = new BoundMethodHandle(directMethodHandle, object, 0);
            MethodType methodType = methodHandle.type().dropParameterTypes(0, 1);
            return MethodHandleImpl.convertArguments(boundMethodHandle, methodType, boundMethodHandle.type(), 0);
        }
        if (methodHandle instanceof DirectMethodHandle) {
            return new BoundMethodHandle((DirectMethodHandle)methodHandle, object, 0);
        }
        return null;
    }

    static MethodHandle bindArgument(MethodHandle methodHandle, int n, Object object) {
        return new BoundMethodHandle(methodHandle, object, n);
    }

    static MethodHandle permuteArguments(MethodHandle methodHandle, MethodType methodType, MethodType methodType2, int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        assert (methodType2.parameterCount() == methodHandle.type().parameterCount());
        int n5 = methodType2.parameterCount();
        int n6 = methodType.parameterCount();
        if (nArray.length != n5) {
            throw MethodHandleStatics.newIllegalArgumentException("wrong number of arguments in permutation");
        }
        Class[] classArray = new Class[n5];
        for (int i = 0; i < n5; ++i) {
            classArray[i] = methodType.parameterType(nArray[i]);
        }
        MethodType methodType3 = MethodType.methodType(methodType2.returnType(), classArray);
        methodHandle = MethodHandleImpl.convertArguments(methodHandle, methodType3, methodType2, 0);
        assert (methodHandle != null);
        methodType2 = methodHandle.type();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        for (n4 = 0; n4 < n5; ++n4) {
            arrayList2.add(nArray[n4] * 10);
        }
        for (n4 = 0; n4 < n6; ++n4) {
            if (arrayList2.contains(n4 * 10)) {
                arrayList.add(n4 * 10);
                continue;
            }
            arrayList3.add(n4);
        }
        while (arrayList2.size() > arrayList.size()) {
            for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                n3 = (Integer)arrayList2.get(n4);
                n2 = arrayList2.indexOf(n3);
                if (n2 == n4) continue;
                n = n6++ * 10;
                arrayList2.set(n4, n);
                arrayList4.add(arrayList.indexOf(n3));
                arrayList.add(n);
            }
        }
        assert (arrayList2.size() == arrayList.size());
        n4 = arrayList.size();
        while (!arrayList2.equals(arrayList)) {
            int n7;
            int n8;
            int n9;
            int n10;
            n3 = -100;
            n2 = 0;
            n = -100;
            int n11 = 0;
            for (n10 = 0; n10 < n4; ++n10) {
                n9 = (Integer)arrayList2.get(n10);
                if (n9 == n + 10) {
                    n = n9;
                    if (n2 >= ++n11) continue;
                    n2 = n11;
                    n3 = n;
                    continue;
                }
                n11 = 0;
                n = -100;
                n8 = (Integer)arrayList.get(n10);
                if (n9 == n8 || n9 < n8 - 10 || n9 > n8 + 10) continue;
                n = n9;
                n11 = 1;
            }
            if (n2 >= 2) {
                n10 = arrayList2.indexOf(n3);
                n9 = arrayList.indexOf(n3);
                n8 = n10 - n9;
                n7 = n10 - (n2 - 1);
                int n12 = n9 - (n2 - 1);
                assert ((n10 | n7 | n9 | n12) >= 0);
                int n13 = Math.min(n7, n12);
                int n14 = Math.max(n10, n9);
                int n15 = 0;
                for (int i = n13; i <= n14; ++i) {
                    if (((Integer)arrayList2.get(i)).intValue() == ((Integer)arrayList.get(i)).intValue()) continue;
                    ++n15;
                }
                List list = arrayList2.subList(n13, n14 + 1);
                Collections.rotate(list, -n8);
                for (int i = n13; i <= n14; ++i) {
                    if (((Integer)arrayList2.get(i)).intValue() == ((Integer)arrayList.get(i)).intValue()) continue;
                    --n15;
                }
                if (n15 >= 2) {
                    List<Class<?>> list2 = Arrays.asList(methodType2.parameterArray());
                    Collections.rotate(list2.subList(n13, n14 + 1), -n8);
                    MethodType methodType4 = MethodType.methodType(methodType2.returnType(), list2);
                    MethodHandle methodHandle2 = AdapterMethodHandle.makeRotateArguments(methodType4, methodHandle, n13, list.size(), n8);
                    if (methodHandle2 != null) {
                        methodHandle = methodHandle2;
                        methodType2 = methodType4;
                        continue;
                    }
                }
                Collections.rotate(list, n8);
            }
            List<Class<?>> list = Arrays.asList(methodType2.parameterArray());
            for (n9 = 0; n9 < n4; ++n9) {
                n8 = (Integer)arrayList.get(n9);
                if (n8 == (Integer)arrayList2.get(n9)) continue;
                n7 = arrayList2.indexOf(n8);
                Collections.swap(list, n9, n7);
                MethodType methodType5 = MethodType.methodType(methodType2.returnType(), list);
                methodHandle = AdapterMethodHandle.makeSwapArguments(methodType5, methodHandle, n9, n7);
                if (methodHandle == null) {
                    throw MethodHandleStatics.newIllegalArgumentException("cannot swap");
                }
                assert (methodHandle.type() == methodType5);
                methodType2 = methodType5;
                Collections.swap(arrayList2, n9, n7);
            }
            assert (arrayList2.equals(arrayList));
        }
        while (!arrayList4.isEmpty()) {
            int n16;
            n3 = arrayList4.size() - 1;
            n2 = (Integer)arrayList4.get(n3);
            n = 1;
            while (n3 - 1 >= 0 && (n16 = ((Integer)arrayList4.get(n3 - 1)).intValue()) == n2 - 1) {
                --n2;
                ++n;
                --n3;
            }
            arrayList4.subList(n3, arrayList4.size()).clear();
            List<Class<?>> list = methodType2.parameterList();
            list = list.subList(0, list.size() - n);
            MethodType methodType6 = MethodType.methodType(methodType2.returnType(), list);
            methodHandle = AdapterMethodHandle.makeDupArguments(methodType6, methodHandle, n2, n);
            if (methodHandle == null) {
                throw MethodHandleStatics.newIllegalArgumentException("cannot dup");
            }
            methodType2 = methodHandle.type();
        }
        while (!arrayList3.isEmpty()) {
            int n17;
            n3 = (Integer)arrayList3.get(0);
            for (n2 = 1; n2 < arrayList3.size() && (n17 = ((Integer)arrayList3.get(n2)).intValue()) == n3 + n2; ++n2) {
            }
            arrayList3.subList(0, n2).clear();
            List<Class<?>> list = methodType.parameterList().subList(n3, n3 + n2);
            MethodType methodType7 = methodType2.insertParameterTypes(n3, list);
            methodHandle = AdapterMethodHandle.makeDropArguments(methodType7, methodHandle, n3, n2);
            if (methodHandle == null) {
                throw MethodHandleStatics.newIllegalArgumentException("cannot drop");
            }
            methodType2 = methodHandle.type();
        }
        methodHandle = MethodHandleImpl.convertArguments(methodHandle, methodType, methodType2, 0);
        assert (methodHandle != null);
        return methodHandle;
    }

    static MethodHandle convertArguments(MethodHandle methodHandle, MethodType methodType, int n) {
        Object object;
        Class<?> clazz;
        MethodType methodType2 = methodHandle.type();
        if (methodType2.equals((Object)methodType)) {
            return methodHandle;
        }
        assert (n > 1 || methodType2.isConvertibleTo(methodType));
        MethodHandle methodHandle2 = null;
        Class<?> clazz2 = methodType2.returnType();
        if (!VerifyType.isNullConversion(clazz2, clazz = methodType.returnType())) {
            if (clazz2 == Void.TYPE) {
                object = clazz.isPrimitive() ? Wrapper.forPrimitiveType(clazz) : Wrapper.OBJECT;
                methodHandle2 = ValueConversions.zeroConstantFunction(object);
            } else {
                methodHandle2 = MethodHandles.identity(clazz);
                methodHandle2 = MethodHandleImpl.convertArguments(methodHandle2, methodHandle2.type().changeParameterType(0, clazz2), n);
            }
            methodType = methodType.changeReturnType(clazz2);
        }
        object = null;
        IllegalArgumentException illegalArgumentException = null;
        try {
            object = MethodHandleImpl.convertArguments(methodHandle, methodType, methodType2, n);
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
        }
        if (object == null) {
            WrongMethodTypeException wrongMethodTypeException = new WrongMethodTypeException("cannot convert to " + methodType + ": " + methodHandle);
            wrongMethodTypeException.initCause(illegalArgumentException);
            throw wrongMethodTypeException;
        }
        if (methodHandle2 != null) {
            object = MethodHandles.filterReturnValue((MethodHandle)object, methodHandle2);
        }
        return object;
    }

    static MethodHandle convertArguments(MethodHandle methodHandle, MethodType methodType, MethodType methodType2, int n) {
        assert (methodType2.parameterCount() == methodHandle.type().parameterCount());
        if (methodType == methodType2) {
            return methodHandle;
        }
        if (methodType2.parameterCount() != methodType.parameterCount()) {
            throw MethodHandleStatics.newIllegalArgumentException("mismatched parameter count", methodType2, methodType);
        }
        MethodHandle methodHandle2 = AdapterMethodHandle.makePairwiseConvert(methodType, methodHandle, n);
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        int n2 = methodType2.parameterCount();
        assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
        MethodType methodType3 = MethodType.genericMethodType(n2);
        MethodHandle methodHandle3 = AdapterMethodHandle.makePairwiseConvert(methodType3, methodHandle, n);
        if (methodHandle3 == null) {
            methodHandle3 = FromGeneric.make(methodHandle);
        }
        if ((methodHandle2 = AdapterMethodHandle.makePairwiseConvert(methodType, methodHandle3, n)) != null) {
            return methodHandle2;
        }
        return ToGeneric.make(methodType, methodHandle3);
    }

    static MethodHandle spreadArguments(MethodHandle methodHandle, Class<?> clazz, int n) {
        MethodType methodType = methodHandle.type();
        int n2 = methodType.parameterCount();
        int n3 = n2 - n;
        MethodType methodType2 = methodType.dropParameterTypes(n3, n2).insertParameterTypes(n3, clazz);
        return MethodHandleImpl.spreadArguments(methodHandle, methodType2, n3, clazz, n);
    }

    static MethodHandle spreadArgumentsFromPos(MethodHandle methodHandle, MethodType methodType, int n) {
        int n2 = methodHandle.type().parameterCount() - n;
        return MethodHandleImpl.spreadArguments(methodHandle, methodType, n, Object[].class, n2);
    }

    static MethodHandle spreadArguments(MethodHandle methodHandle, MethodType methodType, int n, Class<?> clazz, int n2) {
        MethodType methodType2 = methodHandle.type();
        assert (n2 == methodType2.parameterCount() - n);
        assert (methodType.parameterType(n) == clazz);
        return AdapterMethodHandle.makeSpreadArguments(methodType, methodHandle, clazz, n, n2);
    }

    static MethodHandle collectArguments(MethodHandle methodHandle, int n, MethodHandle methodHandle2) {
        MethodType methodType = methodHandle.type();
        Class<?> clazz = methodHandle2.type().returnType();
        assert (clazz != Void.TYPE);
        if (clazz != methodType.parameterType(n)) {
            methodHandle = methodHandle.asType(methodType.changeParameterType(n, clazz));
        }
        MethodType methodType2 = methodType.dropParameterTypes(n, n + 1).insertParameterTypes(n, methodHandle2.type().parameterArray());
        return MethodHandleImpl.collectArguments(methodHandle, methodType2, n, methodHandle2);
    }

    static MethodHandle collectArguments(MethodHandle methodHandle, MethodType methodType, int n, MethodHandle methodHandle2) {
        MethodType methodType2 = methodHandle.type();
        MethodType methodType3 = methodHandle2.type();
        assert (methodType.parameterCount() == n + methodType3.parameterCount());
        assert (methodType2.parameterCount() == n + 1);
        MethodHandle methodHandle3 = null;
        if (AdapterMethodHandle.canCollectArguments(methodType2, methodType3, n, false)) {
            methodHandle3 = AdapterMethodHandle.makeCollectArguments(methodHandle, methodHandle2, n, false);
        }
        if (methodHandle3 == null) {
            assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
            MethodHandle methodHandle4 = MethodHandleImpl.convertArguments(methodHandle, methodType2.generic(), methodType2, 0);
            MethodHandle methodHandle5 = MethodHandleImpl.convertArguments(methodHandle2, methodType3.generic(), methodType3, 0);
            if (methodHandle4 == null || methodHandle5 == null) {
                return null;
            }
            MethodHandle methodHandle6 = FilterGeneric.makeArgumentCollector(methodHandle5, methodHandle4);
            methodHandle3 = MethodHandleImpl.convertArguments(methodHandle6, methodType, methodHandle6.type(), 0);
        }
        return methodHandle3;
    }

    static MethodHandle filterArgument(MethodHandle methodHandle, int n, MethodHandle methodHandle2) {
        MethodType methodType;
        MethodType methodType2 = methodHandle.type();
        MethodType methodType3 = methodHandle2.type();
        assert (methodType3.parameterCount() == 1);
        MethodHandle methodHandle3 = null;
        if (AdapterMethodHandle.canCollectArguments(methodType2, methodType3, n, false) && (methodHandle3 = AdapterMethodHandle.makeCollectArguments(methodHandle, methodHandle2, n, false)) != null) {
            return methodHandle3;
        }
        assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
        MethodType methodType4 = methodType2.changeParameterType(n, methodType3.parameterType(0));
        MethodType methodType5 = methodType2.generic();
        if (methodType2 != methodType5) {
            methodHandle = MethodHandleImpl.convertArguments(methodHandle, methodType5, methodType2, 0);
            methodType2 = methodType5;
        }
        if (methodType3 != (methodType = methodType3.generic())) {
            methodHandle2 = MethodHandleImpl.convertArguments(methodHandle2, methodType, methodType3, 0);
            methodType3 = methodType;
        }
        if ((methodHandle3 = methodType3 == methodType2 ? FilterOneArgument.make(methodHandle2, methodHandle) : FilterGeneric.makeArgumentFilter(n, methodHandle2, methodHandle)).type() != methodType4) {
            methodHandle3 = methodHandle3.asType(methodType4);
        }
        return methodHandle3;
    }

    static MethodHandle foldArguments(MethodHandle methodHandle, MethodType methodType, int n, MethodHandle methodHandle2) {
        MethodHandle methodHandle3;
        MethodType methodType2;
        MethodType methodType3 = methodHandle.type();
        if (AdapterMethodHandle.canCollectArguments(methodType3, methodType2 = methodHandle2.type(), n, true) && (methodHandle3 = AdapterMethodHandle.makeCollectArguments(methodHandle, methodHandle2, n, true)) != null) {
            return methodHandle3;
        }
        assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
        if (n != 0) {
            return null;
        }
        methodHandle3 = MethodHandleImpl.convertArguments(methodHandle, methodType3.generic(), methodType3, 0);
        MethodHandle methodHandle4 = MethodHandleImpl.convertArguments(methodHandle2, methodType2.generic(), methodType2, 0);
        if (methodType2.returnType() == Void.TYPE) {
            methodHandle3 = MethodHandleImpl.dropArguments(methodHandle3, methodType3.generic().insertParameterTypes(n, Object.class), n);
        }
        if (methodHandle3 == null || methodHandle4 == null) {
            return null;
        }
        MethodHandle methodHandle5 = FilterGeneric.makeArgumentFolder(methodHandle4, methodHandle3);
        return MethodHandleImpl.convertArguments(methodHandle5, methodType, methodHandle5.type(), 0);
    }

    static MethodHandle dropArguments(MethodHandle methodHandle, MethodType methodType, int n) {
        int n2 = methodType.parameterCount() - methodHandle.type().parameterCount();
        MethodHandle methodHandle2 = AdapterMethodHandle.makeDropArguments(methodType, methodHandle, n, n2);
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        throw new UnsupportedOperationException("NYI");
    }

    static MethodHandle selectAlternative(boolean bl, MethodHandle methodHandle, MethodHandle methodHandle2) {
        return bl ? methodHandle : methodHandle2;
    }

    static MethodHandle selectAlternative() {
        if (SELECT_ALTERNATIVE != null) {
            return SELECT_ALTERNATIVE;
        }
        try {
            SELECT_ALTERNATIVE = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "selectAlternative", MethodType.methodType(MethodHandle.class, Boolean.TYPE, MethodHandle.class, MethodHandle.class));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        return SELECT_ALTERNATIVE;
    }

    static MethodHandle makeGuardWithTest(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
        assert (methodHandle.type().returnType() == Boolean.TYPE);
        MethodType methodType = methodHandle2.type();
        MethodType methodType2 = methodType.insertParameterTypes(0, Boolean.TYPE);
        if (AdapterMethodHandle.canCollectArguments(methodType2, methodHandle.type(), 0, true) && GuardWithTest.preferRicochetFrame(methodType)) {
            assert (methodHandle2.type().equals((Object)methodHandle3.type()));
            MethodHandle methodHandle4 = MethodHandles.exactInvoker(methodHandle2.type());
            MethodHandle methodHandle5 = MethodHandleImpl.selectAlternative();
            methodHandle5 = MethodHandleImpl.bindArgument(methodHandle5, 2, CountingMethodHandle.wrap(methodHandle3));
            methodHandle5 = MethodHandleImpl.bindArgument(methodHandle5, 1, CountingMethodHandle.wrap(methodHandle2));
            MethodHandle methodHandle6 = MethodHandleImpl.filterArgument(methodHandle4, 0, methodHandle5);
            assert (methodHandle6.type().parameterType(0) == Boolean.TYPE);
            MethodHandle methodHandle7 = MethodHandleImpl.foldArguments(methodHandle6, methodHandle6.type().dropParameterTypes(0, 1), 0, methodHandle);
            return methodHandle7;
        }
        return GuardWithTest.make(methodHandle, methodHandle2, methodHandle3);
    }

    static MethodHandle makeGuardWithCatch(MethodHandle methodHandle, Class<? extends Throwable> clazz, MethodHandle methodHandle2) {
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        int n = methodType.parameterCount();
        if (n < GuardWithCatch.INVOKES.length) {
            MethodType methodType3 = methodType.generic();
            MethodType methodType4 = methodType3.insertParameterTypes(0, Throwable.class);
            MethodHandle methodHandle3 = MethodHandleImpl.convertArguments(methodHandle, methodType3, methodType, 2);
            MethodHandle methodHandle4 = MethodHandleImpl.convertArguments(methodHandle2, methodType4, methodType2, 2);
            GuardWithCatch guardWithCatch = new GuardWithCatch(methodHandle3, clazz, methodHandle4);
            if (methodHandle3 == null || methodHandle4 == null || guardWithCatch == null) {
                return null;
            }
            return MethodHandleImpl.convertArguments(guardWithCatch, methodType, methodType3, 2);
        }
        MethodType methodType5 = MethodType.genericMethodType(0, true);
        MethodType methodType6 = methodType5.insertParameterTypes(0, Throwable.class);
        MethodHandle methodHandle5 = MethodHandleImpl.spreadArgumentsFromPos(methodHandle, methodType5, 0);
        methodHandle2 = methodHandle2.asType(methodType2.changeParameterType(0, Throwable.class));
        MethodHandle methodHandle6 = MethodHandleImpl.spreadArgumentsFromPos(methodHandle2, methodType6, 1);
        GuardWithCatch guardWithCatch = new GuardWithCatch(GuardWithCatch.VARARGS_INVOKE, methodHandle5, clazz, methodHandle6);
        if (methodHandle5 == null || methodHandle6 == null || guardWithCatch == null) {
            return null;
        }
        return MethodHandleImpl.collectArguments(guardWithCatch, methodType, 0, ValueConversions.varargsArray(n)).asType(methodType);
    }

    static MethodHandle throwException(MethodType methodType) {
        return AdapterMethodHandle.makeRetypeRaw(methodType, MethodHandleImpl.throwException());
    }

    static MethodHandle throwException() {
        if (THROW_EXCEPTION != null) {
            return THROW_EXCEPTION;
        }
        try {
            THROW_EXCEPTION = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "throwException", MethodType.methodType(Empty.class, Throwable.class));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        return THROW_EXCEPTION;
    }

    static <T extends Throwable> Empty throwException(T t) throws T {
        throw t;
    }

    static final class AllocateObject<C>
    extends BoundMethodHandle {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final Class<C> allocateClass;
        private final MethodHandle rawConstructor;
        static final MethodHandle[] INVOKES = AllocateObject.makeInvokes();
        static final MethodHandle VARARGS_INVOKE;
        static final MethodHandle ALLOCATE;
        static final MethodType[] CON_TYPES;
        static final MethodType VARARGS_CON_TYPE;

        private AllocateObject(MethodHandle methodHandle, Class<C> clazz, MethodHandle methodHandle2) {
            super(methodHandle);
            this.allocateClass = clazz;
            this.rawConstructor = methodHandle2;
            assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
        }

        private AllocateObject(Class<C> clazz) {
            super(ALLOCATE.asType(MethodType.methodType(clazz, AllocateObject.class)));
            this.allocateClass = clazz;
            this.rawConstructor = null;
        }

        static MethodHandle make(Class<?> clazz, MethodHandle methodHandle) {
            assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
            MethodType methodType = methodHandle.type();
            assert (methodType.parameterType(0) == clazz);
            MethodType methodType2 = methodType.dropParameterTypes(0, 1).changeReturnType(clazz);
            int n = methodType.parameterCount() - 1;
            if (n < INVOKES.length) {
                MethodHandle methodHandle2 = INVOKES[n];
                MethodType methodType3 = CON_TYPES[n];
                MethodHandle methodHandle3 = MethodHandleImpl.convertArguments(methodHandle, methodType3, methodType, 0);
                if (methodHandle3 == null) {
                    return null;
                }
                AllocateObject allocateObject = new AllocateObject(methodHandle2, clazz, methodHandle3);
                assert (allocateObject.type() == methodType2.generic());
                return MethodHandleImpl.convertArguments(allocateObject, methodType2, allocateObject.type(), 0);
            }
            MethodHandle methodHandle4 = VARARGS_INVOKE;
            MethodType methodType4 = CON_TYPES[n];
            MethodHandle methodHandle5 = MethodHandleImpl.spreadArgumentsFromPos(methodHandle, methodType4, 1);
            if (methodHandle5 == null) {
                return null;
            }
            AllocateObject allocateObject = new AllocateObject(methodHandle4, clazz, methodHandle5);
            return MethodHandleImpl.collectArguments(allocateObject, methodType2, 1, null);
        }

        @Override
        String debugString() {
            return MethodHandleStatics.addTypeString(this.allocateClass.getSimpleName(), this);
        }

        private C allocate() throws InstantiationException {
            return (C)unsafe.allocateInstance(this.allocateClass);
        }

        private C invoke_V(Object ... objectArray) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, objectArray);
            return c;
        }

        private C invoke_L0() throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c);
            return c;
        }

        private C invoke_L1(Object object) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object);
            return c;
        }

        private C invoke_L2(Object object, Object object2) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2);
            return c;
        }

        private C invoke_L3(Object object, Object object2, Object object3) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2, object3);
            return c;
        }

        private C invoke_L4(Object object, Object object2, Object object3, Object object4) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2, object3, object4);
            return c;
        }

        private C invoke_L5(Object object, Object object2, Object object3, Object object4, Object object5) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2, object3, object4, object5);
            return c;
        }

        private C invoke_L6(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2, object3, object4, object5, object6);
            return c;
        }

        private C invoke_L7(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2, object3, object4, object5, object6, object7);
            return c;
        }

        private C invoke_L8(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws Throwable {
            C c = this.allocate();
            this.rawConstructor.invokeExact(c, object, object2, object3, object4, object5, object6, object7, object8);
            return c;
        }

        static MethodHandle[] makeInvokes() {
            ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
            MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP;
            while (true) {
                int n = arrayList.size();
                String string = "invoke_L" + n;
                MethodHandle methodHandle = null;
                try {
                    methodHandle = lookup.findVirtual(AllocateObject.class, string, MethodType.genericMethodType(n));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
                if (methodHandle == null) break;
                arrayList.add(methodHandle);
            }
            assert (arrayList.size() == 9);
            return arrayList.toArray(new MethodHandle[0]);
        }

        static MethodType makeConType(MethodHandle methodHandle) {
            MethodType methodType = methodHandle.type();
            return methodType.changeParameterType(0, Object.class).changeReturnType(Void.TYPE);
        }

        static {
            try {
                VARARGS_INVOKE = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(AllocateObject.class, "invoke_V", MethodType.genericMethodType(0, true));
                ALLOCATE = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(AllocateObject.class, "allocate", MethodType.genericMethodType(0));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw MethodHandleStatics.uncaughtException(reflectiveOperationException);
            }
            CON_TYPES = new MethodType[INVOKES.length];
            for (int i = 0; i < INVOKES.length; ++i) {
                AllocateObject.CON_TYPES[i] = AllocateObject.makeConType(INVOKES[i]);
            }
            VARARGS_CON_TYPE = AllocateObject.makeConType(VARARGS_INVOKE);
        }
    }

    static final class FieldAccessor<C, V>
    extends BoundMethodHandle {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        final Object base;
        final long offset;
        final String name;
        static final HashMap<Class<?>, MethodHandle[]> ARRAY_CACHE = new HashMap();

        FieldAccessor(MemberName memberName, boolean bl) {
            super(FieldAccessor.fhandle(memberName.getDeclaringClass(), memberName.getFieldType(), bl, memberName.isStatic()));
            this.offset = memberName.getVMIndex();
            this.name = memberName.getName();
            this.base = FieldAccessor.staticBase(memberName);
        }

        @Override
        String debugString() {
            return MethodHandleStatics.addTypeString(this.name, this);
        }

        int getFieldI(C c) {
            return unsafe.getInt(c, this.offset);
        }

        void setFieldI(C c, int n) {
            unsafe.putInt(c, this.offset, n);
        }

        long getFieldJ(C c) {
            return unsafe.getLong(c, this.offset);
        }

        void setFieldJ(C c, long l) {
            unsafe.putLong(c, this.offset, l);
        }

        float getFieldF(C c) {
            return unsafe.getFloat(c, this.offset);
        }

        void setFieldF(C c, float f) {
            unsafe.putFloat(c, this.offset, f);
        }

        double getFieldD(C c) {
            return unsafe.getDouble(c, this.offset);
        }

        void setFieldD(C c, double d) {
            unsafe.putDouble(c, this.offset, d);
        }

        boolean getFieldZ(C c) {
            return unsafe.getBoolean(c, this.offset);
        }

        void setFieldZ(C c, boolean bl) {
            unsafe.putBoolean(c, this.offset, bl);
        }

        byte getFieldB(C c) {
            return unsafe.getByte(c, this.offset);
        }

        void setFieldB(C c, byte by) {
            unsafe.putByte(c, this.offset, by);
        }

        short getFieldS(C c) {
            return unsafe.getShort(c, this.offset);
        }

        void setFieldS(C c, short s) {
            unsafe.putShort(c, this.offset, s);
        }

        char getFieldC(C c) {
            return unsafe.getChar(c, this.offset);
        }

        void setFieldC(C c, char c2) {
            unsafe.putChar(c, this.offset, c2);
        }

        V getFieldL(C c) {
            return (V)unsafe.getObject(c, this.offset);
        }

        void setFieldL(C c, V v) {
            unsafe.putObject(c, this.offset, v);
        }

        static Object staticBase(final MemberName memberName) {
            if (!memberName.isStatic()) {
                return null;
            }
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Class<?> clazz = memberName.getDeclaringClass();
                        Field field = clazz.getDeclaredField(memberName.getName());
                        return unsafe.staticFieldBase(field);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        throw MethodHandleStatics.uncaughtException(noSuchFieldException);
                    }
                }
            });
        }

        int getStaticI() {
            return unsafe.getInt(this.base, this.offset);
        }

        void setStaticI(int n) {
            unsafe.putInt(this.base, this.offset, n);
        }

        long getStaticJ() {
            return unsafe.getLong(this.base, this.offset);
        }

        void setStaticJ(long l) {
            unsafe.putLong(this.base, this.offset, l);
        }

        float getStaticF() {
            return unsafe.getFloat(this.base, this.offset);
        }

        void setStaticF(float f) {
            unsafe.putFloat(this.base, this.offset, f);
        }

        double getStaticD() {
            return unsafe.getDouble(this.base, this.offset);
        }

        void setStaticD(double d) {
            unsafe.putDouble(this.base, this.offset, d);
        }

        boolean getStaticZ() {
            return unsafe.getBoolean(this.base, this.offset);
        }

        void setStaticZ(boolean bl) {
            unsafe.putBoolean(this.base, this.offset, bl);
        }

        byte getStaticB() {
            return unsafe.getByte(this.base, this.offset);
        }

        void setStaticB(byte by) {
            unsafe.putByte(this.base, this.offset, by);
        }

        short getStaticS() {
            return unsafe.getShort(this.base, this.offset);
        }

        void setStaticS(short s) {
            unsafe.putShort(this.base, this.offset, s);
        }

        char getStaticC() {
            return unsafe.getChar(this.base, this.offset);
        }

        void setStaticC(char c) {
            unsafe.putChar(this.base, this.offset, c);
        }

        V getStaticL() {
            return (V)unsafe.getObject(this.base, this.offset);
        }

        void setStaticL(V v) {
            unsafe.putObject(this.base, this.offset, v);
        }

        static String fname(Class<?> clazz, boolean bl, boolean bl2) {
            String string = !bl2 ? (!bl ? "getField" : "setField") : (!bl ? "getStatic" : "setStatic");
            return string + Wrapper.basicTypeChar(clazz);
        }

        static MethodType ftype(Class<?> clazz, Class<?> clazz2, boolean bl, boolean bl2) {
            if (!bl2) {
                if (!bl) {
                    return MethodType.methodType(clazz2, clazz);
                }
                return MethodType.methodType(Void.TYPE, clazz, clazz2);
            }
            if (!bl) {
                return MethodType.methodType(clazz2);
            }
            return MethodType.methodType(Void.TYPE, clazz2);
        }

        static MethodHandle fhandle(Class<?> clazz, Class<?> clazz2, boolean bl, boolean bl2) {
            MethodHandle methodHandle;
            String string = FieldAccessor.fname(clazz2, bl, bl2);
            if (clazz.isPrimitive()) {
                throw MethodHandleStatics.newIllegalArgumentException("primitive " + clazz);
            }
            Class<Object> clazz3 = Object.class;
            Class<Object> clazz4 = clazz2;
            if (!clazz4.isPrimitive()) {
                clazz4 = Object.class;
            }
            MethodType methodType = FieldAccessor.ftype(clazz3, clazz4, bl, bl2);
            try {
                methodHandle = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(FieldAccessor.class, string, methodType);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw MethodHandleStatics.uncaughtException(reflectiveOperationException);
            }
            if (clazz4 != clazz2 || !bl2 && clazz3 != clazz) {
                MethodType methodType2 = FieldAccessor.ftype(clazz, clazz2, bl, bl2);
                methodType2 = methodType2.insertParameterTypes(0, FieldAccessor.class);
                methodHandle = MethodHandleImpl.convertArguments(methodHandle, methodType2, 0);
            }
            return methodHandle;
        }

        static boolean doCache(Class<?> clazz) {
            if (clazz.isPrimitive()) {
                return true;
            }
            ClassLoader classLoader = clazz.getClassLoader();
            return classLoader == null || classLoader == ClassLoader.getSystemClassLoader();
        }

        static int getElementI(int[] nArray, int n) {
            return nArray[n];
        }

        static void setElementI(int[] nArray, int n, int n2) {
            nArray[n] = n2;
        }

        static long getElementJ(long[] lArray, int n) {
            return lArray[n];
        }

        static void setElementJ(long[] lArray, int n, long l) {
            lArray[n] = l;
        }

        static float getElementF(float[] fArray, int n) {
            return fArray[n];
        }

        static void setElementF(float[] fArray, int n, float f) {
            fArray[n] = f;
        }

        static double getElementD(double[] dArray, int n) {
            return dArray[n];
        }

        static void setElementD(double[] dArray, int n, double d) {
            dArray[n] = d;
        }

        static boolean getElementZ(boolean[] blArray, int n) {
            return blArray[n];
        }

        static void setElementZ(boolean[] blArray, int n, boolean bl) {
            blArray[n] = bl;
        }

        static byte getElementB(byte[] byArray, int n) {
            return byArray[n];
        }

        static void setElementB(byte[] byArray, int n, byte by) {
            byArray[n] = by;
        }

        static short getElementS(short[] sArray, int n) {
            return sArray[n];
        }

        static void setElementS(short[] sArray, int n, short s) {
            sArray[n] = s;
        }

        static char getElementC(char[] cArray, int n) {
            return cArray[n];
        }

        static void setElementC(char[] cArray, int n, char c) {
            cArray[n] = c;
        }

        static Object getElementL(Object[] objectArray, int n) {
            return objectArray[n];
        }

        static void setElementL(Object[] objectArray, int n, Object object) {
            objectArray[n] = object;
        }

        static <V> V getElementL(Class<V[]> clazz, V[] VArray, int n) {
            return clazz.cast(VArray)[n];
        }

        static <V> void setElementL(Class<V[]> clazz, V[] VArray, int n, V v) {
            clazz.cast(VArray)[n] = v;
        }

        static String aname(Class<?> clazz, boolean bl) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2 == null) {
                throw new IllegalArgumentException();
            }
            return (!bl ? "getElement" : "setElement") + Wrapper.basicTypeChar(clazz2);
        }

        static MethodType atype(Class<?> clazz, boolean bl) {
            Class<?> clazz2 = clazz.getComponentType();
            if (!bl) {
                return MethodType.methodType(clazz2, clazz, Integer.TYPE);
            }
            return MethodType.methodType(Void.TYPE, clazz, Integer.TYPE, clazz2);
        }

        static MethodHandle ahandle(Class<?> clazz, boolean bl) {
            MethodHandle methodHandle;
            Class<Object> clazz2 = clazz.getComponentType();
            String string = FieldAccessor.aname(clazz, bl);
            Class<?> clazz3 = null;
            if (!clazz2.isPrimitive() && clazz2 != Object.class) {
                clazz3 = clazz;
                clazz = Object[].class;
                clazz2 = Object.class;
            }
            MethodType methodType = FieldAccessor.atype(clazz, bl);
            if (clazz3 != null) {
                methodType = methodType.insertParameterTypes(0, Class.class);
            }
            try {
                methodHandle = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(FieldAccessor.class, string, methodType);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw MethodHandleStatics.uncaughtException(reflectiveOperationException);
            }
            if (clazz3 != null) {
                MethodType methodType2 = FieldAccessor.atype(clazz3, bl);
                methodHandle = methodHandle.bindTo(clazz3);
                methodHandle = MethodHandleImpl.convertArguments(methodHandle, methodType2, 0);
            }
            return methodHandle;
        }
    }

    private static class GuardWithCatch
    extends BoundMethodHandle {
        private final MethodHandle target;
        private final Class<? extends Throwable> exType;
        private final MethodHandle catcher;
        static final MethodHandle[] INVOKES = GuardWithCatch.makeInvokes();
        static final MethodHandle VARARGS_INVOKE;

        GuardWithCatch(MethodHandle methodHandle, Class<? extends Throwable> clazz, MethodHandle methodHandle2) {
            this(INVOKES[methodHandle.type().parameterCount()], methodHandle, clazz, methodHandle2);
        }

        GuardWithCatch(MethodHandle methodHandle, MethodHandle methodHandle2, Class<? extends Throwable> clazz, MethodHandle methodHandle3) {
            super(methodHandle);
            this.target = methodHandle2;
            this.exType = clazz;
            this.catcher = methodHandle3;
        }

        @Override
        String debugString() {
            return MethodHandleStatics.addTypeString(this.target, this);
        }

        private Object invoke_V(Object ... objectArray) throws Throwable {
            try {
                return this.target.invokeExact(objectArray);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, objectArray);
            }
        }

        private Object invoke_L0() throws Throwable {
            try {
                return this.target.invokeExact();
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable);
            }
        }

        private Object invoke_L1(Object object) throws Throwable {
            try {
                return this.target.invokeExact(object);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object);
            }
        }

        private Object invoke_L2(Object object, Object object2) throws Throwable {
            try {
                return this.target.invokeExact(object, object2);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2);
            }
        }

        private Object invoke_L3(Object object, Object object2, Object object3) throws Throwable {
            try {
                return this.target.invokeExact(object, object2, object3);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2, object3);
            }
        }

        private Object invoke_L4(Object object, Object object2, Object object3, Object object4) throws Throwable {
            try {
                return this.target.invokeExact(object, object2, object3, object4);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2, object3, object4);
            }
        }

        private Object invoke_L5(Object object, Object object2, Object object3, Object object4, Object object5) throws Throwable {
            try {
                return this.target.invokeExact(object, object2, object3, object4, object5);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2, object3, object4, object5);
            }
        }

        private Object invoke_L6(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws Throwable {
            try {
                return this.target.invokeExact(object, object2, object3, object4, object5, object6);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2, object3, object4, object5, object6);
            }
        }

        private Object invoke_L7(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) throws Throwable {
            try {
                return this.target.invokeExact(object, object2, object3, object4, object5, object6, object7);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2, object3, object4, object5, object6, object7);
            }
        }

        private Object invoke_L8(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws Throwable {
            try {
                return this.target.invokeExact(object, object2, object3, object4, object5, object6, object7, object8);
            }
            catch (Throwable throwable) {
                if (!this.exType.isInstance(throwable)) {
                    throw throwable;
                }
                return this.catcher.invokeExact(throwable, object, object2, object3, object4, object5, object6, object7, object8);
            }
        }

        static MethodHandle[] makeInvokes() {
            ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
            MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP;
            while (true) {
                int n = arrayList.size();
                String string = "invoke_L" + n;
                MethodHandle methodHandle = null;
                try {
                    methodHandle = lookup.findVirtual(GuardWithCatch.class, string, MethodType.genericMethodType(n));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
                if (methodHandle == null) break;
                arrayList.add(methodHandle);
            }
            assert (arrayList.size() == 9);
            return arrayList.toArray(new MethodHandle[0]);
        }

        static {
            try {
                VARARGS_INVOKE = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(GuardWithCatch.class, "invoke_V", MethodType.genericMethodType(0, true));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw MethodHandleStatics.uncaughtException(reflectiveOperationException);
            }
        }
    }

    private static class GuardWithTest
    extends BoundMethodHandle {
        private final MethodHandle test;
        private final MethodHandle target;
        private final MethodHandle fallback;
        static final MethodHandle[] INVOKES = GuardWithTest.makeInvokes();
        static final MethodHandle VARARGS_INVOKE;

        private GuardWithTest(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3, MethodHandle methodHandle4) {
            super(methodHandle);
            this.test = methodHandle2;
            this.target = methodHandle3;
            this.fallback = methodHandle4;
        }

        static boolean preferRicochetFrame(MethodType methodType) {
            return true;
        }

        static MethodHandle make(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
            MethodType methodType = methodHandle2.type();
            int n = methodType.parameterCount();
            if (n < INVOKES.length) {
                if (GuardWithTest.preferRicochetFrame(methodType)) assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
                MethodHandle methodHandle4 = INVOKES[n];
                MethodType methodType2 = methodType.generic();
                assert (methodHandle4.type().dropParameterTypes(0, 1) == methodType2);
                MethodHandle methodHandle5 = MethodHandleImpl.convertArguments(methodHandle, methodType2.changeReturnType(Boolean.TYPE), methodHandle.type(), 2);
                MethodHandle methodHandle6 = MethodHandleImpl.convertArguments(methodHandle2, methodType2, methodType, 2);
                MethodHandle methodHandle7 = MethodHandleImpl.convertArguments(methodHandle3, methodType2, methodType, 2);
                if (methodHandle5 == null || methodHandle6 == null || methodHandle7 == null) {
                    return null;
                }
                GuardWithTest guardWithTest = new GuardWithTest(methodHandle4, methodHandle5, methodHandle6, methodHandle7);
                return MethodHandleImpl.convertArguments(guardWithTest, methodType, methodType2, 2);
            }
            assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
            MethodHandle methodHandle8 = VARARGS_INVOKE;
            MethodType methodType3 = MethodType.genericMethodType(1);
            assert (methodHandle8.type().dropParameterTypes(0, 1) == methodType3);
            MethodHandle methodHandle9 = MethodHandleImpl.spreadArgumentsFromPos(methodHandle, methodType3.changeReturnType(Boolean.TYPE), 0);
            MethodHandle methodHandle10 = MethodHandleImpl.spreadArgumentsFromPos(methodHandle2, methodType3, 0);
            MethodHandle methodHandle11 = MethodHandleImpl.spreadArgumentsFromPos(methodHandle3, methodType3, 0);
            GuardWithTest guardWithTest = new GuardWithTest(methodHandle8, methodHandle9, methodHandle10, methodHandle11);
            if (methodHandle9 == null || methodHandle10 == null || methodHandle11 == null) {
                return null;
            }
            return MethodHandleImpl.collectArguments(guardWithTest, methodType, 0, null);
        }

        @Override
        String debugString() {
            return MethodHandleStatics.addTypeString(this.target, this);
        }

        private Object invoke_V(Object ... objectArray) throws Throwable {
            if (this.test.invokeExact(objectArray)) {
                return this.target.invokeExact(objectArray);
            }
            return this.fallback.invokeExact(objectArray);
        }

        private Object invoke_L0() throws Throwable {
            if (this.test.invokeExact()) {
                return this.target.invokeExact();
            }
            return this.fallback.invokeExact();
        }

        private Object invoke_L1(Object object) throws Throwable {
            if (this.test.invokeExact(object)) {
                return this.target.invokeExact(object);
            }
            return this.fallback.invokeExact(object);
        }

        private Object invoke_L2(Object object, Object object2) throws Throwable {
            if (this.test.invokeExact(object, object2)) {
                return this.target.invokeExact(object, object2);
            }
            return this.fallback.invokeExact(object, object2);
        }

        private Object invoke_L3(Object object, Object object2, Object object3) throws Throwable {
            if (this.test.invokeExact(object, object2, object3)) {
                return this.target.invokeExact(object, object2, object3);
            }
            return this.fallback.invokeExact(object, object2, object3);
        }

        private Object invoke_L4(Object object, Object object2, Object object3, Object object4) throws Throwable {
            if (this.test.invokeExact(object, object2, object3, object4)) {
                return this.target.invokeExact(object, object2, object3, object4);
            }
            return this.fallback.invokeExact(object, object2, object3, object4);
        }

        private Object invoke_L5(Object object, Object object2, Object object3, Object object4, Object object5) throws Throwable {
            if (this.test.invokeExact(object, object2, object3, object4, object5)) {
                return this.target.invokeExact(object, object2, object3, object4, object5);
            }
            return this.fallback.invokeExact(object, object2, object3, object4, object5);
        }

        private Object invoke_L6(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws Throwable {
            if (this.test.invokeExact(object, object2, object3, object4, object5, object6)) {
                return this.target.invokeExact(object, object2, object3, object4, object5, object6);
            }
            return this.fallback.invokeExact(object, object2, object3, object4, object5, object6);
        }

        private Object invoke_L7(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) throws Throwable {
            if (this.test.invokeExact(object, object2, object3, object4, object5, object6, object7)) {
                return this.target.invokeExact(object, object2, object3, object4, object5, object6, object7);
            }
            return this.fallback.invokeExact(object, object2, object3, object4, object5, object6, object7);
        }

        private Object invoke_L8(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws Throwable {
            if (this.test.invokeExact(object, object2, object3, object4, object5, object6, object7, object8)) {
                return this.target.invokeExact(object, object2, object3, object4, object5, object6, object7, object8);
            }
            return this.fallback.invokeExact(object, object2, object3, object4, object5, object6, object7, object8);
        }

        static MethodHandle[] makeInvokes() {
            ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
            MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP;
            while (true) {
                int n = arrayList.size();
                String string = "invoke_L" + n;
                MethodHandle methodHandle = null;
                try {
                    methodHandle = lookup.findVirtual(GuardWithTest.class, string, MethodType.genericMethodType(n));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
                if (methodHandle == null) break;
                arrayList.add(methodHandle);
            }
            assert (arrayList.size() == 9);
            return arrayList.toArray(new MethodHandle[0]);
        }

        static {
            try {
                VARARGS_INVOKE = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(GuardWithTest.class, "invoke_V", MethodType.genericMethodType(0, true));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw MethodHandleStatics.uncaughtException(reflectiveOperationException);
            }
        }
    }
}

