/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeBodyPart;
import com.sun.xml.internal.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.internal.messaging.saaj.soap.Envelope;
import com.sun.xml.internal.messaging.saaj.soap.MessageImpl;
import com.sun.xml.internal.messaging.saaj.soap.SOAPDocument;
import com.sun.xml.internal.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.internal.messaging.saaj.soap.SOAPIOException;
import com.sun.xml.internal.messaging.saaj.soap.SOAPVersionMismatchException;
import com.sun.xml.internal.messaging.saaj.soap.impl.ElementImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.EnvelopeImpl;
import com.sun.xml.internal.messaging.saaj.util.ByteInputStream;
import com.sun.xml.internal.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.internal.messaging.saaj.util.FastInfosetReflection;
import com.sun.xml.internal.messaging.saaj.util.JAXMStreamSource;
import com.sun.xml.internal.messaging.saaj.util.MimeHeadersUtil;
import com.sun.xml.internal.messaging.saaj.util.XMLDeclarationParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public abstract class SOAPPartImpl
extends SOAPPart
implements SOAPDocument {
    protected static final Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap", "com.sun.xml.internal.messaging.saaj.soap.LocalStrings");
    protected MimeHeaders headers;
    protected Envelope envelope;
    protected Source source;
    protected SOAPDocumentImpl document = new SOAPDocumentImpl(this);
    private boolean sourceWasSet = false;
    protected boolean omitXmlDecl = true;
    protected String sourceCharsetEncoding = null;
    protected MessageImpl message;
    static boolean lazyContentLength;

    protected SOAPPartImpl() {
        this(null);
    }

    protected SOAPPartImpl(MessageImpl messageImpl) {
        this.headers = new MimeHeaders();
        this.message = messageImpl;
        this.headers.setHeader("Content-Type", this.getContentType());
    }

    protected abstract String getContentType();

    protected abstract Envelope createEnvelopeFromSource() throws SOAPException;

    protected abstract Envelope createEmptyEnvelope(String var1) throws SOAPException;

    protected abstract SOAPPartImpl duplicateType();

    protected String getContentTypeString() {
        return this.getContentType();
    }

    public boolean isFastInfoset() {
        return this.message != null ? this.message.isFastInfoset() : false;
    }

    @Override
    public SOAPEnvelope getEnvelope() throws SOAPException {
        if (this.sourceWasSet) {
            this.sourceWasSet = false;
        }
        this.lookForEnvelope();
        if (this.envelope != null) {
            if (this.source != null) {
                this.document.removeChild(this.envelope);
                this.envelope = this.createEnvelopeFromSource();
            }
        } else if (this.source != null) {
            this.envelope = this.createEnvelopeFromSource();
        } else {
            this.envelope = this.createEmptyEnvelope(null);
            this.document.insertBefore(this.envelope, null);
        }
        return this.envelope;
    }

    protected void lookForEnvelope() throws SOAPException {
        Element element = this.document.doGetDocumentElement();
        if (element == null || element instanceof Envelope) {
            this.envelope = (EnvelopeImpl)element;
        } else {
            if (!(element instanceof ElementImpl)) {
                log.severe("SAAJ0512.soap.incorrect.factory.used");
                throw new SOAPExceptionImpl("Unable to create envelope: incorrect factory used during tree construction");
            }
            ElementImpl elementImpl = (ElementImpl)element;
            if (elementImpl.getLocalName().equalsIgnoreCase("Envelope")) {
                String string;
                String string2 = elementImpl.getPrefix();
                String string3 = string = string2 == null ? elementImpl.getNamespaceURI() : elementImpl.getNamespaceURI(string2);
                if (!string.equals("http://schemas.xmlsoap.org/soap/envelope/") && !string.equals("http://www.w3.org/2003/05/soap-envelope")) {
                    log.severe("SAAJ0513.soap.unknown.ns");
                    throw new SOAPVersionMismatchException("Unable to create envelope from given source because the namespace was not recognized");
                }
            } else {
                log.severe("SAAJ0514.soap.root.elem.not.named.envelope");
                throw new SOAPExceptionImpl("Unable to create envelope from given source because the root element is not named \"Envelope\"");
            }
        }
    }

    @Override
    public void removeAllMimeHeaders() {
        this.headers.removeAllHeaders();
    }

    @Override
    public void removeMimeHeader(String string) {
        this.headers.removeHeader(string);
    }

    @Override
    public String[] getMimeHeader(String string) {
        return this.headers.getHeader(string);
    }

    @Override
    public void setMimeHeader(String string, String string2) {
        this.headers.setHeader(string, string2);
    }

    @Override
    public void addMimeHeader(String string, String string2) {
        this.headers.addHeader(string, string2);
    }

    @Override
    public Iterator getAllMimeHeaders() {
        return this.headers.getAllHeaders();
    }

    @Override
    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this.headers.getMatchingHeaders(stringArray);
    }

    @Override
    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    @Override
    public Source getContent() throws SOAPException {
        if (this.source != null) {
            InputStream inputStream = null;
            if (this.source instanceof JAXMStreamSource) {
                StreamSource streamSource = (StreamSource)this.source;
                inputStream = streamSource.getInputStream();
            } else if (FastInfosetReflection.isFastInfosetSource(this.source)) {
                SAXSource sAXSource = (SAXSource)this.source;
                inputStream = sAXSource.getInputSource().getByteStream();
            }
            if (inputStream != null) {
                try {
                    inputStream.reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.source;
        }
        return ((Envelope)this.getEnvelope()).getContent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setContent(Source source) throws SOAPException {
        try {
            if (source instanceof StreamSource) {
                InputStream inputStream = ((StreamSource)source).getInputStream();
                Reader reader = ((StreamSource)source).getReader();
                if (inputStream != null) {
                    this.source = new JAXMStreamSource(inputStream);
                } else {
                    if (reader == null) {
                        log.severe("SAAJ0544.soap.no.valid.reader.for.src");
                        throw new SOAPExceptionImpl("Source does not have a valid Reader or InputStream");
                    }
                    this.source = new JAXMStreamSource(reader);
                }
            } else if (FastInfosetReflection.isFastInfosetSource(source)) {
                InputStream inputStream = FastInfosetReflection.FastInfosetSource_getInputStream(source);
                if (!(inputStream instanceof ByteInputStream)) {
                    ByteOutputStream byteOutputStream = new ByteOutputStream();
                    byteOutputStream.write(inputStream);
                    FastInfosetReflection.FastInfosetSource_setInputStream(source, byteOutputStream.newInputStream());
                }
                this.source = source;
            } else {
                this.source = source;
            }
            this.sourceWasSet = true;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.severe("SAAJ0545.soap.cannot.set.src.for.part");
            throw new SOAPExceptionImpl("Error setting the source for SOAPPart: " + exception.getMessage());
        }
    }

    public InputStream getContentAsStream() throws IOException {
        Closeable closeable;
        if (this.source != null) {
            closeable = null;
            if (this.source instanceof StreamSource && !this.isFastInfoset()) {
                closeable = ((StreamSource)this.source).getInputStream();
            } else if (FastInfosetReflection.isFastInfosetSource(this.source) && this.isFastInfoset()) {
                try {
                    closeable = FastInfosetReflection.FastInfosetSource_getInputStream(this.source);
                }
                catch (Exception exception) {
                    throw new IOException(exception.toString());
                }
            }
            if (closeable != null) {
                if (lazyContentLength) {
                    return closeable;
                }
                if (!(closeable instanceof ByteInputStream)) {
                    log.severe("SAAJ0546.soap.stream.incorrect.type");
                    throw new IOException("Internal error: stream not of the right type");
                }
                return (ByteInputStream)closeable;
            }
        }
        closeable = new ByteOutputStream();
        Envelope envelope = null;
        try {
            envelope = (Envelope)this.getEnvelope();
            envelope.output((OutputStream)closeable, this.isFastInfoset());
        }
        catch (SOAPException sOAPException) {
            log.severe("SAAJ0547.soap.cannot.externalize");
            throw new SOAPIOException("SOAP exception while trying to externalize: ", sOAPException);
        }
        return ((ByteOutputStream)closeable).newInputStream();
    }

    MimeBodyPart getMimePart() throws SOAPException {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(this.getDataHandler());
            AttachmentPartImpl.copyMimeHeaders(this.headers, mimeBodyPart);
            return mimeBodyPart;
        }
        catch (SOAPException sOAPException) {
            throw sOAPException;
        }
        catch (Exception exception) {
            log.severe("SAAJ0548.soap.cannot.externalize.hdr");
            throw new SOAPExceptionImpl("Unable to externalize header", exception);
        }
    }

    MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    DataHandler getDataHandler() {
        DataSource dataSource = new DataSource(){

            @Override
            public OutputStream getOutputStream() throws IOException {
                throw new IOException("Illegal Operation");
            }

            @Override
            public String getContentType() {
                return SOAPPartImpl.this.getContentTypeString();
            }

            @Override
            public String getName() {
                return SOAPPartImpl.this.getContentId();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return SOAPPartImpl.this.getContentAsStream();
            }
        };
        return new DataHandler(dataSource);
    }

    @Override
    public SOAPDocumentImpl getDocument() {
        this.handleNewSource();
        return this.document;
    }

    @Override
    public SOAPPartImpl getSOAPPart() {
        return this;
    }

    @Override
    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    @Override
    public Element getDocumentElement() {
        try {
            this.getEnvelope();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return this.document.getDocumentElement();
    }

    protected void doGetDocumentElement() {
        this.handleNewSource();
        try {
            this.lookForEnvelope();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }

    @Override
    public Element createElement(String string) throws DOMException {
        return this.document.createElement(string);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    @Override
    public Text createTextNode(String string) {
        return this.document.createTextNode(string);
    }

    @Override
    public Comment createComment(String string) {
        return this.document.createComment(string);
    }

    @Override
    public CDATASection createCDATASection(String string) throws DOMException {
        return this.document.createCDATASection(string);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        return this.document.createProcessingInstruction(string, string2);
    }

    @Override
    public Attr createAttribute(String string) throws DOMException {
        return this.document.createAttribute(string);
    }

    @Override
    public EntityReference createEntityReference(String string) throws DOMException {
        return this.document.createEntityReference(string);
    }

    @Override
    public NodeList getElementsByTagName(String string) {
        this.handleNewSource();
        return this.document.getElementsByTagName(string);
    }

    @Override
    public Node importNode(Node node, boolean bl) throws DOMException {
        this.handleNewSource();
        return this.document.importNode(node, bl);
    }

    @Override
    public Element createElementNS(String string, String string2) throws DOMException {
        return this.document.createElementNS(string, string2);
    }

    @Override
    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return this.document.createAttributeNS(string, string2);
    }

    @Override
    public NodeList getElementsByTagNameNS(String string, String string2) {
        this.handleNewSource();
        return this.document.getElementsByTagNameNS(string, string2);
    }

    @Override
    public Element getElementById(String string) {
        this.handleNewSource();
        return this.document.getElementById(string);
    }

    @Override
    public Node appendChild(Node node) throws DOMException {
        this.handleNewSource();
        return this.document.appendChild(node);
    }

    @Override
    public Node cloneNode(boolean bl) {
        this.handleNewSource();
        return this.document.cloneNode(bl);
    }

    protected SOAPPartImpl doCloneNode() {
        this.handleNewSource();
        SOAPPartImpl sOAPPartImpl = this.duplicateType();
        sOAPPartImpl.headers = MimeHeadersUtil.copy(this.headers);
        sOAPPartImpl.source = this.source;
        return sOAPPartImpl;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    @Override
    public NodeList getChildNodes() {
        this.handleNewSource();
        return this.document.getChildNodes();
    }

    @Override
    public Node getFirstChild() {
        this.handleNewSource();
        return this.document.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        this.handleNewSource();
        return this.document.getLastChild();
    }

    @Override
    public String getLocalName() {
        return this.document.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    @Override
    public Node getNextSibling() {
        this.handleNewSource();
        return this.document.getNextSibling();
    }

    @Override
    public String getNodeName() {
        return this.document.getNodeName();
    }

    @Override
    public short getNodeType() {
        return this.document.getNodeType();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.document.getNodeValue();
    }

    @Override
    public Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    @Override
    public Node getParentNode() {
        return this.document.getParentNode();
    }

    @Override
    public String getPrefix() {
        return this.document.getPrefix();
    }

    @Override
    public Node getPreviousSibling() {
        return this.document.getPreviousSibling();
    }

    @Override
    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    @Override
    public boolean hasChildNodes() {
        this.handleNewSource();
        return this.document.hasChildNodes();
    }

    @Override
    public Node insertBefore(Node node, Node node2) throws DOMException {
        this.handleNewSource();
        return this.document.insertBefore(node, node2);
    }

    @Override
    public boolean isSupported(String string, String string2) {
        return this.document.isSupported(string, string2);
    }

    @Override
    public void normalize() {
        this.handleNewSource();
        this.document.normalize();
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        this.handleNewSource();
        return this.document.removeChild(node);
    }

    @Override
    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.handleNewSource();
        return this.document.replaceChild(node, node2);
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
        this.document.setNodeValue(string);
    }

    @Override
    public void setPrefix(String string) throws DOMException {
        this.document.setPrefix(string);
    }

    private void handleNewSource() {
        if (this.sourceWasSet) {
            try {
                this.getEnvelope();
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
        }
    }

    protected XMLDeclarationParser lookForXmlDecl() throws SOAPException {
        if (this.source != null && this.source instanceof StreamSource) {
            Reader reader = null;
            InputStream inputStream = ((StreamSource)this.source).getInputStream();
            if (inputStream != null) {
                if (this.getSourceCharsetEncoding() == null) {
                    reader = new InputStreamReader(inputStream);
                } else {
                    try {
                        reader = new InputStreamReader(inputStream, this.getSourceCharsetEncoding());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        log.log(Level.SEVERE, "SAAJ0551.soap.unsupported.encoding", new Object[]{this.getSourceCharsetEncoding()});
                        throw new SOAPExceptionImpl("Unsupported encoding " + this.getSourceCharsetEncoding(), unsupportedEncodingException);
                    }
                }
            } else {
                reader = ((StreamSource)this.source).getReader();
            }
            if (reader != null) {
                PushbackReader pushbackReader = new PushbackReader(reader, 4096);
                XMLDeclarationParser xMLDeclarationParser = new XMLDeclarationParser(pushbackReader);
                try {
                    xMLDeclarationParser.parse();
                }
                catch (Exception exception) {
                    log.log(Level.SEVERE, "SAAJ0552.soap.xml.decl.parsing.failed");
                    throw new SOAPExceptionImpl("XML declaration parsing failed", exception);
                }
                String string = xMLDeclarationParser.getXmlDeclaration();
                if (string != null && string.length() > 0) {
                    this.omitXmlDecl = false;
                }
                if (lazyContentLength) {
                    this.source = new StreamSource(pushbackReader);
                }
                return xMLDeclarationParser;
            }
        } else if (this.source == null || this.source instanceof DOMSource) {
            // empty if block
        }
        return null;
    }

    public void setSourceCharsetEncoding(String string) {
        this.sourceCharsetEncoding = string;
    }

    @Override
    public Node renameNode(Node node, String string, String string2) throws DOMException {
        this.handleNewSource();
        return this.document.renameNode(node, string, string2);
    }

    @Override
    public void normalizeDocument() {
        this.document.normalizeDocument();
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.document.getDomConfig();
    }

    @Override
    public Node adoptNode(Node node) throws DOMException {
        this.handleNewSource();
        return this.document.adoptNode(node);
    }

    @Override
    public void setDocumentURI(String string) {
        this.document.setDocumentURI(string);
    }

    @Override
    public String getDocumentURI() {
        return this.document.getDocumentURI();
    }

    @Override
    public void setStrictErrorChecking(boolean bl) {
        this.document.setStrictErrorChecking(bl);
    }

    @Override
    public String getInputEncoding() {
        return this.document.getInputEncoding();
    }

    @Override
    public String getXmlEncoding() {
        return this.document.getXmlEncoding();
    }

    @Override
    public boolean getXmlStandalone() {
        return this.document.getXmlStandalone();
    }

    @Override
    public void setXmlStandalone(boolean bl) throws DOMException {
        this.document.setXmlStandalone(bl);
    }

    @Override
    public String getXmlVersion() {
        return this.document.getXmlVersion();
    }

    @Override
    public void setXmlVersion(String string) throws DOMException {
        this.document.setXmlVersion(string);
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.document.getStrictErrorChecking();
    }

    @Override
    public String getBaseURI() {
        return this.document.getBaseURI();
    }

    @Override
    public short compareDocumentPosition(Node node) throws DOMException {
        return this.document.compareDocumentPosition(node);
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.document.getTextContent();
    }

    @Override
    public void setTextContent(String string) throws DOMException {
        this.document.setTextContent(string);
    }

    @Override
    public boolean isSameNode(Node node) {
        return this.document.isSameNode(node);
    }

    @Override
    public String lookupPrefix(String string) {
        return this.document.lookupPrefix(string);
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        return this.document.isDefaultNamespace(string);
    }

    @Override
    public String lookupNamespaceURI(String string) {
        return this.document.lookupNamespaceURI(string);
    }

    @Override
    public boolean isEqualNode(Node node) {
        return this.document.isEqualNode(node);
    }

    @Override
    public Object getFeature(String string, String string2) {
        return this.document.getFeature(string, string2);
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return this.document.setUserData(string, object, userDataHandler);
    }

    @Override
    public Object getUserData(String string) {
        return this.document.getUserData(string);
    }

    @Override
    public void recycleNode() {
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public void setValue(String string) {
        log.severe("SAAJ0571.soappart.setValue.not.defined");
        throw new IllegalStateException("Setting value of a soap part is not defined");
    }

    @Override
    public void setParentElement(SOAPElement sOAPElement) throws SOAPException {
        log.severe("SAAJ0570.soappart.parent.element.not.defined");
        throw new SOAPExceptionImpl("The parent element of a soap part is not defined");
    }

    @Override
    public SOAPElement getParentElement() {
        return null;
    }

    @Override
    public void detachNode() {
    }

    public String getSourceCharsetEncoding() {
        return this.sourceCharsetEncoding;
    }

    static {
        try {
            lazyContentLength = Boolean.getBoolean("saaj.lazy.contentlength");
        }
        catch (AccessControlException accessControlException) {
            lazyContentLength = false;
        }
    }
}

