/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xalan.internal.utils.ObjectFactory;
import com.sun.org.apache.xml.internal.serializer.utils.SystemIDResolver;
import com.sun.org.apache.xml.internal.serializer.utils.Utils;
import com.sun.org.apache.xml.internal.serializer.utils.WrappedRuntimeException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;

final class CharInfo {
    private HashMap m_charToString;
    public static final String HTML_ENTITIES_RESOURCE = "com.sun.org.apache.xml.internal.serializer.HTMLEntities";
    public static final String XML_ENTITIES_RESOURCE = "com.sun.org.apache.xml.internal.serializer.XMLEntities";
    static final char S_HORIZONAL_TAB = '\t';
    static final char S_LINEFEED = '\n';
    static final char S_CARRIAGERETURN = '\r';
    static final char S_SPACE = ' ';
    static final char S_QUOTE = '\"';
    static final char S_LT = '<';
    static final char S_GT = '>';
    static final char S_NEL = '\u0085';
    static final char S_LINE_SEPARATOR = '\u2028';
    boolean onlyQuotAmpLtGt = true;
    static final int ASCII_MAX = 128;
    private final boolean[] shouldMapAttrChar_ASCII;
    private final boolean[] shouldMapTextChar_ASCII;
    private final int[] array_of_bits = this.createEmptySetOfIntegers(65535);
    private static final int SHIFT_PER_WORD = 5;
    private static final int LOW_ORDER_BITMASK = 31;
    private int firstWordNotUsed = 0;
    private final CharKey m_charKey;
    private static HashMap m_getCharInfoCache = new HashMap();

    private CharInfo() {
        this.shouldMapAttrChar_ASCII = new boolean[128];
        this.shouldMapTextChar_ASCII = new boolean[128];
        this.m_charKey = new CharKey();
    }

    private CharInfo(String string, String string2, boolean bl) {
        this();
        this.m_charToString = new HashMap();
        ResourceBundle resourceBundle = null;
        boolean bl2 = true;
        if (bl) {
            try {
                resourceBundle = PropertyResourceBundle.getBundle(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle != null) {
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string3;
                int n;
                String string4 = enumeration.nextElement();
                boolean bl3 = this.defineEntity(string4, (char)(n = Integer.parseInt(string3 = resourceBundle.getString(string4))));
                if (!bl3) continue;
                bl2 = false;
            }
        } else {
            InputStream inputStream = null;
            try {
                Object object;
                Object object2;
                if (bl) {
                    inputStream = CharInfo.class.getResourceAsStream(string);
                } else {
                    object2 = ObjectFactory.findClassLoader();
                    inputStream = object2 == null ? ClassLoader.getSystemResourceAsStream(string) : ((ClassLoader)object2).getResourceAsStream(string);
                    if (inputStream == null) {
                        try {
                            object = new URL(string);
                            inputStream = ((URL)object).openStream();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (inputStream == null) {
                    throw new RuntimeException(Utils.messages.createMessage("ER_RESOURCE_COULD_NOT_FIND", new Object[]{string, string}));
                }
                try {
                    object2 = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object2 = new BufferedReader(new InputStreamReader(inputStream));
                }
                object = ((BufferedReader)object2).readLine();
                while (object != null) {
                    if (((String)object).length() == 0 || ((String)object).charAt(0) == '#') {
                        object = ((BufferedReader)object2).readLine();
                        continue;
                    }
                    int n = ((String)object).indexOf(32);
                    if (n > 1) {
                        String string5 = ((String)object).substring(0, n);
                        if (++n < ((String)object).length()) {
                            int n2;
                            boolean bl4;
                            String string6 = ((String)object).substring(n);
                            if ((n = string6.indexOf(32)) > 0) {
                                string6 = string6.substring(0, n);
                            }
                            if (bl4 = this.defineEntity(string5, (char)(n2 = Integer.parseInt(string6)))) {
                                bl2 = false;
                            }
                        }
                    }
                    object = ((BufferedReader)object2).readLine();
                }
                inputStream.close();
            }
            catch (Exception exception) {
                throw new RuntimeException(Utils.messages.createMessage("ER_RESOURCE_COULD_NOT_LOAD", new Object[]{string, exception.toString(), string, exception.toString()}));
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.onlyQuotAmpLtGt = bl2;
        if ("xml".equals(string2)) {
            this.shouldMapTextChar_ASCII[34] = false;
        }
        if ("html".equals(string2)) {
            this.shouldMapAttrChar_ASCII[60] = false;
            this.shouldMapTextChar_ASCII[34] = false;
        }
    }

    private boolean defineEntity(String string, char c) {
        StringBuilder stringBuilder = new StringBuilder("&");
        stringBuilder.append(string);
        stringBuilder.append(';');
        String string2 = stringBuilder.toString();
        boolean bl = this.defineChar2StringMapping(string2, c);
        return bl;
    }

    String getOutputStringForChar(char c) {
        CharKey charKey = new CharKey();
        charKey.setChar(c);
        return (String)this.m_charToString.get(charKey);
    }

    final boolean shouldMapAttrChar(int n) {
        if (n < 128) {
            return this.shouldMapAttrChar_ASCII[n];
        }
        return this.get(n);
    }

    final boolean shouldMapTextChar(int n) {
        if (n < 128) {
            return this.shouldMapTextChar_ASCII[n];
        }
        return this.get(n);
    }

    private static CharInfo getCharInfoBasedOnPrivilege(final String string, final String string2, final boolean bl) {
        return (CharInfo)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new CharInfo(string, string2, bl);
            }
        });
    }

    static CharInfo getCharInfo(String string, String string2) {
        CharInfo charInfo = (CharInfo)m_getCharInfoCache.get(string);
        if (charInfo != null) {
            return CharInfo.mutableCopyOf(charInfo);
        }
        try {
            charInfo = CharInfo.getCharInfoBasedOnPrivilege(string, string2, true);
            m_getCharInfoCache.put(string, charInfo);
            return CharInfo.mutableCopyOf(charInfo);
        }
        catch (Exception exception) {
            try {
                return CharInfo.getCharInfoBasedOnPrivilege(string, string2, false);
            }
            catch (Exception exception2) {
                if (string.indexOf(58) < 0) {
                    String string3 = SystemIDResolver.getAbsoluteURIFromRelative(string);
                } else {
                    try {
                        String string4 = SystemIDResolver.getAbsoluteURI(string, null);
                    }
                    catch (TransformerException transformerException) {
                        throw new WrappedRuntimeException(transformerException);
                    }
                }
                return CharInfo.getCharInfoBasedOnPrivilege(string, string2, false);
            }
        }
    }

    private static CharInfo mutableCopyOf(CharInfo charInfo) {
        CharInfo charInfo2 = new CharInfo();
        int n = charInfo.array_of_bits.length;
        System.arraycopy(charInfo.array_of_bits, 0, charInfo2.array_of_bits, 0, n);
        charInfo2.firstWordNotUsed = charInfo.firstWordNotUsed;
        n = charInfo.shouldMapAttrChar_ASCII.length;
        System.arraycopy(charInfo.shouldMapAttrChar_ASCII, 0, charInfo2.shouldMapAttrChar_ASCII, 0, n);
        n = charInfo.shouldMapTextChar_ASCII.length;
        System.arraycopy(charInfo.shouldMapTextChar_ASCII, 0, charInfo2.shouldMapTextChar_ASCII, 0, n);
        charInfo2.m_charToString = (HashMap)charInfo.m_charToString.clone();
        charInfo2.onlyQuotAmpLtGt = charInfo.onlyQuotAmpLtGt;
        return charInfo2;
    }

    private static int arrayIndex(int n) {
        return n >> 5;
    }

    private static int bit(int n) {
        int n2 = 1 << (n & 0x1F);
        return n2;
    }

    private int[] createEmptySetOfIntegers(int n) {
        this.firstWordNotUsed = 0;
        int[] nArray = new int[CharInfo.arrayIndex(n - 1) + 1];
        return nArray;
    }

    private final void set(int n) {
        this.setASCIItextDirty(n);
        this.setASCIIattrDirty(n);
        int n2 = n >> 5;
        int n3 = n2 + 1;
        if (this.firstWordNotUsed < n3) {
            this.firstWordNotUsed = n3;
        }
        int n4 = n2;
        this.array_of_bits[n4] = this.array_of_bits[n4] | 1 << (n & 0x1F);
    }

    private final boolean get(int n) {
        boolean bl = false;
        int n2 = n >> 5;
        if (n2 < this.firstWordNotUsed) {
            bl = (this.array_of_bits[n2] & 1 << (n & 0x1F)) != 0;
        }
        return bl;
    }

    private boolean extraEntity(String string, int n) {
        boolean bl = false;
        if (n < 128) {
            switch (n) {
                case 34: {
                    if (string.equals("&quot;")) break;
                    bl = true;
                    break;
                }
                case 38: {
                    if (string.equals("&amp;")) break;
                    bl = true;
                    break;
                }
                case 60: {
                    if (string.equals("&lt;")) break;
                    bl = true;
                    break;
                }
                case 62: {
                    if (string.equals("&gt;")) break;
                    bl = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private void setASCIItextDirty(int n) {
        if (0 <= n && n < 128) {
            this.shouldMapTextChar_ASCII[n] = true;
        }
    }

    private void setASCIIattrDirty(int n) {
        if (0 <= n && n < 128) {
            this.shouldMapAttrChar_ASCII[n] = true;
        }
    }

    boolean defineChar2StringMapping(String string, char c) {
        CharKey charKey = new CharKey(c);
        this.m_charToString.put(charKey, string);
        this.set(c);
        boolean bl = this.extraEntity(string, c);
        return bl;
    }

    private static class CharKey {
        private char m_char;

        public CharKey(char c) {
            this.m_char = c;
        }

        public CharKey() {
        }

        public final void setChar(char c) {
            this.m_char = c;
        }

        public final int hashCode() {
            return this.m_char;
        }

        public final boolean equals(Object object) {
            return ((CharKey)object).m_char == this.m_char;
        }
    }
}

