/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class Driver {
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle("com.sun.java.util.jar.pack.DriverResource");
    private static final String PACK200_OPTION_MAP = "--repack                 $ \n  -r +>- @--repack              $ \n--no-gzip                $ \n  -g +>- @--no-gzip             $ \n--strip-debug            $ \n  -G +>- @--strip-debug         $ \n--no-keep-file-order     $ \n  -O +>- @--no-keep-file-order  $ \n--segment-limit=      *> = \n  -S +>  @--segment-limit=      = \n--effort=             *> = \n  -E +>  @--effort=             = \n--deflate-hint=       *> = \n  -H +>  @--deflate-hint=       = \n--modification-time=  *> = \n  -m +>  @--modification-time=  = \n--pass-file=        *> &\u0000 \n  -P +>  @--pass-file=        &\u0000 \n--unknown-attribute=  *> = \n  -U +>  @--unknown-attribute=  = \n--class-attribute=  *> &\u0000 \n  -C +>  @--class-attribute=  &\u0000 \n--field-attribute=  *> &\u0000 \n  -F +>  @--field-attribute=  &\u0000 \n--method-attribute= *> &\u0000 \n  -M +>  @--method-attribute= &\u0000 \n--code-attribute=   *> &\u0000 \n  -D +>  @--code-attribute=   &\u0000 \n--config-file=      *>   . \n  -f +>  @--config-file=        . \n--no-strip-debug  !--strip-debug         \n--gzip            !--no-gzip             \n--keep-file-order !--no-keep-file-order  \n--verbose                $ \n  -v +>- @--verbose             $ \n--quiet        !--verbose  \n  -q +>- !--verbose               \n--log-file=           *> = \n  -l +>  @--log-file=           = \n--version                . \n  -V +>  @--version             . \n--help               . \n  -? +> @--help . \n  -h +> @--help . \n--           . \n-   +?    >- . \n";
    private static final String UNPACK200_OPTION_MAP = "--deflate-hint=       *> = \n  -H +>  @--deflate-hint=       = \n--verbose                $ \n  -v +>- @--verbose             $ \n--quiet        !--verbose  \n  -q +>- !--verbose               \n--remove-pack-file       $ \n  -r +>- @--remove-pack-file    $ \n--log-file=           *> = \n  -l +>  @--log-file=           = \n--config-file=        *> . \n  -f +>  @--config-file=        . \n--           . \n-   +?    >- . \n--version                . \n  -V +>  @--version             . \n--help               . \n  -? +> @--help . \n  -h +> @--help . \n";
    private static final String[] PACK200_PROPERTY_TO_OPTION = new String[]{"pack.segment.limit", "--segment-limit=", "pack.keep.file.order", "--no-keep-file-order", "pack.effort", "--effort=", "pack.deflate.hint", "--deflate-hint=", "pack.modification.time", "--modification-time=", "pack.pass.file.", "--pass-file=", "pack.unknown.attribute", "--unknown-attribute=", "pack.class.attribute.", "--class-attribute=", "pack.field.attribute.", "--field-attribute=", "pack.method.attribute.", "--method-attribute=", "pack.code.attribute.", "--code-attribute=", "com.sun.java.util.jar.pack.verbose", "--verbose", "com.sun.java.util.jar.pack.strip.debug", "--strip-debug"};
    private static final String[] UNPACK200_PROPERTY_TO_OPTION = new String[]{"unpack.deflate.hint", "--deflate-hint=", "com.sun.java.util.jar.pack.verbose", "--verbose", "com.sun.java.util.jar.pack.unpack.remove.packfile", "--remove-pack-file"};

    Driver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) throws IOException {
        Object object;
        Object object3;
        Object object4;
        Object object522;
        Object object6;
        String[] stringArray2;
        String string;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        Object object7 = null;
        String string2 = "com.sun.java.util.jar.pack.verbose";
        Object object8 = arrayList.isEmpty() ? "" : (String)arrayList.get(0);
        switch (object8) {
            case "--pack": {
                arrayList.remove(0);
                break;
            }
            case "--unpack": {
                arrayList.remove(0);
                bl = false;
                bl2 = true;
            }
        }
        object8 = new HashMap();
        object8.put(string2, System.getProperty(string2));
        if (bl) {
            string = PACK200_OPTION_MAP;
            stringArray2 = PACK200_PROPERTY_TO_OPTION;
        } else {
            string = UNPACK200_OPTION_MAP;
            stringArray2 = UNPACK200_PROPERTY_TO_OPTION;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            block41: while (true) {
                object6 = Driver.parseCommandOptions(arrayList, string, hashMap);
                object522 = hashMap.keySet().iterator();
                while (object522.hasNext()) {
                    object4 = (String)object522.next();
                    object3 = null;
                    for (int i = 0; i < stringArray2.length; i += 2) {
                        if (!((String)object4).equals(stringArray2[1 + i])) continue;
                        object3 = stringArray2[0 + i];
                        break;
                    }
                    if (object3 == null) continue;
                    String string3 = (String)hashMap.get(object4);
                    object522.remove();
                    if (!((String)object3).endsWith(".")) {
                        if (!((String)object4).equals("--verbose") && !((String)object4).endsWith("=")) {
                            boolean bl5;
                            boolean bl6 = bl5 = string3 != null;
                            if (((String)object4).startsWith("--no-")) {
                                bl5 = !bl5;
                            }
                            string3 = bl5 ? "true" : "false";
                        }
                        object8.put(object3, string3);
                        continue;
                    }
                    if (((String)object3).contains(".attribute.")) {
                        for (String string4 : string3.split("\u0000")) {
                            String[] bl8 = string4.split("=", 2);
                            object8.put((String)object3 + bl8[0], bl8[1]);
                        }
                        continue;
                    }
                    int n = 1;
                    for (String string4 : string3.split("\u0000")) {
                        while (object8.containsKey(object = (String)object3 + "cli." + n++)) {
                        }
                        object8.put(object, string4);
                    }
                }
                if (!"--config-file=".equals(object6)) break;
                object522 = (String)arrayList.remove(0);
                object4 = new Properties();
                object3 = new FileInputStream((String)object522);
                Object object9 = null;
                try {
                    ((Properties)object4).load((InputStream)object3);
                }
                catch (Throwable throwable) {
                    object9 = throwable;
                    throw throwable;
                }
                finally {
                    if (object3 != null) {
                        if (object9 != null) {
                            try {
                                ((InputStream)object3).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object9).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object3).close();
                        }
                    }
                }
                if (object8.get(string2) != null) {
                    ((Properties)object4).list(System.out);
                }
                object3 = ((Hashtable)object4).entrySet().iterator();
                while (true) {
                    if (!object3.hasNext()) continue block41;
                    object9 = object3.next();
                    object8.put((String)object9.getKey(), (String)object9.getValue());
                }
                break;
            }
            if ("--version".equals(object6)) {
                System.out.println(MessageFormat.format(RESOURCE.getString("VERSION"), Driver.class.getName(), "1.31, 07/05/05"));
                return;
            }
            if ("--help".equals(object6)) {
                Driver.printUsage(bl, true, System.out);
                System.exit(1);
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(MessageFormat.format(RESOURCE.getString("BAD_ARGUMENT"), illegalArgumentException));
            Driver.printUsage(bl, false, System.err);
            System.exit(2);
            return;
        }
        block48: for (Object object522 : hashMap.keySet()) {
            object4 = (String)hashMap.get(object522);
            switch (object522) {
                case "--repack": {
                    bl3 = true;
                    continue block48;
                }
                case "--no-gzip": {
                    bl4 = object4 == null;
                    continue block48;
                }
                case "--log-file=": {
                    object7 = object4;
                    continue block48;
                }
            }
            throw new InternalError(MessageFormat.format(RESOURCE.getString("BAD_OPTION"), object522, hashMap.get(object522)));
        }
        if (object7 != null && !((String)object7).equals("")) {
            if (((String)object7).equals("-")) {
                System.setErr(System.out);
            } else {
                object6 = new FileOutputStream((String)object7);
                System.setErr(new PrintStream((OutputStream)object6));
            }
        }
        boolean bl7 = object8.get(string2) != null;
        object522 = "";
        if (!arrayList.isEmpty()) {
            object522 = (String)arrayList.remove(0);
        }
        object4 = "";
        if (!arrayList.isEmpty()) {
            object4 = (String)arrayList.remove(0);
        }
        object3 = "";
        String string5 = "";
        String string6 = "";
        if (bl3) {
            if (((String)object522).toLowerCase().endsWith(".pack") || ((String)object522).toLowerCase().endsWith(".pac") || ((String)object522).toLowerCase().endsWith(".gz")) {
                System.err.println(MessageFormat.format(RESOURCE.getString("BAD_REPACK_OUTPUT"), object522));
                Driver.printUsage(bl, false, System.err);
                System.exit(2);
            }
            object3 = object522;
            if (((String)object4).equals("")) {
                object4 = object3;
            }
            string6 = Driver.createTempFile((String)object3, ".pack").getPath();
            object522 = string6;
            bl4 = false;
        }
        if (!(arrayList.isEmpty() && (((String)object4).toLowerCase().endsWith(".jar") || ((String)object4).toLowerCase().endsWith(".zip") || ((String)object4).equals("-") && !bl))) {
            Driver.printUsage(bl, false, System.err);
            System.exit(2);
            return;
        }
        if (bl3) {
            bl2 = true;
            bl = true;
        } else if (bl) {
            bl2 = false;
        }
        Pack200.Packer packer = Pack200.newPacker();
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        packer.properties().putAll((Map<String, String>)object8);
        unpacker.properties().putAll((Map<String, String>)object8);
        if (bl3 && ((String)object3).equals(object4)) {
            String string7 = Driver.getZipComment((String)object4);
            if (bl7 && string7.length() > 0) {
                System.out.println(MessageFormat.format(RESOURCE.getString("DETECTED_ZIP_COMMENT"), string7));
            }
            if (string7.indexOf("PACK200") >= 0) {
                System.out.println(MessageFormat.format(RESOURCE.getString("SKIP_FOR_REPACKED"), object4));
                bl = false;
                bl2 = false;
                bl3 = false;
            }
        }
        try {
            if (bl) {
                void var21_50;
                JarFile jarFile = new JarFile(new File((String)object4));
                if (((String)object522).equals("-")) {
                    PrintStream bufferedInputStream = System.out;
                    System.setOut(System.err);
                } else if (bl4) {
                    if (!((String)object522).endsWith(".gz")) {
                        System.err.println(MessageFormat.format(RESOURCE.getString("WRITE_PACK_FILE"), object522));
                        Driver.printUsage(bl, false, System.err);
                        System.exit(2);
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream((String)object522);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(bufferedOutputStream);
                } else {
                    if (!((String)object522).toLowerCase().endsWith(".pack") && !((String)object522).toLowerCase().endsWith(".pac")) {
                        System.err.println(MessageFormat.format(RESOURCE.getString("WIRTE_PACKGZ_FILE"), object522));
                        Driver.printUsage(bl, false, System.err);
                        System.exit(2);
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream((String)object522);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                }
                packer.pack(jarFile, (OutputStream)var21_50);
                var21_50.close();
            }
            if (bl3 && ((String)object3).equals(object4)) {
                File file = Driver.createTempFile((String)object4, ".bak");
                file.delete();
                boolean bl8 = new File((String)object4).renameTo(file);
                if (!bl8) {
                    throw new Error(MessageFormat.format(RESOURCE.getString("SKIP_FOR_MOVE_FAILED"), string5));
                }
                string5 = file.getPath();
            }
            if (bl2) {
                InputStream inputStream = ((String)object522).equals("-") ? System.in : new FileInputStream(new File((String)object522));
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                inputStream = bufferedInputStream;
                if (Utils.isGZIPMagic(Utils.readMagic(bufferedInputStream))) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                object = ((String)object3).equals("") ? object4 : object3;
                OutputStream outputStream = ((String)object).equals("-") ? System.out : new FileOutputStream((String)object);
                outputStream = new BufferedOutputStream(outputStream);
                try (JarOutputStream jarOutputStream = new JarOutputStream(outputStream);){
                    unpacker.unpack(inputStream, jarOutputStream);
                }
            }
            if (!string5.equals("")) {
                new File(string5).delete();
                string5 = "";
            }
        }
        finally {
            if (!string5.equals("")) {
                File file = new File((String)object4);
                file.delete();
                new File(string5).renameTo(file);
            }
            if (!string6.equals("")) {
                new File(string6).delete();
            }
        }
    }

    private static File createTempFile(String string, String string2) throws IOException {
        File file = new File(string);
        String string3 = file.getName();
        if (string3.length() < 3) {
            string3 = string3 + "tmp";
        }
        File file2 = file.getParentFile();
        if (file.getParentFile() == null && string2.equals(".bak")) {
            file2 = new File(".").getAbsoluteFile();
        }
        return Files.createTempFile(file2.toPath(), string3, string2, new FileAttribute[0]).toFile();
    }

    private static void printUsage(boolean bl, boolean bl2, PrintStream printStream) {
        String string = bl ? "pack200" : "unpack200";
        String[] stringArray = (String[])RESOURCE.getObject("PACK_HELP");
        String[] stringArray2 = (String[])RESOURCE.getObject("UNPACK_HELP");
        String[] stringArray3 = bl ? stringArray : stringArray2;
        for (int i = 0; i < stringArray3.length; ++i) {
            printStream.println(stringArray3[i]);
            if (bl2) continue;
            printStream.println(MessageFormat.format(RESOURCE.getString("MORE_INFO"), string));
            break;
        }
    }

    private static String getZipComment(String string) throws IOException {
        byte[] byArray = new byte[1000];
        long l = new File(string).length();
        if (l <= 0L) {
            return "";
        }
        long l2 = Math.max(0L, l - (long)byArray.length);
        try (FileInputStream fileInputStream = new FileInputStream(new File(string));){
            ((InputStream)fileInputStream).skip(l2);
            ((InputStream)fileInputStream).read(byArray);
            for (int i = byArray.length - 4; i >= 0; --i) {
                if (byArray[i + 0] != 80 || byArray[i + 1] != 75 || byArray[i + 2] != 5 || byArray[i + 3] != 6) continue;
                if ((i += 22) < byArray.length) {
                    String string2 = new String(byArray, i, byArray.length - i, "UTF8");
                    return string2;
                }
                String string3 = "";
                return string3;
            }
            String string4 = "";
            return string4;
        }
    }

    private static String parseCommandOptions(List<String> list, String string, Map<String, String> map) {
        ListIterator<String> listIterator;
        ListIterator<String> listIterator2;
        Object object;
        block32: {
            String string2;
            SortedMap sortedMap;
            Object object2;
            object = null;
            TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
            for (String string3 : string.split("\n")) {
                String[] stringArray;
                object2 = string3.split("\\p{Space}+");
                if (((String[])object2).length == 0) continue;
                sortedMap = object2[0];
                object2[0] = "";
                if (((String)((Object)sortedMap)).length() == 0 && ((String[])object2).length >= 1) {
                    sortedMap = object2[1];
                    object2[1] = "";
                }
                if (((String)((Object)sortedMap)).length() == 0 || (stringArray = treeMap.put(sortedMap, object2)) == null) continue;
                throw new RuntimeException(MessageFormat.format(RESOURCE.getString("DUPLICATE_OPTION"), string3.trim()));
            }
            listIterator2 = list.listIterator();
            listIterator = new ArrayList().listIterator();
            block14: while (true) {
                if (listIterator.hasPrevious()) {
                    string2 = (String)listIterator.previous();
                    listIterator.remove();
                } else {
                    if (!listIterator2.hasNext()) break block32;
                    string2 = (String)listIterator2.next();
                }
                int n = string2.length();
                while (true) {
                    String[] stringArray;
                    int n2;
                    if (!treeMap.containsKey(object2 = string2.substring(0, n))) {
                        if (n == 0) break block14;
                        sortedMap = treeMap.headMap(object2);
                        n2 = sortedMap.isEmpty() ? 0 : ((String)sortedMap.lastKey()).length();
                        n = Math.min(n2, n - 1);
                        object2 = string2.substring(0, n);
                        continue;
                    }
                    object2 = ((String)object2).intern();
                    assert (string2.startsWith((String)object2));
                    assert (((String)object2).length() == n);
                    sortedMap = string2.substring(n);
                    n2 = 0;
                    boolean bl = false;
                    int n3 = listIterator.nextIndex();
                    block16: for (String string4 : stringArray = (String[])treeMap.get(object2)) {
                        boolean bl2;
                        if (string4.length() == 0) continue;
                        if (string4.startsWith("#")) break;
                        int n4 = 0;
                        char c = string4.charAt(n4++);
                        switch (c) {
                            case '+': {
                                bl2 = ((String)((Object)sortedMap)).length() != 0;
                                c = string4.charAt(n4++);
                                break;
                            }
                            case '*': {
                                bl2 = true;
                                c = string4.charAt(n4++);
                                break;
                            }
                            default: {
                                boolean bl3 = bl2 = ((String)((Object)sortedMap)).length() == 0;
                            }
                        }
                        if (!bl2) continue;
                        String string5 = string4.substring(n4);
                        switch (c) {
                            case '.': {
                                object = string5.length() != 0 ? string5.intern() : object2;
                                break block32;
                            }
                            case '?': {
                                object = string5.length() != 0 ? string5.intern() : string2;
                                bl = true;
                                break block16;
                            }
                            case '@': {
                                object2 = string5.intern();
                                continue block16;
                            }
                            case '>': {
                                listIterator.add(string5 + (String)((Object)sortedMap));
                                sortedMap = "";
                                continue block16;
                            }
                            case '!': {
                                Object object3 = string5.length() != 0 ? string5.intern() : object2;
                                map.remove(object3);
                                map.put((String)object3, null);
                                n2 = 1;
                                continue block16;
                            }
                            case '$': {
                                String string6;
                                String string7 = string5.length() != 0 ? string5 : ((string6 = map.get(object2)) == null || string6.length() == 0 ? "1" : "" + (1 + Integer.parseInt(string6)));
                                map.put((String)object2, string7);
                                n2 = 1;
                                continue block16;
                            }
                            case '&': 
                            case '=': {
                                String string8;
                                String string9;
                                boolean bl4;
                                boolean bl5 = bl4 = c == '&';
                                if (listIterator.hasPrevious()) {
                                    string9 = (String)listIterator.previous();
                                    listIterator.remove();
                                } else if (listIterator2.hasNext()) {
                                    string9 = (String)listIterator2.next();
                                } else {
                                    object = string2 + " ?";
                                    bl = true;
                                    break block16;
                                }
                                if (bl4 && (string8 = map.get(object2)) != null) {
                                    String string10 = string5;
                                    if (string10.length() == 0) {
                                        string10 = " ";
                                    }
                                    string9 = string8 + string5 + string9;
                                }
                                map.put((String)object2, string9);
                                n2 = 1;
                                continue block16;
                            }
                            default: {
                                throw new RuntimeException(MessageFormat.format(RESOURCE.getString("BAD_SPEC"), object2, string4));
                            }
                        }
                    }
                    if (n2 != 0 && !bl) continue block14;
                    while (listIterator.nextIndex() > n3) {
                        listIterator.previous();
                        listIterator.remove();
                    }
                    if (bl) {
                        throw new IllegalArgumentException((String)object);
                    }
                    if (n == 0) break block14;
                    --n;
                }
                break;
            }
            listIterator.add(string2);
        }
        list.subList(0, listIterator2.nextIndex()).clear();
        while (listIterator.hasPrevious()) {
            list.add(0, (String)listIterator.previous());
        }
        return object;
    }
}

