/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.util;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Platform;
import java.io.File;
import sun.plugin2.util.SystemUtil;

public class NativeLibLoader {
    private static final boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;

    private NativeLibLoader() {
    }

    public static synchronized void load(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new InternalError("Wrong library name passed to load method");
        }
        String[] stringArray2 = SystemUtil.getSystemProperty("sun.boot.class.path").split(File.pathSeparator);
        String[] stringArray3 = NativeLibLoader.getPossibleSubdirs();
        String string = Environment.getForcedDeployRoot();
        if (!(string != null && NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray3, string + File.separator + "lib" + File.separator + "deploy.jar") || NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray3, NativeLibLoader.findSuffix(stringArray2, "plugin.jar")) || NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray3, NativeLibLoader.findSuffix(stringArray2, "deploy.jar")) || NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray3, NativeLibLoader.findSuffix(stringArray2, "javaws.jar")))) {
            throw new InternalError("Unable to find plugin native libraries");
        }
    }

    private static boolean tryLoadingFromJRE(String[] stringArray, String[] stringArray2, String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string).getParentFile();
        File file2 = file.getParentFile();
        File file3 = null;
        if (file2 != null) {
            file3 = file2.getParentFile();
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl2 = false;
            if (stringArray[i].equalsIgnoreCase("npjp2") || stringArray[i].equalsIgnoreCase("jp2iexp")) {
                block13: {
                    try {
                        String string2 = Platform.get().getLoadedNativeLibPath(stringArray[i]);
                        if (string2 != null) {
                            File file4;
                            if (DEBUG) {
                                System.err.println("NativeLibLoader: resolving loaded " + string2);
                            }
                            if ((file4 = new File(string2)).exists() && file4.canRead()) {
                                System.load(file4.getAbsolutePath());
                                if (!DEBUG) continue;
                                System.err.println("   (Succeeded)");
                                continue;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG) break block13;
                        throwable.printStackTrace();
                    }
                }
                if ((SystemUtil.getenv("FORCED_DEPLOY_ROOT") != null || SystemUtil.getenv("FORCED_JRE_ROOT") != null) && SystemUtil.getenv("FORCED_OVERRIDE_BROWSERLIB") == null) {
                    file = new File(System.getProperty("java.home"));
                    for (int j = 0; j < stringArray2.length && !bl2; ++j) {
                        bl2 = NativeLibLoader.tryLoading(stringArray[i], file, stringArray2[j]);
                    }
                    if (bl2) continue;
                    bl = false;
                    continue;
                }
            }
            for (int j = 0; j < stringArray2.length && !bl2; ++j) {
                bl2 = NativeLibLoader.tryLoading(stringArray[i], file, stringArray2[j]);
                if (!bl2) {
                    bl2 = NativeLibLoader.tryLoading(stringArray[i], file2, stringArray2[j]);
                }
                if (bl2) continue;
                bl2 = NativeLibLoader.tryLoading(stringArray[i], file3, stringArray2[j]);
            }
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    private static String[] getPossibleSubdirs() {
        String string;
        String string2 = SystemUtil.getSystemProperty("sun.boot.library.path");
        if (!string2.startsWith(string = SystemUtil.getJavaHome())) {
            throw new InternalError("sun.boot.library.path (\"" + string2 + "\") did not start with java.home (\"" + string + "\")");
        }
        String string3 = string2.substring(string.length());
        if (string3.startsWith(File.separator)) {
            string3 = string3.substring(1);
        }
        String string4 = "jre" + File.separator + string3;
        String string5 = string3 + File.separator + "plugin2";
        String string6 = string4 + File.separator + "plugin2";
        return new String[]{string3, string4, string5, string6};
    }

    private static boolean tryLoading(String string, File file, String string2) {
        String string3;
        File file2;
        if (file == null) {
            return false;
        }
        File file3 = file;
        if (string2 != null) {
            file3 = new File(file, string2);
        }
        if (!(file2 = new File(file3, SystemUtil.formatNativeLibraryName(string))).exists() && (string3 = SystemUtil.getSystemProperty("os.name").toLowerCase()).startsWith("mac os x")) {
            file2 = new File(file3, string);
        }
        if (!file2.exists()) {
            if (DEBUG) {
                System.err.println("NativeLibLoader: " + file2.getAbsolutePath() + " doesn't exist");
            }
            return false;
        }
        if (DEBUG) {
            System.err.println("NativeLibLoader: trying to load " + file2.getAbsolutePath());
        }
        System.load(file2.getAbsolutePath());
        if (DEBUG) {
            System.err.println("  (Succeeded)");
        }
        return true;
    }

    private static String findSuffix(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(string)) continue;
            return stringArray[i];
        }
        return null;
    }
}

