/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.net.CrossDomainXML;
import com.sun.deploy.net.DeployClassLoader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.security.util.SecurityConstants;

public class SecurityManagerHelper {
    private static final ThreadLocal inThreadGroupCheck = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };

    static void resetHelper(final HashSet hashSet) {
        hashSet.clear();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Enumeration<?> enumeration = System.getProperties().propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)enumeration.nextElement();
                    if (string2 == null || !string2.startsWith("package.restrict.access.") || (string = System.getProperty(string2)) == null || !string.equalsIgnoreCase("true")) continue;
                    String string3 = string2.substring(24);
                    hashSet.add(string3);
                }
                return null;
            }
        });
    }

    static void checkAccessHelper(Thread thread, SecurityManager securityManager, ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        if (!SecurityManagerHelper.isThreadTerminated(thread) && !SecurityManagerHelper.inThreadGroup(securityManager, thread, classLoader, classArray, field, field2)) {
            securityManager.checkPermission(SecurityConstants.MODIFY_THREAD_PERMISSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkAccessHelper(ThreadGroup threadGroup, SecurityManager securityManager, ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        if (inThreadGroupCheck.get().equals(Boolean.TRUE)) {
            securityManager.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        } else {
            try {
                inThreadGroupCheck.set(Boolean.TRUE);
                if (!SecurityManagerHelper.inThreadGroup(securityManager, threadGroup, classLoader, classArray, field, field2)) {
                    securityManager.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
                }
                Object var7_6 = null;
                inThreadGroupCheck.set(Boolean.FALSE);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                inThreadGroupCheck.set(Boolean.FALSE);
                throw throwable;
            }
        }
    }

    private static boolean isThreadTerminated(Thread thread) {
        try {
            return thread.getState() == Thread.State.TERMINATED;
        }
        catch (Throwable throwable) {
            return !thread.isAlive();
        }
    }

    private static Plugin2ClassLoader currentAppletClassLoader(ClassLoader classLoader, Class[] classArray, final Field field, final Field field2) {
        int n;
        if (classLoader == null || classLoader instanceof Plugin2ClassLoader) {
            return (Plugin2ClassLoader)classLoader;
        }
        for (n = 0; n < classArray.length; ++n) {
            classLoader = classArray[n].getClassLoader();
            if (!(classLoader instanceof Plugin2ClassLoader)) continue;
            return (Plugin2ClassLoader)classLoader;
        }
        for (n = 0; n < classArray.length; ++n) {
            final ClassLoader classLoader2 = classArray[n].getClassLoader();
            if (!(classLoader2 instanceof URLClassLoader) || (classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AccessControlContext accessControlContext = null;
                    ProtectionDomain[] protectionDomainArray = null;
                    try {
                        accessControlContext = (AccessControlContext)field.get(classLoader2);
                        if (accessControlContext == null) {
                            return null;
                        }
                        protectionDomainArray = (ProtectionDomain[])field2.get(accessControlContext);
                        if (protectionDomainArray == null) {
                            return null;
                        }
                    }
                    catch (Exception exception) {
                        throw new UnsupportedOperationException(exception);
                    }
                    for (int i = 0; i < protectionDomainArray.length; ++i) {
                        ClassLoader classLoader = protectionDomainArray[i].getClassLoader();
                        if (!(classLoader instanceof Plugin2ClassLoader)) continue;
                        return classLoader;
                    }
                    return null;
                }
            })) == null) continue;
            return (Plugin2ClassLoader)classLoader;
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof Plugin2ClassLoader) {
            return (Plugin2ClassLoader)classLoader;
        }
        return null;
    }

    private static boolean inThreadGroup(SecurityManager securityManager, ThreadGroup threadGroup, ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        if (SecurityManagerHelper.currentAppletClassLoader(classLoader, classArray, field, field2) == null) {
            return false;
        }
        ThreadGroup threadGroup2 = SecurityManagerHelper.getThreadGroupHelper(securityManager, classLoader, classArray, field, field2);
        if (threadGroup2 == null) {
            return false;
        }
        return threadGroup2.parentOf(threadGroup);
    }

    private static boolean inThreadGroup(SecurityManager securityManager, Thread thread, ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        return SecurityManagerHelper.inThreadGroup(securityManager, thread.getThreadGroup(), classLoader, classArray, field, field2);
    }

    static void checkPackageAccessHelper(SecurityManager securityManager, String string, HashSet hashSet) {
        try {
            securityManager.checkPackageAccess(string);
        }
        catch (RuntimeException runtimeException) {
            if (DeployClassLoader.isLoadingClass()) {
                DeployClassLoader.setClassLoadingException((Throwable)runtimeException);
                return;
            }
            throw runtimeException;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2) && !string.startsWith(string2 + ".")) continue;
            securityManager.checkPermission(new RuntimePermission("accessClassInPackage." + string));
        }
    }

    static void checkConnectHelper(SecurityManager securityManager, String string, int n, Object object, Class[] classArray) {
        int n2;
        URL uRL = null;
        int n3 = n2 = n < 0 ? n : -4;
        if (n2 == -2 || n2 == -3) {
            try {
                uRL = new URL(string);
                string = uRL.getHost();
                n = uRL.getPort();
                if (n == -1) {
                    n = uRL.getDefaultPort();
                }
                if (CrossDomainXML.quickCheck((URL)uRL, (String)string, (int)n, (int)n2)) {
                    return;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        try {
            securityManager.checkConnect(string, n, object);
        }
        catch (SecurityException securityException) {
            if (CrossDomainXML.check((Class[])classArray, (URL)uRL, (String)string, (int)n, (int)n2)) {
                return;
            }
            throw securityException;
        }
    }

    static void checkConnectHelper(SecurityManager securityManager, String string, int n, Class[] classArray) {
        int n2;
        URL uRL = null;
        int n3 = n2 = n < 0 ? n : -4;
        if (n2 == -2 || n2 == -3) {
            try {
                uRL = new URL(string);
                string = uRL.getHost();
                n = uRL.getPort();
                if (n == -1) {
                    n = uRL.getDefaultPort();
                }
                if (CrossDomainXML.quickCheck((URL)uRL, (String)string, (int)n, (int)n2)) {
                    return;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        try {
            securityManager.checkConnect(string, n);
        }
        catch (SecurityException securityException) {
            if (CrossDomainXML.check((Class[])classArray, (URL)uRL, (String)string, (int)n, (int)n2)) {
                return;
            }
            throw securityException;
        }
    }

    static void checkAwtEventQueueAccessHelper(SecurityManager securityManager, AppContext appContext, ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        try {
            AppContext appContext2 = ToolkitStore.get().getAppContext();
            Plugin2ClassLoader plugin2ClassLoader = SecurityManagerHelper.currentAppletClassLoader(classLoader, classArray, field, field2);
            if (appContext2.equals(appContext) && plugin2ClassLoader != null) {
                securityManager.checkAwtEventQueueAccess();
            }
            return;
        }
        catch (SecurityException securityException) {
            securityManager.checkSecurityAccess("accessEventQueue");
            return;
        }
    }

    static void checkPrintJobAccessHelper(SecurityManager securityManager) {
        try {
            securityManager.checkPrintJobAccess();
            return;
        }
        catch (SecurityException securityException) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    SecurityManagerHelper.showPrintDialog();
                    return null;
                }
            });
            return;
        }
    }

    private static void showPrintDialog() {
        String string = ResourceManager.getString((String)"plugin.print.title");
        String string2 = ResourceManager.getString((String)"plugin.print.message");
        String string3 = ResourceManager.getString((String)"plugin.print.always");
        String string4 = (String)ToolkitStore.get().getAppContext().get((Object)"sun.plugin.security.printDialog");
        int n = 0;
        if (!Trace.isAutomationEnabled() && string4 == null) {
            UIFactory uIFactory = ToolkitStore.getUI();
            ToolkitStore.getUI();
            n = uIFactory.showMessageDialog(null, null, 7, string, null, string2, null, null, string3, null);
        } else {
            Trace.msgSecurityPrintln((String)"securitymgr.automation.printing");
            ToolkitStore.getUI();
            n = 0;
        }
        ToolkitStore.getUI();
        if (n == 2) {
            ToolkitStore.get().getAppContext().put((Object)"sun.plugin.security.printDialog", (Object)"skip");
        } else {
            ToolkitStore.getUI();
            if (n != 0) {
                throw new SecurityException("checkPrintJobAccess");
            }
        }
    }

    static void checkSecurityAccessHelper(SecurityManager securityManager, String string) {
        if (string != null && string.equals("java")) {
            return;
        }
        securityManager.checkSecurityAccess(string);
    }

    static AppContext getAppContextHelper(ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        Plugin2ClassLoader plugin2ClassLoader = SecurityManagerHelper.currentAppletClassLoader(classLoader, classArray, field, field2);
        if (plugin2ClassLoader == null) {
            return null;
        }
        AppContext appContext = plugin2ClassLoader.getAppContext();
        if (appContext == null) {
            throw new SecurityException("Applet classloader has invalid AppContext");
        }
        return appContext;
    }

    static ThreadGroup getThreadGroupHelper(SecurityManager securityManager, ClassLoader classLoader, Class[] classArray, Field field, Field field2) {
        ThreadGroup threadGroup;
        Plugin2ClassLoader plugin2ClassLoader = SecurityManagerHelper.currentAppletClassLoader(classLoader, classArray, field, field2);
        ThreadGroup threadGroup2 = threadGroup = plugin2ClassLoader == null ? null : plugin2ClassLoader.getThreadGroup();
        if (threadGroup != null) {
            return threadGroup;
        }
        return securityManager.getThreadGroup();
    }
}

