/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.config.AutoUpdater;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.PlatformFactory;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public abstract class Platform {
    private static final boolean DEBUG = Config.getDeployDebug() || Config.getPluginDebug();
    private static Platform _platform;
    private Collection fx_runtimes = null;
    protected static final String UPGRADE_FILENAME = "CacheUpgrade.properties";
    protected AutoUpdater auInstance;

    public static void setInstance(Platform platform) {
        _platform = platform;
    }

    public static Platform get() {
        if (_platform == null) {
            Platform.setInstance(PlatformFactory.newInstance());
        }
        return _platform;
    }

    public abstract void addRemoveProgramsAdd(String var1, String var2, String var3, String var4, String var5, String var6, boolean var7);

    public abstract void cacheSecurityBaseline(String var1, String var2);

    public abstract void addRemoveProgramsRemove(String var1, boolean var2);

    public abstract boolean canAutoDownloadJRE();

    public abstract String getBrowserPath();

    public abstract String getBrowserHomePath();

    public abstract String getDefaultSystemCache();

    public abstract String getFireFoxUserProfileDirectory();

    public abstract boolean canBecomeAdmin();

    public abstract boolean hasAdminPrivileges();

    public abstract Vector getInstalledJREList();

    public abstract void notifyJREInstalled(String var1);

    public abstract String getLibrarySufix();

    public abstract String getLibraryPrefix();

    public abstract String getMozillaUserProfileDirectory();

    public abstract long getNativePID();

    public abstract String getSessionSpecificString();

    public abstract String getSystemJavawsPath();

    public abstract int getSystemShortcutIconSize(boolean var1);

    public abstract int installShortcut(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public abstract boolean isBrowserFireFox();

    public abstract boolean isLocalInstallSupported();

    public abstract boolean isNativeModalDialogUp();

    public abstract boolean isPlatformIconType(String var1);

    public abstract boolean isPlatformWindowsVista();

    public abstract void loadDeployNativeLib();

    public abstract void sendJFXPing(String var1, String var2, String var3, String var4, String var5, int var6, String var7);

    public abstract void setUserHomeOverride(String var1);

    public abstract boolean showDocument(String var1);

    public abstract boolean getJqsSettings();

    public abstract void setJqsSettings(boolean var1);

    public abstract boolean getJavaPluginSettings();

    public abstract int setJavaPluginSettings(boolean var1);

    public abstract void initBrowserSettings();

    public abstract int applyBrowserSettings();

    public abstract boolean systemLookAndFeelDefault();

    public abstract String getUserHome();

    public String getLocalStorageDir() {
        return this.getUserHome();
    }

    public abstract String getUserHomeOverride();

    public abstract String getOSHome();

    public abstract String getSystemHome();

    public abstract String getPlatformSpecificJavaName();

    public abstract String getPlatformExtension();

    public abstract String getDebugJavaPath(String var1);

    public abstract String getLongPathName(String var1);

    public abstract boolean samePaths(String var1, String var2);

    public abstract int getPlatformMaxCommandLineLength();

    public abstract boolean useAltFileSystemView();

    public abstract String toExecArg(String var1);

    public abstract void onLoad(Object var1);

    public abstract void onSave(Object var1);

    public abstract boolean shouldPromptForAutoCheck();

    public abstract void handleUserResponse(int var1);

    public abstract void resetJavaHome();

    public String getJucheckPath() {
        return null;
    }

    protected void addJfxRuntimeIfValid(Collection collection, String string) {
        if (string == null) {
            return;
        }
        JfxRuntime jfxRuntime = JfxRuntime.runtimeForPath(string);
        if (jfxRuntime != null) {
            collection.add(jfxRuntime);
        }
    }

    protected Collection detectInstalledJfxRuntimes() {
        LinkedList linkedList = new LinkedList();
        this.addJfxRuntimeIfValid(linkedList, Environment.getenv("FORCED_FX_ROOT"));
        this.addJfxRuntimeIfValid(linkedList, System.getProperty("java.home"));
        return linkedList;
    }

    public Collection getInstalledJfxRuntimes() {
        return this.getInstalledJfxRuntimes(false);
    }

    public Collection getInstalledJfxRuntimes(boolean bl) {
        if (bl || null == this.fx_runtimes) {
            this.fx_runtimes = Collections.unmodifiableCollection(this.detectInstalledJfxRuntimes());
            if (DEBUG) {
                System.out.println(this.fx_runtimes.size() + " JavaFX runtime found.");
                Iterator iterator = this.fx_runtimes.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    JfxRuntime jfxRuntime = (JfxRuntime)iterator.next();
                    System.out.println("  " + ++n + ") " + jfxRuntime.toString());
                }
            }
        }
        return this.fx_runtimes;
    }

    public String getPlatformNativeEncoding() {
        return "UTF-8";
    }

    public JfxRuntime getBestJfxRuntime(VersionID versionID) {
        String string;
        if (DEBUG) {
            System.out.println("Looking for best JavaFX runtime for " + versionID + " ...");
        }
        if ((string = Environment.getenv("FORCED_FX_ROOT")) != null) {
            return JfxRuntime.runtimeForPath(string);
        }
        if (null == versionID) {
            versionID = new VersionID("2.0+");
        }
        JfxRuntime jfxRuntime = null;
        Iterator iterator = this.getInstalledJfxRuntimes().iterator();
        while (iterator.hasNext()) {
            JfxRuntime jfxRuntime2 = (JfxRuntime)iterator.next();
            VersionID versionID2 = jfxRuntime2.getProductVersion();
            if (DEBUG) {
                System.out.println("Test " + jfxRuntime2);
            }
            if (versionID.equals(versionID2)) {
                if (DEBUG) {
                    System.out.println("Perfect match: " + jfxRuntime2);
                }
                return jfxRuntime2;
            }
            if (!versionID.match(versionID2)) continue;
            if (DEBUG) {
                System.out.println("A match: " + jfxRuntime2);
            }
            if (jfxRuntime != null && !jfxRuntime2.getProductVersion().isGreaterThan(jfxRuntime.getProductVersion())) continue;
            jfxRuntime = jfxRuntime2;
            if (!DEBUG) continue;
            System.out.println("A better match: " + jfxRuntime);
        }
        return jfxRuntime;
    }

    public void storeCacheUpgradeInfo(final Properties properties) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Object run() throws IOException {
                    if (properties == null) {
                        File file = new File(Platform.this.getUserHome(), Platform.UPGRADE_FILENAME);
                        if (!file.exists()) return null;
                        file.delete();
                        return null;
                    }
                    OutputStream outputStream = null;
                    try {
                        Properties properties2 = Platform.this.getCacheUpgradeProperties();
                        properties2.putAll((Map<?, ?>)properties);
                        File file = new File(Platform.this.getUserHome(), Platform.UPGRADE_FILENAME);
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        outputStream = new FileOutputStream(file);
                        properties2.store(outputStream, "");
                        Object var5_5 = null;
                        if (outputStream == null) return null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        if (outputStream == null) throw throwable;
                        outputStream.close();
                        throw throwable;
                    }
                    outputStream.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException, true);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
    }

    public Properties getCacheUpgradeInfo(String[] stringArray) {
        Properties properties = this.getCacheUpgradeProperties();
        Properties properties2 = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = properties.getProperty(stringArray[i]);
            if (string == null) continue;
            properties2.put(stringArray[i], string);
        }
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Properties getCacheUpgradeProperties() {
        InputStream inputStream;
        Properties properties;
        block10: {
            properties = new Properties();
            inputStream = null;
            final File file = new File(this.getUserHome(), UPGRADE_FILENAME);
            if (!file.isFile()) break block10;
            inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new FileInputStream(file);
                }
            });
            properties.load(inputStream);
        }
        Object var5_6 = null;
        if (inputStream == null) return properties;
        try {
            inputStream.close();
            return properties;
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
        return properties;
        {
            catch (PrivilegedActionException privilegedActionException) {
                Trace.ignored(privilegedActionException, true);
                Object var5_7 = null;
                if (inputStream == null) return properties;
                try {
                    inputStream.close();
                    return properties;
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                }
                return properties;
            }
            catch (Exception exception) {
                Trace.ignored(exception);
                Object var5_8 = null;
                if (inputStream == null) return properties;
                try {
                    inputStream.close();
                    return properties;
                }
                catch (Exception exception2) {
                    Trace.ignored(exception2);
                }
                return properties;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
            throw throwable;
        }
    }

    public abstract String getLoadedNativeLibPath(String var1);

    public synchronized AutoUpdater getAutoUpdater() {
        if (this.auInstance == null) {
            this.auInstance = new AutoUpdater();
        }
        return this.auInstance;
    }
}

