#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.07';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkII_2',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo7D_2',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::LensInfo',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfoK5',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Samsung::Type1',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::mwg_coll',
	'Image::ExifTool::XMP::mwg_kw',
	'Image::ExifTool::XMP::mwg_rs',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 79 => 0x69 },
	'about' => { 305 => 'about' },
	'abspeakaudiofilepath' => { 311 => 'absPeakAudioFilePath' },
	'accessorytype' => { 225 => 0x53 },
	'actionadvised' => { 93 => 0x2a },
	'activearea' => { 86 => 0xc68d },
	'actived-lighting' => { 161 => 0x22, 189 => 0x24 },
	'actived-lightingmode' => { 189 => 0x25 },
	'addaspectratioinfo' => { 60 => 0x80e },
	'additionalmodelinformation' => { 295 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 60 => 0x80f, 61 => 0x11, 62 => 0x13, 65 => 0x14 },
	'address' => { 119 => 'Address' },
	'adjustmentmode' => { 271 => 0x15 },
	'adultcontentwarning' => { 301 => 'AdultContentWarning', 304 => 'adultContentWarning' },
	'advancedraw' => { 191 => 0x76a43203 },
	'advancedscenemode' => { 225 => 0x3d },
	'advisory' => { 309 => 'Advisory' },
	'ae_iso' => { 228 => 0x2 },
	'aeaperture' => { 228 => 0x1 },
	'aebautocancel' => { 60 => 0x104 },
	'aebbracketvalue' => { 55 => 0x11 },
	'aebsequence' => { 60 => 0x105 },
	'aebsequenceautocancel' => { 58 => 0x9, 59 => 0x9, 61 => 0x8, 62 => 0x9, 65 => 0x9, 66 => 0x7 },
	'aebshotcount' => { 60 => 0x106 },
	'aebxv' => { 228 => 0x4 },
	'aeexposuretime' => { 228 => 0x0 },
	'aelbutton' => { 135 => 0x45 },
	'aelexposureindicator' => { 135 => 0x51 },
	'aelock' => { 135 => 0x5b, 199 => '4.2', 203 => '4.2', 205 => 0x201, 248 => 0x48 },
	'aelockbutton' => { 198 => '16.1', 199 => '4.1', 200 => '15.1', 201 => '30.1', 202 => '16.1', 203 => '4.1', 204 => '17.1' },
	'aelockbuttonplusdials' => { 198 => '16.2', 201 => '32.1' },
	'aelockformb-d80' => { 204 => '3.1' },
	'aemaxaperture' => { 228 => 0x9 },
	'aemaxaperture2' => { 228 => 0xa },
	'aemeteringmode' => { 228 => 0xc },
	'aemeteringsegments' => { 248 => 0x209 },
	'aemicroadjustment' => { 60 => 0x111 },
	'aeminaperture' => { 228 => 0xb },
	'aeminexposuretime' => { 228 => 0x5 },
	'aeprogrammode' => { 228 => 0x6 },
	'aesetting' => { 25 => 0x21 },
	'aexv' => { 228 => 0x3 },
	'af-cpriorityselection' => { 198 => '1.1', 201 => '1.1', 202 => '0.1' },
	'af-onformb-d10' => { 198 => '3.3', 201 => '3.2' },
	'af-onformb-d11' => { 202 => '2.2' },
	'af-spriorityselection' => { 198 => '1.2', 201 => '1.2', 202 => '0.2' },
	'afactivation' => { 198 => '2.1', 201 => '2.1' },
	'afadjustment' => { 248 => 0x72 },
	'afandmeteringbuttons' => { 60 => 0x701 },
	'afaperture' => { 159 => 0x5, 160 => 0x5 },
	'afareaheight' => { 142 => 0x1a },
	'afareaillumination' => { 135 => 0x4b, 203 => '15.3' },
	'afareamode' => { 135 => 0xe, 141 => 0x0, 142 => 0x5, 225 => 0xf, 272 => 0x11, 273 => 0x11 },
	'afareamodesetting' => { 199 => '11.1', 200 => '0.1', 203 => '16.1', 204 => '2.1' },
	'afareas' => { 205 => 0x304 },
	'afareawidth' => { 142 => 0x18 },
	'afareaxposition' => { 142 => 0x14 },
	'afareayposition' => { 142 => 0x16 },
	'afassist' => { 58 => 0x5, 66 => 0x5, 135 => 0x48, 198 => '2.5', 199 => '0.2', 200 => '0.2', 201 => '2.4', 202 => '1.4', 203 => '0.2', 204 => '2.3' },
	'afassistbeam' => { 60 => 0x50e, 61 => 0x4, 62 => 0x5, 63 => 0x4, 64 => 0x4, 65 => 0x5 },
	'afassistlamp' => { 225 => 0x31 },
	'afdefocus' => { 229 => 0x6 },
	'afduringliveview' => { 60 => 0x511 },
	'affinetune' => { 143 => 0x0 },
	'affinetuneadj' => { 143 => 0x2, 169 => 0x2d1, 170 => 0x2dc, 205 => 0x307 },
	'affinetuneindex' => { 143 => 0x1 },
	'afilluminator' => { 272 => 0x29, 277 => 0xb044 },
	'afimageheight' => { 142 => 0x12 },
	'afimagewidth' => { 142 => 0x10 },
	'afintegrationtime' => { 229 => 0x7 },
	'afmicroadjactive' => { 1 => 0x1 },
	'afmicroadjustment' => { 60 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2 },
	'afmode' => { 83 => 0x3009, 271 => 0x5, 277 => 0xb043 },
	'afonaelockbuttonswitch' => { 60 => 0x702 },
	'afonbutton' => { 198 => '3.1' },
	'afpoint' => { 25 => 0x13, 82 => 0x18, 141 => 0x1, 208 => 0x308, 271 => 0x1f },
	'afpointactivationarea' => { 59 => 0x11, 65 => 0x11 },
	'afpointareaexpansion' => { 60 => 0x508 },
	'afpointautoselection' => { 60 => 0x50b },
	'afpointbrightness' => { 60 => 0x50d, 198 => '2.4' },
	'afpointdisplayduringfocus' => { 60 => 0x50c },
	'afpointillumination' => { 59 => 0xa, 198 => '2.3', 201 => '2.3', 202 => '1.3', 204 => '2.4' },
	'afpointmode' => { 233 => 0x3 },
	'afpointposition' => { 83 => 0x2021, 225 => 0x4d },
	'afpointregistration' => { 58 => 0x7 },
	'afpoints' => { 134 => 0x10 },
	'afpointselected' => { 205 => 0x305, 248 => 0xe },
	'afpointselected2' => { 233 => 0x4 },
	'afpointselection' => { 59 => 0xb, 198 => '1.3', 201 => '1.3' },
	'afpointselectionmethod' => { 60 => 0x50f, 61 => 0xc, 62 => 0xd, 65 => 0xd },
	'afpointsinfocus' => { 55 => 0xe, 141 => 0x2, 229 => 0xb, 248 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 15 => 0x38 },
	'afpointspotmetering' => { 59 => 0xd },
	'afpointsunknown1' => { 229 => 0x0 },
	'afpointsunknown2' => { 229 => 0x2 },
	'afpointsused' => { 142 => 0x8 },
	'afpredictor' => { 229 => 0x4 },
	'afresponse' => { 161 => 0xad },
	'afresult' => { 210 => 0x1038 },
	'afsearch' => { 205 => 0x303 },
	'afwithshutter' => { 272 => 0x2a },
	'aggregationtype' => { 302 => 'aggregationType' },
	'agreement' => { 304 => 'agreement' },
	'aiservocontinuousshooting' => { 59 => 0x15 },
	'aiservoimagepriority' => { 60 => 0x503 },
	'aiservotrackingmethod' => { 60 => 0x504 },
	'aiservotrackingsensitivity' => { 59 => 0x14, 60 => 0x502 },
	'album' => { 311 => 'album' },
	'alreadyapplied' => { 289 => 'AlreadyApplied' },
	'alternatetitle' => { 302 => 'alternateTitle' },
	'alttapename' => { 311 => 'altTapeName' },
	'alttimecode' => { 311 => 'altTimecode' },
	'alttimecodetimeformat' => { 311 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 311 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 311 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 2 => 0x1 },
	'ambienttemperature' => { 260 => 0x14 },
	'ambienttemperaturefahrenheit' => { 260 => 0x13 },
	'analogbalance' => { 86 => 0xc627 },
	'angleadj' => { 79 => 0x8b },
	'anti-blur' => { 277 => 0xb04b },
	'antialiasstrength' => { 86 => 0xc632 },
	'aperturerange' => { 60 => 0x10d },
	'apertureringuse' => { 233 => '1.4' },
	'aperturevalue' => { 69 => 0x2, 86 => 0x9202, 210 => 0x1002, 293 => 'ApertureValue' },
	'applekeywords' => { 214 => 'AAPL:Keywords' },
	'applicationnotes' => { 86 => 0x2bc, 227 => 0x2bc },
	'applicationrecordversion' => { 93 => 0x0 },
	'applyshootingmeteringmode' => { 60 => 0x10e },
	'approximatefnumber' => { 220 => 0x313, 226 => 0x3406 },
	'approximatefocusdistance' => { 286 => 'ApproximateFocusDistance' },
	'armidentifier' => { 94 => 0x78 },
	'armversion' => { 94 => 0x7a },
	'artfilter' => { 205 => 0x529 },
	'artist' => { 86 => 0x13b, 216 => 'Artist', 248 => 0x22e, 307 => 'Artist', 311 => 'artist' },
	'artworkcopyrightnotice' => { 295 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcreator' => { 295 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkdatecreated' => { 295 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworkorobject' => { 295 => 'ArtworkOrObject' },
	'artworksource' => { 295 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 295 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworktitle' => { 295 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 209 => 0x1113 },
	'aspectratio' => { 3 => 0x0, 209 => 0x1112, 272 => 0x55 },
	'asshoticcprofile' => { 86 => 0xc68f },
	'asshotneutral' => { 86 => 0xc628 },
	'asshotpreprofilematrix' => { 86 => 0xc690 },
	'asshotprofilename' => { 86 => 0xc6f6 },
	'asshotwhitexy' => { 86 => 0xc629 },
	'assignbktbutton' => { 198 => '4.2' },
	'assignfuncbutton' => { 60 => 0x70b },
	'assistbuttonfunction' => { 58 => 0xd },
	'attributionname' => { 287 => 'attributionName' },
	'attributionurl' => { 287 => 'attributionURL' },
	'audio' => { 225 => 0x20 },
	'audiobitrate' => { 47 => 0x6c },
	'audiochannels' => { 47 => 0x70 },
	'audiochanneltype' => { 311 => 'audioChannelType' },
	'audiocompression' => { 113 => 'Compression' },
	'audiocompressor' => { 311 => 'audioCompressor' },
	'audioduration' => { 93 => 0x99 },
	'audiomoddate' => { 311 => 'audioModDate' },
	'audiooutcue' => { 93 => 0x9a },
	'audiosamplerate' => { 47 => 0x6e, 311 => 'audioSampleRate' },
	'audiosampletype' => { 311 => 'audioSampleType' },
	'audiosamplingrate' => { 93 => 0x97 },
	'audiosamplingresolution' => { 93 => 0x98 },
	'audiotype' => { 93 => 0x96 },
	'author' => { 115 => 'Author', 214 => 'Author', 216 => 'Author', 259 => 'Author', 285 => 'author', 299 => 'Author' },
	'authorsposition' => { 300 => 'AuthorsPosition' },
	'autoaperture' => { 242 => '0.1' },
	'autobracket' => { 271 => 0x19 },
	'autobracketing' => { 90 => 0x1100, 248 => 0x18 },
	'autobracketmodem' => { 198 => '21.2', 201 => '26.2' },
	'autobracketorder' => { 135 => 0x43, 198 => '21.3', 201 => '26.3', 202 => '12.2', 203 => '2.2', 204 => '13.2' },
	'autobracketset' => { 198 => '21.1', 200 => '11.1', 201 => '26.1', 202 => '12.1', 203 => '2.1', 204 => '13.1' },
	'autobrightness' => { 289 => 'AutoBrightness' },
	'autocontrast' => { 289 => 'AutoContrast' },
	'autodistortioncontrol' => { 150 => 0x4 },
	'autodynamicrange' => { 90 => 0x140b },
	'autoexposure' => { 289 => 'AutoExposure' },
	'autoexposurebracketing' => { 55 => 0x10 },
	'autofocus' => { 208 => 0x209 },
	'autofp' => { 203 => '7.3', 204 => '31.4' },
	'autoiso' => { 55 => 0x1, 83 => 0x3008, 199 => '1.1', 203 => '1.1' },
	'autoisomax' => { 199 => '1.2', 203 => '1.2' },
	'autoisominshutterspeed' => { 199 => '1.3', 203 => '1.3' },
	'autolightingoptimizer' => { 12 => 0xbe, 13 => 0xbf, 16 => 0xbf, 43 => 0x2, 60 => 0x204, 79 => 0x6f },
	'autolightingoptimizeron' => { 79 => 0x6e },
	'autoredeye' => { 191 => 0xfe28a44f },
	'autorotate' => { 55 => 0x1b },
	'autoshadows' => { 289 => 'AutoShadows' },
	'auxiliarylens' => { 161 => 0x82 },
	'avaperturesetting' => { 233 => 0x13 },
	'avsettingwithoutlens' => { 60 => 0x707 },
	'azimuth' => { 123 => 'Azimuth' },
	'babyage' => { 225 => [0x8010,0x33] },
	'babyname' => { 225 => 0x66 },
	'backgroundalpha' => { 306 => 'bgalpha' },
	'baseexposurecompensation' => { 233 => 0x15 },
	'baseiso' => { 55 => 0x2, 73 => 0x101c, 226 => 0x312a },
	'baselineexposure' => { 86 => 0xc62a },
	'baselinenoise' => { 86 => 0xc62b },
	'baselinesharpness' => { 86 => 0xc62c },
	'baseurl' => { 309 => 'BaseURL' },
	'batterylevel' => { 135 => 0x60 },
	'batteryorder' => { 198 => '12.5', 201 => '13.2', 202 => '2.1' },
	'batteryvoltage' => { 260 => 0x2a },
	'bayergreensplit' => { 86 => 0xc62d },
	'bayerpattern' => { 97 => 0xf902, 138 => 0x17 },
	'beatspliceparams' => { 311 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 311 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 311 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 311 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 311 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 311 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 198 => '13.1', 199 => '0.1', 200 => '2.1', 201 => '10.1', 203 => '0.1', 204 => '4.1' },
	'beeppitch' => { 202 => '3.1' },
	'beepvolume' => { 202 => '4.5' },
	'bestqualityscale' => { 86 => 0xc65c },
	'bestshotmode' => { 83 => 0x3007 },
	'bitdepth' => { 120 => 'BitDepth', 138 => 0x11, 166 => 0x41 },
	'bitspercomponent' => { 95 => 0x87 },
	'bitspersample' => { 86 => 0x102, 307 => 'BitsPerSample' },
	'blacklevel' => { 86 => 0xc61a, 210 => 0x1012 },
	'blacklevel2' => { 209 => 0x600, 213 => 0x600 },
	'blacklevelrepeatdim' => { 86 => 0xc619 },
	'blackpoint' => { 248 => 0x200 },
	'bleachbypasstoning' => { 248 => 0x7f },
	'bluebalance' => { 149 => 0x271, 210 => 0x1018, 227 => 0x12, 248 => 0x1b },
	'bluecurvelimits' => { 78 => 0x1fe },
	'bluecurvepoints' => { 78 => 0x1d4 },
	'bluehue' => { 289 => 'BlueHue' },
	'bluesaturation' => { 289 => 'BlueSaturation' },
	'blurwarning' => { 90 => 0x1300 },
	'bodybatteryadload' => { 231 => 0x3 },
	'bodybatteryadnoload' => { 231 => 0x2 },
	'bodybatterystate' => { 231 => '1.1' },
	'bodybatteryvoltage1' => { 231 => 0x2 },
	'bodybatteryvoltage2' => { 231 => 0x4 },
	'bodybatteryvoltage3' => { 231 => 0x6 },
	'bodybatteryvoltage4' => { 231 => 0x8 },
	'bodyfirmware' => { 265 => 0x0 },
	'bodyfirmwareversion' => { 206 => 0x104, 207 => 0x100, 210 => 0x104 },
	'bodyserialnumber' => { 265 => 0x10 },
	'bracketmode' => { 39 => 0x3 },
	'bracketsequence' => { 83 => 0x301d },
	'bracketshotnumber' => { 39 => 0x5, 233 => 0x9 },
	'bracketstep' => { 132 => 0xe },
	'bracketvalue' => { 39 => 0x4 },
	'brightness' => { 86 => 0xfe53, 114 => 'Brightness', 132 => 0x2c, 163 => 0x34, 260 => 0x25, 272 => 0x22, 277 => 0x2007, 289 => 'Brightness' },
	'brightnessadj' => { 78 => 0x114, 184 => 0x0, 194 => 0x2d, 280 => 0x8018 },
	'brightnessvalue' => { 86 => 0x9203, 210 => 0x1003, 293 => 'BrightnessValue' },
	'bulbduration' => { 55 => 0x18 },
	'burstmode' => { 100 => 0xa, 225 => 0x2a },
	'burstmode2' => { 100 => 0x18 },
	'burstshot' => { 271 => 0x34 },
	'buttonfunctioncontroloff' => { 60 => 0x70a },
	'bwfilter' => { 132 => 0x2a, 139 => 0x39 },
	'bwmode' => { 210 => 0x203 },
	'by-line' => { 93 => 0x50 },
	'by-linetitle' => { 93 => 0x55 },
	'bytecount' => { 302 => 'byteCount' },
	'calibration' => { 271 => 0x24 },
	'calibrationilluminant1' => { 86 => 0xc65a },
	'calibrationilluminant2' => { 86 => 0xc65b },
	'cameraangle' => { 311 => 'cameraAngle' },
	'cameracalibration1' => { 86 => 0xc623 },
	'cameracalibration2' => { 86 => 0xc624 },
	'cameracalibrationsig' => { 86 => 0xc6f3 },
	'cameracolorcalibration01' => { 27 => 0x0, 33 => 0xba },
	'cameracolorcalibration02' => { 27 => 0x4, 33 => 0xbf },
	'cameracolorcalibration03' => { 27 => 0x8, 33 => 0xc4 },
	'cameracolorcalibration04' => { 27 => 0xc, 33 => 0xc9 },
	'cameracolorcalibration05' => { 27 => 0x10, 33 => 0xce },
	'cameracolorcalibration06' => { 27 => 0x14, 33 => 0xd3 },
	'cameracolorcalibration07' => { 27 => 0x18, 33 => 0xd8 },
	'cameracolorcalibration08' => { 27 => 0x1c, 33 => 0xdd },
	'cameracolorcalibration09' => { 27 => 0x20, 33 => 0xe2 },
	'cameracolorcalibration10' => { 27 => 0x24, 33 => 0xe7 },
	'cameracolorcalibration11' => { 27 => 0x28, 33 => 0xec },
	'cameracolorcalibration12' => { 27 => 0x2c, 33 => 0xf1 },
	'cameracolorcalibration13' => { 27 => 0x30, 33 => 0xf6 },
	'cameracolorcalibration14' => { 27 => 0x34, 33 => 0xfb },
	'cameracolorcalibration15' => { 27 => 0x38, 33 => 0x100 },
	'cameraid' => { 210 => 0x209, 270 => 0x209 },
	'cameraiso' => { 25 => 0x10 },
	'cameralabel' => { 311 => 'cameraLabel' },
	'cameramodel' => { 311 => 'cameraModel' },
	'cameramove' => { 311 => 'cameraMove' },
	'cameraorientation' => { 4 => 0x30, 7 => 0x30, 9 => 0x35, 10 => 0x30, 11 => 0x30, 12 => 0x31, 13 => 0x31, 14 => 0x35, 15 => 0x27, 16 => 0x31, 18 => 0x38, 19 => 0x36, 21 => 0x11, 250 => 0x1 },
	'cameraowner' => { 101 => 0xc353 },
	'cameraparameters' => { 210 => 0x2050 },
	'cameraprofile' => { 289 => 'CameraProfile' },
	'cameraprofiledigest' => { 289 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 86 => 0xc62f, 131 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 205 => 0x0 },
	'cameratemperature' => { 4 => 0x18, 7 => 0x18, 9 => 0x19, 10 => 0x18, 11 => 0x18, 12 => 0x19, 13 => 0x19, 14 => 0x19, 15 => 0x17, 16 => 0x19, 18 => 0x19, 19 => 0x19, 20 => 0x19, 22 => [0x87,0x91], 23 => [0x99,0x9f,0xa4,0xa8,0x105], 24 => [0x64,0x1d2,0x1f7,0x1fa,0x47,0x53,0x5b,0x5c], 55 => 0xc, 220 => 0x320, 226 => 0x3402, 248 => 0x47, 268 => 0x43 },
	'cameratemperature2' => { 251 => 0xc },
	'cameratemperature3' => { 251 => 0xe },
	'cameratemperature4' => { 251 => 0x14 },
	'cameratemperature5' => { 251 => 0x16 },
	'cameratype' => { 55 => 0x1a, 210 => 0x207 },
	'cameratype2' => { 206 => 0x100 },
	'canonexposuremode' => { 25 => 0x14 },
	'canonfiledescription' => { 73 => 0x805 },
	'canonfilelength' => { 44 => 0xe },
	'canonfirmwareversion' => { 44 => 0x7, 73 => 0x80b },
	'canonflashinfo' => { 73 => 0x1028 },
	'canonflashmode' => { 25 => 0x4 },
	'canonimagesize' => { 6 => 0x39, 25 => 0xa },
	'canonimagetype' => { 44 => 0x6, 73 => 0x815 },
	'canonmodelid' => { 44 => 0x10, 73 => 0x1834 },
	'canonvrd' => { 87 => 'CanonVRD' },
	'caption' => { 285 => 'caption' },
	'caption-abstract' => { 93 => 0x78 },
	'captionsauthornames' => { 292 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 292 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 300 => 'CaptionWriter' },
	'captureframerate' => { 83 => 0x4001 },
	'cardshutterlock' => { 135 => 0x49 },
	'casioimagesize' => { 83 => 0x9 },
	'catalogsets' => { 93 => 0xff, 284 => 'CatalogSets' },
	'categories' => { 44 => 0x23, 285 => 'categories' },
	'category' => { 93 => 0xf, 300 => 'Category' },
	'ccdboardversion' => { 220 => 0x331 },
	'ccdscanmode' => { 210 => 0x1039 },
	'ccdsensitivity' => { 181 => 0x6 },
	'ccdversion' => { 220 => 0x330 },
	'cellglobalid' => { 288 => 'cgi' },
	'celllength' => { 86 => 0x109 },
	'cellr' => { 288 => 'r' },
	'celltowerid' => { 288 => 'cellid' },
	'cellwidth' => { 86 => 0x108 },
	'centerafarea' => { 203 => '15.1' },
	'centerfocuspoint' => { 204 => '2.2' },
	'centerweightedareasize' => { 198 => '7.1', 201 => '5.1', 202 => '7.1', 203 => '6.3', 204 => '8.1' },
	'certificate' => { 315 => 'Certificate' },
	'cfapattern' => { 86 => 0xa302, 293 => 'CFAPattern' },
	'cfapatterncolumns' => { 293 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 293 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 293 => [\'CFAPattern','CFAPatternValues'] },
	'channel' => { 302 => 'channel' },
	'channels' => { 113 => 'Channels' },
	'checkmark' => { 78 => 0x26a },
	'checkmark2' => { 79 => 0x8e },
	'childfontfiles' => { 316 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 198 => '10.3' },
	'chromablurradius' => { 86 => 0xc631 },
	'chromaticaberration' => { 79 => 0x66 },
	'chromaticaberrationb' => { 289 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 79 => 0x6b },
	'chromaticaberrationcorrection' => { 241 => 0x1 },
	'chromaticaberrationon' => { 79 => 0x62 },
	'chromaticaberrationr' => { 289 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 79 => 0x6a },
	'chrominancenoisereduction' => { 79 => 0x5e, 271 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 79 => 0x60 },
	'city' => { 93 => 0x5a, 119 => 'City', 225 => 0x6d, 300 => 'City' },
	'clarity' => { 289 => 'Clarity' },
	'classifystate' => { 93 => 0xe1 },
	'client' => { 311 => 'client' },
	'clmodeshootingspeed' => { 198 => '10.2', 201 => '11.2', 202 => '10.2', 204 => '11.1' },
	'cmcontrast' => { 213 => 0x2022 },
	'cmexposurecompensation' => { 213 => 0x2000 },
	'cmhue' => { 213 => 0x2021 },
	'cmsaturation' => { 213 => 0x2020 },
	'cmsharpness' => { 213 => 0x2023 },
	'cmwhitebalance' => { 213 => 0x2001 },
	'cmwhitebalancecomp' => { 213 => 0x2002 },
	'cmwhitebalancegraypoint' => { 213 => 0x2010 },
	'codec' => { 127 => 'Codec' },
	'codedcharacterset' => { 94 => 0x5a },
	'collectionname' => { 296 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 296 => 'Collections' },
	'collectionuri' => { 296 => [\'Collections','CollectionsCollectionURI'] },
	'coloraberrationcontrol' => { 191 => 0xc89224b },
	'coloradjustment' => { 271 => 0x14 },
	'coloradjustmentmode' => { 270 => 0x210 },
	'coloranta' => { 316 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 316 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 316 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 316 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 316 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 316 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 316 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 316 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 316 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 316 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 316 => 'Colorants' },
	'colorantswatchname' => { 316 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttype' => { 316 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 316 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 114 => 'ColorBalance' },
	'colorbalanceadj' => { 191 => 0x76a43202 },
	'colorbalanceblue' => { 132 => 0x1e },
	'colorbalancegreen' => { 132 => 0x1d },
	'colorbalancered' => { 132 => 0x1c },
	'colorblur' => { 79 => 0x65 },
	'colorbooster' => { 191 => 0x5f0e7d23 },
	'colorboostlevel' => { 185 => 0x1 },
	'colorboosttype' => { 185 => 0x0 },
	'colorclass' => { 254 => 0xde },
	'colorcompensationfilter' => { 135 => [0x3a,0x5f], 136 => 0x111, 277 => 0xb022 },
	'colorcontrol' => { 210 => 0x102b },
	'colorcorrection' => { 280 => 0x8015 },
	'colordataversion' => { 31 => 0x0, 32 => 0x0, 34 => 0x0 },
	'coloreffect' => { 225 => 0x28 },
	'colorfilter' => { 82 => 0x17, 83 => 0x3017, 132 => 0x29, 139 => [0x38,0x4d,0x4f], 253 => 0x17 },
	'colorgain' => { 166 => 0x51 },
	'colorhue' => { 161 => 0x8d },
	'colorimetricreference' => { 86 => 0xc6bf },
	'colormatrix' => { 209 => 0x200, 210 => 0x1011, 268 => 0xa030 },
	'colormatrix1' => { 86 => 0xc621 },
	'colormatrix2' => { 86 => 0xc622, 213 => 0x200 },
	'colormatrixa' => { 248 => 0x203 },
	'colormatrixadobergb' => { 268 => 0xa032 },
	'colormatrixb' => { 248 => 0x204 },
	'colormatrixnumber' => { 210 => 0x1019 },
	'colormatrixsrgb' => { 268 => 0xa031 },
	'colormode' => { 83 => 0x3015, 90 => 0x1210, 100 => 0x66, 132 => 0x28, 135 => 0x16, 136 => 0x101, 139 => 0x7, 161 => 0x3, 181 => 0x4, 225 => 0x32, 271 => 0x2c, 277 => 0xb029, 300 => 'ColorMode' },
	'colormoirereduction' => { 192 => 0x15 },
	'colormoirereductionmode' => { 192 => 0x5 },
	'colornoisereduction' => { 280 => 0x8029, 289 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 289 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 192 => 0x18 },
	'colornoisereductionsharpness' => { 192 => 0x1c },
	'colorplanes' => { 89 => 0x2 },
	'colorprofile' => { 132 => 0x33 },
	'colorrepresentation' => { 95 => 0x3c },
	'colorreproduction' => { 277 => 0xb020 },
	'colorsequence' => { 95 => 0x41 },
	'colorspace' => { 35 => 0x3, 44 => 0xb4, 73 => 0x10b4, 86 => 0xa001, 120 => 'ColorSpace', 133 => 0x2f, 134 => 0x25, 135 => 0x17, 161 => 0x1e, 205 => 0x507, 248 => 0x37, 268 => 0xa011, 271 => 0xb, 293 => 'ColorSpace' },
	'colortempasshot' => { 28 => 0x4, 29 => 0x1d, 30 => 0x26, 31 => 0x43, 34 => 0x43 },
	'colortempauto' => { 28 => 0x9, 29 => 0x22, 30 => 0x1c, 31 => 0x48, 34 => 0x48 },
	'colortempcloudy' => { 28 => 0x22, 29 => 0x31, 30 => 0x35, 31 => 0x5c, 34 => 0x75 },
	'colortempcustom' => { 31 => 0x84 },
	'colortempcustom1' => { 29 => 0x45 },
	'colortempcustom2' => { 29 => 0x4a },
	'colortempdaylight' => { 28 => 0x18, 29 => 0x27, 30 => 0x2b, 31 => 0x52, 34 => 0x6b },
	'colortemperature' => { 4 => 0x73, 5 => [0x48,0x4e], 6 => 0x37, 7 => 0x62, 8 => 0x37, 9 => [0x7b,0x7c], 10 => 0x73, 11 => 0x73, 12 => 0x77, 13 => 0x73, 14 => 0x7c, 15 => 0x58, 16 => 0x73, 18 => 0x7f, 19 => 0x7d, 21 => 0x57, 44 => 0xae, 53 => 0x9, 73 => 0x10ae, 90 => 0x1005, 98 => 0x846, 114 => 'ColorTemperature', 133 => [0x6e,0x49], 134 => 0x3f, 135 => [0x39,0x5e], 136 => 0x10b, 139 => [0x3c,0x4c,0x4e], 220 => 0x321, 248 => 0x50, 277 => 0xb021, 289 => 'Temperature' },
	'colortemperatureadj' => { 280 => 0x8013 },
	'colortemperaturebg' => { 210 => 0x1013 },
	'colortemperaturerg' => { 210 => 0x1014 },
	'colortemperaturesetting' => { 135 => 0x25 },
	'colortempflash' => { 28 => 0x36, 29 => 0x40, 30 => 0x49, 31 => 0x70, 34 => 0x89 },
	'colortempflashdata' => { 31 => 0x24a },
	'colortempfluorescent' => { 28 => 0x2c, 29 => 0x3b, 30 => 0x3f, 31 => 0x66, 34 => 0x7f },
	'colortempkelvin' => { 28 => 0x31, 30 => 0x44, 31 => 0x6b, 34 => 0x84 },
	'colortempmeasured' => { 28 => 0xe, 31 => 0x4d, 34 => 0x4d },
	'colortemppc1' => { 30 => 0x94, 31 => 0x75 },
	'colortemppc2' => { 30 => 0x99, 31 => 0x7a },
	'colortemppc3' => { 30 => 0x9e, 31 => 0x7f },
	'colortempshade' => { 28 => 0x1d, 29 => 0x2c, 30 => 0x30, 31 => 0x57, 34 => 0x70 },
	'colortemptungsten' => { 28 => 0x27, 29 => 0x36, 30 => 0x3a, 31 => 0x61, 34 => 0x7a },
	'colortempunknown' => { 28 => 0x13, 30 => 0x21, 34 => 0x52 },
	'colortempunknown10' => { 28 => 0x63, 30 => 0x76, 34 => 0xa2 },
	'colortempunknown11' => { 28 => 0x68, 30 => 0x7b, 34 => 0xa7 },
	'colortempunknown12' => { 28 => 0x6d, 30 => 0x80, 34 => 0xac },
	'colortempunknown13' => { 28 => 0x72, 30 => 0x85, 34 => 0xb1 },
	'colortempunknown14' => { 30 => 0x8a, 34 => 0xb6 },
	'colortempunknown15' => { 30 => 0x8f, 34 => 0xbb },
	'colortempunknown16' => { 30 => 0xa3 },
	'colortempunknown2' => { 28 => 0x3b, 30 => 0x4e, 34 => 0x57 },
	'colortempunknown3' => { 28 => 0x40, 30 => 0x53, 34 => 0x5c },
	'colortempunknown4' => { 28 => 0x45, 30 => 0x58, 34 => 0x61 },
	'colortempunknown5' => { 28 => 0x4a, 30 => 0x5d, 34 => 0x66 },
	'colortempunknown6' => { 28 => 0x4f, 30 => 0x62, 34 => 0x8e },
	'colortempunknown7' => { 28 => 0x54, 30 => 0x67, 34 => 0x93 },
	'colortempunknown8' => { 28 => 0x59, 30 => 0x6c, 34 => 0x98 },
	'colortempunknown9' => { 28 => 0x5e, 30 => 0x71, 34 => 0x9d },
	'colortone' => { 6 => 0x6f, 8 => 0x77, 25 => 0x2a, 35 => 0x2 },
	'colortoneadj' => { 78 => 0x11e },
	'colortonefaithful' => { 15 => 0x107, 49 => 0x6c, 50 => 0x6c },
	'colortonelandscape' => { 15 => 0x105, 49 => 0x3c, 50 => 0x3c },
	'colortonemonochrome' => { 49 => 0x84, 50 => 0x84 },
	'colortoneneutral' => { 15 => 0x106, 49 => 0x54, 50 => 0x54 },
	'colortoneportrait' => { 15 => 0x104, 49 => 0x24, 50 => 0x24 },
	'colortonestandard' => { 15 => 0x103, 49 => 0xc, 50 => 0xc },
	'colortoneunknown' => { 50 => 0x9c },
	'colortoneuserdef1' => { 15 => 0x109, 49 => 0x9c, 50 => 0xb4 },
	'colortoneuserdef2' => { 15 => 0x10a, 49 => 0xb4, 50 => 0xcc },
	'colortoneuserdef3' => { 15 => 0x10b, 49 => 0xcc, 50 => 0xe4 },
	'commanddials' => { 203 => '5.1' },
	'commanddialsaperturesetting' => { 198 => '17.3', 201 => '33.3', 202 => '17.3' },
	'commanddialschangemainsub' => { 198 => '17.2', 201 => '33.2', 202 => '17.2' },
	'commanddialsmenuandplayback' => { 198 => '17.4', 201 => '33.4', 202 => '17.4' },
	'commanddialsreverserotation' => { 198 => '17.1', 200 => '16.2', 201 => '33.1', 202 => '17.1', 204 => '18.1' },
	'commanderchannel' => { 203 => '10.2' },
	'commandergroupa_ttl-aacomp' => { 203 => '13.1' },
	'commandergroupa_ttlcomp' => { 204 => '32.1' },
	'commandergroupamanualoutput' => { 203 => '13.2' },
	'commandergroupamode' => { 203 => '11.2' },
	'commandergroupb_ttl-aacomp' => { 203 => '14.1' },
	'commandergroupb_ttlcomp' => { 204 => '33.1' },
	'commandergroupbmanualoutput' => { 203 => '14.2' },
	'commandergroupbmode' => { 203 => '11.3' },
	'commanderinternalflash' => { 203 => '11.1' },
	'commanderinternalmanualoutput' => { 203 => '12.2' },
	'commanderinternalttlchannel' => { 201 => '18.2' },
	'commanderinternalttlcomp' => { 203 => '12.1', 204 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 201 => '20.1', 202 => '26.1' },
	'commanderinternalttlcompgroupa' => { 201 => '21.1', 202 => '27.1' },
	'commanderinternalttlcompgroupb' => { 201 => '22.1', 202 => '28.1' },
	'comment' => { 0 => 0x2, 87 => 'Comment', 115 => 'Comment', 216 => 'Comment' },
	'complianceprofile' => { 302 => 'complianceProfile' },
	'componentsconfiguration' => { 86 => 0x9101, 120 => 'Components', 293 => 'ComponentsConfiguration' },
	'componentversion' => { 73 => 0x80c },
	'composer' => { 311 => 'composer' },
	'compositionadjust' => { 247 => '0.1' },
	'compositionadjustrotation' => { 247 => 0x7 },
	'compositionadjustx' => { 247 => 0x5 },
	'compositionadjusty' => { 247 => 0x6 },
	'compressedbitsperpixel' => { 86 => 0x9102, 293 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 136 => 0x40, 210 => 0x40 },
	'compression' => { 86 => 0x103, 307 => 'Compression' },
	'compressionfactor' => { 205 => 0x50d },
	'compressionratio' => { 120 => 'Compression', 210 => 0x1034 },
	'constrainedcropheight' => { 78 => 0x266, 254 => 0xd6 },
	'constrainedcropwidth' => { 78 => 0x262, 254 => 0xd5 },
	'contact' => { 93 => 0x76 },
	'contentlocationcode' => { 93 => 0x1a },
	'contentlocationname' => { 93 => 0x1b },
	'continuousbracketing' => { 135 => 0x20 },
	'continuousdrive' => { 25 => 0x5 },
	'continuousshootingspeed' => { 60 => 0x610 },
	'continuousshotlimit' => { 60 => 0x611 },
	'contrast' => { 6 => 0x73, 8 => 0x75, 25 => 0xd, 82 => 0xc, 83 => [0x3012,0x20], 86 => [0xa408,0xfe54], 90 => [0x1004,0x1006], 114 => 'Contrast', 132 => 0x20, 133 => 0x31, 134 => 0x27, 135 => 0x19, 139 => 0x2, 163 => 0x33, 210 => 0x1029, 225 => 0x39, 226 => 0x300a, 248 => 0x20, 253 => 0xc, 260 => 0x24, 271 => 0xd, 272 => 0x1d, 273 => 0x1a, 277 => 0x2004, 289 => 'Contrast', 293 => 'Contrast' },
	'contrastadj' => { 78 => 0x115, 194 => 0x2c, 280 => 0x8017 },
	'contrastdetectaf' => { 142 => 0x4 },
	'contrastdetectafarea' => { 248 => 0x231 },
	'contrastdetectafinfocus' => { 142 => 0x1c },
	'contrastfaithful' => { 15 => 0xec, 49 => 0x60, 50 => 0x60 },
	'contrasthighlight' => { 248 => 0x6d },
	'contrasthighlightshadowadj' => { 248 => 0x6f },
	'contrastlandscape' => { 15 => 0xea, 49 => 0x30, 50 => 0x30 },
	'contrastmode' => { 225 => 0x2c },
	'contrastmonochrome' => { 15 => 0xed, 49 => 0x78, 50 => 0x78 },
	'contrastneutral' => { 15 => 0xeb, 49 => 0x48, 50 => 0x48 },
	'contrastportrait' => { 15 => 0xe9, 49 => 0x18, 50 => 0x18 },
	'contrastsetting' => { 205 => 0x505, 213 => 0x1012 },
	'contrastshadow' => { 248 => 0x6e },
	'contraststandard' => { 15 => 0xe8, 49 => 0x0, 50 => 0x0 },
	'contrastunknown' => { 50 => 0x90 },
	'contrastuserdef1' => { 15 => 0xee, 49 => 0x90, 50 => 0xa8 },
	'contrastuserdef2' => { 15 => 0xef, 49 => 0xa8, 50 => 0xc0 },
	'contrastuserdef3' => { 15 => 0xf0, 49 => 0xc0, 50 => 0xd8 },
	'contributedmedia' => { 311 => 'contributedMedia' },
	'contributedmediaduration' => { 311 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 311 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 311 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 311 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 311 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 311 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 311 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 311 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 311 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 311 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 290 => 'contributor' },
	'contributors' => { 115 => 'Contributors' },
	'controldialset' => { 135 => 0x46 },
	'controlledvocabularyterm' => { 295 => 'CVterm' },
	'controllerboardversion' => { 220 => 0x332 },
	'controlmode' => { 55 => 0x12 },
	'conversionlens' => { 225 => 0x35 },
	'converter' => { 86 => 0xfe4d, 181 => 0xb, 289 => 'Converter' },
	'converttograyscale' => { 289 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 86 => 0x8298, 115 => 'Copyright', 216 => 'Copyright', 248 => 0x22f, 259 => 'Copyright', 299 => 'Copyright', 302 => 'copyright', 304 => 'copyright', 307 => 'Copyright', 311 => 'copyright' },
	'copyrightflag' => { 257 => 0x40a },
	'copyrightnotice' => { 93 => 0x74 },
	'copyrightowner' => { 301 => 'CopyrightOwner' },
	'copyrightownerid' => { 301 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 301 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 301 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 301 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 301 => 'CopyrightStatus' },
	'coringfilter' => { 209 => 0x310, 210 => 0x102d, 213 => 0x310 },
	'coringvalues' => { 209 => 0x311, 213 => 0x311 },
	'corporateentity' => { 302 => 'corporateEntity' },
	'country' => { 119 => 'Country', 225 => 0x69, 300 => 'Country' },
	'country-primarylocationcode' => { 93 => 0x64 },
	'country-primarylocationname' => { 93 => 0x65 },
	'countrycode' => { 255 => 'CountryCode', 294 => 'CountryCode' },
	'coverage' => { 290 => 'coverage' },
	'coverdate' => { 302 => 'coverDate' },
	'coverdisplaydate' => { 302 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 248 => 0x28 },
	'crc32' => { 291 => 'crc32' },
	'createdate' => { 86 => 0x9004, 115 => 'CreateDate', 214 => 'CreationDate', 216 => 'create-date', 259 => 'CreationDate', 309 => 'CreateDate' },
	'creationdate' => { 299 => 'CreationDate', 302 => 'creationDate' },
	'creationtime' => { 216 => 'Creation Time' },
	'creativestyle' => { 272 => 0x1a, 273 => 0x18 },
	'creativestylewaschanged' => { 280 => 0x8001 },
	'creator' => { 214 => 'Creator', 259 => 'Creator', 290 => 'creator', 299 => 'Creator' },
	'creatoraddress' => { 294 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorcity' => { 294 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 294 => 'CreatorContactInfo' },
	'creatorcountry' => { 294 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatorpostalcode' => { 294 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 294 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 309 => 'CreatorTool' },
	'creatorworkemail' => { 294 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 294 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 294 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 93 => 0x6e, 300 => 'Credit' },
	'creditline' => { 304 => 'creditLine' },
	'creditlinereq' => { 314 => 'CreditLineReq' },
	'creditlinerequired' => { 301 => 'CreditLineRequired' },
	'cropactive' => { 78 => 0x244 },
	'cropangle' => { 289 => 'CropAngle' },
	'cropaspectratio' => { 78 => 0x260 },
	'cropbottom' => { 89 => 0x9, 186 => 0x36, 254 => 0xdc, 289 => 'CropBottom' },
	'cropbottommargin' => { 36 => 0x3 },
	'cropconstraintowarp' => { 289 => 'CropConstrainToWarp' },
	'cropheight' => { 78 => 0x24c, 209 => 0x615, 213 => 0x615, 289 => 'CropHeight' },
	'crophispeed' => { 161 => 0x1b },
	'cropleft' => { 78 => 0x246, 89 => 0x6, 186 => 0x1e, 209 => 0x612, 213 => 0x612, 254 => 0xd9, 289 => 'CropLeft' },
	'cropleftmargin' => { 36 => 0x0 },
	'cropoutputheight' => { 186 => 0xce },
	'cropoutputheightinches' => { 186 => 0x96 },
	'cropoutputpixels' => { 186 => 0xd6 },
	'cropoutputresolution' => { 186 => 0xb6 },
	'cropoutputscale' => { 186 => 0xbe },
	'cropoutputwidth' => { 186 => 0xc6 },
	'cropoutputwidthinches' => { 186 => 0x8e },
	'croppedimageheight' => { 3 => 0x2 },
	'croppedimagewidth' => { 3 => 0x1 },
	'cropright' => { 89 => 0x8, 186 => 0x2e, 254 => 0xdb, 289 => 'CropRight' },
	'croprightmargin' => { 36 => 0x1 },
	'croprotation' => { 89 => 0xb },
	'cropscaledresolution' => { 186 => 0x9e },
	'cropsourceresolution' => { 186 => 0xae },
	'croptop' => { 78 => 0x248, 89 => 0x7, 186 => 0x26, 209 => 0x613, 213 => 0x613, 254 => 0xda, 289 => 'CropTop' },
	'croptopmargin' => { 36 => 0x2 },
	'cropunit' => { 289 => 'CropUnit' },
	'cropunits' => { 289 => 'CropUnits' },
	'cropwidth' => { 78 => 0x24a, 209 => 0x614, 213 => 0x614, 289 => 'CropWidth' },
	'crossprocess' => { 248 => 0x7b },
	'crossprocessparams' => { 248 => 0x235 },
	'currenticcprofile' => { 86 => 0xc691 },
	'currentpreprofilematrix' => { 86 => 0xc692 },
	'currentversion' => { 280 => 0xd000 },
	'curves' => { 191 => 0x76a43201 },
	'custom1' => { 301 => 'Custom1' },
	'custom10' => { 301 => 'Custom10' },
	'custom2' => { 301 => 'Custom2' },
	'custom3' => { 301 => 'Custom3' },
	'custom4' => { 301 => 'Custom4' },
	'custom5' => { 301 => 'Custom5' },
	'custom6' => { 301 => 'Custom6' },
	'custom7' => { 301 => 'Custom7' },
	'custom8' => { 301 => 'Custom8' },
	'custom9' => { 301 => 'Custom9' },
	'customcontrast' => { 79 => 0x4e },
	'customcontrols' => { 60 => 0x70c },
	'customlinear' => { 79 => 0x4f },
	'customoutputhighlightpoint' => { 79 => 0x53 },
	'customoutputshadowpoint' => { 79 => 0x54 },
	'custompicturestylefilename' => { 44 => 0x4010 },
	'customrawhighlight' => { 79 => 0x7c },
	'customrawhighlightpoint' => { 79 => 0x51 },
	'customrawshadow' => { 79 => 0x85 },
	'customrawshadowpoint' => { 79 => 0x52 },
	'customrendered' => { 86 => 0xa401, 293 => 'CustomRendered' },
	'customsaturation' => { 205 => 0x503 },
	'customsettingsalldefault' => { 198 => '0.2', 201 => '0.2' },
	'customsettingsbank' => { 198 => '0.1', 201 => '0.1' },
	'customsharpness' => { 79 => 0x50 },
	'customwbbluelevel' => { 135 => 0x36 },
	'customwberror' => { 135 => 0x37 },
	'customwbgreenlevel' => { 135 => 0x35 },
	'customwbredlevel' => { 135 => 0x34 },
	'customwbsetting' => { 135 => 0x26 },
	'd-lightinghq' => { 191 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 187 => 0x2 },
	'd-lightinghqhighlight' => { 187 => 0x1 },
	'd-lightinghqselected' => { 191 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 187 => 0x0 },
	'd-lightinghs' => { 191 => 0xce5554aa },
	'd-lightinghsadjustment' => { 188 => 0x0 },
	'd-lightinghscolorboost' => { 188 => 0x1 },
	'd-rangeoptimizerhighlight' => { 280 => 0x8024 },
	'd-rangeoptimizermode' => { 280 => 0x8022 },
	'd-rangeoptimizershadow' => { 280 => 0x802d },
	'd-rangeoptimizervalue' => { 280 => 0x8023 },
	'datacompressionmethod' => { 95 => 0x6e },
	'dataimprint' => { 132 => 0x34 },
	'date' => { 248 => 0x6, 290 => 'date' },
	'dateacquired' => { 131 => 'DateAcquired' },
	'datecreated' => { 93 => 0x37, 300 => 'DateCreated' },
	'datedisplayformat' => { 183 => 0x3 },
	'dateimprint' => { 200 => '4.2' },
	'daterecieved' => { 302 => 'dateRecieved' },
	'datesent' => { 94 => 0x46 },
	'datestampmode' => { 44 => 0x1c },
	'datetime' => { 285 => 'datetime', 307 => 'DateTime' },
	'datetimedigitized' => { 293 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 76 => 0x0, 86 => 0x9003, 112 => 0x14, 115 => 'OriginalDate', 260 => 0xb, 293 => 'DateTimeOriginal' },
	'datetimestamp' => { 100 => 0x64 },
	'daylightsavings' => { 183 => 0x2 },
	'declination' => { 123 => 'Declination' },
	'decposition' => { 132 => 0x32 },
	'defaultcroporigin' => { 86 => 0xc61f },
	'defaultcropsize' => { 86 => 0xc620 },
	'defaultscale' => { 86 => 0xc61e },
	'defringe' => { 289 => 'Defringe' },
	'deletedimagecount' => { 161 => 0xa6, 167 => 0x6e },
	'derivedfrom' => { 312 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 312 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 312 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 312 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 312 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 312 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 312 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 312 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 312 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 312 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 312 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 312 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 312 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 312 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 312 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 312 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 312 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 312 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 216 => 'Description', 290 => 'description' },
	'destination' => { 94 => 0x5 },
	'destinationcity' => { 248 => 0x24, 252 => 0x3 },
	'destinationcitycode' => { 253 => 0x1001 },
	'destinationdst' => { 248 => 0x26, 252 => '0.3' },
	'developmentdynamicrange' => { 90 => 0x1403 },
	'devicesettingdescription' => { 293 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 293 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 293 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 293 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'dialdirectiontvav' => { 60 => 0x706 },
	'digitalcreationdate' => { 93 => 0x3e },
	'digitalcreationtime' => { 93 => 0x3f },
	'digitaldeehighlightadj' => { 166 => 0x202 },
	'digitaldeeshadowadj' => { 166 => 0x200 },
	'digitaldeethreshold' => { 166 => 0x201 },
	'digitalfilter01' => { 239 => 0x5 },
	'digitalfilter02' => { 239 => 0x16 },
	'digitalfilter03' => { 239 => 0x27 },
	'digitalfilter04' => { 239 => 0x38 },
	'digitalfilter05' => { 239 => 0x49 },
	'digitalfilter06' => { 239 => 0x5a },
	'digitalfilter07' => { 239 => 0x6b },
	'digitalfilter08' => { 239 => 0x7c },
	'digitalfilter09' => { 239 => 0x8d },
	'digitalfilter10' => { 239 => 0x9e },
	'digitalfilter11' => { 239 => 0xaf },
	'digitalfilter12' => { 239 => 0xc0 },
	'digitalfilter13' => { 239 => 0xd1 },
	'digitalfilter14' => { 239 => 0xe2 },
	'digitalfilter15' => { 239 => 0xf3 },
	'digitalfilter16' => { 239 => 0x104 },
	'digitalfilter17' => { 239 => 0x115 },
	'digitalfilter18' => { 239 => 0x126 },
	'digitalfilter19' => { 239 => 0x137 },
	'digitalfilter20' => { 239 => 0x148 },
	'digitalgain' => { 53 => 0xb },
	'digitalgem' => { 156 => 0x0 },
	'digitalice' => { 166 => 0x100 },
	'digitalimageguid' => { 295 => 'DigImageGUID' },
	'digitalroc' => { 165 => 0x0 },
	'digitalsourcefiletype' => { 295 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 295 => 'DigitalSourceType' },
	'digitalzoom' => { 25 => 0xc, 82 => 0xa, 100 => 0x68, 114 => 'DigitalZoom', 132 => 0xc, 161 => 0x86, 181 => 0xa, 210 => 0x204, 248 => 0x1e, 253 => 0xa, 270 => 0x204 },
	'digitalzoomon' => { 270 => 0x21b },
	'digitalzoomratio' => { 86 => 0xa404, 293 => 'DigitalZoomRatio' },
	'director' => { 311 => 'director' },
	'directorphotography' => { 311 => 'directorPhotography' },
	'directory' => { 87 => 'Directory' },
	'directoryindex' => { 4 => 0x137, 7 => 0x17e, 9 => [0x233,0x238], 10 => 0x13f, 11 => 0x133, 12 => 0x1df, 13 => [0x1a3,0x1a7], 14 => 0x1f0, 17 => 0x49, 18 => 0x1e7, 19 => 0x1e5, 21 => 0x1d3 },
	'directorynumber' => { 152 => 0x6 },
	'disclaimer' => { 216 => 'Disclaimer' },
	'displayallafpoints' => { 60 => 0x514 },
	'displayaperture' => { 25 => 0x23 },
	'displayedunitsx' => { 258 => 0x2 },
	'displayedunitsy' => { 258 => 0x6 },
	'distance1' => { 100 => 0x28 },
	'distance2' => { 100 => 0x2c },
	'distance3' => { 100 => 0x30 },
	'distance4' => { 100 => 0x34 },
	'distortioncontrol' => { 167 => 0x10 },
	'distortioncorrection' => { 79 => 0x67, 205 => 0x50b, 241 => 0x0 },
	'distortioncorrection2' => { 209 => 0x1011 },
	'distortioncorrectionon' => { 79 => 0x63 },
	'distributor' => { 302 => 'distributor' },
	'dmcomment' => { 311 => 'comment' },
	'dngbackwardversion' => { 86 => 0xc613 },
	'dnglensinfo' => { 86 => 0xc630 },
	'dngversion' => { 86 => 0xc612 },
	'document' => { 216 => 'Document' },
	'documentancestorid' => { 300 => [\'DocumentAncestors','DocumentAncestorsAncestorID'] },
	'documentancestors' => { 300 => 'DocumentAncestors' },
	'documenthistory' => { 93 => 0xe7 },
	'documentid' => { 312 => 'DocumentID' },
	'documentname' => { 86 => 0x10d },
	'documentnotes' => { 93 => 0xe6 },
	'doi' => { 302 => 'doi' },
	'dotrange' => { 86 => 0x150 },
	'drivemode' => { 83 => 0x3103, 132 => 0x6, 135 => 0x1e, 205 => 0x600, 248 => 0x34, 271 => 0x3, 272 => 0x4 },
	'drivemode2' => { 135 => 0xa, 233 => 0x7 },
	'dspfirmwareversion' => { 248 => 0x27 },
	'duration' => { 47 => 0x6a, 113 => 'Duration', 127 => 'Duration', 311 => 'duration' },
	'durationscale' => { 311 => [\'duration','durationScale'] },
	'durationvalue' => { 311 => [\'duration','durationValue'] },
	'dustremovaldata' => { 44 => 0x97 },
	'dynamicafarea' => { 198 => '1.4', 201 => '1.4' },
	'dynamicrange' => { 90 => 0x1400 },
	'dynamicrangeexpansion' => { 248 => 0x69 },
	'dynamicrangemax' => { 78 => 0x7c },
	'dynamicrangemin' => { 78 => 0x7a },
	'dynamicrangeoptimizer' => { 135 => 0x15, 277 => [0xb025,0xb04f] },
	'dynamicrangeoptimizerlevel' => { 272 => 0x19, 273 => 0x17 },
	'dynamicrangeoptimizermode' => { 272 => 0x18, 273 => 0x16 },
	'dynamicrangeoptimizersetting' => { 135 => 0x27 },
	'dynamicrangesetting' => { 90 => 0x1402 },
	'e-dialinprogram' => { 233 => '1.3' },
	'easyexposurecomp' => { 204 => '6.1' },
	'easyexposurecompensation' => { 198 => '6.4', 201 => '4.4', 202 => '5.2' },
	'easymode' => { 25 => 0xb },
	'edgenoisereduction' => { 192 => 0x4, 280 => 0x8028 },
	'edition' => { 302 => 'edition' },
	'editorialupdate' => { 93 => 0x8 },
	'editstatus' => { 93 => 0x7, 255 => 'EditStatus' },
	'editversionname' => { 191 => 0x3d136244 },
	'effectivelv' => { 248 => 0x2d },
	'effectivemaxaperture' => { 159 => 0x12, 160 => 0x13 },
	'eissn' => { 302 => 'eIssn' },
	'elevation' => { 123 => 'Elevation' },
	'email' => { 115 => 'EMail' },
	'embargodate' => { 302 => 'embargoDate', 304 => 'embargoDate' },
	'encryptionkey' => { 268 => 0xa020 },
	'endingpage' => { 302 => 'endingPage' },
	'enduser' => { 301 => 'EndUser' },
	'enduserid' => { 301 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 301 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 311 => 'engineer' },
	'enhancedarktones' => { 184 => 0x8 },
	'enhancement' => { 82 => 0x16, 83 => 0x3016 },
	'enhancer' => { 209 => 0x300 },
	'enhancervalues' => { 209 => 0x301 },
	'envelopenumber' => { 94 => 0x28 },
	'envelopepriority' => { 94 => 0x3c },
	'enveloperecordversion' => { 94 => 0x0 },
	'epsonimageheight' => { 210 => 0x20c },
	'epsonimagewidth' => { 210 => 0x20b },
	'epsonsoftware' => { 210 => 0x20d },
	'equipmentinstitution' => { 282 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 282 => 'EquipmentManufacturer' },
	'equipmentversion' => { 206 => 0x0 },
	'ettlii' => { 60 => 0x304, 61 => 0xd, 62 => 0xe, 63 => 0x7, 64 => 0x7, 65 => 0xe },
	'event' => { 284 => 'Event', 295 => 'Event', 302 => 'event' },
	'eventnumber' => { 260 => 0x9 },
	'evsteps' => { 233 => '1.2', 235 => 0x0 },
	'evstepsize' => { 200 => '5.1', 203 => '0.7' },
	'exclusivityenddate' => { 304 => 'exclusivityEndDate' },
	'excursiontolerance' => { 95 => 0x82 },
	'exif' => { 87 => 'EXIF' },
	'exifbyteorder' => { 87 => 'ExifByteOrder' },
	'exifcamerainfo' => { 93 => 0xe8 },
	'exifimageheight' => { 86 => 0xa003, 293 => 'PixelYDimension' },
	'exifimagewidth' => { 86 => 0xa002, 293 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 87 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 86 => 0x9000, 293 => 'ExifVersion' },
	'exitpupilposition' => { 159 => 0x4, 160 => 0x4 },
	'expirationdate' => { 93 => 0x25, 302 => 'expirationDate', 304 => 'expirationDate' },
	'expirationtime' => { 93 => 0x26 },
	'exposure' => { 86 => 0xfe51, 289 => 'Exposure' },
	'exposureadj' => { 189 => 0x0 },
	'exposureadj2' => { 189 => 0x12 },
	'exposureadjust' => { 271 => 0xc },
	'exposurebracketingindicatorlast' => { 135 => 0x52 },
	'exposurebracketstepsize' => { 233 => 0x8 },
	'exposurebracketvalue' => { 161 => 0x19 },
	'exposurecompensation' => { 55 => 0x6, 69 => 0x0, 86 => 0x9204, 100 => 0x24, 114 => 'ExposureComp', 132 => 0xd, 133 => 0x53, 134 => 0x1e, 210 => 0x1006, 248 => 0x16, 268 => 0xa013, 271 => [0xc,0x35], 293 => 'ExposureBiasValue' },
	'exposurecompensationmode' => { 135 => 0x47 },
	'exposurecompensationsetting' => { 135 => 0x1 },
	'exposurecompstepsize' => { 198 => '6.3', 201 => '4.3' },
	'exposurecontrolstep' => { 202 => '6.1' },
	'exposurecontrolstepsize' => { 198 => '6.2', 201 => '4.2', 204 => '7.1' },
	'exposuredelaymode' => { 198 => '10.1', 200 => '9.1', 201 => '10.4', 202 => '10.1', 203 => '6.4', 204 => '11.2' },
	'exposuredifference' => { 161 => 0xe },
	'exposureindex' => { 86 => 0xa215, 293 => 'ExposureIndex' },
	'exposureindicator' => { 135 => 0x50 },
	'exposurelevelincrements' => { 58 => 0x6, 59 => 0x6, 60 => 0x101, 61 => 0x5, 62 => 0x6, 63 => 0x5, 64 => 0x5, 65 => 0x6, 66 => 0x4, 272 => 0x58 },
	'exposuremode' => { 86 => 0xa402, 114 => 'ExposureMode', 132 => 0x1, 133 => 0xa, 134 => 0x0, 135 => 0x0, 205 => 0x200, 222 => 0x40d, 271 => 0x8, 277 => 0xb041, 293 => 'ExposureMode' },
	'exposuremodeinmanual' => { 60 => 0x10b },
	'exposureprogram' => { 86 => 0x8822, 272 => 0x3c, 273 => 0x3c, 293 => 'ExposureProgram' },
	'exposureshift' => { 205 => 0x203 },
	'exposuretime' => { 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 22 => 0x6, 23 => 0x7, 55 => 0x16, 86 => 0x829a, 97 => 0xfd05, 100 => 0x20, 102 => 0xfa24, 104 => 0xf104, 107 => 0x12, 109 => 0x38, 112 => 0x10, 114 => 'ExposureTime', 132 => 0x9, 133 => 0x35, 134 => 0x48, 135 => 0x8, 248 => 0x12, 268 => 0xa018, 271 => 0x32, 293 => 'ExposureTime' },
	'exposuretime2' => { 271 => 0x33 },
	'exposuretuning' => { 161 => 0x1c },
	'exposurevalue' => { 98 => 0x3 },
	'exposurewarning' => { 90 => 0x1302 },
	'exrauto' => { 90 => 0x1033 },
	'exrmode' => { 90 => 0x1034 },
	'extendedwbdetect' => { 205 => 0x902 },
	'extender' => { 206 => 0x301 },
	'extenderfirmwareversion' => { 206 => 0x304 },
	'extendermagnification' => { 116 => 'Magnification' },
	'extendermake' => { 116 => 'Make' },
	'extendermodel' => { 116 => 'Model', 206 => 0x303 },
	'extenderserialnumber' => { 116 => 'SerialNumber', 206 => 0x302 },
	'externalflash' => { 208 => 0x1201 },
	'externalflashae1' => { 210 => 0x101f },
	'externalflashae1_0' => { 210 => 0x101b },
	'externalflashae2' => { 210 => 0x1020 },
	'externalflashae2_0' => { 210 => 0x101c },
	'externalflashbounce' => { 208 => 0x1204, 210 => 0x1026, 240 => 0x1a },
	'externalflashexposurecomp' => { 161 => 0x17, 240 => 0x19 },
	'externalflashfirmware' => { 153 => 0x6, 154 => 0x6, 155 => 0x6 },
	'externalflashflags' => { 153 => 0x8, 154 => 0x8, 155 => 0x8 },
	'externalflashguidenumber' => { 208 => 0x1203, 240 => '24.1' },
	'externalflashgvalue' => { 210 => 0x1025 },
	'externalflashmode' => { 210 => 0x1028, 240 => 0x2 },
	'externalflashzoom' => { 208 => 0x1205, 210 => 0x1027 },
	'externalsensorbrightnessvalue' => { 220 => 0x311, 226 => 0x3408 },
	'eyestartaf' => { 135 => 0x40 },
	'face10position' => { 80 => 0x3f4, 81 => 0x1ec, 151 => 0x28, 237 => 0x12 },
	'face10size' => { 238 => 0x12 },
	'face11position' => { 151 => 0x2c, 237 => 0x14 },
	'face11size' => { 238 => 0x14 },
	'face12position' => { 151 => 0x30, 237 => 0x16 },
	'face12size' => { 238 => 0x16 },
	'face13position' => { 237 => 0x18 },
	'face13size' => { 238 => 0x18 },
	'face14position' => { 237 => 0x1a },
	'face14size' => { 238 => 0x1a },
	'face15position' => { 237 => 0x1c },
	'face15size' => { 238 => 0x1c },
	'face16position' => { 237 => 0x1e },
	'face16size' => { 238 => 0x1e },
	'face17position' => { 237 => 0x20 },
	'face17size' => { 238 => 0x20 },
	'face18position' => { 237 => 0x22 },
	'face18size' => { 238 => 0x22 },
	'face19position' => { 237 => 0x24 },
	'face19size' => { 238 => 0x24 },
	'face1position' => { 37 => 0x8, 80 => 0xd, 81 => 0x18, 151 => 0x4, 218 => 0x1, 237 => 0x0, 261 => 0xbc, 275 => 0x0, 276 => 0x0 },
	'face1size' => { 238 => 0x0 },
	'face20position' => { 237 => 0x26 },
	'face20size' => { 238 => 0x26 },
	'face21position' => { 237 => 0x28 },
	'face21size' => { 238 => 0x28 },
	'face22position' => { 237 => 0x2a },
	'face22size' => { 238 => 0x2a },
	'face23position' => { 237 => 0x2c },
	'face23size' => { 238 => 0x2c },
	'face24position' => { 237 => 0x2e },
	'face24size' => { 238 => 0x2e },
	'face25position' => { 237 => 0x30 },
	'face25size' => { 238 => 0x30 },
	'face26position' => { 237 => 0x32 },
	'face26size' => { 238 => 0x32 },
	'face27position' => { 237 => 0x34 },
	'face27size' => { 238 => 0x34 },
	'face28position' => { 237 => 0x36 },
	'face28size' => { 238 => 0x36 },
	'face29position' => { 237 => 0x38 },
	'face29size' => { 238 => 0x38 },
	'face2position' => { 37 => 0xa, 80 => 0x7c, 81 => 0x4c, 151 => 0x8, 218 => 0x5, 237 => 0x2, 261 => 0xc8, 275 => 0x20, 276 => 0x25 },
	'face2size' => { 238 => 0x2 },
	'face30position' => { 237 => 0x3a },
	'face30size' => { 238 => 0x3a },
	'face31position' => { 237 => 0x3c },
	'face31size' => { 238 => 0x3c },
	'face32position' => { 237 => 0x3e },
	'face32size' => { 238 => 0x3e },
	'face3position' => { 37 => 0xc, 80 => 0xeb, 81 => 0x80, 151 => 0xc, 218 => 0x9, 237 => 0x4, 261 => 0xd4, 275 => 0x40, 276 => 0x4a },
	'face3size' => { 238 => 0x4 },
	'face4position' => { 37 => 0xe, 80 => 0x15a, 81 => 0xb4, 151 => 0x10, 218 => 0xd, 237 => 0x6, 261 => 0xe0, 275 => 0x60, 276 => 0x6f },
	'face4size' => { 238 => 0x6 },
	'face5position' => { 37 => 0x10, 80 => 0x1c9, 81 => 0xe8, 151 => 0x14, 218 => 0x11, 237 => 0x8, 261 => 0xec, 275 => 0x80, 276 => 0x94 },
	'face5size' => { 238 => 0x8 },
	'face6position' => { 37 => 0x12, 80 => 0x238, 81 => 0x11c, 151 => 0x18, 237 => 0xa, 261 => 0xf8, 275 => 0xa0, 276 => 0xb9 },
	'face6size' => { 238 => 0xa },
	'face7position' => { 37 => 0x14, 80 => 0x2a7, 81 => 0x150, 151 => 0x1c, 237 => 0xc, 261 => 0x104, 275 => 0xc0, 276 => 0xde },
	'face7size' => { 238 => 0xc },
	'face8position' => { 37 => 0x16, 80 => 0x316, 81 => 0x184, 151 => 0x20, 237 => 0xe, 261 => 0x110, 275 => 0xe0, 276 => 0x103 },
	'face8size' => { 238 => 0xe },
	'face9position' => { 37 => 0x18, 80 => 0x385, 81 => 0x1b8, 151 => 0x24, 237 => 0x10 },
	'face9size' => { 238 => 0x10 },
	'facedetect' => { 248 => 0x76 },
	'facedetectarea' => { 209 => 0x1201 },
	'facedetectframecrop' => { 209 => 0x1207 },
	'facedetectframesize' => { 37 => 0x3, 80 => 0x1, 81 => 0x4, 151 => 0x1, 209 => 0x1203, 248 => 0x77, 261 => 0xb6 },
	'faceinfounknown' => { 83 => 0x2089 },
	'faceorientation' => { 81 => 0x8 },
	'faceposition' => { 236 => 0x2, 269 => 0x4 },
	'facepositions' => { 90 => 0x4103 },
	'facesdetected' => { 37 => 0x2, 38 => 0x2, 80 => 0x0, 81 => 0x2, 83 => 0x211c, 90 => 0x4100, 151 => 0x3, 209 => 0x1200, 225 => 0x3f, 236 => 0x0, 261 => 0xb5, 269 => 0x0, 279 => 0x30 },
	'facesrecognized' => { 219 => 0x0 },
	'facewidth' => { 38 => 0x1 },
	'faithfuloutputhighlightpoint' => { 79 => 0x38 },
	'faithfuloutputshadowpoint' => { 79 => 0x39 },
	'faithfulrawcolortone' => { 79 => 0x31 },
	'faithfulrawcontrast' => { 79 => 0x33 },
	'faithfulrawhighlight' => { 79 => 0x79 },
	'faithfulrawhighlightpoint' => { 79 => 0x36 },
	'faithfulrawlinear' => { 79 => 0x34 },
	'faithfulrawsaturation' => { 79 => 0x32 },
	'faithfulrawshadow' => { 79 => 0x82 },
	'faithfulrawshadowpoint' => { 79 => 0x37 },
	'faithfulrawsharpness' => { 79 => 0x35 },
	'femicroadjustment' => { 60 => 0x110 },
	'ffid' => { 291 => 'ffid' },
	'fieldcount' => { 210 => 0x103f },
	'filedatarate' => { 311 => 'fileDataRate' },
	'fileformat' => { 71 => 0x0, 94 => 0x14, 271 => 0x22, 277 => 0xb000 },
	'fileindex' => { 4 => 0x143, 7 => 0x172, 9 => [0x227,0x22c], 10 => 0x133, 11 => 0x13f, 12 => 0x1d3, 13 => [0x197,0x19b], 14 => 0x1e4, 17 => 0x3d, 18 => 0x1db, 19 => 0x1d9, 21 => 0x1c7 },
	'filemodifydate' => { 87 => 'FileModifyDate' },
	'filename' => { 87 => 'FileName' },
	'filenameasdelivered' => { 301 => 'FileNameAsDelivered' },
	'filenumber' => { 39 => 0x1, 44 => 0x8, 73 => 0x1817, 84 => 'FileNumber', 152 => 0x8 },
	'filenumbermemory' => { 132 => 0x1a },
	'filenumbersequence' => { 198 => '12.2', 200 => '3.1', 201 => '11.1', 202 => '4.3', 204 => '5.2' },
	'filesource' => { 86 => 0xa300, 90 => 0x8000, 293 => 'FileSource' },
	'fileversion' => { 94 => 0x16 },
	'fillflashautoreduction' => { 58 => 0xe, 59 => 0xe, 66 => 0xa },
	'filllight' => { 289 => 'FillLight' },
	'fillorder' => { 86 => 0x10a },
	'filmmode' => { 90 => 0x1401, 222 => 0x412, 225 => 0x42 },
	'filmtype' => { 166 => 0x2 },
	'filtereffect' => { 39 => 0xe, 163 => 0x37 },
	'filtereffectfaithful' => { 49 => 0x70, 50 => 0x70 },
	'filtereffectlandscape' => { 49 => 0x40, 50 => 0x40 },
	'filtereffectmonochrome' => { 15 => 0xff, 49 => 0x88, 50 => 0x88 },
	'filtereffectneutral' => { 49 => 0x58, 50 => 0x58 },
	'filtereffectportrait' => { 49 => 0x28, 50 => 0x28 },
	'filtereffectstandard' => { 49 => 0x10, 50 => 0x10 },
	'filtereffectunknown' => { 50 => 0xa0 },
	'filtereffectuserdef1' => { 49 => 0xa0, 50 => 0xb8 },
	'filtereffectuserdef2' => { 49 => 0xb8, 50 => 0xd0 },
	'filtereffectuserdef3' => { 49 => 0xd0, 50 => 0xe8 },
	'finderdisplayduringexposure' => { 59 => 0x1 },
	'finesharpness' => { 248 => 0x70 },
	'finetuneoptcenterweighted' => { 198 => '7.2', 204 => '9.1' },
	'finetuneoptmatrixmetering' => { 198 => '8.1', 201 => '6.1', 204 => '8.2' },
	'finetuneoptspotmetering' => { 198 => '8.2', 201 => '6.2', 204 => '9.2' },
	'firmware' => { 210 => 0x405, 271 => [0x17,0x3b], 286 => 'Firmware' },
	'firmwaredate' => { 82 => 0x15, 83 => 0x2001, 260 => 0x4 },
	'firmwareid' => { 138 => 0x0 },
	'firmwarename' => { 268 => 0xa001 },
	'firmwarerevision' => { 15 => 0xa4, 44 => 0x1e, 262 => 0x0 },
	'firmwarerevision2' => { 262 => 0xc },
	'firmwareversion' => { 4 => 0x10b, 7 => 0x136, 10 => 0xff, 11 => 0x107, 98 => 0xce5, 112 => 0x57, 114 => 'FirmwareVersion', 225 => 0x2, 226 => 0x3109, 248 => 0x230, 264 => 0x2 },
	'firstpublicationdate' => { 301 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 93 => 0x16 },
	'flash' => { 86 => 0x9209, 133 => 0x1f, 134 => 0x15, 293 => 'Flash' },
	'flashactivity' => { 25 => 0x1c },
	'flashbatterylevel' => { 31 => 0x249 },
	'flashbias' => { 225 => 0x24 },
	'flashbits' => { 25 => 0x1d },
	'flashchargelevel' => { 210 => 0x1010 },
	'flashcolorfilter' => { 155 => 0x10 },
	'flashcommandermode' => { 153 => '9.1', 154 => '9.1', 155 => '9.1' },
	'flashcompensation' => { 153 => 0xa, 154 => 0xa, 155 => 0xa, 286 => 'FlashCompensation' },
	'flashcontrolbuilt-in' => { 201 => '16.1', 202 => '23.1' },
	'flashcontrolmode' => { 153 => '9.2', 154 => '9.2', 155 => '9.2', 205 => 0x404 },
	'flashdefault' => { 135 => 0x42 },
	'flashdevice' => { 210 => 0x1005 },
	'flashdistance' => { 83 => 0x2034 },
	'flashenergy' => { 86 => 0xa20b, 293 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 161 => 0x18 },
	'flashexposurecomp' => { 55 => 0xf, 90 => 0x1011, 117 => 'ExposureComp', 132 => 0x23, 136 => 0x104, 161 => 0x12, 205 => 0x401, 210 => 0x1023, 248 => 0x4d, 271 => 0x3a, 277 => 0x104 },
	'flashexposurecompset' => { 228 => 0xe },
	'flashexposurecompsetting' => { 135 => 0x10 },
	'flashexposureindicator' => { 135 => 0x54 },
	'flashexposureindicatorlast' => { 135 => 0x56 },
	'flashexposureindicatornext' => { 135 => 0x55 },
	'flashexposurelock' => { 39 => 0x19 },
	'flashfired' => { 100 => 0x5d, 117 => 'Fired', 132 => 0x14, 179 => '590.3', 225 => 0x8007, 293 => [\'Flash','FlashFired'] },
	'flashfiring' => { 60 => 0x306, 61 => 0x6, 62 => 0x7, 65 => 0x7 },
	'flashfirmwareversion' => { 206 => 0x1002 },
	'flashfocallength' => { 153 => 0xb, 154 => 0xc, 155 => 0xc },
	'flashfunction' => { 293 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 153 => 0xe, 154 => 0xf, 155 => 0xf },
	'flashgroupacompensation' => { 153 => 0x11, 154 => 0x12, 155 => 0x13 },
	'flashgroupacontrolmode' => { 153 => 0xf, 154 => '16.1', 155 => '17.1' },
	'flashgroupaoutput' => { 153 => 0x11, 154 => 0x12, 155 => 0x13 },
	'flashgroupbcompensation' => { 153 => 0x12, 154 => 0x13, 155 => 0x14 },
	'flashgroupbcontrolmode' => { 153 => 0x10, 154 => '17.1', 155 => '18.1' },
	'flashgroupboutput' => { 153 => 0x12, 154 => 0x13, 155 => 0x14 },
	'flashgroupccompensation' => { 154 => 0x14, 155 => 0x15 },
	'flashgroupccontrolmode' => { 154 => '17.2', 155 => '18.2' },
	'flashgroupcoutput' => { 154 => 0x14, 155 => 0x15 },
	'flashguidenumber' => { 55 => 0xd, 70 => 0x0, 117 => 'GuideNumber' },
	'flashintensity' => { 82 => [0x19,0x5], 205 => 0x405 },
	'flashlevel' => { 199 => 0x9, 277 => 0xb048 },
	'flashmake' => { 117 => 'Make' },
	'flashmanufacturer' => { 131 => 'FlashManufacturer' },
	'flashmetering' => { 132 => 0x3f, 135 => 0x1c },
	'flashmeteringmode' => { 4 => 0x15, 9 => 0x15, 10 => 0x15, 11 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 16 => 0x15, 18 => 0x15, 20 => 0x15 },
	'flashmeteringsegments' => { 248 => 0x20a },
	'flashmode' => { 82 => 0x4, 100 => 0x5c, 117 => 'Mode', 132 => 0x2, 133 => 0x20, 134 => 0x16, 135 => 0xf, 161 => 0x87, 205 => 0x400, 210 => 0x1004, 248 => 0xc, 253 => 0x4, 263 => 0x20, 270 => 0x225, 272 => 0x23, 273 => 0x23, 293 => [\'Flash','FlashMode'] },
	'flashmodel' => { 117 => 'Model', 131 => 'FlashModel', 206 => 0x1001 },
	'flashoptions' => { 233 => 0x2 },
	'flashoptions2' => { 233 => 0x10 },
	'flashoutput' => { 31 => 0x248, 55 => 0x21, 153 => 0xa, 154 => 0xa, 155 => 0xa },
	'flashpixversion' => { 86 => 0xa000, 293 => 'FlashpixVersion' },
	'flashredeyemode' => { 293 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 205 => 0x403 },
	'flashreturn' => { 293 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 117 => 'SerialNumber', 206 => 0x1003 },
	'flashsetting' => { 161 => 0x8 },
	'flashshutterspeed' => { 198 => '20.2', 201 => '15.2', 202 => '22.2', 203 => '7.2', 204 => '23.1' },
	'flashsource' => { 153 => 0x4, 154 => 0x4, 155 => 0x4 },
	'flashstatus' => { 240 => 0x0 },
	'flashsyncspeed' => { 198 => '20.1', 201 => '15.1', 202 => '22.1' },
	'flashsyncspeedav' => { 58 => 0x3, 60 => 0x10f, 61 => 0x2, 62 => 0x3, 63 => 0x2, 64 => 0x2, 65 => 0x3, 66 => 0x6 },
	'flashthreshold' => { 70 => 0x1 },
	'flashtype' => { 117 => 'Type', 135 => 0x59, 161 => 0x9, 206 => 0x1000 },
	'flashwarning' => { 202 => '30.1', 203 => '7.1', 204 => '31.1', 225 => 0x62 },
	'flickerreduce' => { 270 => 0x218 },
	'fliphorizontal' => { 191 => 0x76a43206 },
	'fnumber' => { 4 => 0x3, 7 => 0x3, 9 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 22 => 0x5, 23 => 0x6, 55 => 0x15, 86 => 0x829d, 97 => 0xfd04, 100 => 0x1e, 102 => 0xfa23, 104 => 0xf103, 107 => 0x13, 109 => 0x3c, 112 => 0xc, 121 => 'FNumber', 132 => 0xa, 133 => 0x36, 134 => 0x47, 135 => 0x9, 248 => 0x13, 268 => 0xa019, 271 => 0x31, 293 => 'FNumber' },
	'focallength' => { 4 => 0x1d, 5 => 0xa, 6 => 0x9, 7 => 0x1d, 8 => 0x9, 9 => 0x1e, 10 => 0x1d, 11 => 0x1d, 12 => 0x1e, 13 => 0x1e, 14 => 0x1e, 15 => 0x28, 16 => 0x1e, 18 => 0x1e, 19 => 0x1e, 20 => 0x1e, 41 => 0x1, 83 => 0x1d, 86 => 0x920a, 107 => 0x1d, 121 => 'FocalLength', 132 => 0x12, 159 => 0xa, 160 => 0xb, 242 => 0x9, 248 => 0x1d, 293 => 'FocalLength' },
	'focallengthin35mmformat' => { 86 => 0xa405, 268 => 0xa01a, 293 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 206 => 0x103, 210 => 0x205 },
	'focalplaneresolutionunit' => { 86 => 0xa210, 293 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 86 => 0xa20e, 293 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 41 => 0x2 },
	'focalplanexunknown' => { 41 => 0x2 },
	'focalplaneyresolution' => { 86 => 0xa20f, 293 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 41 => 0x3 },
	'focalplaneyunknown' => { 41 => 0x3 },
	'focaltype' => { 6 => 0x2d, 41 => 0x0 },
	'focalunits' => { 25 => 0x19 },
	'focus' => { 181 => 0x8 },
	'focusarea' => { 132 => 0x31 },
	'focusareaselection' => { 203 => '15.2' },
	'focuscontinuous' => { 25 => 0x20 },
	'focusdisplayaiservoandmf' => { 60 => 0x515 },
	'focusdistance' => { 121 => 'FocusDistance', 132 => 0x13, 159 => 0x9, 160 => 0xa, 208 => 0x305 },
	'focusdistancelower' => { 4 => 0x45, 7 => 0x45, 9 => 0x56, 10 => 0x45, 11 => 0x45, 12 => 0x52, 13 => 0x52, 14 => 0x56, 16 => 0x52, 18 => 0x59, 19 => 0x57, 21 => 0x32, 55 => 0x14 },
	'focusdistanceupper' => { 4 => 0x43, 7 => 0x43, 9 => 0x54, 10 => 0x43, 11 => 0x43, 12 => 0x50, 13 => 0x50, 14 => 0x54, 16 => 0x50, 18 => 0x57, 19 => 0x55, 21 => 0x30, 55 => 0x13 },
	'focusholdbutton' => { 135 => 0x44 },
	'focusinfoversion' => { 208 => 0x0 },
	'focusingscreen' => { 59 => 0x0, 60 => 0x80b, 65 => 0x0 },
	'focusmode' => { 25 => 0x7, 82 => 0x3, 83 => [0x3003,0xd], 90 => 0x1021, 100 => 0x38, 114 => 'FocusMode', 132 => 0x30, 134 => 0xe, 135 => 0xc, 161 => 0x7, 205 => 0x301, 210 => 0x100b, 225 => 0x7, 248 => 0xd, 253 => 0x3, 272 => 0x10, 273 => 0x10, 277 => 0xb042 },
	'focusmode2' => { 233 => '3.1' },
	'focusmodesetting' => { 199 => '10.1' },
	'focusmodeswitch' => { 135 => 0x58 },
	'focuspixel' => { 90 => 0x1023 },
	'focuspointwrap' => { 198 => '2.2', 201 => '2.2', 202 => '1.2', 204 => '2.5' },
	'focusposition' => { 159 => 0x8, 160 => 0x8, 248 => 0x10 },
	'focusprocess' => { 205 => 0x302 },
	'focusrange' => { 25 => 0x12, 210 => 0x100a },
	'focussetting' => { 271 => 0x6 },
	'focusstepcount' => { 208 => 0x301, 210 => 0x100e },
	'focusstepinfinity' => { 208 => 0x303, 210 => 0x103b },
	'focusstepnear' => { 208 => 0x304, 210 => 0x103c },
	'focustrackinglockon' => { 198 => ['1.5','4.1'], 201 => '3.1', 202 => '0.4' },
	'focuswarning' => { 90 => 0x1301 },
	'foldername' => { 132 => 0x27 },
	'fontcomposite' => { 316 => [\'Fonts','FontsComposite'] },
	'fontface' => { 316 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 316 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 316 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 316 => [\'Fonts','FontsFontName'] },
	'fonts' => { 316 => 'Fonts' },
	'fonttype' => { 316 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 316 => [\'Fonts','FontsVersionString'] },
	'for' => { 259 => 'For' },
	'format' => { 290 => 'format' },
	'forwardlock' => { 306 => 'forwardlock' },
	'forwardmatrix1' => { 86 => 0xc714 },
	'forwardmatrix2' => { 86 => 0xc715 },
	'framecount' => { 47 => [0x2,0x4] },
	'framenum' => { 254 => 0xd7 },
	'framenumber' => { 90 => 0x8003, 248 => 0x29 },
	'framerate' => { 47 => [0x1,0x6] },
	'frameselector' => { 224 => '0.1' },
	'freebytes' => { 73 => 0x1 },
	'freememorycardimages' => { 133 => [0x37,0x54], 134 => [0x2d,0x4a], 135 => 0x32 },
	'fujiflashmode' => { 90 => 0x1010 },
	'fullimagesize' => { 277 => 0xb02b },
	'fullsizeimage' => { 120 => 'data' },
	'fullsizeimagename' => { 120 => '1Name' },
	'fullsizeimagetype' => { 120 => '0Type' },
	'funcbutton' => { 198 => ['14.1','15.1'], 201 => '28.1', 202 => '13.1', 204 => '14.1' },
	'funcbuttonplusdials' => { 198 => ['14.2','15.2'], 201 => '31.1' },
	'functionbutton' => { 203 => '5.2' },
	'gainbase' => { 209 => 0x610 },
	'gaincontrol' => { 86 => 0xa407, 293 => 'GainControl' },
	'gamma' => { 86 => 0xa500 },
	'gammacompensatedvalue' => { 95 => 0x91 },
	'geimagesize' => { 90 => 0x1304 },
	'gemake' => { 91 => 0x300 },
	'gemodel' => { 91 => 0x207 },
	'genre' => { 302 => 'genre', 311 => 'genre' },
	'geography' => { 303 => 'geography' },
	'geosync' => { 87 => 'Geosync' },
	'geotag' => { 87 => 'Geotag' },
	'geotime' => { 87 => 'Geotime' },
	'globalaltitude' => { 257 => 0x419 },
	'globalangle' => { 257 => 0x40d },
	'good' => { 311 => 'good' },
	'gpsaltitude' => { 92 => 0x6, 118 => 'Altitude', 293 => 'GPSAltitude' },
	'gpsaltituderef' => { 92 => 0x5, 293 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 92 => 0x1c, 293 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 92 => 0x1d },
	'gpsdatetime' => { 118 => 'DateTime', 293 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 92 => 0x18, 118 => 'Bearing', 293 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 92 => 0x17, 293 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 92 => 0x1a, 118 => 'Distance', 293 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 92 => 0x19, 293 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 92 => 0x14, 293 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 92 => 0x13 },
	'gpsdestlongitude' => { 92 => 0x16, 293 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 92 => 0x15 },
	'gpsdifferential' => { 92 => 0x1e, 118 => 'Differential', 293 => 'GPSDifferential' },
	'gpsdop' => { 92 => 0xb, 293 => 'GPSDOP' },
	'gpshpositioningerror' => { 92 => 0x1f },
	'gpsimgdirection' => { 92 => 0x11, 293 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 92 => 0x10, 293 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 92 => 0x2, 118 => 'Latitude', 293 => 'GPSLatitude' },
	'gpslatituderef' => { 92 => 0x1 },
	'gpslongitude' => { 92 => 0x4, 118 => 'Longitude', 293 => 'GPSLongitude' },
	'gpslongituderef' => { 92 => 0x3 },
	'gpsmapdatum' => { 92 => 0x12, 118 => 'Datum', 293 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 92 => 0xa, 118 => 'MeasureMode', 293 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 92 => 0x1b, 293 => 'GPSProcessingMethod' },
	'gpssatellites' => { 92 => 0x8, 118 => 'Satellites', 293 => 'GPSSatellites' },
	'gpsspeed' => { 92 => 0xd, 118 => 'Speed', 293 => 'GPSSpeed' },
	'gpsspeedref' => { 92 => 0xc, 293 => 'GPSSpeedRef' },
	'gpsstatus' => { 92 => 0x9, 293 => 'GPSStatus' },
	'gpstimestamp' => { 92 => 0x7 },
	'gpstrack' => { 92 => 0xf, 118 => 'Heading', 293 => 'GPSTrack' },
	'gpstrackref' => { 92 => 0xe, 293 => 'GPSTrackRef' },
	'gpsversionid' => { 92 => 0x0, 293 => 'GPSVersionID' },
	'gradation' => { 205 => 0x50f },
	'gradientbasedcorractive' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrcontrast' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrections' => { 289 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrhue' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrmaskcenterweight' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskflow' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskradius' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmasks' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmaskvalue' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskwhat' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskzerox' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrsaturation' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrsharpness' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrwhat' => { 289 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 289 => 'GrainAmount' },
	'grainfrequency' => { 289 => 'GrainFrequency' },
	'grainsize' => { 289 => 'GrainSize' },
	'graymixeraqua' => { 289 => 'GrayMixerAqua' },
	'graymixerblue' => { 289 => 'GrayMixerBlue' },
	'graymixergreen' => { 289 => 'GrayMixerGreen' },
	'graymixermagenta' => { 289 => 'GrayMixerMagenta' },
	'graymixerorange' => { 289 => 'GrayMixerOrange' },
	'graymixerpurple' => { 289 => 'GrayMixerPurple' },
	'graymixerred' => { 289 => 'GrayMixerRed' },
	'graymixeryellow' => { 289 => 'GrayMixerYellow' },
	'graypoint' => { 280 => 0x8021 },
	'grayresponseunit' => { 86 => 0x122 },
	'greencurvelimits' => { 78 => 0x1c4 },
	'greencurvepoints' => { 78 => 0x19a },
	'greenhue' => { 289 => 'GreenHue' },
	'greensaturation' => { 289 => 'GreenSaturation' },
	'griddisplay' => { 198 => '13.3', 200 => '2.2', 201 => '10.5', 202 => '3.4', 203 => '6.1', 204 => '4.2' },
	'gripbatteryadload' => { 231 => 0x5 },
	'gripbatteryadnoload' => { 231 => 0x4 },
	'gripbatterystate' => { 231 => '1.2' },
	'halftonehints' => { 86 => 0x141 },
	'hasalternative' => { 302 => 'hasAlternative' },
	'hascorrection' => { 302 => 'hasCorrection' },
	'hascrop' => { 289 => 'HasCrop' },
	'hasextendedxmp' => { 313 => 'HasExtendedXMP' },
	'haspreviousversion' => { 302 => 'hasPreviousVersion' },
	'hassettings' => { 289 => 'HasSettings' },
	'hastranslation' => { 302 => 'hasTranslation' },
	'hdr' => { 277 => 0x200a },
	'headline' => { 93 => 0x69, 300 => 'Headline' },
	'hierarchicalkeywords' => { 297 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 297 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 297 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 297 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 297 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 297 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 297 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 297 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 297 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 297 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 297 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 297 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 283 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 12 => 0xbc, 13 => 0xbd, 16 => 0xbd, 21 => 0xa5, 60 => 0x202, 90 => 0x100e, 161 => 0xb1, 248 => 0x71, 272 => 0x2c, 277 => 0x2009 },
	'highlight' => { 271 => 0xf },
	'highlightcolordistortreduct' => { 280 => 0x8026 },
	'highlightprotection' => { 190 => 0x6 },
	'highlightrecovery' => { 289 => 'HighlightRecovery' },
	'highlighttonepriority' => { 9 => 0x7, 12 => 0x7, 13 => 0x7, 14 => 0x7, 16 => 0x7, 18 => 0x7, 20 => 0x7, 60 => 0x203 },
	'highlowkeyadj' => { 248 => 0x6c },
	'highspeedsync' => { 135 => 0x5 },
	'histogramxml' => { 191 => 0x83a1a25 },
	'history' => { 300 => 'History', 312 => 'History' },
	'historyaction' => { 312 => [\'History','HistoryAction'] },
	'historychanged' => { 312 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 312 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 312 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 312 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 312 => [\'History','HistoryWhen'] },
	'hometowncity' => { 83 => 0x3006, 248 => 0x23, 252 => 0x2 },
	'hometowncitycode' => { 253 => 0x1000 },
	'hometowndst' => { 248 => 0x25, 252 => '0.2' },
	'hostcomputer' => { 86 => 0x13c },
	'hue' => { 139 => 0x3b, 248 => 0x67 },
	'hueadj' => { 194 => 0x2f, 280 => 0x8019 },
	'hueadjustment' => { 133 => 0x4a, 134 => 0x40, 161 => 0x92, 163 => 0x36 },
	'hueadjustmentaqua' => { 289 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 289 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 289 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 289 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 289 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 289 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 289 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 289 => 'HueAdjustmentYellow' },
	'huesetting' => { 213 => 0x1011 },
	'icc_profile' => { 87 => 'ICC_Profile' },
	'iccprofilename' => { 300 => 'ICCProfile' },
	'idccreativestyle' => { 280 => 0x8000 },
	'idcpreviewlength' => { 280 => 0x202 },
	'idcpreviewstart' => { 280 => 0x201 },
	'identifier' => { 290 => 'identifier', 309 => 'Identifier' },
	'illumination' => { 203 => '0.5' },
	'imageadjustment' => { 161 => 0x80, 181 => 0x5 },
	'imagealterationconstraints' => { 301 => 'ImageAlterationConstraints' },
	'imagearea' => { 171 => 0x10, 174 => 0x10 },
	'imageareaoffset' => { 248 => 0x38 },
	'imageauthentication' => { 161 => 0x20 },
	'imageboundary' => { 161 => 0x16 },
	'imagecount' => { 161 => 0xa5 },
	'imagecreator' => { 301 => 'ImageCreator' },
	'imagecreatorid' => { 301 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 301 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 301 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 161 => 0xa2 },
	'imagedescription' => { 86 => 0x10e, 307 => 'ImageDescription' },
	'imageduplicationconstraints' => { 301 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 191 => 0xfe443a45 },
	'imageeditcount' => { 248 => 0x41 },
	'imageediting' => { 248 => 0x32 },
	'imagefileconstraints' => { 301 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 301 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 301 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 86 => 0x101, 138 => 0xc, 307 => 'ImageLength' },
	'imagehistory' => { 86 => 0x9213 },
	'imageidnumber' => { 220 => 0x340 },
	'imagenumber' => { 15 => 0xd0, 86 => 0x9211, 114 => 'ImageNumber', 133 => 0xae, 134 => 0x5e, 286 => 'ImageNumber' },
	'imagenumber2' => { 134 => 0x62 },
	'imageoptimization' => { 161 => 0xa9 },
	'imageorientation' => { 93 => 0x83 },
	'imageprocessing' => { 161 => 0x1a },
	'imageprocessingversion' => { 209 => 0x0 },
	'imagequality' => { 114 => 'ImageQuality', 173 => '723.2', 174 => '732.2', 179 => '708.1', 225 => 0x1 },
	'imagequality2' => { 205 => 0x603 },
	'imagereview' => { 199 => '0.4', 203 => '0.4' },
	'imagereviewtime' => { 199 => '2.1', 200 => '19.1', 201 => '9.2', 202 => '20.1', 204 => '21.2' },
	'imagesize' => { 120 => 'ImageSize' },
	'imagesizerestriction' => { 304 => 'imageSizeRestriction' },
	'imagesourcedata' => { 86 => 0x935c },
	'imagestabilization' => { 25 => 0x22, 83 => 0x3020, 114 => 'ImageStabilization', 133 => 0xbd, 134 => 0x71, 135 => 0x57, 136 => [0x18,0x107,0x113], 161 => 0xac, 205 => 0x604, 208 => 0x1600, 225 => 0x1a, 272 => 0x3d, 277 => 0xb026 },
	'imagestyle' => { 272 => 0x2d },
	'imagesupplier' => { 301 => 'ImageSupplier' },
	'imagesupplierid' => { 301 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 301 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 301 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetone' => { 248 => 0x4f },
	'imagetype' => { 93 => 0x82, 301 => 'ImageType' },
	'imageuniqueid' => { 44 => 0x28, 86 => 0xa420, 293 => 'ImageUniqueID' },
	'imagewidth' => { 86 => 0x100, 138 => 0xe, 307 => 'ImageWidth' },
	'incrementaltemperature' => { 289 => 'IncrementalTemperature' },
	'incrementaltint' => { 289 => 'IncrementalTint' },
	'industry' => { 302 => 'industry', 303 => 'industry' },
	'infobuttonwhenshooting' => { 60 => 0x409 },
	'infraredilluminator' => { 260 => 0x28 },
	'ingredients' => { 312 => 'Ingredients' },
	'ingredientsalternatepaths' => { 312 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 312 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 312 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 312 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 312 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 312 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 312 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 312 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 312 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 312 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 312 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 312 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 312 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 312 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 312 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 312 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 312 => [\'Ingredients','IngredientsVersionID'] },
	'initialzoomliveview' => { 198 => '4.4' },
	'initialzoomsetting' => { 198 => '9.3', 201 => '27.3' },
	'inkset' => { 86 => 0x14c },
	'instanceid' => { 312 => 'InstanceID' },
	'instantplaybacksetup' => { 135 => 0x3e },
	'instantplaybacktime' => { 135 => 0x3d },
	'instructions' => { 300 => 'Instructions' },
	'instrument' => { 311 => 'instrument' },
	'intellectualgenre' => { 294 => 'IntellectualGenre' },
	'intelligentauto' => { 277 => 0xb052 },
	'intelligentd-range' => { 225 => 0x79 },
	'intelligentexposure' => { 225 => 0x5d },
	'intelligentresolution' => { 225 => 0x70 },
	'interchangecolorspace' => { 95 => 0x40 },
	'internalflash' => { 132 => 0x2b, 198 => '23.1', 199 => '8.1', 200 => '22.1', 203 => '8.1', 204 => '24.1', 208 => 0x1208 },
	'internalflashae1' => { 210 => 0x1021 },
	'internalflashae1_0' => { 210 => 0x101d },
	'internalflashae2' => { 210 => 0x1022 },
	'internalflashae2_0' => { 210 => 0x101e },
	'internalflashmode' => { 240 => 0x1 },
	'internalflashstrength' => { 240 => 0x3 },
	'internalflashtable' => { 210 => 0x1024 },
	'internalserialnumber' => { 44 => 0x96, 54 => 0x9, 90 => 0x10, 137 => 0x49dc, 206 => 0x102, 225 => 0x25, 232 => 0x4, 264 => 0x5 },
	'interopindex' => { 86 => 0x1 },
	'interopversion' => { 86 => 0x2 },
	'intervallength' => { 132 => 0x10 },
	'intervalmode' => { 132 => 0x26 },
	'intervalnumber' => { 132 => 0x11 },
	'introtime' => { 311 => 'introTime' },
	'introtimescale' => { 311 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 311 => [\'introTime','introTimeValue'] },
	'iptc-naa' => { 86 => 0x83bb, 227 => 0x83bb },
	'iptcbitspersample' => { 95 => 0x56 },
	'iptcdigest' => { 257 => 0x425 },
	'iptcimageheight' => { 95 => 0x1e },
	'iptcimagerotation' => { 95 => 0x66 },
	'iptcimagewidth' => { 95 => 0x14 },
	'iptclastedited' => { 295 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 95 => 0xa },
	'iptcpixelheight' => { 95 => 0x32 },
	'iptcpixelwidth' => { 95 => 0x28 },
	'isbn' => { 302 => 'isbn' },
	'iscorrectionof' => { 302 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 79 => 0x3 },
	'iso' => { 4 => 0x6, 6 => 0x75, 7 => 0x6, 8 => 0x79, 9 => 0x6, 10 => 0x6, 11 => 0x6, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 22 => 0x0, 23 => 0x1, 82 => 0x14, 83 => [0x3014,0x14], 86 => 0x8827, 97 => 0xfd06, 98 => 0x1784, 100 => 0x60, 102 => [0xfa2e,0xfa46], 103 => [0x27,0x28], 104 => 0xf105, 107 => 0x14, 109 => 0x4e, 112 => 0x34, 114 => 'ISO', 132 => 0x8, 157 => 0x0, 161 => 0x2, 227 => 0x17, 248 => 0x14, 253 => 0x14, 268 => 0xa014, 293 => 'ISOSpeedRatings' },
	'iso2' => { 157 => 0x6, 168 => 0x265, 169 => 0x25c, 170 => 0x265, 171 => 0x221, 172 => 0x25d, 173 => 0x256, 174 => 0x25d, 176 => 0x2b5, 177 => 0x265, 180 => 0x2b5 },
	'isoauto' => { 233 => '14.4' },
	'isoautoparameters' => { 248 => 0x7a },
	'isodisplay' => { 200 => '2.3', 202 => '3.3', 204 => '4.3' },
	'isoexpansion' => { 60 => 0x103, 61 => 0x7, 62 => 0x8, 65 => 0x8, 157 => 0x4 },
	'isoexpansion2' => { 157 => 0xa },
	'isofloor' => { 233 => 0x6 },
	'isoselection' => { 161 => 0xf },
	'isosensitivitystep' => { 202 => '6.2' },
	'isosetting' => { 100 => 0x5e, 114 => 'ISOSetting', 132 => 0x24, 133 => 0x26, 134 => 0x1c, 135 => 0x13, 139 => 0x6, 161 => 0x13, 233 => '17.3', 263 => 0x27, 272 => 0x16, 273 => 0x14 },
	'isospeed' => { 86 => 0x8833 },
	'isospeedexpansion' => { 59 => 0x3 },
	'isospeedincrements' => { 60 => 0x102 },
	'isospeedlatitudeyyy' => { 86 => 0x8834 },
	'isospeedlatitudezzz' => { 86 => 0x8835 },
	'isospeedrange' => { 60 => 0x103 },
	'isostepsize' => { 198 => '6.1', 201 => '4.1' },
	'isovalue' => { 210 => 0x1001 },
	'issn' => { 302 => 'issn' },
	'issueidentifier' => { 302 => 'issueIdentifier' },
	'issuename' => { 302 => 'issueName' },
	'istranslationof' => { 302 => 'isTranslationOf' },
	'jobid' => { 93 => 0xb8 },
	'jobref' => { 310 => 'JobRef' },
	'jobrefid' => { 310 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 310 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 310 => [\'JobRef','JobRefUrl'] },
	'jpegquality' => { 6 => 0x66, 226 => 0x3034 },
	'jpegsize' => { 226 => 0x303a },
	'jpgfromraw' => { 73 => 0x2007, 84 => 'JpgFromRaw', 227 => 0x2e },
	'jpgfromrawlength' => { 86 => [0x117,0x202] },
	'jpgfromrawstart' => { 86 => [0x111,0x201] },
	'jpgrecordedpixels' => { 233 => '14.1' },
	'key' => { 311 => 'key' },
	'keyword' => { 302 => 'keyword' },
	'keywordinfo' => { 297 => 'Keywords' },
	'keywords' => { 93 => 0x19, 115 => 'Keywords', 214 => 'Keywords', 259 => 'Keywords', 285 => 'keywords', 299 => 'Keywords' },
	'killdate' => { 302 => 'killDate' },
	'kodakimageheight' => { 97 => 0xf908, 100 => 0xe, 102 => [0xfa1e,0xfa52], 108 => 0x70 },
	'kodakimagewidth' => { 97 => 0xf907, 100 => 0xc, 102 => [0xfa1d,0xfa51], 108 => 0x6c },
	'kodakinfotype' => { 97 => 0xfa00 },
	'kodakmaker' => { 108 => 0x8 },
	'kodakmodel' => { 100 => 0x0, 108 => 0x28 },
	'label' => { 216 => 'Label', 309 => 'Label' },
	'landmark' => { 225 => 0x6f },
	'landscapeoutputhighlightpoint' => { 79 => 0x26 },
	'landscapeoutputshadowpoint' => { 79 => 0x27 },
	'landscaperawcolortone' => { 79 => 0x1f },
	'landscaperawcontrast' => { 79 => 0x21 },
	'landscaperawhighlight' => { 79 => 0x77 },
	'landscaperawhighlightpoint' => { 79 => 0x24 },
	'landscaperawlinear' => { 79 => 0x22 },
	'landscaperawsaturation' => { 79 => 0x20 },
	'landscaperawshadow' => { 79 => 0x80 },
	'landscaperawshadowpoint' => { 79 => 0x25 },
	'landscaperawsharpness' => { 79 => 0x23 },
	'language' => { 290 => 'language' },
	'languageidentifier' => { 93 => 0x87 },
	'lastfilenumber' => { 132 => 0x1b },
	'lastkeywordiptc' => { 131 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 131 => 'LastKeywordXMP' },
	'lasturl' => { 312 => 'LastURL' },
	'lc1' => { 242 => 0x2 },
	'lc10' => { 242 => 0xb },
	'lc11' => { 242 => 0xc },
	'lc12' => { 242 => 0xd },
	'lc14' => { 242 => 0xf },
	'lc15' => { 242 => 0x10 },
	'lc2' => { 242 => 0x3 },
	'lc3' => { 242 => 0x4 },
	'lc4' => { 242 => 0x5 },
	'lc5' => { 242 => 0x6 },
	'lc6' => { 242 => 0x7 },
	'lc7' => { 242 => 0x8 },
	'lcddisplayatpoweron' => { 60 => 0x811, 64 => 0xa },
	'lcddisplayreturntoshoot' => { 65 => 0x12 },
	'lcdillumination' => { 198 => '17.5', 201 => '10.3', 202 => '4.2', 204 => '5.4' },
	'lcdilluminationduringbulb' => { 60 => 0x408 },
	'lcdpanels' => { 59 => 0x8 },
	'lcheditor' => { 191 => 0x8ae85e },
	'legacyiptcdigest' => { 300 => 'LegacyIPTCDigest' },
	'lens' => { 86 => 0xfdea, 161 => 0x84, 286 => 'Lens' },
	'lensafstopbutton' => { 58 => 0x11, 59 => 0x13, 60 => 0x506, 61 => 0x10, 62 => 0x12, 65 => 0x13, 66 => 0x9 },
	'lensaperturerange' => { 271 => 0x30 },
	'lensdistortionparams' => { 210 => 0x206 },
	'lensdrivenoaf' => { 60 => 0x505 },
	'lensfirmware' => { 265 => 0x20, 268 => 0xa004 },
	'lensfirmwareversion' => { 206 => 0x204 },
	'lensfocalrange' => { 271 => 0xa },
	'lensfstops' => { 158 => 0x7, 159 => 0xc, 160 => 0xd, 161 => 0x8b, 242 => '0.3' },
	'lensid' => { 286 => 'LensID' },
	'lensidnumber' => { 158 => 0x6, 159 => 0xb, 160 => 0xc },
	'lensinfo' => { 86 => 0xa432, 286 => 'LensInfo' },
	'lenskind' => { 242 => 0x1 },
	'lensmake' => { 86 => 0xa433, 121 => 'Make' },
	'lensmanualdistortionamount' => { 289 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 131 => 'LensManufacturer' },
	'lensmodel' => { 4 => 0x937, 10 => 0x92b, 11 => 0x933, 44 => 0x95, 86 => 0xa434, 121 => 'Model', 131 => 'LensModel', 206 => 0x203 },
	'lensprofilechromaticaberrationscale' => { 289 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 289 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 289 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 289 => 'LensProfileEnable' },
	'lensprofilefilename' => { 289 => 'LensProfileFilename' },
	'lensprofilename' => { 289 => 'LensProfileName' },
	'lensprofilesetup' => { 289 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 289 => 'LensProfileVignettingScale' },
	'lensproperties' => { 206 => 0x20b },
	'lensserialnumber' => { 42 => 0x0, 86 => 0xa435, 121 => 'SerialNumber', 206 => 0x202, 225 => 0x52, 265 => 0x30 },
	'lensshutterlock' => { 135 => 0x4a },
	'lenstemperature' => { 210 => 0x1008 },
	'lenstype' => { 4 => 0xe2, 5 => 0xd, 6 => 0xc, 7 => 0x111, 8 => 0xc, 9 => [0x14e,0x14f], 10 => 0xd6, 11 => 0xde, 12 => 0xf6, 13 => 0xea, 14 => 0xff, 15 => [0xc,0x97], 16 => 0xe6, 18 => 0xea, 19 => 0xe8, 21 => 0xee, 25 => 0x16, 136 => 0x10c, 161 => 0x83, 206 => 0x201, 217 => 0x16, 223 => 0x303, 224 => 0x0, 225 => 0x51, 226 => 0x3405, 243 => 0x0, 244 => 0x0, 245 => 0x1, 246 => 0x1, 248 => 0x3f, 268 => 0xa003, 277 => 0xb027 },
	'levelgaugepitch' => { 205 => 0x904 },
	'levelgaugeroll' => { 205 => 0x903 },
	'levelorientation' => { 247 => 0x0 },
	'license' => { 287 => 'license' },
	'licensee' => { 301 => 'Licensee' },
	'licenseeid' => { 301 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 301 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 301 => 'LicenseeImageNotes' },
	'licenseename' => { 301 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 301 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 301 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 301 => 'LicenseeTransactionID' },
	'licenseid' => { 301 => 'LicenseID' },
	'licensestartdate' => { 301 => 'LicenseStartDate' },
	'licensetransactiondate' => { 301 => 'LicenseTransactionDate' },
	'licensetype' => { 291 => 'licensetype' },
	'licensor' => { 301 => 'Licensor' },
	'licensorcity' => { 301 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 301 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 301 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 301 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 301 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 301 => 'LicensorImageID' },
	'licensorname' => { 301 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 301 => 'LicensorNotes' },
	'licensorpostalcode' => { 301 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 301 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 301 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 301 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 301 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 301 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 301 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 301 => 'LicensorTransactionID' },
	'licensorurl' => { 301 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 210 => 0x1009 },
	'lightingmode' => { 83 => 0x302a },
	'lightreading' => { 248 => 0x15 },
	'lightsource' => { 86 => 0x9208, 161 => 0x90, 213 => 0x1000, 293 => 'LightSource' },
	'lightsourcespecial' => { 270 => 0x21d },
	'lightswitch' => { 204 => '0.1' },
	'lightvaluecenter' => { 210 => 0x103d },
	'lightvalueperiphery' => { 210 => 0x103e },
	'linearresponselimit' => { 86 => 0xc62e },
	'linkaetoafpoint' => { 233 => '14.2' },
	'liveviewaf' => { 200 => '32.1', 204 => '34.1' },
	'liveviewafareamode' => { 202 => '34.1' },
	'liveviewafmode' => { 202 => '34.2' },
	'liveviewexposuresimulation' => { 60 => 0x810 },
	'liveviewmonitorofftime' => { 202 => '20.2' },
	'liveviewshooting' => { 39 => 0x13 },
	'localafareapoint' => { 135 => 0xd, 272 => 0x12, 273 => 0x12 },
	'localcaption' => { 93 => 0x79 },
	'localizedcameramodel' => { 86 => 0xc615 },
	'locallocationname' => { 268 => 0x30 },
	'location' => { 225 => 0x67, 284 => 'Location', 294 => 'Location', 302 => 'location' },
	'locationareacode' => { 288 => 'lac' },
	'locationcreated' => { 295 => 'LocationCreated' },
	'locationcreatedcity' => { 295 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 295 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 295 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedprovincestate' => { 295 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 295 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 295 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationname' => { 268 => 0x31 },
	'locationshown' => { 295 => 'LocationShown' },
	'locationshowncity' => { 295 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 295 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 295 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownprovincestate' => { 295 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 295 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 295 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 60 => 0x709 },
	'logcomment' => { 311 => 'logComment' },
	'longexposurenoisereduction' => { 60 => 0x201, 61 => 0x1, 62 => 0x2, 63 => 0x1, 64 => 0x1, 65 => 0x2, 66 => 0x1, 272 => 0x2b, 277 => [0xb04e,0x2008] },
	'longexposurenoisereduction2' => { 39 => 0x8 },
	'longfocal' => { 4 => 0xe6, 5 => 0x10, 6 => 0x13, 7 => 0x115, 8 => 0x13, 9 => [0x152,0x153], 10 => 0xda, 12 => 0xfa, 13 => 0xee, 14 => 0x103, 15 => 0x95, 16 => 0xea, 18 => 0xee, 19 => 0xec, 21 => 0xf2, 25 => 0x17 },
	'loop' => { 311 => 'loop' },
	'luminanceadjustmentaqua' => { 289 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 289 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 289 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 289 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 289 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 289 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 289 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 289 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 78 => 0x150 },
	'luminancecurvepoints' => { 78 => 0x126 },
	'luminancenoisereduction' => { 79 => 0x5f, 271 => 0x1b },
	'luminancenoisereductioncontrast' => { 289 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 289 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 79 => 0x6d },
	'luminancesmoothing' => { 289 => 'LuminanceSmoothing' },
	'm16cversion' => { 220 => 0x333 },
	'macro' => { 90 => 0x1020, 91 => 0x202, 210 => 0x202, 263 => 0x21, 270 => 0x202, 277 => 0xb040 },
	'macromagnification' => { 4 => 0x1b, 7 => 0x1b, 10 => 0x1b, 11 => 0x1b, 15 => 0x1b, 16 => 0x1b, 39 => 0x10 },
	'macromode' => { 25 => 0x1, 132 => 0xb, 205 => 0x300, 225 => 0x1c },
	'magicfilter' => { 205 => 0x52c },
	'magnifiedview' => { 62 => 0x11, 64 => 0x9 },
	'maindialexposurecomp' => { 203 => '0.6' },
	'make' => { 74 => 0x0, 86 => 0x10f, 114 => 'Make', 216 => 'Make', 227 => 0x10f, 307 => 'Make' },
	'makernote' => { 293 => 'MakerNote' },
	'makernotecanon' => { 85 => 'MakN', 86 => 0x927c },
	'makernotecasio' => { 85 => 'MakN', 86 => 0x927c },
	'makernotecasio2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotefujifilm' => { 85 => 'MakN', 86 => 0x927c },
	'makernotege' => { 85 => 'MakN', 86 => 0x927c },
	'makernotege2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotehp' => { 85 => 'MakN', 86 => 0x927c },
	'makernotehp2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotehp4' => { 85 => 'MakN', 86 => 0x927c },
	'makernotehp6' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteisl' => { 85 => 'MakN', 86 => 0x927c },
	'makernotejvc' => { 85 => 'MakN', 86 => 0x927c },
	'makernotejvctext' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak10' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak1a' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak1b' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak3' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak4' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak5' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak6a' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak6b' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak7' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak8a' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak8b' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodak9' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekodakunknown' => { 85 => 'MakN', 86 => 0x927c },
	'makernotekyocera' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteleica' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteleica2' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteleica3' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteleica4' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteleica5' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteleica6' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteminolta' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteminolta2' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteminolta3' => { 85 => 'MakN', 86 => 0x927c },
	'makernotenikon' => { 85 => 'MakN', 86 => 0x927c },
	'makernotenikon2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotenikon3' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteoffset' => { 270 => 0xff },
	'makernoteolympus' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteolympus2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepanasonic' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepanasonic2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepentax' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepentax2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepentax3' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepentax4' => { 85 => 'MakN', 86 => 0x927c },
	'makernotepentax5' => { 85 => 'MakN', 86 => 0x927c },
	'makernotephaseone' => { 85 => 'MakN', 86 => 0x927c },
	'makernotereconyx' => { 85 => 'MakN', 86 => 0x927c },
	'makernotericoh' => { 85 => 'MakN', 86 => 0x927c },
	'makernotericohtext' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesafety' => { 86 => 0xc635 },
	'makernotesamsung1a' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesamsung1b' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesamsung2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesanyo' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesanyoc4' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesanyopatch' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesigma' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesony' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesony2' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesony3' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesony4' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesonyericsson' => { 85 => 'MakN', 86 => 0x927c },
	'makernotesonysrf' => { 85 => 'MakN', 86 => 0x927c },
	'makernotetype' => { 264 => 0x1 },
	'makernoteunknown' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteunknowntext' => { 85 => 'MakN', 86 => 0x927c },
	'makernoteversion' => { 136 => 0x0, 161 => 0x1, 210 => 0x0, 225 => 0x8000, 267 => 0x0, 268 => 0x1, 271 => 0x1d, 274 => 0x2000 },
	'managedfrom' => { 312 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 312 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 312 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 312 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 312 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 312 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 312 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 312 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 312 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 312 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 312 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 312 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 312 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 312 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 312 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 312 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 312 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 312 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 312 => 'Manager' },
	'managervariant' => { 312 => 'ManagerVariant' },
	'manageto' => { 312 => 'ManageTo' },
	'manageui' => { 312 => 'ManageUI' },
	'manifest' => { 312 => 'Manifest' },
	'manifestlinkform' => { 312 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 312 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 312 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 312 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 312 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 312 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 312 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 312 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 312 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 312 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 312 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 312 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 312 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 312 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 312 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 312 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 312 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 312 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 312 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 312 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 312 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 312 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 205 => 0x900 },
	'manometerreading' => { 205 => 0x901 },
	'manualafpointselectpattern' => { 60 => 0x513 },
	'manualexposuretime' => { 135 => 0x6 },
	'manualflash' => { 208 => 0x1209 },
	'manualflashoutput' => { 25 => 0x29, 199 => '8.2', 200 => '22.2', 201 => '16.2', 202 => '23.2', 203 => '8.2', 204 => '24.2' },
	'manualflashstrength' => { 205 => 0x406 },
	'manualfnumber' => { 135 => 0x7 },
	'manualfocusdistance' => { 161 => 0x85, 210 => 0x100c, 270 => 0x223 },
	'manualtv' => { 59 => 0x5, 60 => 0x705 },
	'manufacturedate' => { 232 => 0x1 },
	'manufacturedate1' => { 266 => 0x4 },
	'manufacturedate2' => { 266 => 0x5 },
	'marked' => { 299 => 'Marked', 315 => 'Marked' },
	'markers' => { 311 => 'markers' },
	'markerscomment' => { 311 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 311 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 311 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 311 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 311 => [\'markers','markersCuePointType'] },
	'markersduration' => { 311 => [\'markers','markersDuration'] },
	'markerslocation' => { 311 => [\'markers','markersLocation'] },
	'markersname' => { 311 => [\'markers','markersName'] },
	'markersprobability' => { 311 => [\'markers','markersProbability'] },
	'markersspeaker' => { 311 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 311 => [\'markers','markersStartTime'] },
	'markerstarget' => { 311 => [\'markers','markersTarget'] },
	'markerstype' => { 311 => [\'markers','markersType'] },
	'maskedareas' => { 86 => 0xc68e },
	'masterdocumentid' => { 93 => 0xb9 },
	'mastergain' => { 166 => 0x50 },
	'maxaperture' => { 25 => 0x1a, 104 => 0x6103, 121 => 'MaxAperture', 132 => 0x17, 242 => '14.1' },
	'maxapertureatcurrentfocal' => { 206 => 0x20a },
	'maxapertureatmaxfocal' => { 90 => 0x1407, 121 => 'MaxApertureAtMaxFocal', 158 => 0xb, 159 => 0x10, 160 => 0x11, 206 => 0x206 },
	'maxapertureatminfocal' => { 90 => 0x1406, 158 => 0xa, 159 => 0xf, 160 => 0x10, 206 => 0x205 },
	'maxaperturevalue' => { 86 => 0x9205, 293 => 'MaxApertureValue' },
	'maxavailheight' => { 295 => 'MaxAvailHeight' },
	'maxavailwidth' => { 295 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 198 => 0xb, 201 => 0xc, 202 => 0xb },
	'maxfaces' => { 209 => 0x1202 },
	'maxfocallength' => { 90 => 0x1405, 121 => 'MaxFocalLength', 158 => 0x9, 159 => 0xe, 160 => 0xf, 206 => 0x208 },
	'maximumdensityrange' => { 95 => 0x8c },
	'maxpagesize' => { 316 => 'MaxPageSize' },
	'maxpagesizeh' => { 316 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 316 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 316 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 86 => 0x119 },
	'maxstorage' => { 306 => 'maxstorage' },
	'mb-d10batteries' => { 198 => '12.6' },
	'mb-d10batterytype' => { 201 => '13.3' },
	'mb-d11batterytype' => { 202 => '2.3' },
	'mb-d80batteries' => { 203 => '6.5' },
	'mb-d80batterytype' => { 204 => '3.2' },
	'mcuversion' => { 158 => 0xc, 159 => 0x11, 160 => 0x12 },
	'md5digest' => { 122 => 'zmd5' },
	'measuredev' => { 20 => 0x9, 55 => 0x3, 73 => 0x1814, 114 => 'MeasuredEV' },
	'measuredev2' => { 9 => 0x8, 20 => 0x8, 55 => 0x17 },
	'measuredev3' => { 9 => 0x9 },
	'measuredlv' => { 220 => 0x312, 226 => 0x3407 },
	'measuredrggb' => { 45 => 0x1 },
	'measuredrggbdata' => { 31 => 0x287 },
	'mediaconstraints' => { 301 => 'MediaConstraints' },
	'mediasummarycode' => { 301 => 'MediaSummaryCode' },
	'menubuttondisplayposition' => { 58 => 0xb, 61 => 0xa, 62 => 0xb, 65 => 0xb },
	'menubuttonreturn' => { 66 => 0xb },
	'menumonitorofftime' => { 201 => '8.2', 202 => '21.1', 204 => '22.1' },
	'metadatadate' => { 309 => 'MetadataDate' },
	'metadatamoddate' => { 311 => 'metadataModDate' },
	'metering' => { 199 => '6.1' },
	'meteringmode' => { 25 => 0x11, 86 => 0x9207, 100 => 0x1c, 132 => 0x7, 133 => 0x25, 135 => 0x12, 205 => 0x202, 248 => 0x17, 271 => 0x9, 272 => 0x15, 273 => 0x13, 293 => 'MeteringMode' },
	'meteringmode2' => { 233 => '2.1' },
	'meteringmode3' => { 233 => '16.1' },
	'meteringoffscaleindicator' => { 135 => 0x53 },
	'meteringtime' => { 198 => '22.2', 199 => '3.2', 200 => '17.1', 201 => '7.3', 202 => '18.1', 203 => '3.2', 204 => '19.1' },
	'mieversion' => { 122 => '0Vers' },
	'minaperture' => { 25 => 0x1b, 121 => 'MinAperture', 242 => '0.2' },
	'minfocallength' => { 90 => 0x1404, 121 => 'MinFocalLength', 158 => 0x8, 159 => 0xd, 160 => 0xe, 206 => 0x207 },
	'minoltadate' => { 132 => 0x15 },
	'minoltaimagesize' => { 132 => 0x4, 133 => 0xc, 134 => 0x2, 136 => 0x103 },
	'minoltamodelid' => { 132 => 0x25 },
	'minoltaquality' => { 132 => 0x5, 133 => 0xd, 134 => 0x3, 136 => [0x102,0x103] },
	'minoltatime' => { 132 => 0x16 },
	'minormodelagedisclosure' => { 301 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 86 => 0x118 },
	'mirrorlockup' => { 58 => 0xc, 59 => 0xc, 60 => 0x60f, 61 => 0xb, 62 => 0xc, 63 => 0x6, 64 => 0x6, 65 => 0xc, 66 => 0x3 },
	'mobilecountrycode' => { 288 => 'mcc' },
	'mobilenetworkcode' => { 288 => 'mnc' },
	'moddate' => { 216 => 'modify-date', 299 => 'ModDate' },
	'model' => { 74 => 0x6, 86 => 0x110, 114 => 'Model', 216 => 'Model', 227 => 0x110, 307 => 'Model' },
	'modelage' => { 295 => 'ModelAge' },
	'modelingflash' => { 198 => '21.4', 201 => '26.4', 202 => '30.2', 203 => '7.4', 204 => '31.3' },
	'modelreleaseid' => { 301 => 'ModelReleaseID' },
	'modelreleasestatus' => { 301 => 'ModelReleaseStatus' },
	'modificationdate' => { 302 => 'modificationDate' },
	'modifiedcolortemp' => { 46 => 0x9 },
	'modifieddigitalgain' => { 46 => 0xb },
	'modifiedparamflag' => { 40 => 0x1 },
	'modifiedpicturestyle' => { 46 => 0xa },
	'modifiedsaturation' => { 205 => 0x504 },
	'modifiedsensorbluelevel' => { 46 => 0x5 },
	'modifiedsensorredlevel' => { 46 => 0x4 },
	'modifiedsharpness' => { 46 => 0x2 },
	'modifiedsharpnessfreq' => { 46 => 0x3 },
	'modifiedtonecurve' => { 46 => 0x1 },
	'modifiedwhitebalance' => { 46 => 0x8 },
	'modifiedwhitebalanceblue' => { 46 => 0x7 },
	'modifiedwhitebalancered' => { 46 => 0x6 },
	'modifydate' => { 86 => 0x132, 115 => 'ModifyDate', 214 => 'ModDate', 215 => 'tIME', 259 => 'ModDate', 309 => 'ModifyDate' },
	'moirefilter' => { 86 => 0xfe58, 289 => 'MoireFilter' },
	'monitordisplayoff' => { 135 => 0x4c },
	'monitorofftime' => { 198 => '18.2', 199 => '3.1', 203 => '3.1' },
	'monochromecontrast' => { 79 => 0x3c },
	'monochromefiltereffect' => { 79 => 0x3a, 248 => 0x73 },
	'monochromelinear' => { 79 => 0x3d },
	'monochromeoutputhighlightpoint' => { 79 => 0x41 },
	'monochromeoutputshadowpoint' => { 79 => 0x42 },
	'monochromerawhighlight' => { 79 => 0x7a },
	'monochromerawhighlightpoint' => { 79 => 0x3f },
	'monochromerawshadow' => { 79 => 0x83 },
	'monochromerawshadowpoint' => { 79 => 0x40 },
	'monochromesharpness' => { 79 => 0x3e },
	'monochrometoning' => { 248 => 0x74 },
	'monochrometoningeffect' => { 79 => 0x3b },
	'monthdaycreated' => { 100 => 0x12, 109 => 0xe },
	'moonphase' => { 260 => 0x12 },
	'morepermissions' => { 287 => 'morePermissions' },
	'motionsensitivity' => { 260 => 0x29 },
	'multiburstimageheight' => { 277 => 0x1002 },
	'multiburstimagewidth' => { 277 => 0x1001 },
	'multiburstmode' => { 277 => 0x1000 },
	'multicontrollerwhilemetering' => { 60 => 0x517 },
	'multiexposureautogain' => { 162 => 0x3 },
	'multiexposuremode' => { 162 => 0x1 },
	'multiexposureshots' => { 162 => 0x2 },
	'multiframenoisereduction' => { 277 => 0x200b },
	'multipleexposuremode' => { 209 => 0x101c },
	'multipleexposureset' => { 233 => '10.1' },
	'multisample' => { 166 => 0x40 },
	'multiselector' => { 198 => '9.4', 201 => '27.4' },
	'multiselectorliveview' => { 198 => '4.3' },
	'multiselectorplaybackmode' => { 198 => ['13.5','9.2'], 201 => '27.2' },
	'multiselectorshootmode' => { 198 => '9.1', 201 => '27.1' },
	'mycolormode' => { 48 => 0x2 },
	'nativedigest' => { 293 => 'NativeDigest', 307 => 'NativeDigest' },
	'ncdfileinfo' => { 98 => 0x414 },
	'ndfilter' => { 55 => 0x1c },
	'nefbitdepth' => { 161 => 0xe22 },
	'nefcompression' => { 161 => 0x93 },
	'neutraloutputhighlightpoint' => { 79 => 0x2f },
	'neutraloutputshadowpoint' => { 79 => 0x30 },
	'neutralrawcolortone' => { 79 => 0x28 },
	'neutralrawcontrast' => { 79 => 0x2a },
	'neutralrawhighlight' => { 79 => 0x78 },
	'neutralrawhighlightpoint' => { 79 => 0x2d },
	'neutralrawlinear' => { 79 => 0x2b },
	'neutralrawsaturation' => { 79 => 0x29 },
	'neutralrawshadow' => { 79 => 0x81 },
	'neutralrawshadowpoint' => { 79 => 0x2e },
	'neutralrawsharpness' => { 79 => 0x2c },
	'newsphotoversion' => { 95 => 0x0 },
	'nickname' => { 309 => 'Nickname' },
	'nikoncapturedata' => { 161 => 0xe01 },
	'nikoncaptureeditversions' => { 161 => 0xe13 },
	'nikoncaptureoutput' => { 161 => 0xe1e },
	'nikoncaptureversion' => { 161 => 0xe09 },
	'nikoniccprofile' => { 161 => 0xe1d },
	'nikonimagesize' => { 173 => '723.1', 174 => '732.1', 179 => 0x2c4 },
	'noisefilter' => { 205 => 0x527 },
	'noisereduction' => { 90 => 0x100b, 133 => 0xb0, 134 => 0x60, 135 => 0x3f, 161 => 0x95, 191 => 0x753dcbc0, 192 => 0x17, 205 => 0x50a, 210 => 0x103a, 225 => 0x2d, 248 => 0x49, 266 => 0x2a },
	'noisereduction2' => { 209 => 0x1010 },
	'noisereductionapplied' => { 86 => 0xc6f7 },
	'noisereductionintensity' => { 192 => 0x9 },
	'noisereductionmethod' => { 192 => 0x11 },
	'noisereductionmode' => { 280 => 0x801e },
	'noisereductionsharpness' => { 192 => 0xd },
	'noisereductionvalue' => { 280 => 0x8027 },
	'nomemorycard' => { 198 => '22.1', 199 => '0.3', 200 => '2.4', 201 => '33.7', 202 => '3.2', 203 => '0.3', 204 => '4.5' },
	'nominalmaxaperture' => { 242 => 0xa },
	'nominalminaperture' => { 242 => '10.1' },
	'notes' => { 281 => 'Notes', 285 => 'notes' },
	'npages' => { 316 => 'NPages' },
	'nrwdata' => { 161 => 0x14 },
	'nullrecord' => { 73 => 0x0 },
	'number' => { 302 => 'number' },
	'numberofbeats' => { 311 => 'numberOfBeats' },
	'numberoffocuspoints' => { 202 => '0.3' },
	'numfacepositions' => { 218 => 0x0 },
	'numindexentries' => { 95 => 0x54 },
	'object' => { 302 => 'object' },
	'objectattributereference' => { 93 => 0x4 },
	'objectcycle' => { 93 => 0x4b },
	'objectdistance' => { 82 => 0x6, 83 => 0x2022 },
	'objectname' => { 93 => 0x5 },
	'objectpreviewdata' => { 93 => 0xca },
	'objectpreviewfileformat' => { 93 => 0xc8 },
	'objectpreviewfileversion' => { 93 => 0xc9 },
	'objecttypereference' => { 93 => 0x3 },
	'oecfcolumns' => { 293 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 293 => [\'OECF','OECFNames'] },
	'oecfrows' => { 293 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 293 => [\'OECF','OECFValues'] },
	'offsetschema' => { 86 => 0xea1d },
	'okbutton' => { 202 => '15.1', 204 => '16.1' },
	'oldsubfiletype' => { 86 => 0xff },
	'olympusimageheight' => { 210 => 0x102f },
	'olympusimagewidth' => { 210 => 0x102e },
	'onetouchwb' => { 210 => 0x302 },
	'opticalzoom' => { 102 => 0xfa3d, 104 => [0x6006,0xf006], 105 => 0x1000, 106 => 0xf, 109 => 0x1e, 121 => 'OpticalZoom' },
	'opticalzoomcode' => { 55 => 0xa },
	'opticalzoommode' => { 225 => 0x34 },
	'opticalzoomon' => { 270 => 0x219 },
	'optionenddate' => { 304 => 'optionEndDate' },
	'opto-electricconvfactor' => { 293 => 'OECF' },
	'ordernumber' => { 90 => 0x8002 },
	'organisationinimagecode' => { 295 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 295 => 'OrganisationInImageName' },
	'organization' => { 302 => 'organization' },
	'orientation' => { 86 => 0x112, 227 => 0x112, 307 => 'Orientation' },
	'orientationlinkedafpoint' => { 60 => 0x516 },
	'originaldecisiondata' => { 84 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 44 => 0x83 },
	'originaldirectory' => { 222 => 0x408 },
	'originaldocumentid' => { 312 => 'OriginalDocumentID' },
	'originalfilename' => { 73 => 0x816, 98 => 0x3e9, 110 => 0x20, 222 => 0x407 },
	'originalimageheight' => { 56 => 0xc, 89 => 0x1 },
	'originalimagewidth' => { 56 => 0xb, 89 => 0x0 },
	'originalrawfiledata' => { 86 => 0xc68c },
	'originalrawfiledigest' => { 86 => 0xc71d },
	'originalrawfilename' => { 86 => 0xc68b },
	'originaltransmissionreference' => { 93 => 0x67 },
	'originatingprogram' => { 93 => 0x41 },
	'originplatform' => { 302 => 'originPlatform' },
	'os' => { 291 => 'os' },
	'otherconditions' => { 301 => 'OtherConditions' },
	'otherconstraints' => { 301 => 'OtherConstraints' },
	'otherimageinfo' => { 301 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 301 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 301 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 301 => 'OtherLicenseRequirements' },
	'outcue' => { 311 => 'outCue' },
	'outcuescale' => { 311 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 311 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 144 => 0x3 },
	'outputimagewidth' => { 144 => 0x2 },
	'outputresolution' => { 144 => 0x4 },
	'owner' => { 315 => 'Owner' },
	'ownerid' => { 93 => 0xbc },
	'ownername' => { 11 => 0x10f, 44 => 0x9, 73 => 0x810, 86 => [0xa430,0xfde8], 114 => 'OwnerName', 286 => 'OwnerName' },
	'padding' => { 86 => 0xea1c },
	'pageimage' => { 309 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 309 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 309 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 309 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 309 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 309 => 'PageInfo' },
	'pagename' => { 86 => 0x11d },
	'pagenumber' => { 86 => 0x129 },
	'pagerange' => { 302 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 289 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectioncontrast' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectionexposure' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionhue' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionmaskcenterweight' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskflow' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskradius' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskvalue' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskwhat' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskzerox' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionsaturation' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionsharpness' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectionwhat' => { 289 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 225 => 0x26 },
	'panasonicimageheight' => { 225 => 0x4c },
	'panasonicimagewidth' => { 225 => 0x4b },
	'panasonicrawversion' => { 227 => 0x1 },
	'panasonictitle' => { 86 => 0xc6d2 },
	'panasonictitle2' => { 86 => 0xc6d3 },
	'panoramacropbottom' => { 278 => 0x7 },
	'panoramacropleft' => { 278 => 0x4 },
	'panoramacropright' => { 278 => 0x6 },
	'panoramacroptop' => { 278 => 0x5 },
	'panoramadirection' => { 51 => 0x5, 278 => 0x3 },
	'panoramaframeheight' => { 278 => 0x9 },
	'panoramaframenumber' => { 51 => 0x2 },
	'panoramaframewidth' => { 278 => 0x8 },
	'panoramafullheight' => { 278 => 0x2 },
	'panoramafullwidth' => { 278 => 0x1 },
	'panoramamode' => { 100 => 0x3c, 205 => 0x601 },
	'panoramasourceheight' => { 278 => 0xb },
	'panoramasourcewidth' => { 278 => 0xa },
	'panoramicstitchcameramotion' => { 129 => 'PanoramicStitchCameraMotion', 130 => 0x1 },
	'panoramicstitchmaptype' => { 129 => 'PanoramicStitchMapType', 130 => 0x2 },
	'panoramicstitchphi0' => { 129 => 'PanoramicStitchPhi0', 130 => 0x5 },
	'panoramicstitchphi1' => { 129 => 'PanoramicStitchPhi1', 130 => 0x6 },
	'panoramicstitchtheta0' => { 129 => 'PanoramicStitchTheta0', 130 => 0x3 },
	'panoramicstitchtheta1' => { 129 => 'PanoramicStitchTheta1', 130 => 0x4 },
	'panoramicstitchversion' => { 130 => 0x0 },
	'pantry' => { 312 => 'Pantry' },
	'parallax' => { 90 => 0xb211 },
	'parametricdarks' => { 289 => 'ParametricDarks' },
	'parametrichighlights' => { 289 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 289 => 'ParametricHighlightSplit' },
	'parametriclights' => { 289 => 'ParametricLights' },
	'parametricmidtonesplit' => { 289 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 289 => 'ParametricShadows' },
	'parametricshadowsplit' => { 289 => 'ParametricShadowSplit' },
	'patientbirthdate' => { 282 => 'PatientDOB' },
	'patientid' => { 282 => 'PatientID' },
	'patientname' => { 282 => 'PatientName' },
	'patientsex' => { 282 => 'PatientSex' },
	'pdfversion' => { 299 => 'PDFVersion' },
	'pentaximagesize' => { 248 => 0x9 },
	'pentaxmodelid' => { 232 => 0x0, 248 => 0x5 },
	'pentaxmodeltype' => { 248 => 0x1 },
	'pentaxversion' => { 248 => 0x0 },
	'people' => { 284 => 'People' },
	'peripheralillumcentralradius' => { 280 => 0x8030 },
	'peripheralillumcentralvalue' => { 280 => 0x8031 },
	'peripheralillumination' => { 79 => 0x68 },
	'peripheralilluminationon' => { 79 => 0x64 },
	'peripheralillumperiphvalue' => { 280 => 0x8032 },
	'peripherallighting' => { 56 => 0x2 },
	'peripherallightingsetting' => { 57 => 0x5 },
	'peripherallightingvalue' => { 56 => 0x6 },
	'permissions' => { 304 => 'permissions' },
	'person' => { 302 => 'person' },
	'personinimage' => { 295 => 'PersonInImage' },
	'perspectivehorizontal' => { 289 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 289 => 'PerspectiveRotate' },
	'perspectivescale' => { 289 => 'PerspectiveScale' },
	'perspectivevertical' => { 289 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 68 => 0x1 },
	'pf10retainprogramshift' => { 68 => 0xb },
	'pf13drivepriority' => { 68 => 0xe },
	'pf14disablefocussearch' => { 68 => 0xf },
	'pf15disableafassistbeam' => { 68 => 0x10 },
	'pf16autofocuspointshoot' => { 68 => 0x11 },
	'pf17disableafpointsel' => { 68 => 0x12 },
	'pf18enableautoafpointsel' => { 68 => 0x13 },
	'pf19continuousshootspeed' => { 68 => 0x14 },
	'pf19shootingspeedhigh' => { 67 => 0xa },
	'pf19shootingspeedlow' => { 67 => 0x9 },
	'pf1disableshootingmodes' => { 68 => 0x2 },
	'pf1value' => { 67 => 0x1 },
	'pf20limitcontinousshots' => { 68 => 0x15 },
	'pf20maxcontinousshots' => { 67 => 0xb },
	'pf21enablequietoperation' => { 68 => 0x16 },
	'pf23felocktime' => { 67 => 0xd },
	'pf23postreleasetime' => { 67 => 0xe },
	'pf23settimerlengths' => { 68 => 0x18 },
	'pf23shutterbuttontime' => { 67 => 0xc },
	'pf24lightlcdduringbulb' => { 68 => 0x19 },
	'pf25aemode' => { 67 => 0xf },
	'pf25afmode' => { 67 => 0x12 },
	'pf25afpointsel' => { 67 => 0x13 },
	'pf25colormatrix' => { 67 => 0x17 },
	'pf25defaultclearsettings' => { 68 => 0x1a },
	'pf25drivemode' => { 67 => 0x11 },
	'pf25imagesize' => { 67 => 0x14 },
	'pf25meteringmode' => { 67 => 0x10 },
	'pf25parameters' => { 67 => 0x16 },
	'pf25wbmode' => { 67 => 0x15 },
	'pf26shortenreleaselag' => { 68 => 0x1b },
	'pf27reversedialrotation' => { 68 => 0x1c },
	'pf27value' => { 67 => 0x18 },
	'pf28noquickdialexpcomp' => { 68 => 0x1d },
	'pf29quickdialswitchoff' => { 68 => 0x1e },
	'pf2disablemeteringmodes' => { 68 => 0x3 },
	'pf2value' => { 67 => 0x2 },
	'pf30enlargementmode' => { 68 => 0x1f },
	'pf31originaldecisiondata' => { 68 => 0x20 },
	'pf3manualexposuremetering' => { 68 => 0x4 },
	'pf3value' => { 67 => 0x3 },
	'pf4exposuretimelimits' => { 68 => 0x5 },
	'pf4exposuretimemax' => { 67 => 0x5 },
	'pf4exposuretimemin' => { 67 => 0x4 },
	'pf5aperturelimits' => { 68 => 0x6 },
	'pf5aperturemax' => { 67 => 0x7 },
	'pf5aperturemin' => { 67 => 0x6 },
	'pf6presetshootingmodes' => { 68 => 0x7 },
	'pf7bracketcontinuousshoot' => { 68 => 0x8 },
	'pf8bracketshots' => { 67 => 0x8 },
	'pf8setbracketshots' => { 68 => 0x9 },
	'pf9changebracketsequence' => { 68 => 0xa },
	'phasedetectaf' => { 142 => 0x6 },
	'phonenumber' => { 115 => 'Phone' },
	'photoeffect' => { 25 => 0x28 },
	'photoeffecthistoryxml' => { 191 => 0xe9651831 },
	'photoeffects' => { 191 => 0xab5eca5e },
	'photoeffectsblue' => { 193 => 0x8 },
	'photoeffectsgreen' => { 193 => 0x6 },
	'photoeffectsred' => { 193 => 0x4 },
	'photoeffectstype' => { 193 => 0x0 },
	'photoinfoplayback' => { 198 => '17.6', 201 => '33.6' },
	'photometricinterpretation' => { 86 => 0x106, 307 => 'PhotometricInterpretation' },
	'photoshopquality' => { 256 => 0x0 },
	'pictinfo' => { 270 => 0x208 },
	'picturecontrol' => { 191 => 0xe2173c47 },
	'picturecontrolactive' => { 194 => 0x0 },
	'picturecontroladjust' => { 163 => 0x30 },
	'picturecontrolbase' => { 163 => 0x18 },
	'picturecontroldata' => { 161 => [0xbd,0x23] },
	'picturecontrolmode' => { 194 => 0x13 },
	'picturecontrolname' => { 163 => 0x4 },
	'picturecontrolquickadjust' => { 163 => 0x31 },
	'picturefinish' => { 133 => 0x71 },
	'picturemode' => { 90 => 0x1031, 205 => 0x520, 248 => [0xb,0x33], 271 => 0x3d },
	'picturemode2' => { 233 => 0x0 },
	'picturemodebwfilter' => { 205 => 0x525 },
	'picturemodecontrast' => { 205 => 0x523 },
	'picturemodehue' => { 205 => 0x522 },
	'picturemodesaturation' => { 205 => 0x521 },
	'picturemodesharpness' => { 205 => 0x524 },
	'picturemodetone' => { 205 => 0x526 },
	'picturestyle' => { 5 => [0x4b,0x51], 6 => 0x6c, 7 => 0x86, 8 => 0x73, 12 => 0xab, 13 => 0xa7, 14 => 0xb0, 15 => 0x6c, 16 => 0xa7, 18 => 0xb3, 53 => 0xa, 79 => 0x2 },
	'picturewizard' => { 268 => 0x21 },
	'pitchangle' => { 247 => 0x2 },
	'planarconfiguration' => { 86 => 0x11c, 307 => 'PlanarConfiguration' },
	'platenames' => { 316 => 'PlateNames' },
	'playbackmenustime' => { 200 => '20.1' },
	'playbackmonitorofftime' => { 201 => '8.1', 202 => '35.1', 204 => '21.1' },
	'playdisplay' => { 135 => 0x4e },
	'plusversion' => { 301 => 'Version' },
	'pngwarning' => { 216 => 'Warning' },
	'portraitoutputhighlightpoint' => { 79 => 0x1d },
	'portraitoutputshadowpoint' => { 79 => 0x1e },
	'portraitrawcolortone' => { 79 => 0x16 },
	'portraitrawcontrast' => { 79 => 0x18 },
	'portraitrawhighlight' => { 79 => 0x76 },
	'portraitrawhighlightpoint' => { 79 => 0x1b },
	'portraitrawlinear' => { 79 => 0x19 },
	'portraitrawsaturation' => { 79 => 0x17 },
	'portraitrawshadow' => { 79 => 0x7f },
	'portraitrawshadowpoint' => { 79 => 0x1c },
	'portraitrawsharpness' => { 79 => 0x1a },
	'portraitrefiner' => { 83 => 0x302b },
	'postalcode' => { 119 => 'PostalCode' },
	'postcropvignetteamount' => { 289 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 289 => 'PostCropVignetteFeather' },
	'postcropvignettemidpoint' => { 289 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 289 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 289 => 'PostCropVignetteStyle' },
	'powersource' => { 231 => '0.1' },
	'poweruptime' => { 161 => 0xb6 },
	'precaptureframes' => { 210 => 0x300 },
	'predictor' => { 86 => 0x13d },
	'preflashreturnstrength' => { 174 => 0x28a },
	'prefs' => { 93 => 0xdd, 255 => 'Prefs' },
	'preservedfilename' => { 312 => 'PreservedFileName' },
	'presetwhitebalance' => { 135 => 0x24, 280 => 0x8002 },
	'presetwhitebalanceadj' => { 280 => 0x8014 },
	'previewapplicationname' => { 86 => 0xc716 },
	'previewapplicationversion' => { 86 => 0xc717 },
	'previewbutton' => { 198 => ['14.1','15.1'], 201 => '29.1', 202 => '14.1' },
	'previewbuttonplusdials' => { 198 => ['14.2','15.2'], 201 => '31.2' },
	'previewcolorspace' => { 86 => 0xc71a },
	'previewcropbottom' => { 254 => 0xef },
	'previewcropleft' => { 254 => 0xec },
	'previewcropright' => { 254 => 0xee },
	'previewcroptop' => { 254 => 0xed },
	'previewdatetime' => { 86 => 0xc71b },
	'previewheight' => { 102 => 0xfa58 },
	'previewimage' => { 83 => 0x2000, 84 => 'PreviewImage', 87 => 'PreviewImage', 88 => 0x4, 124 => 'data', 136 => 0x81, 210 => 0x280, 223 => 0x300, 277 => 0x2001 },
	'previewimageborders' => { 248 => 0x3e },
	'previewimageheight' => { 52 => 0x4 },
	'previewimagelength' => { 52 => 0x2, 83 => 0x3, 86 => [0x117,0x202], 136 => 0x89, 164 => 0x202, 205 => 0x102, 210 => 0x1037, 248 => 0x3, 263 => 0x1e, 267 => 0x3, 271 => 0x1b, 274 => 0x202 },
	'previewimagename' => { 124 => '1Name' },
	'previewimagesize' => { 83 => 0x2, 107 => 0x2, 124 => 'ImageSize', 248 => 0x2, 271 => 0x1c, 277 => 0xb02c },
	'previewimagestart' => { 52 => 0x5, 83 => 0x4, 86 => [0x111,0x201], 136 => 0x88, 164 => 0x201, 205 => 0x101, 210 => 0x1036, 248 => 0x4, 263 => 0x1c, 267 => 0x2, 271 => 0x1a, 274 => 0x201 },
	'previewimagetype' => { 124 => '0Type' },
	'previewimagevalid' => { 205 => 0x100, 210 => 0x1035 },
	'previewimagewidth' => { 52 => 0x3 },
	'previewquality' => { 52 => 0x1 },
	'previewsettingsdigest' => { 86 => 0xc719 },
	'previewsettingsname' => { 86 => 0xc718 },
	'previewwidth' => { 102 => 0xfa57 },
	'primaryafpoint' => { 142 => 0x7 },
	'primarychromaticities' => { 86 => 0x13f, 307 => 'PrimaryChromaticities' },
	'printim' => { 86 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 135 => 0x1d, 272 => 0x28 },
	'privatertkinfo' => { 283 => 'privateRTKInfo' },
	'processingsoftware' => { 86 => 0xb },
	'processversion' => { 289 => 'ProcessVersion' },
	'producer' => { 214 => 'Producer', 299 => 'Producer' },
	'productid' => { 94 => 0x32 },
	'productioncode' => { 232 => 0x2 },
	'productorserviceconstraints' => { 301 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 86 => 0xc6f4 },
	'profilecopyright' => { 86 => 0xc6fe },
	'profileembedpolicy' => { 86 => 0xc6fd },
	'profilehuesatmapdata1' => { 86 => 0xc6fa },
	'profilehuesatmapdata2' => { 86 => 0xc6fb },
	'profilehuesatmapdims' => { 86 => 0xc6f9 },
	'profilelooktabledata' => { 86 => 0xc726 },
	'profilelooktabledims' => { 86 => 0xc725 },
	'profilename' => { 86 => 0xc6f8 },
	'profiletonecurve' => { 86 => 0xc6fc },
	'programiso' => { 225 => 0x3c },
	'programline' => { 233 => '1.1' },
	'programmode' => { 139 => 0x5 },
	'programshift' => { 161 => 0xd },
	'programversion' => { 93 => 0x46 },
	'projectname' => { 311 => 'projectName' },
	'projectref' => { 311 => 'projectRef' },
	'projectrefpath' => { 311 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 311 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 301 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 301 => 'PropertyReleaseStatus' },
	'province-state' => { 93 => 0x5f },
	'publicationdate' => { 302 => 'publicationDate' },
	'publicationname' => { 302 => 'publicationName' },
	'publisher' => { 290 => 'publisher' },
	'pulldown' => { 311 => 'pullDown' },
	'quality' => { 0 => 0x1, 25 => 0x3, 82 => 0x2, 83 => 0x3002, 90 => 0x1000, 100 => 0x9, 161 => 0x4, 181 => 0x3, 210 => 0x201, 220 => 0x300, 248 => 0x8, 253 => 0x2, 271 => 0x16, 272 => 0x56, 277 => [0x102,0xb047] },
	'qualitymode' => { 83 => 0x8 },
	'quantizationmethod' => { 95 => 0x78 },
	'quickadjust' => { 194 => 0x2a },
	'quickcontroldialinmeter' => { 60 => 0x703 },
	'quickshot' => { 270 => 0x213 },
	'rangefinder' => { 200 => '4.1' },
	'rasterizedcaption' => { 93 => 0x7d },
	'rating' => { 86 => 0x4746, 254 => 0xdf, 285 => 'rating', 291 => 'rating', 309 => 'Rating' },
	'ratingpercent' => { 86 => 0x4749, 131 => 'Rating' },
	'rawandjpgrecording' => { 58 => 0x8, 136 => 0x109, 233 => 0xd },
	'rawbrightnessadj' => { 78 => 0x38 },
	'rawcoloradj' => { 78 => 0x2e },
	'rawcropbottom' => { 254 => 0xd4 },
	'rawcropleft' => { 254 => 0xd1 },
	'rawcropright' => { 254 => 0xd3 },
	'rawcroptop' => { 254 => 0xd2 },
	'rawcustomsaturation' => { 78 => 0x30 },
	'rawcustomtone' => { 78 => 0x34 },
	'rawdatauniqueid' => { 86 => 0xc65d },
	'rawdepth' => { 138 => 0x10 },
	'rawdevautogradation' => { 212 => 0x119 },
	'rawdevcolorspace' => { 211 => 0x108, 212 => 0x109 },
	'rawdevcontrastvalue' => { 211 => 0x106, 212 => 0x105 },
	'rawdeveditstatus' => { 211 => 0x10b },
	'rawdevengine' => { 211 => 0x109, 212 => 0x10b },
	'rawdevexposurebiasvalue' => { 211 => 0x100, 212 => 0x100 },
	'rawdevgradation' => { 212 => 0x112 },
	'rawdevgraypoint' => { 211 => 0x103, 212 => 0x104 },
	'rawdevmemorycoloremphasis' => { 211 => 0x105, 212 => 0x108 },
	'rawdevnoisereduction' => { 211 => 0x10a, 212 => 0x10a },
	'rawdevpicturemode' => { 212 => 0x10c },
	'rawdevpm_bwfilter' => { 212 => 0x110 },
	'rawdevpmcontrast' => { 212 => 0x10e },
	'rawdevpmnoisefilter' => { 212 => 0x120 },
	'rawdevpmpicturetone' => { 212 => 0x111 },
	'rawdevpmsaturation' => { 212 => 0x10d },
	'rawdevpmsharpness' => { 212 => 0x10f },
	'rawdevsaturation3' => { 212 => 0x113 },
	'rawdevsaturationemphasis' => { 211 => 0x104, 212 => 0x107 },
	'rawdevsettings' => { 211 => 0x10c },
	'rawdevsharpnessvalue' => { 211 => 0x107, 212 => 0x106 },
	'rawdevversion' => { 211 => 0x0, 212 => 0x0 },
	'rawdevwbfineadjustment' => { 211 => 0x102, 212 => 0x103 },
	'rawdevwhitebalance' => { 212 => 0x101 },
	'rawdevwhitebalancevalue' => { 211 => 0x101, 212 => 0x102 },
	'rawfile' => { 86 => 0xfe4c },
	'rawfilename' => { 289 => 'RawFileName' },
	'rawimagecenter' => { 161 => 0x99 },
	'rawimagedigest' => { 86 => 0xc71c },
	'rawimagesize' => { 248 => 0x39 },
	'rawinfoversion' => { 213 => 0x0 },
	'rawjpgheight' => { 75 => 0x4 },
	'rawjpgquality' => { 39 => 0x6, 75 => 0x1 },
	'rawjpgsize' => { 39 => 0x7, 75 => 0x2 },
	'rawjpgwidth' => { 75 => 0x3 },
	'rawmeasuredrggb' => { 30 => 0x26a, 32 => 0x280, 34 => 0x194 },
	'reardisplay' => { 198 => '12.3' },
	'recognizedface1age' => { 219 => 0x20 },
	'recognizedface1name' => { 219 => 0x4 },
	'recognizedface1position' => { 219 => 0x18 },
	'recognizedface2age' => { 219 => 0x50 },
	'recognizedface2name' => { 219 => 0x34 },
	'recognizedface2position' => { 219 => 0x48 },
	'recognizedface3age' => { 219 => 0x80 },
	'recognizedface3name' => { 219 => 0x64 },
	'recognizedface3position' => { 219 => 0x78 },
	'recognizedfaceflags' => { 225 => 0x63 },
	'recommendedexposureindex' => { 86 => 0x8832 },
	'recorddisplay' => { 135 => 0x4d },
	'recordid' => { 73 => 0x1804 },
	'recordingmode' => { 82 => 0x1, 253 => 0x1 },
	'recordmode' => { 25 => 0x9, 83 => 0x3000 },
	'recordshutterrelease' => { 270 => 0x217 },
	'redbalance' => { 149 => 0x270, 210 => 0x1017, 227 => 0x11, 248 => 0x1c },
	'redcurvelimits' => { 78 => 0x18a },
	'redcurvepoints' => { 78 => 0x160 },
	'redeyecorrection' => { 195 => 0x0 },
	'redeyeinfo' => { 289 => 'RedEyeInfo' },
	'redeyereduction' => { 135 => 0x41 },
	'redhue' => { 289 => 'RedHue' },
	'redsaturation' => { 289 => 'RedSaturation' },
	'reductionmatrix1' => { 86 => 0xc625 },
	'reductionmatrix2' => { 86 => 0xc626 },
	'referenceblackwhite' => { 86 => 0x214, 307 => 'ReferenceBlackWhite' },
	'referencedate' => { 93 => 0x2f },
	'referencenumber' => { 93 => 0x32 },
	'references' => { 115 => 'References' },
	'referenceservice' => { 93 => 0x2d },
	'regionappliedtodimensions' => { 298 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 298 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 298 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 298 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 298 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 298 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 298 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 298 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 298 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 298 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 298 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 298 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 301 => 'RegionConstraints' },
	'regiondescription' => { 298 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 298 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 298 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 298 => 'Regions' },
	'regioninfomp' => { 128 => 'RegionInfo' },
	'regioninfompregions' => { 128 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 298 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 298 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 128 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionrectangle' => { 128 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionseealso' => { 298 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 298 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 295 => 'RegistryId' },
	'registryitemid' => { 295 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 295 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 113 => 'data' },
	'relatedaudiofilename' => { 113 => '1Name' },
	'relatedaudiofiletype' => { 113 => '0Type' },
	'relatedimagefileformat' => { 86 => 0x1000 },
	'relatedimageheight' => { 86 => 0x1002 },
	'relatedimagewidth' => { 86 => 0x1001 },
	'relatedsoundfile' => { 86 => 0xa004, 293 => 'RelatedSoundFile' },
	'relatedvideofile' => { 127 => 'data' },
	'relatedvideofilename' => { 127 => '1Name' },
	'relatedvideofiletype' => { 127 => '0Type' },
	'relation' => { 290 => 'relation' },
	'relativepeakaudiofilepath' => { 311 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 311 => 'relativeTimestamp' },
	'relativetimestampscale' => { 311 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 311 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 198 => '17.8', 201 => '33.8', 202 => '17.6' },
	'releasedate' => { 93 => 0x1e, 311 => 'releaseDate' },
	'releasemode' => { 83 => 0x3001, 277 => 0xb049 },
	'releasesetting' => { 73 => 0x1016 },
	'releasetime' => { 93 => 0x23 },
	'remoteonduration' => { 199 => '3.4', 200 => '17.2', 202 => '18.2', 203 => '4.3', 204 => '19.2' },
	'renditionclass' => { 312 => 'RenditionClass' },
	'renditionof' => { 312 => 'RenditionOf' },
	'renditionofalternatepaths' => { 312 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 312 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 312 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 312 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 312 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 312 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 312 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 312 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 312 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 312 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 312 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 312 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 312 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 312 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 312 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 312 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 312 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 312 => 'RenditionParams' },
	'repeatingflashcount' => { 153 => 0xd, 154 => 0xe, 155 => 0xe, 201 => '17.2', 202 => '24.2', 203 => '9.2', 204 => '25.2' },
	'repeatingflashoutput' => { 201 => '17.1', 202 => '24.1', 203 => '9.1', 204 => '25.1' },
	'repeatingflashrate' => { 153 => 0xc, 154 => 0xd, 155 => 0xd, 201 => '18.1', 202 => '25.1', 203 => '10.1', 204 => '26.1' },
	'resampleparams' => { 311 => 'resampleParams' },
	'resampleparamsquality' => { 311 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 270 => 0x21e },
	'resolution' => { 120 => 'Resolution' },
	'resolutionmode' => { 271 => 0x4 },
	'resolutionunit' => { 86 => 0x128, 96 => 0x2, 307 => 'ResolutionUnit' },
	'restrictions' => { 304 => 'restrictions' },
	'retouchhistory' => { 161 => 0x9e },
	'retouchinfo' => { 289 => 'RetouchInfo' },
	'reuse' => { 301 => 'Reuse' },
	'reuseallowed' => { 314 => 'ReuseAllowed' },
	'reuseprohibited' => { 304 => 'reuseProhibited' },
	'reverseindicators' => { 198 => '12.1', 200 => '4.3', 201 => '33.5', 202 => '5.1', 204 => '6.2' },
	'revision' => { 291 => 'revision' },
	'rgbcurvelimits' => { 78 => 0x238 },
	'rgbcurvepoints' => { 78 => 0x20e },
	'ricohdate' => { 263 => 0x6 },
	'ricohimageheight' => { 263 => 0x2 },
	'ricohimagewidth' => { 263 => 0x0 },
	'rightascension' => { 123 => 'RightAscension' },
	'rights' => { 290 => 'rights' },
	'rightsagent' => { 302 => 'rightsAgent', 304 => 'rightsAgent' },
	'rightsowner' => { 304 => 'rightsOwner' },
	'rollangle' => { 247 => 0x1 },
	'romoperationmode' => { 73 => 0x80d },
	'rotation' => { 22 => 0x17, 23 => 0x18, 72 => 0x3, 78 => 0x26e, 89 => 0x4, 123 => 'Rotation', 133 => [0x65,0x50], 134 => 0x46, 135 => 0x5a, 179 => '590.1', 191 => 0x76a43207, 225 => 0x30, 233 => '17.2', 254 => 0xd8, 272 => 0x3f, 273 => 0x3f },
	'routing' => { 259 => 'Routing' },
	'rowsperstrip' => { 86 => 0x116 },
	'rpp' => { 285 => 'rpp' },
	'safetyshift' => { 60 => 0x108 },
	'safetyshiftinavortv' => { 58 => 0x10, 59 => 0x10, 61 => 0xf, 62 => 0x10, 65 => 0x10 },
	'samplebits' => { 113 => 'SampleBits' },
	'samplerate' => { 113 => 'SampleRate' },
	'samplesperpixel' => { 86 => 0x115, 307 => 'SamplesPerPixel' },
	'samplestructure' => { 95 => 0x5a },
	'sanyoquality' => { 270 => 0x201 },
	'sanyothumbnail' => { 270 => 0x100 },
	'saturation' => { 6 => 0x6e, 8 => 0x76, 25 => 0xe, 35 => 0x1, 82 => 0xd, 83 => [0x3013,0x1f], 86 => [0xa409,0xfe55], 90 => 0x1003, 114 => 'Saturation', 132 => 0x1f, 133 => 0x32, 134 => 0x28, 135 => 0x1a, 139 => 0x1, 161 => [0x94,0xaa], 163 => 0x35, 225 => 0x40, 226 => 0x300d, 248 => 0x1f, 253 => 0xd, 260 => 0x27, 263 => 0x28, 271 => 0x10, 272 => 0x1e, 273 => 0x1b, 277 => 0x2005, 289 => 'Saturation', 293 => 'Saturation' },
	'saturationadj' => { 78 => 0x116, 190 => 0x1, 194 => 0x2e, 280 => 0x8016 },
	'saturationadjustmentaqua' => { 289 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 289 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 289 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 289 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 289 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 289 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 289 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 289 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 15 => 0xfe, 49 => 0x68, 50 => 0x68 },
	'saturationlandscape' => { 15 => 0xfc, 49 => 0x38, 50 => 0x38 },
	'saturationmonochrome' => { 49 => 0x80, 50 => 0x80 },
	'saturationneutral' => { 15 => 0xfd, 49 => 0x50, 50 => 0x50 },
	'saturationportrait' => { 15 => 0xfb, 49 => 0x20, 50 => 0x20 },
	'saturationsetting' => { 213 => 0x1010 },
	'saturationstandard' => { 15 => 0xfa, 49 => 0x8, 50 => 0x8 },
	'saturationunknown' => { 50 => 0x98 },
	'saturationuserdef1' => { 15 => 0x100, 49 => 0x98, 50 => 0xb0 },
	'saturationuserdef2' => { 15 => 0x101, 49 => 0xb0, 50 => 0xc8 },
	'saturationuserdef3' => { 15 => 0x102, 49 => 0xc8, 50 => 0xe0 },
	'saveid' => { 312 => 'SaveID' },
	'scaletype' => { 311 => 'scaleType' },
	'scanimageenhancer' => { 166 => 0x60 },
	'scanningdirection' => { 95 => 0x64 },
	'scene' => { 294 => 'Scene', 311 => 'scene' },
	'scenearea' => { 208 => 0x211, 210 => 0x1031 },
	'sceneassist' => { 161 => 0x9c },
	'scenecapturetype' => { 86 => 0xa406, 293 => 'SceneCaptureType' },
	'scenedetect' => { 208 => 0x210, 210 => 0x1030 },
	'scenedetectdata' => { 208 => 0x212, 210 => 0x1033 },
	'scenemode' => { 102 => 0xfa02, 136 => 0x100, 161 => 0x8f, 205 => 0x509, 210 => 0x403, 225 => 0x8001, 277 => 0xb023 },
	'scenemodeused' => { 104 => [0x6002,0xf002] },
	'sceneselect' => { 270 => 0x21f },
	'scenetype' => { 86 => 0xa301, 293 => 'SceneType' },
	'screentips' => { 198 => '12.7', 201 => '13.1', 202 => '4.4', 204 => '5.1' },
	'section' => { 302 => 'section' },
	'securityclassification' => { 86 => 0x9212 },
	'selectableafpoint' => { 60 => 0x509 },
	'selectafareaselectmode' => { 60 => 0x512 },
	'selftimer' => { 25 => 0x2, 225 => 0x2e, 270 => 0x214 },
	'selftimer2' => { 55 => 0x1d },
	'selftimerinterval' => { 202 => '19.2' },
	'selftimermode' => { 86 => 0x882b },
	'selftimershotcount' => { 200 => '18.2', 202 => '19.3', 204 => '20.2' },
	'selftimertime' => { 73 => 0x1806, 135 => 0x1f, 198 => '18.1', 199 => '3.3', 200 => '18.1', 201 => '7.2', 202 => '19.1', 203 => '3.3', 204 => '20.1' },
	'seminfo' => { 86 => 0x8546 },
	'sensingmethod' => { 86 => 0xa217, 293 => 'SensingMethod' },
	'sensitivityadjust' => { 248 => 0x40 },
	'sensitivitysteps' => { 233 => ['14.3','17.4'], 235 => 0x1 },
	'sensitivitytype' => { 86 => 0x8830 },
	'sensorareas' => { 268 => 0xa010 },
	'sensorbitdepth' => { 226 => 0x312d },
	'sensorbluelevel' => { 53 => 0x5 },
	'sensorcleaning' => { 66 => 0xd },
	'sensorfullheight' => { 97 => 0xf904 },
	'sensorfullwidth' => { 97 => 0xf903 },
	'sensorheight' => { 97 => 0xf901, 102 => 0xfa21, 138 => 0x8, 226 => 0x312c },
	'sensorpixelsize' => { 161 => 0x9a },
	'sensorredlevel' => { 53 => 0x4 },
	'sensorsize' => { 114 => 'SensorSize', 248 => 0x35 },
	'sensortemperature' => { 208 => 0x1500, 210 => 0x1007, 271 => 0x39 },
	'sensorwidth' => { 97 => 0xf900, 102 => 0xfa20, 138 => 0xa, 226 => 0x312b },
	'sequence' => { 260 => 0x7 },
	'sequencenumber' => { 55 => 0x9, 83 => 0x301c, 90 => 0x1101, 100 => 0x1d, 225 => 0x2b, 277 => 0xb04a },
	'sequenceshotinterval' => { 270 => 0x224 },
	'sequentialshot' => { 270 => 0x20e },
	'serialnumber' => { 44 => 0xc, 73 => 0x180b, 86 => [0xa431,0xfde9], 97 => 0xfa04, 99 => 0xfa00, 101 => 0xc354, 102 => 0xfa19, 111 => 0x0, 112 => 0xa8, 114 => 'SerialNumber', 161 => [0xa0,0x1d], 206 => 0x101, 210 => [0x404,0x101a], 220 => 0x303, 226 => 0x3103, 248 => 0x229, 260 => 0x15, 264 => 0x5, 271 => 0x2, 286 => 'SerialNumber' },
	'serialnumberformat' => { 44 => 0x15, 73 => 0x183b },
	'seriesdatetime' => { 282 => 'SeriesDateTime' },
	'seriesdescription' => { 282 => 'SeriesDescription' },
	'seriesmodality' => { 282 => 'SeriesModality' },
	'seriesnumber' => { 282 => 'SeriesNumber' },
	'serviceidentifier' => { 94 => 0x1e },
	'setbuttoncrosskeysfunc' => { 63 => 0x0, 64 => 0x0 },
	'setbuttonwhenshooting' => { 58 => 0x1, 60 => 0x704, 66 => 0xc },
	'setfunctionwhenshooting' => { 61 => 0x0, 62 => 0x1, 65 => 0x1 },
	'shadingcompensation' => { 205 => 0x50c },
	'shadingcompensation2' => { 209 => 0x1012 },
	'shadow' => { 271 => 0xe },
	'shadowcompensation' => { 248 => 0x79 },
	'shadowprotection' => { 190 => 0x0 },
	'shadows' => { 86 => 0xfe52, 289 => 'Shadows' },
	'shadowscale' => { 86 => 0xc633 },
	'shadowtint' => { 289 => 'ShadowTint' },
	'shakereduction' => { 249 => 0x1 },
	'sharpendetail' => { 289 => 'SharpenDetail' },
	'sharpenedgemasking' => { 289 => 'SharpenEdgeMasking' },
	'sharpening' => { 226 => 0x300b },
	'sharpeningadj' => { 194 => 0x2b },
	'sharpenradius' => { 289 => 'SharpenRadius' },
	'sharpness' => { 5 => [0x42,0x48], 6 => 0x72, 8 => 0x74, 25 => 0xf, 53 => 0x2, 82 => 0xb, 83 => [0x3011,0x21], 86 => [0xa40a,0xfe56], 90 => 0x1001, 100 => 0x6b, 109 => 0x37, 114 => 'Sharpness', 132 => 0x21, 133 => 0x30, 134 => 0x26, 135 => 0x18, 139 => 0x3, 161 => 0x6, 163 => 0x32, 210 => 0x100f, 225 => 0x41, 248 => 0x21, 253 => 0xb, 260 => 0x26, 263 => 0x22, 264 => 0x1003, 271 => 0x11, 272 => 0x1c, 273 => 0x19, 277 => 0x2006, 289 => 'Sharpness', 293 => 'Sharpness' },
	'sharpnessadj' => { 78 => 0x25a, 280 => 0x801a },
	'sharpnessfactor' => { 210 => 0x102a },
	'sharpnessfaithful' => { 15 => 0xf5, 49 => 0x64, 50 => 0x64 },
	'sharpnessfrequency' => { 5 => [0x41,0x47], 53 => 0x3 },
	'sharpnesslandscape' => { 15 => 0xf3, 49 => 0x34, 50 => 0x34 },
	'sharpnessmonochrome' => { 15 => 0xf6, 49 => 0x7c, 50 => 0x7c },
	'sharpnessneutral' => { 15 => 0xf4, 49 => 0x4c, 50 => 0x4c },
	'sharpnessovershoot' => { 280 => 0x801b },
	'sharpnessportrait' => { 15 => 0xf2, 49 => 0x1c, 50 => 0x1c },
	'sharpnesssetting' => { 205 => 0x506, 213 => 0x1013 },
	'sharpnessstandard' => { 15 => 0xf1, 49 => 0x4, 50 => 0x4 },
	'sharpnessthreshold' => { 280 => 0x801d },
	'sharpnessundershoot' => { 280 => 0x801c },
	'sharpnessunknown' => { 50 => 0x94 },
	'sharpnessuserdef1' => { 15 => 0xf7, 49 => 0x94, 50 => 0xac },
	'sharpnessuserdef2' => { 15 => 0xf8, 49 => 0xac, 50 => 0xc4 },
	'sharpnessuserdef3' => { 15 => 0xf9, 49 => 0xc4, 50 => 0xdc },
	'shootinginfodisplay' => { 198 => '13.2', 201 => '10.2', 202 => '4.1', 204 => '5.3' },
	'shootinginfomonitorofftime' => { 201 => '9.1', 202 => '21.2', 204 => '22.2' },
	'shootingmode' => { 114 => 'ShootingMode', 161 => 0x89, 225 => 0x1f },
	'shootingmodesetting' => { 199 => '5.1' },
	'shortdescription' => { 291 => 'shortdescription' },
	'shortdocumentid' => { 93 => 0xba },
	'shortfocal' => { 4 => 0xe4, 5 => 0xe, 6 => 0x11, 7 => 0x113, 8 => 0x11, 9 => [0x150,0x151], 10 => 0xd8, 12 => 0xf8, 13 => 0xec, 14 => 0x101, 15 => 0x93, 16 => 0xe8, 18 => 0xec, 19 => 0xea, 21 => 0xf0, 25 => 0x18 },
	'shortownername' => { 15 => 0xac },
	'shortreleasetimelag' => { 60 => 0x80d },
	'shotdate' => { 311 => 'shotDate' },
	'shotday' => { 311 => 'shotDay' },
	'shotlocation' => { 311 => 'shotLocation' },
	'shotname' => { 311 => 'shotName' },
	'shotnumber' => { 311 => 'shotNumber' },
	'shotsize' => { 311 => 'shotSize' },
	'shutter-aelock' => { 58 => 0x4, 60 => 0x701, 61 => 0x3, 62 => 0x4, 63 => 0x3, 64 => 0x3, 65 => 0x4, 66 => 0x2 },
	'shutteraelbutton' => { 59 => 0x4 },
	'shutterbuttonafonbutton' => { 60 => 0x701 },
	'shuttercount' => { 7 => 0x176, 39 => 0x1, 161 => 0xa7, 167 => [0x6a,0x157,0x24d], 168 => 0x286, 169 => 0x279, 170 => 0x284, 171 => 0x242, 172 => 0x280, 173 => 0x276, 174 => [0x27d,0x27f], 175 => 0x246, 176 => 0x2d6, 177 => 0x287, 178 => 0x320, 179 => 0x24a, 180 => 0x2d5, 248 => 0x5d },
	'shuttercurtainsync' => { 58 => 0xf, 59 => 0xf, 60 => 0x305, 61 => 0xe, 62 => 0xf, 63 => 0x8, 64 => 0x8, 65 => 0xf, 66 => 0x8 },
	'shuttermode' => { 100 => 0x1b },
	'shutterreleasebuttonae-l' => { 198 => '17.7', 200 => '16.1', 201 => '7.1', 202 => '17.5', 204 => '18.2' },
	'shutterreleasemethod' => { 73 => 0x1010 },
	'shutterreleasenocfcard' => { 58 => 0x2, 59 => 0x2, 66 => 0xf },
	'shutterreleasetiming' => { 73 => 0x1011 },
	'shutterspeedrange' => { 60 => 0x10c },
	'shutterspeedvalue' => { 69 => 0x1, 86 => 0x9201, 210 => 0x1000, 293 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 300 => 'SidecarForExtension' },
	'similarityindex' => { 93 => 0xe4 },
	'singleframebracketing' => { 135 => 0x21 },
	'slaveflashmeteringsegments' => { 248 => 0x20b },
	'slowshutter' => { 55 => 0x8 },
	'slowsync' => { 90 => 0x1030 },
	'smartrange' => { 268 => 0xa012 },
	'smoothness' => { 86 => 0xfe57, 289 => 'Smoothness' },
	'software' => { 86 => 0x131, 115 => 'Software', 216 => 'Software', 271 => 0x18, 307 => 'Software' },
	'softwareversion' => { 270 => 0x207 },
	'sonydatetime' => { 279 => 0x6 },
	'sonyimagesize' => { 135 => 0x3b, 272 => 0x54, 273 => 0x54 },
	'sonymodelid' => { 277 => 0xb001 },
	'sonyquality' => { 135 => 0x3c },
	'source' => { 93 => 0x73, 216 => 'Source', 290 => 'source', 291 => 'source', 300 => 'Source' },
	'sourcedirectoryindex' => { 239 => 0x0 },
	'sourcefileindex' => { 239 => 0x2 },
	'spatialfrequencyresponse' => { 293 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 293 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 293 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 293 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 293 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 311 => 'speakerPlacement' },
	'specialeffectlevel' => { 83 => 0x3030 },
	'specialeffectmode' => { 83 => 0x2076 },
	'specialeffectsetting' => { 83 => 0x3031 },
	'specialinstructions' => { 93 => 0x28 },
	'specialmode' => { 210 => 0x200, 270 => 0x200 },
	'spectralsensitivity' => { 86 => 0x8824, 293 => 'SpectralSensitivity' },
	'splittoningbalance' => { 289 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 289 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 289 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 289 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 289 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 132 => 0x2d },
	'spotfocuspointy' => { 132 => 0x2e },
	'spotmeteringmode' => { 25 => 0x27 },
	'spotmeterlinktoafpoint' => { 60 => 0x107 },
	'sractive' => { 233 => '17.1' },
	'srawquality' => { 25 => 0x2e },
	'srfocallength' => { 249 => 0x3 },
	'srhalfpresstime' => { 249 => 0x2 },
	'srresult' => { 249 => 0x0 },
	'standardoutputhighlightpoint' => { 79 => 0x14 },
	'standardoutputsensitivity' => { 86 => 0x8831 },
	'standardoutputshadowpoint' => { 79 => 0x15 },
	'standardrawcolortone' => { 79 => 0xd },
	'standardrawcontrast' => { 79 => 0xf },
	'standardrawhighlight' => { 79 => 0x75 },
	'standardrawhighlightpoint' => { 79 => 0x12 },
	'standardrawlinear' => { 79 => 0x10 },
	'standardrawsaturation' => { 79 => 0xe },
	'standardrawshadow' => { 79 => 0x7e },
	'standardrawshadowpoint' => { 79 => 0x13 },
	'standardrawsharpness' => { 79 => 0x11 },
	'startingpage' => { 302 => 'startingPage' },
	'startmovieshooting' => { 60 => 0x70d },
	'starttimecode' => { 311 => 'startTimecode' },
	'starttimecodetimeformat' => { 311 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 311 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 311 => [\'startTimecode','startTimecodeValue'] },
	'state' => { 119 => 'State', 225 => 0x6b, 300 => 'State' },
	'status' => { 284 => 'Status' },
	'storagemethod' => { 138 => 0x12 },
	'straightenangle' => { 191 => 0x2fc08431 },
	'stretchmode' => { 311 => 'stretchMode' },
	'studydatetime' => { 282 => 'StudyDateTime' },
	'studydescription' => { 282 => 'StudyDescription' },
	'studyid' => { 282 => 'StudyID' },
	'studyphysician' => { 282 => 'StudyPhysician' },
	'sub-location' => { 93 => 0x5c },
	'subfiledata' => { 122 => 'data' },
	'subfiledirectory' => { 122 => '1Directory' },
	'subfilemimetype' => { 122 => '2MIME' },
	'subfilename' => { 122 => '1Name' },
	'subfileresource' => { 122 => 'rsrc' },
	'subfiletype' => { 86 => 0xfe, 122 => '0Type' },
	'subject' => { 214 => 'Subject', 259 => 'Subject', 290 => 'subject', 299 => 'Subject' },
	'subjectarea' => { 86 => 0x9214, 293 => 'SubjectArea' },
	'subjectcode' => { 294 => 'SubjectCode' },
	'subjectdistance' => { 86 => 0x9206, 100 => 0x3e, 293 => 'SubjectDistance' },
	'subjectdistancerange' => { 86 => 0xa40c, 293 => 'SubjectDistanceRange' },
	'subjectlocation' => { 86 => 0xa214, 293 => 'SubjectLocation' },
	'subjectprogram' => { 132 => 0x22 },
	'subjectreference' => { 93 => 0xc },
	'subsectime' => { 86 => 0x9290 },
	'subsectimedigitized' => { 86 => 0x9292 },
	'subsectimeoriginal' => { 86 => 0x9291 },
	'subsection1' => { 302 => 'subsection1' },
	'subsection2' => { 302 => 'subsection2' },
	'subsection3' => { 302 => 'subsection3' },
	'subsection4' => { 302 => 'subsection4' },
	'superimposeddisplay' => { 58 => 0xa, 60 => 0x510, 61 => 0x9, 62 => 0xa, 65 => 0xa, 66 => 0xe },
	'supermacro' => { 44 => 0x1a },
	'supplementalcategories' => { 93 => 0x14, 300 => 'SupplementalCategories' },
	'supplementaltype' => { 95 => 0x37 },
	'svisosetting' => { 233 => 0x14 },
	'switchtoregisteredafpoint' => { 59 => 0x12, 60 => 0x50a },
	'tagged' => { 254 => 0xdd, 285 => 'tagged' },
	'tagslist' => { 292 => 'TagsList' },
	'takenumber' => { 311 => 'takeNumber' },
	'tapename' => { 311 => 'tapeName' },
	'targetaperture' => { 55 => 0x4 },
	'targetcompressionratio' => { 71 => 0x1 },
	'targetdistancesetting' => { 73 => 0x1807 },
	'targetexposuretime' => { 55 => 0x5 },
	'targetimagetype' => { 73 => 0x100a },
	'teaser' => { 302 => 'teaser' },
	'teleconverter' => { 136 => 0x105, 277 => 0x105 },
	'tempo' => { 311 => 'tempo' },
	'termsandconditionstext' => { 301 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 301 => 'TermsAndConditionsURL' },
	'textlayername' => { 300 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 300 => 'TextLayers' },
	'textlayertext' => { 300 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 225 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 86 => 0x107 },
	'thumbnailfilename' => { 73 => 0x817 },
	'thumbnailformat' => { 309 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 102 => 0xfa55, 309 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 73 => 0x2008, 84 => 'ThumbnailImage', 88 => 0x3, 125 => 'data', 210 => 0x100, 309 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 125 => '1Name' },
	'thumbnailimagesize' => { 125 => 'ImageSize' },
	'thumbnailimagetype' => { 125 => '0Type' },
	'thumbnailimagevalidarea' => { 44 => 0x13 },
	'thumbnaillength' => { 86 => 0x202 },
	'thumbnailoffset' => { 86 => 0x201 },
	'thumbnails' => { 309 => 'Thumbnails' },
	'thumbnailwidth' => { 102 => 0xfa54, 309 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 302 => 'ticker' },
	'tilelength' => { 86 => 0x143 },
	'tilewidth' => { 86 => 0x142 },
	'time' => { 98 => 0x401, 248 => 0x7 },
	'timecreated' => { 93 => 0x3c, 100 => 0x14, 109 => 0x10, 255 => 'TimeCreated' },
	'timeperiod' => { 302 => 'timePeriod' },
	'timerfunctionbutton' => { 199 => '5.2', 200 => '12.1' },
	'timerlength' => { 60 => 0x80c },
	'timescaleparams' => { 311 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 311 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 311 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 311 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 94 => 0x50 },
	'timesignature' => { 311 => 'timeSignature' },
	'timesincepoweron' => { 225 => 0x29 },
	'timestamp' => { 7 => 0x45e, 15 => 0x11c, 216 => 'TimeStamp' },
	'timestamp1' => { 7 => 0x45a },
	'timezone' => { 183 => 0x0 },
	'timezonecode' => { 76 => 0x1 },
	'timezoneinfo' => { 76 => 0x2 },
	'timezoneoffset' => { 86 => 0x882a },
	'tint' => { 289 => 'Tint' },
	'title' => { 115 => 'Title', 214 => 'Title', 216 => 'Title', 225 => 0x65, 259 => 'Title', 290 => 'title', 299 => 'Title' },
	'tonecomp' => { 161 => 0x81 },
	'tonecurve' => { 53 => 0x1, 248 => 0x402, 289 => 'ToneCurve' },
	'tonecurve1' => { 268 => 0xa040 },
	'tonecurve2' => { 268 => 0xa041 },
	'tonecurve3' => { 268 => 0xa042 },
	'tonecurve4' => { 268 => 0xa043 },
	'tonecurveactive' => { 78 => 0x110 },
	'tonecurvebluex' => { 280 => 0x9003 },
	'tonecurvebluey' => { 280 => 0x9007 },
	'tonecurvebrightnessx' => { 280 => 0x9000 },
	'tonecurvebrightnessy' => { 280 => 0x9004 },
	'tonecurvefilename' => { 98 => 0x1391 },
	'tonecurvegreenx' => { 280 => 0x9002 },
	'tonecurvegreeny' => { 280 => 0x9006 },
	'tonecurveinterpolation' => { 78 => 0x159 },
	'tonecurvemode' => { 78 => 0x113 },
	'tonecurvename' => { 289 => 'ToneCurveName' },
	'tonecurveproperty' => { 78 => 0x3c },
	'tonecurveredx' => { 280 => 0x9001 },
	'tonecurveredy' => { 280 => 0x9005 },
	'tonecurves' => { 248 => 0x403 },
	'toningeffect' => { 39 => 0xf, 161 => 0xb3, 163 => 0x38 },
	'toningeffectfaithful' => { 49 => 0x74, 50 => 0x74 },
	'toningeffectlandscape' => { 49 => 0x44, 50 => 0x44 },
	'toningeffectmonochrome' => { 15 => 0x108, 49 => 0x8c, 50 => 0x8c },
	'toningeffectneutral' => { 49 => 0x5c, 50 => 0x5c },
	'toningeffectportrait' => { 49 => 0x2c, 50 => 0x2c },
	'toningeffectstandard' => { 49 => 0x14, 50 => 0x14 },
	'toningeffectunknown' => { 50 => 0xa4 },
	'toningeffectuserdef1' => { 49 => 0xa4, 50 => 0xbc },
	'toningeffectuserdef2' => { 49 => 0xbc, 50 => 0xd4 },
	'toningeffectuserdef3' => { 49 => 0xd4, 50 => 0xec },
	'toningsaturation' => { 163 => 0x39 },
	'totalzoom' => { 100 => 0x62 },
	'tracknumber' => { 311 => 'trackNumber' },
	'tracks' => { 311 => 'Tracks' },
	'tracksframerate' => { 311 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 311 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 311 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 311 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 311 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 311 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 311 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 311 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 311 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 311 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 311 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 311 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 311 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 311 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 311 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 311 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 311 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 122 => 'zmie' },
	'transferfunction' => { 86 => 0x12d, 307 => 'TransferFunction' },
	'transform' => { 225 => [0x8012,0x59] },
	'transmissionreference' => { 300 => 'TransmissionReference' },
	'trapped' => { 214 => 'Trapped', 299 => 'Trapped' },
	'travelday' => { 225 => 0x36 },
	'triggermode' => { 260 => 0x6 },
	'ttl_da_adown' => { 240 => 0x5 },
	'ttl_da_aup' => { 240 => 0x4 },
	'ttl_da_bdown' => { 240 => 0x7 },
	'ttl_da_bup' => { 240 => 0x6 },
	'tungstenawb' => { 230 => 0x1 },
	'tvexposuretimesetting' => { 233 => 0x12 },
	'type' => { 290 => 'type', 306 => 'type' },
	'uniquecameramodel' => { 86 => 0xc614 },
	'uniquedocumentid' => { 93 => 0xbb },
	'uniqueobjectname' => { 94 => 0x64 },
	'unknownblock' => { 209 => 0x1103 },
	'unknowncontrast' => { 79 => 0x45 },
	'unknownev' => { 98 => 0x1 },
	'unknownlinear' => { 79 => 0x46 },
	'unknownmode' => { 83 => 0x301b },
	'unknownnumber' => { 73 => 0x180b },
	'unknownoutputhighlightpoint' => { 79 => 0x4a },
	'unknownoutputshadowpoint' => { 79 => 0x4b },
	'unknownrawhighlight' => { 79 => 0x7b },
	'unknownrawhighlightpoint' => { 79 => 0x48 },
	'unknownrawshadow' => { 79 => 0x84 },
	'unknownrawshadowpoint' => { 79 => 0x49 },
	'unknownsharpness' => { 79 => 0x47 },
	'unsharp1color' => { 196 => 0x13 },
	'unsharp1halowidth' => { 196 => 0x19 },
	'unsharp1intensity' => { 196 => 0x17 },
	'unsharp1threshold' => { 196 => 0x1b },
	'unsharp2color' => { 196 => 0x2e },
	'unsharp2halowidth' => { 196 => 0x34 },
	'unsharp2intensity' => { 196 => 0x32 },
	'unsharp2threshold' => { 196 => 0x36 },
	'unsharp3color' => { 196 => 0x49 },
	'unsharp3halowidth' => { 196 => 0x4f },
	'unsharp3intensity' => { 196 => 0x4d },
	'unsharp3threshold' => { 196 => 0x51 },
	'unsharp4color' => { 196 => 0x64 },
	'unsharp4halowidth' => { 196 => 0x6a },
	'unsharp4intensity' => { 196 => 0x68 },
	'unsharp4threshold' => { 196 => 0x6c },
	'unsharpcount' => { 196 => 0x0 },
	'unsharpmask' => { 79 => 0x90, 191 => 0x76a43200 },
	'unsharpmaskfineness' => { 79 => 0x94 },
	'unsharpmaskstrength' => { 79 => 0x92 },
	'unsharpmaskthreshold' => { 79 => 0x96 },
	'urgency' => { 93 => 0xa, 300 => 'Urgency' },
	'url' => { 115 => 'URL', 216 => 'URL', 257 => 0x40b, 302 => 'url' },
	'usablemeteringmodes' => { 60 => 0x10a },
	'usableshootingmodes' => { 60 => 0x109 },
	'usage' => { 303 => 'usage' },
	'usagefee' => { 304 => 'usageFee' },
	'usageterms' => { 315 => 'UsageTerms' },
	'usercomment' => { 73 => 0x805, 86 => 0x9286, 293 => 'UserComment' },
	'userdef1picturestyle' => { 15 => 0x10c, 49 => 0xd8, 50 => 0xf0 },
	'userdef2picturestyle' => { 15 => 0x10e, 49 => 0xda, 50 => 0xf2 },
	'userdef3picturestyle' => { 15 => 0x110, 49 => 0xdc, 50 => 0xf4 },
	'userfields' => { 284 => 'UserFields' },
	'userlabel' => { 260 => 0x2b },
	'userprofile' => { 220 => 0x302, 226 => 0x3038 },
	'usmlenselectronicmf' => { 59 => 0x7, 60 => 0x501 },
	'utmeasting' => { 126 => 'Easting' },
	'utmmapdatum' => { 126 => 'Datum' },
	'utmnorthing' => { 126 => 'Northing' },
	'utmzone' => { 126 => 'Zone' },
	'uv-irfiltercorrection' => { 220 => 0x325 },
	'validbits' => { 209 => 0x611, 210 => 0x102c },
	'validpixeldepth' => { 213 => 0x611 },
	'variousmodes' => { 100 => 0x26 },
	'variousmodes2' => { 100 => 0x3a },
	'variprogram' => { 161 => 0xab },
	'version' => { 90 => 0x0, 259 => 'Version', 289 => 'Version' },
	'versioncreatedate' => { 280 => 0xd100 },
	'versionid' => { 312 => 'VersionID' },
	'versionidentifier' => { 302 => 'versionIdentifier' },
	'versionmodifydate' => { 280 => 0xd101 },
	'versions' => { 312 => 'Versions' },
	'versionscomments' => { 312 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 312 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 312 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 312 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 312 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 312 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 312 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 312 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 312 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 312 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 312 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 198 => '3.2' },
	'vfdisplayillumination' => { 60 => 0x510 },
	'vibrance' => { 289 => 'Vibrance' },
	'vibrationreduction' => { 167 => [0x75,0x82,0x1ae], 175 => '586.1', 179 => '590.2', 182 => 0x4 },
	'videoalphamode' => { 311 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 311 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 311 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 311 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 311 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 311 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 311 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 311 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 311 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 311 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 311 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 311 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 311 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortype' => { 311 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 311 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 311 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 47 => 0x74 },
	'videocolorspace' => { 311 => 'videoColorSpace' },
	'videocompressor' => { 311 => 'videoCompressor' },
	'videofieldorder' => { 311 => 'videoFieldOrder' },
	'videoframerate' => { 311 => 'videoFrameRate' },
	'videoframesize' => { 311 => 'videoFrameSize' },
	'videoframesizeh' => { 311 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 311 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 311 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 311 => 'videoModDate' },
	'videopixelaspectratio' => { 311 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 311 => 'videoPixelDepth' },
	'videoquality' => { 83 => 0x4003 },
	'viewfinderdisplay' => { 198 => '12.4' },
	'viewfinderwarning' => { 198 => '13.4', 202 => '3.5', 203 => '6.2', 204 => '4.4' },
	'viewinfoduringexposure' => { 60 => 0x407 },
	'vignetteamount' => { 289 => 'VignetteAmount' },
	'vignettecontrol' => { 161 => 0x2a, 191 => 0x76a43205 },
	'vignettecontrolintensity' => { 191 => 0xac6bd5c0 },
	'vignettemidpoint' => { 289 => 'VignetteMidpoint' },
	'voicememo' => { 270 => 0x216 },
	'volume' => { 302 => 'volume' },
	'vr_0x66' => { 167 => 0x66 },
	'vrdoffset' => { 44 => 0xd0 },
	'wb_bluepresetsfluorescent' => { 137 => 0x40a },
	'wb_gbrglevels' => { 137 => 0xae, 140 => 0x4 },
	'wb_glevel' => { 209 => 0x11f },
	'wb_glevel3000k' => { 209 => 0x113 },
	'wb_glevel3300k' => { 209 => 0x114 },
	'wb_glevel3600k' => { 209 => 0x115 },
	'wb_glevel3900k' => { 209 => 0x116 },
	'wb_glevel4000k' => { 209 => 0x117 },
	'wb_glevel4300k' => { 209 => 0x118 },
	'wb_glevel4500k' => { 209 => 0x119 },
	'wb_glevel4800k' => { 209 => 0x11a },
	'wb_glevel5300k' => { 209 => 0x11b },
	'wb_glevel6000k' => { 209 => 0x11c },
	'wb_glevel6600k' => { 209 => 0x11d },
	'wb_glevel7500k' => { 209 => 0x11e },
	'wb_grbglevels' => { 148 => 0x0 },
	'wb_rbgglevels' => { 145 => 0x0 },
	'wb_rblevels' => { 161 => 0xc, 209 => 0x100 },
	'wb_rblevels3000k' => { 209 => 0x102 },
	'wb_rblevels3300k' => { 209 => 0x103 },
	'wb_rblevels3600k' => { 209 => 0x104 },
	'wb_rblevels3900k' => { 209 => 0x105 },
	'wb_rblevels4000k' => { 209 => 0x106 },
	'wb_rblevels4300k' => { 209 => 0x107 },
	'wb_rblevels4500k' => { 209 => 0x108 },
	'wb_rblevels4800k' => { 209 => 0x109 },
	'wb_rblevels5300k' => { 209 => 0x10a },
	'wb_rblevels6000k' => { 209 => 0x10b },
	'wb_rblevels6600k' => { 209 => 0x10c },
	'wb_rblevels7500k' => { 209 => 0x10d },
	'wb_rblevelsauto' => { 213 => 0x110 },
	'wb_rblevelscloudy' => { 139 => 0x10, 213 => 0x121 },
	'wb_rblevelscoolwhitef' => { 139 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 213 => 0x132 },
	'wb_rblevelscwb1' => { 209 => 0x10e },
	'wb_rblevelscwb2' => { 209 => 0x10f },
	'wb_rblevelscwb3' => { 209 => 0x110 },
	'wb_rblevelscwb4' => { 209 => 0x111 },
	'wb_rblevelsdaylight' => { 139 => 0xc },
	'wb_rblevelsdaylightf' => { 139 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 213 => 0x130 },
	'wb_rblevelsdaywhitef' => { 139 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 213 => 0x131 },
	'wb_rblevelseveningsunlight' => { 213 => 0x124 },
	'wb_rblevelsfineweather' => { 213 => 0x122 },
	'wb_rblevelsflash' => { 139 => 0x18 },
	'wb_rblevelsshade' => { 139 => 0x20, 213 => 0x120 },
	'wb_rblevelstungsten' => { 139 => 0x8, 213 => 0x123 },
	'wb_rblevelsunknown' => { 139 => 0x1c },
	'wb_rblevelsused' => { 213 => 0x100 },
	'wb_rblevelswhitef' => { 139 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 213 => 0x133 },
	'wb_rbpresetcloudy' => { 137 => 0x3f0 },
	'wb_rbpresetcoolwhitef' => { 137 => 0x308 },
	'wb_rbpresetcustom' => { 137 => 0x424 },
	'wb_rbpresetdaylight' => { 137 => 0x3ec },
	'wb_rbpresetflash' => { 137 => [0x3f4,0x304] },
	'wb_rbpresetshade' => { 137 => 0x418 },
	'wb_rbpresettungsten' => { 137 => 0x3e8 },
	'wb_redpresetsfluorescent' => { 137 => 0x3fc },
	'wb_rgbglevels' => { 147 => 0x0 },
	'wb_rgblevels' => { 137 => 0x96, 221 => 0xd, 222 => 0x413, 226 => 0x3036 },
	'wb_rggblevels' => { 140 => 0x4, 146 => 0x0 },
	'wb_rggblevelsasshot' => { 28 => 0x0, 29 => 0x19, 30 => 0x22, 31 => 0x3f, 34 => 0x3f },
	'wb_rggblevelsauto' => { 26 => 0x0, 28 => 0x5, 29 => 0x1e, 30 => 0x18, 31 => 0x44, 34 => 0x44, 268 => 0xa022 },
	'wb_rggblevelsblack' => { 268 => 0xa028 },
	'wb_rggblevelscloudy' => { 26 => 0xc, 28 => 0x1e, 29 => 0x2d, 30 => 0x31, 31 => 0x58, 34 => 0x71, 248 => 0x20f },
	'wb_rggblevelscustom' => { 26 => 0x1c, 31 => 0x80 },
	'wb_rggblevelscustom1' => { 29 => 0x41 },
	'wb_rggblevelscustom2' => { 29 => 0x46 },
	'wb_rggblevelsdaylight' => { 26 => 0x4, 28 => 0x14, 29 => 0x23, 30 => 0x27, 31 => 0x4e, 34 => 0x67, 248 => 0x20d },
	'wb_rggblevelsflash' => { 26 => 0x18, 28 => 0x32, 29 => 0x3c, 30 => 0x45, 31 => 0x6c, 34 => 0x85, 248 => 0x214 },
	'wb_rggblevelsfluorescent' => { 26 => 0x14, 28 => 0x28, 29 => 0x37, 30 => 0x3b, 31 => 0x62, 34 => 0x7b },
	'wb_rggblevelsfluorescentd' => { 248 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 248 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 248 => 0x213 },
	'wb_rggblevelsilluminator1' => { 268 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 268 => 0xa024 },
	'wb_rggblevelskelvin' => { 26 => 0x20, 28 => 0x2d, 30 => 0x40, 31 => 0x67, 34 => 0x80 },
	'wb_rggblevelsmeasured' => { 28 => 0xa, 31 => 0x49, 34 => 0x49 },
	'wb_rggblevelspc1' => { 30 => 0x90, 31 => 0x71 },
	'wb_rggblevelspc2' => { 30 => 0x95, 31 => 0x76 },
	'wb_rggblevelspc3' => { 30 => 0x9a, 31 => 0x7b },
	'wb_rggblevelsshade' => { 26 => 0x8, 28 => 0x19, 29 => 0x28, 30 => 0x2c, 31 => 0x53, 34 => 0x6c, 248 => 0x20e },
	'wb_rggblevelstungsten' => { 26 => 0x10, 28 => 0x23, 29 => 0x32, 30 => 0x36, 31 => 0x5d, 34 => 0x76, 248 => 0x210 },
	'wb_rggblevelsuncorrected' => { 268 => 0xa021 },
	'wb_rggblevelsunknown' => { 28 => 0xf, 30 => 0x1d, 34 => 0x4e },
	'wb_rggblevelsunknown10' => { 28 => 0x5f, 30 => 0x72, 34 => 0x9e },
	'wb_rggblevelsunknown11' => { 28 => 0x64, 30 => 0x77, 34 => 0xa3 },
	'wb_rggblevelsunknown12' => { 28 => 0x69, 30 => 0x7c, 34 => 0xa8 },
	'wb_rggblevelsunknown13' => { 28 => 0x6e, 30 => 0x81, 34 => 0xad },
	'wb_rggblevelsunknown14' => { 30 => 0x86, 34 => 0xb2 },
	'wb_rggblevelsunknown15' => { 30 => 0x8b, 34 => 0xb7 },
	'wb_rggblevelsunknown16' => { 30 => 0x9f },
	'wb_rggblevelsunknown2' => { 28 => 0x37, 30 => 0x4a, 34 => 0x53 },
	'wb_rggblevelsunknown3' => { 28 => 0x3c, 30 => 0x4f, 34 => 0x58 },
	'wb_rggblevelsunknown4' => { 28 => 0x41, 30 => 0x54, 34 => 0x5d },
	'wb_rggblevelsunknown5' => { 28 => 0x46, 30 => 0x59, 34 => 0x62 },
	'wb_rggblevelsunknown6' => { 28 => 0x4b, 30 => 0x5e, 34 => 0x8a },
	'wb_rggblevelsunknown7' => { 28 => 0x50, 30 => 0x63, 34 => 0x8f },
	'wb_rggblevelsunknown8' => { 28 => 0x55, 30 => 0x68, 34 => 0x94 },
	'wb_rggblevelsunknown9' => { 28 => 0x5a, 30 => 0x6d, 34 => 0x99 },
	'wbadjbluebalance' => { 197 => 0x8 },
	'wbadjcolortemp' => { 78 => 0x1a },
	'wbadjlighting' => { 197 => 0x15 },
	'wbadjlightingsubtype' => { 197 => 0x14 },
	'wbadjmode' => { 197 => 0x10 },
	'wbadjredbalance' => { 197 => 0x0 },
	'wbadjrgblevels' => { 78 => 0x8 },
	'wbadjtemperature' => { 197 => 0x18 },
	'wbadjtint' => { 197 => 0x25 },
	'wbadjustab' => { 225 => 0x46 },
	'wbadjustgm' => { 225 => 0x47 },
	'wbbluelevel' => { 220 => 0x324, 225 => 0x8006, 227 => 0x26 },
	'wbbracketmode' => { 39 => 0x9 },
	'wbbracketvalueab' => { 39 => 0xc },
	'wbbracketvaluegm' => { 39 => 0xd },
	'wbfinetuneactive' => { 78 => 0x24 },
	'wbfinetunesaturation' => { 78 => 0x28 },
	'wbfinetunetone' => { 78 => 0x2c },
	'wbgreenlevel' => { 220 => 0x323, 225 => 0x8005, 227 => 0x25 },
	'wbmediaimagesizesetting' => { 60 => 0x708 },
	'wbmode' => { 139 => 0x4, 210 => 0x1015 },
	'wbredlevel' => { 220 => 0x322, 225 => 0x8004, 227 => 0x24 },
	'wbscale' => { 140 => 0x0 },
	'wbshiftab' => { 53 => 0xc, 234 => 0x10 },
	'wbshiftgm' => { 53 => 0xd },
	'wbshiftmg' => { 234 => 0x11 },
	'webstatement' => { 315 => 'WebStatement' },
	'whitebalance' => { 4 => 0x6f, 5 => [0x44,0x4a], 6 => 0x36, 7 => 0x5e, 8 => 0x36, 9 => [0x77,0x78], 10 => 0x6f, 11 => 0x6f, 12 => 0x73, 13 => 0x6f, 14 => 0x78, 15 => 0x54, 16 => 0x6f, 18 => 0x7b, 21 => 0x53, 53 => 0x8, 55 => 0x7, 82 => 0x7, 83 => [0x19,0x2012], 86 => [0xa403,0xfe4e], 90 => 0x1002, 98 => 0x3fc, 99 => 0xfa0d, 100 => 0x40, 132 => 0x3, 133 => 0xe, 134 => 0x4, 135 => 0xb, 136 => 0x115, 161 => 0x5, 181 => 0x7, 220 => 0x304, 225 => 0x3, 226 => 0x3033, 248 => 0x19, 253 => 0x7, 263 => 0x26, 271 => [0x3c,0x7], 277 => [0x115,0xb054], 289 => 'WhiteBalance', 293 => 'WhiteBalance' },
	'whitebalance2' => { 205 => 0x500 },
	'whitebalanceadj' => { 78 => 0x18, 191 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 230 => 0x0 },
	'whitebalancebias' => { 83 => 0x2011, 210 => 0x304, 225 => 0x23 },
	'whitebalanceblue' => { 53 => 0x7 },
	'whitebalancebracket' => { 205 => 0x502, 210 => 0x303 },
	'whitebalancebracketing' => { 135 => 0x22 },
	'whitebalancecomp' => { 213 => 0x1001 },
	'whitebalancefinetune' => { 90 => 0x100a, 135 => 0x38, 136 => 0x112, 161 => 0xb, 272 => 0x6, 277 => 0x112 },
	'whitebalancemode' => { 248 => 0x1a },
	'whitebalancered' => { 53 => 0x6 },
	'whitebalanceset' => { 233 => 0xa },
	'whitebalancesetting' => { 135 => 0x23 },
	'whitebalancetemperature' => { 205 => 0x501 },
	'whiteboard' => { 210 => 0x301 },
	'whitelevel' => { 86 => 0xc61d },
	'whitepoint' => { 86 => 0x13e, 248 => 0x201, 307 => 'WhitePoint' },
	'widefocuszone' => { 132 => 0x2f },
	'widerange' => { 270 => 0x20f },
	'wordcount' => { 302 => 'wordCount' },
	'workcolorspace' => { 78 => 0x270 },
	'worldtimelocation' => { 225 => 0x3a, 248 => 0x22, 252 => '0.1' },
	'writer-editor' => { 93 => 0x7a },
	'x3filllight' => { 271 => 0x12 },
	'xmp' => { 77 => 0xffff00f6, 87 => 'XMP' },
	'xmptoolkit' => { 308 => 'xmptk' },
	'xpauthor' => { 86 => 0x9c9d },
	'xpcomment' => { 86 => 0x9c9c },
	'xpkeywords' => { 86 => 0x9c9e },
	'xposition' => { 86 => 0x11e },
	'xpsubject' => { 86 => 0x9c9f },
	'xptitle' => { 86 => 0x9c9b },
	'xresolution' => { 86 => 0x11a, 96 => 0x3, 258 => 0x0, 307 => 'XResolution' },
	'xyresolution' => { 89 => 0x3 },
	'ycbcrcoefficients' => { 86 => 0x211, 307 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 86 => 0x213, 307 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 86 => 0x212, 307 => 'YCbCrSubSampling' },
	'yearcreated' => { 100 => 0x10, 109 => 0xc },
	'yposition' => { 86 => 0x11f },
	'yresolution' => { 86 => 0x11b, 96 => 0x5, 258 => 0x4, 307 => 'YResolution' },
	'zonematching' => { 136 => 0x10a, 139 => [0x3a,0x4a], 277 => 0xb024 },
	'zonematchingmode' => { 135 => 0x14 },
	'zonematchingon' => { 134 => 0x75 },
	'zonematchingvalue' => { 272 => 0x1f },
	'zoomedpreviewlength' => { 210 => 0xf05 },
	'zoomedpreviewsize' => { 210 => 0xf06 },
	'zoomedpreviewstart' => { 210 => 0xf04 },
	'zoomsourcewidth' => { 25 => 0x24 },
	'zoomstepcount' => { 208 => 0x300, 210 => 0x100d },
	'zoomtargetwidth' => { 25 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'abstract' => 1,
	'accessdate' => 1,
	'acdsee' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeunknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afmicroadj' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'animationextension' => 1,
	'animationiterations' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturesetting' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectinfo' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachments' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavgbitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomode' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiovendorid' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo5dmkii_2a' => 1,
	'camerainfo5dmkii_2b' => 1,
	'camerainfo7d_2a' => 1,
	'camerainfo7d_2b' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'cell' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'checkedby' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastcurve' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'costumedesigner' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatorinfo' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropx' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropy' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd40' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datecompleted' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'dc' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'externalleading' => 1,
	'extraflags' => 1,
	'extrasamples' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'fileattributes' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0104' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameheight' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framewidth' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'generator' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'historybuffersize' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'identification' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'image' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'includedfileid' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'insertmode' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isbasefont' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isoinfo' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'linearized' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailstop' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturer' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mcdi' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'mean' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'mincache' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noiseprofile' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'osversion' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'othersampledesc' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxtags' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestyleinfo2' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primaryitemreference' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'product' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'rawcodecversion' => 1,
	'rawdata' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencevirtual' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'relativepath' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'runwindow' => 1,
	'sampledegradationpriority' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsunginfo' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenecolorimetryestimates' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod40' => 1,
	'shotinfod5000' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signatureusagerights' => 1,
	'signedelement' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyimageheight' => 1,
	'sonyimagewidth' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundschemetitle' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'synchronizedlyrictext' => 1,
	'syncsampletable' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'temperature' => 1,
	'tempinfok5' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textjunk' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaledittime' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wb_grgblevels' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbinfoa100' => 1,
	'wcsprofiles' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'writer' => 1,
	'writingapp' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpextension' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xp_dip_xml' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = $strName;
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $lc = $$tagTablePtr{$id} ? lc $$tagTablePtr{$id}{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2011, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
