/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

////////////////////////////////////////////////////////////////
// Global
////////////////////////////////////////////////////////////////

var collect = null;
var KMeleon = false;

////////////////////////////////////////////////////////////////
// Lifecycle
////////////////////////////////////////////////////////////////

var initNewsfox = false;
var autoRefreshTimer = null;
function startup()
{
  // This method was getting called twice, not sure why
  // so short circuit if method already invoked.
  if (initNewsfox) return;
	if (navigator.userAgent.indexOf('K-Meleon') > -1) KMeleon = true;
	options.load();
	options.save();
  initNewsfox = true;
  refreshModel();

	if( !KMeleon )
	{
		var newLivemarks = getNewLivemarks();
		if( newLivemarks.length )
		{
			var selected = new Array();
			var params = { ok:false, livemarks:newLivemarks, selected:selected, onlyNew:true };
			var win = window.openDialog("chrome://newsfox/content/livemarksDlg.xul",
				"newsfox-dialog","chrome,centerscreen,modal", params);

			if (params.ok)
			{
				model.updateLivemarks(newLivemarks, selected, true);
				refreshModel();
			}
		}
	}
	else
	{
		var mngLMbutton = document.getElementById("mngLMbutton");
		mngLMbutton.setAttribute("hidden", true);
	}

	frames["content"].location.href = "chrome://newsfox/locale/help/start.html";

  if(options.checkOnStartup) 
    checkFeeds();

	if( options.autoRefresh )
		autoRefreshTimer = setTimeout(this.checkFeeds, options.autoRefreshInterval * 60 * 1000);

}

function refreshModel()
{
  loadFeedModel();
  model.shiftExcluded();
  var tree = document.getElementById("newsfox.feedTree");
  tree.view = new FeedTreeModel();
}

var clean = false;
function cleanup()
{
  if (!initNewsfox) return;
  if (clean) return;
	if( null != autoRefreshTimer )
		clearTimeout(autoRefreshTimer);
  saveFeedModel();
  clean = true;
}

function openNewsfox(newTab)
{
	var tabbrowser = window.gBrowser;
  var tabs = tabbrowser.tabContainer.childNodes;
  var tab;
  for (var i = 0; i < tabs.length; ++i) {
    tab = tabs[i];
    var browser = tabbrowser.getBrowserForTab(tab);
		if("chrome://newsfox/content/newsfox.xul" == browser.contentDocument.location)
		{
			tabbrowser.selectedTab = tab;
			return;
		}
	}
	// if we got to this point, it means that no NewsFox in current window. Try to search other windows if any.

	var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                   .getService(Components.interfaces.nsIWindowMediator);
	var enumerator = wm.getEnumerator("navigator:browser");
	while(enumerator.hasMoreElements())
	{
	  var win = enumerator.getNext();
  	// |win| is [Object ChromeWindow] (just like |window|), do something with it
		tabbrowser = win.gBrowser;
	  tabs = tabbrowser.tabContainer.childNodes;
	  for (var i = 0; i < tabs.length; ++i) {
	    tab = tabs[i];
	    var browser = tabbrowser.getBrowserForTab(tab);
			if("chrome://newsfox/content/newsfox.xul" == browser.contentDocument.location)
			{
				// some problems with raising, so we close it to re-open after in current window
				browser.loadURI("about:blank", null, null); // if there is only one tab it'll not be removed. So, we change the browser location to save feeds
				tabbrowser.removeTab(tab);
			}
  	}
	}
	// Now we sure that no NewsFox is opened. Starting one.
	if (newTab) {
		getBrowser().addTab("chrome://newsfox/content/newsfox.xul")
	} else {
		getBrowser().loadURI("chrome://newsfox/content/newsfox.xul", null, null);
	}
}

////////////////////////////////////////////////////////////////
// Commands
////////////////////////////////////////////////////////////////

/**
 * Check feeds for new items.
 */
function checkFeeds()
{
	if( null != autoRefreshTimer )
		clearTimeout(autoRefreshTimer);
  refreshingAllFeeds = true;
  doCheckFeeds();
}

/**
 * Check an indiviual feed.
 */
function checkSoloFeed()
{
  var tree = document.getElementById("newsfox.feedTree");
  if (checkInProgress || -1 == tree.currentIndex) return;
	else checkInProgress = true;
  var elem = document.getElementById("busyAnimation");
  elem.style.visibility = "visible";
  cancelCheck = true; // force cancel after this feed updates
  precheckFeed( getFeedIndex(tree.currentIndex) );
}

/**
 * Add a new feed.
 */
function addFeed()
{
  var params = { ok:false, url:"" };
  var win = window.openDialog("chrome://newsfox/content/addFeed.xul",
    "newsfox-dialog","chrome,centerscreen,modal", params);
  // TODO - Need to verify URL first
  if (params.ok)
  {
    createNewFeed(model, params.url);
    saveFeedModel();
    refreshModel();
  }
}

/**
 * Permantly deleted a feed.
 */
function deleteFeed()
{
  var tree = document.getElementById("newsfox.feedTree");
  var feed = model.get(getFeedIndex(tree.currentIndex));

	var stringsBundle = document.getElementById("newsfox-string-bundle");
	var confirmationMessage = stringsBundle.getString('confirmation.deleteFeed');
	confirmationMessage += "\n" + entityDecode(feed.getDisplayName());
  if (window.confirm(confirmationMessage))
  {
    deleteFeedFromDisk(feed);
    model.remove(feed);
    saveFeedModel();
    refreshModel();
    // Tree loses selection when node removed - need to force
    // next/prev node selected b/f calling this method.
    //feedSelected();
  }
}

/**
 * Show global options.
 */
function showOptions()
{ 
  var params = { ok:false, style:options.globalStyle, checkOnStartup:options.checkOnStartup, autoRefresh:options.autoRefresh, autoRefreshInterval:options.autoRefreshInterval, notifyUponNew:options.notifyUponNew };
  var win = window.openDialog("chrome://newsfox/content/options.xul",
    "newsfox-dialog","chrome,centerscreen,modal", params);
	var oldAutoRefreshInterval = options.autoRefreshInterval;

  if (params.ok)
  {
    options.globalStyle = params.style;
    options.checkOnStartup = params.checkOnStartup;
		options.autoRefresh = params.autoRefresh;
		if( options.autoRefresh )
		{
			if( options.autoRefreshInterval != params.autoRefreshInterval )
			{
				if( null != autoRefreshTimer )
					clearTimeout(autoRefreshTimer);
				autoRefreshTimer = setTimeout(this.checkFeeds, params.autoRefreshInterval * 60 * 1000);
			}
		}
		else if( null != autoRefreshTimer )
			clearTimeout(autoRefreshTimer);
		options.autoRefreshInterval = params.autoRefreshInterval;
		options.notifyUponNew = params.notifyUponNew;
    options.save();
  }
}

/**
 * Restore an deleted article.
 */
function restoreArticle()
{
  /*
  var tree = document.getElementById("newsfox.feedTree");
  var index = tree.currentIndex;
  if (index != model.size()+1) return;

  tree = document.getElementById("newsfox.articleTree");
  var start = new Object();
  var end   = new Object();
  var range = tree.view.selection.getRangeCount();

  for (var i=0; i<range; i++)
  {
    tree.view.selection.getRangeAt(i,start,end);
    for (var j=start.value; j<=end.value; j++)
    {
      var art = collect.get(j);
      art.trash = false;
    }    
    collect = new TrashCollection();
    tree.treeBoxObject.rowCountChanged(start.value, -(end.value-start.value+1));
  }
  
  // Update unread count
  tree = document.getElementById("newsfox.feedTree");
  tree.treeBoxObject.invalidate();   
  */
}

/**
 * Delete an article.
 */
function deleteArticle()
{
  try
  {
    var tree = document.getElementById("newsfox.feedTree");
    var index = tree.currentIndex;
    var feed = model.get( getFeedIndex(index) );

    tree = document.getElementById("newsfox.articleTree");
    var range = tree.view.selection.getRangeCount();
    if (range == 0) return;
    var start = new Object();
    var end   = new Object();

		var stringsBundle = document.getElementById("newsfox-string-bundle");
		var confirmationMessage = stringsBundle.getString('confirmation.deleteArticles');
    if (!confirm(confirmationMessage))
      return;

    // Regular delete
    for (var i=0; i<range; i++)
    {
      tree.view.selection.getRangeAt(i,start,end);
      for (var j=end.value; j>=start.value; j--)
			{
				var article = collect.get(j);
				feed.removeByURL(article.link);
			}
    }

    saveFeed(feed);
    saveFeedModel();

    // Update unread count
    tree = document.getElementById("newsfox.feedTree");
    tree.treeBoxObject.invalidate();
    feedSelected();
  }
  catch (err)
  {
    var msg = "deleteArticle(): " + err;
    alert(msg);
  }
}

/**
 * Show help.
 */
function help()
{
  frames["content"].location.href = "chrome://newsfox/locale/help/start.html";
}

/**
 * Goto to homepage of selected feed.
 */
function home()
{
  var tree = document.getElementById("newsfox.feedTree");
	var feed = model.get( getFeedIndex(tree.currentIndex) );

	openNewTab(feed.homepage);
}

/**
 * Show options dialog for current feed.
 */
function showFeedOptions()
{
  var tree = document.getElementById("newsfox.feedTree");
	var feed = model.get( getFeedIndex(tree.currentIndex) );

	var params = { ok:false, name:entityDecode(feed.getDisplayName()), iconsrc:feed.icon.src, homepage:feed.homepage, url:feed.url, style:feed.style, deleteOld:feed.deleteOld, autoCheck:feed.autoCheck, dontDeleteUnread:feed.dontDeleteUnread };
  var win = window.openDialog("chrome://newsfox/content/feedOptions.xul",
    "newsfox-dialog","chrome,centerscreen,modal", params);
  
  if (params.ok)
  {
    feed.url = params.url.trim();
    feed.style = params.style;
    feed.deleteOld = params.deleteOld;
    feed.autoCheck = params.autoCheck;
		feed.dontDeleteUnread = params.dontDeleteUnread;
		var val = params.name.trim();
		if (val == feed.defaultName) feed.customName = "";
		else feed.setCustomName(val);
		if (params.iconsrc == "")
			feed.icon.src = iconOk;
		else
			feed.icon.src = params.iconsrc.trim();
		feed.homepage = params.homepage.trim();
		downloadIcon(feed);
    saveFeedModel();
    refreshModel();
  }
}

/**
 * Troubleshoot feed errors.
 */
function troubleshoot()
{
  var tree = document.getElementById("newsfox.feedTree");
  var feed = model.get(tree.currentIndex);

  var iframe = document.getElementById("content");
  var doc = iframe.contentDocument;
  doc.body.style.font = "10pt Verdana";
  doc.body.style.background = "white";
  while (doc.body.childNodes.length > 0)
    doc.body.removeChild(doc.body.childNodes[0]);

  var summary = getErrorSummary(feed.error);
  var remedies = getErrorRemedies(feed.error);

  var b = doc.createElement("b");
  b.appendChild(doc.createTextNode(summary));

  var p = doc.createElement("p");
  p.innerHTML = remedies;

  doc.body.appendChild(b);
  doc.body.appendChild(doc.createElement("hr"));
  doc.body.appendChild(p);
}

////////////////////////////////////////////////////////////////
// Util
////////////////////////////////////////////////////////////////

function openNewTab(url)
{
	if(!KMeleon)
	{
		const kWindowMediatorContractID = "@mozilla.org/appshell/window-mediator;1";
		const kWindowMediatorIID = Components.interfaces.nsIWindowMediator;
		const kWindowMediator = Components.classes[kWindowMediatorContractID].getService(kWindowMediatorIID);
		var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
		var browser = browserWindow.getBrowser();
		var tab = browser.addTab(url);
	}
	else
	{
		window.open(url);
		window.focus();
	}
}

// AG: function getParentFeed is never used...
function getParentFeed(art)
{
  for (var i=0; i<model.size(); i++)
  {
    var feed = model.get(i);
    for (var j=0; j<feed.size(); j++)
      if (feed.get(j).link == art.link)
        return feed;
  }
  return null;
}

// AG
function getFeedIndex(row)
{
	if( row < 0 )
		return row;
  var nFeedCount = model.size();
  var nCount = 0;
  for (var i = 0; i < nFeedCount; i++ )
  {
    var feed = model.get(i); 
    nCount += 1;
    if( feed.expanded )
      nCount += feed.getCategories().length;
    if( row < nCount ) return i;
  }
  return nCount; // shouldn't return this, unless some specials meant by Andy Frank (flagged, trash, etc.)
}

function getCategoryNo(row)
{
	if( row < 0 )
		return 0;
  var nFeedCount = model.size();
  var nCount = 0;
  for (var i = 0; i < nFeedCount; i++ )
  {
    var feed = model.get(i);
    var nextFeedSize = 1;
    if( feed.expanded )
      nextFeedSize += feed.getCategories().length;
    if( row < nCount + nextFeedSize) return row - nCount;
    nCount += nextFeedSize;
  }
  return nCount; // shouldn't return this, unless some specials meant by Andy Frank (flagged, trash, etc.)
}

function getTreeIndexOf(nFeed, nCategory)
{
  var nFeedCount = model.size();
  if (nFeed >= nFeedCount)
    nFeed = nFeedCount - 1;
  var index = 0;
  for (var i = 0; i < nFeed; i++ )
  {
    var feed = model.get(i);
    if( feed.expanded )
      index += feed.getCategories().length;
    index += 1;
  }

  return index + nCategory;
}
////////////////////////////////////////////////////////////////
// Selection
////////////////////////////////////////////////////////////////

/**
 * Feed selected.
 */
function feedSelected()
{
  var tree = document.getElementById("newsfox.feedTree");
  var index = tree.currentIndex;
  var nFeed = getFeedIndex(index);

  var feed = model.get(nFeed);
	downloadIcon(feed);
	loadFeed(feed);
	feed.flags.length = feed.size();

  var title = document.getElementById("feedTitle");
  title.value = entityDecode(feed.getDisplayName());

  if (nFeed < model.size()) collect = new NormalCollection(feed, getCategoryNo(index));
  else if (nFeed == model.size()) collect = new FlaggedCollection();
  else collect = new TrashCollection();

  tree = document.getElementById("newsfox.articleTree");  
  tree.view = null;  
  tree.view = new ArticleTreeModel();
  if (lastCol != null) 
  {
    noToggleOrder = true;
    tree.view.cycleHeader(lastColName, lastCol);
    noToggleOrder = false;
  }
}

/**
 * Article selected.
 */
function articleSelected()
{
  var tree = document.getElementById("newsfox.articleTree");
  var index = tree.currentIndex;
  var art = collect.get(index);
  var read = collect.feed.isRead(art);

  if (!read)
  {
    collect.feed.setRead(art, true);
    tree.treeBoxObject.invalidateRow(index);
    var tree = document.getElementById("newsfox.feedTree");
    tree.treeBoxObject.invalidate();
  }

  // Display body in content
	var iframe = document.getElementById("content");
  var style = collect.feed.getStyle();
  if (style == 2)
  {
    // Display as webpage
		iframe.docShell.allowJavascript = true;
    frames["content"].location.href = art.link;
  }
  else
  {
		// creating simple HTML-file to resolve security issue pointed out by Wladimir Palant
		var file = getTextViewFile(art);
		iframe.docShell.allowJavascript = false;
		frames["content"].location.href = "file:///" + file.path;
  }
	frames["content"].scrollTo(0,0);
}

function articleTreeMClicked()
{
	var tree = document.getElementById("newsfox.articleTree");
	var index = tree.currentIndex;
	var article = collect.get(index);
	openNewTab(article.link);
}

function articleTreeDblClicked()
{
	this.articleTreeMClicked();
}

/**
 * Select the next unread article.
 */
function selectNextUnreadArticle()
{
  if (model.size() == 0)
  {
    //alert('No Feeds');
    return;
  }
 
  var feedtree = document.getElementById("newsfox.feedTree");
  var arttree = document.getElementById("newsfox.articleTree");
  var curFeedTreeIndex = feedtree.currentIndex;
  var feedIndex = getFeedIndex(curFeedTreeIndex);
  var artIndex = 0;
  if (feedIndex < 0) 
  {
    feedIndex = 0;
  }
  else 
  {
    artIndex = arttree.currentIndex;
    if (artIndex < 0) artIndex = 0;
  }

  var feed;
  var art;
  for (i = feedIndex; i < model.size(); i++) 
  {
    feed = model.get(i);

    // TODO: uncomment this: This does not seem to be working all the time
    //if (feed.getUnread() == 0) continue;

    var treeIndex = getTreeIndexOf(i,0); // calculating index in left tree taking into account categories
    feedtree.view.selection.select(treeIndex);
    feedtree.treeBoxObject.ensureRowIsVisible(treeIndex);
    if (i == feedIndex)
    {
      for (j = artIndex; j < model.get(i).size(); j++)
      {
        art = model.get(i).get(j);
        if (!model.get(i).isRead(art))
        {
          arttree.view.selection.select(j);
          arttree.treeBoxObject.ensureRowIsVisible(j);
          return;
        }
      }
    }
    else
    {
      var curFeedSize = model.get(i).size();
      for (j = 0; j < curFeedSize ; j++)
      {
        art = model.get(i).get(j);
        if (!model.get(i).isRead(art))
        {
          arttree.view.selection.select(j);
          arttree.treeBoxObject.ensureRowIsVisible(j);
          return;
        }
      }
    }
  }

  for (i = 0; i < model.size(); i++)
  {
    feed = model.get(i);
    // TODO: uncomment this: This does not seem to be working all the time
    //if (feed.getUnread() == 0) continue;

    var treeIndex = getTreeIndexOf(i,0); // calculating index in left tree taking into account categories
    feedtree.view.selection.select(treeIndex);
    feedtree.treeBoxObject.ensureRowIsVisible(treeIndex);
    for (j = 0; j < model.get(i).size(); j++) 
    {
      art = model.get(i).get(j);
      if (!model.get(i).isRead(art)) 
      {
        arttree.view.selection.select(j);
        arttree.treeBoxObject.ensureRowIsVisible(j);
        return;
      }
    }
  }

  //alert("no articles unread");
  return;
}

/**
 * Select the previous unread article.
 */
function selectPrevUnreadArticle() 
{
  if (model.size() == 0) 
  {
    //alert('No Feeds');
    return;
  }

  var feedtree = document.getElementById("newsfox.feedTree");
  var arttree = document.getElementById("newsfox.articleTree");
  var curFeedTreeIndex = feedtree.currentIndex;
  var feedIndex = getFeedIndex(curFeedTreeIndex);
  var artIndex = 0;

  if (feedIndex < 0) 
  {
    feedIndex = model.size() - 1;
  } 
  else 
  {
    artIndex = arttree.currentIndex;
    if (artIndex < 0) 
    {
      artIndex = model.get(feedIndex).size() - 1;
      if (artIndex < 0) artIndex = 0;
    }
  }

  var feed;
  var art;
  for (i = feedIndex; i >= 0; i--) 
  {
    feed = model.get(i);
    // TODO: uncomment this: This does not seem to be working all the time
    //if (feed.getUnread() == 0) continue;

    var treeIndex = getTreeIndexOf(i,0); // calculating index in left tree taking into account categories
    feedtree.view.selection.select(treeIndex);
    feedtree.treeBoxObject.ensureRowIsVisible(treeIndex);
    if (i == feedIndex) 
    {
      for (j = artIndex; j >= 0; j--) 
      {
        art = model.get(i).get(j);
        if (!model.get(i).isRead(art)) 
        {
          arttree.view.selection.select(j);
          arttree.treeBoxObject.ensureRowIsVisible(j);
          return;
        }
      }
    } 
    else 
    {
      for (j = model.get(i).size() - 1; j >= 0; j--) 
      {
        art = model.get(i).get(j);
        if (!model.get(i).isRead(art)) 
        {
          arttree.view.selection.select(j);
          arttree.treeBoxObject.ensureRowIsVisible(j);
          return;
        }
      }
    }
  }

  for (i = model.size(); i >= 0; i--) 
  {
    feed = model.get(i);
    // TODO: uncomment this: This does not seem to be working all the time
    //if (feed.getUnread() == 0) continue;

    var treeIndex = getTreeIndexOf(i,0); // calculating index in left tree taking into account categories
    feedtree.view.selection.select(treeIndex);
    feedtree.treeBoxObject.ensureRowIsVisible(treeIndex);
    for (j = model.get(i).size() - 1; j >= 0; j--) 
    {
      art = model.get(i).get(j);
      if (!model.get(i).isRead(art)) 
      {
        arttree.view.selection.select(j);
        arttree.treeBoxObject.ensureRowIsVisible(j);
        return;
      }
    }
  }

  //alert("no articles unread");
  return;
}

////////////////////////////////////////////////////////////////
// Event Handlers
////////////////////////////////////////////////////////////////

/**
 * Route events.
 */
function handleEvent(e) 
{
  if (e.keyCode == 0) handleMouseEvent(e);
  handleKeyEvent(e);
}

/**
 * Handle mouse events.
 */
function handleMouseEvent(e) 
{
}

/**
 * Handle keyboard events.
 */
function handleKeyEvent(e)
{
  switch(e.keyCode) 
  {
    case 40: 
      if (e.altKey) 
      {
        e.stopPropagation();
        e.preventDefault(); 
        selectNextUnreadArticle(); 
      }
			else if(e.ctrlKey)
				moveFeed(false);
      break;

		case 38: 
      if (e.altKey) 
      {
        e.stopPropagation(); 
        e.preventDefault(); 
        selectPrevUnreadArticle(); 
      }
			else if(e.ctrlKey)
				moveFeed(true);
      break;
		case 46: // delete
			if("newsfox.articleTree" == document.commandDispatcher.focusedElement.id)
				deleteArticle();
			else if("newsfox.feedTree" == document.commandDispatcher.focusedElement.id)
				deleteFeed();
			break;
  }
}

////////////////////////////////////////////////////////////////
// FeedTreeModel
////////////////////////////////////////////////////////////////

function FeedTreeModel() 
{
  var iconErr = "chrome://newsfox/skin/images/brokenFeed.png";
  var flagIcon = "chrome://newsfox/skin/images/flagFeed.png";
  var trashIcon = "chrome://newsfox/skin/images/trash.png";

  // 3/25/05 - Temp disable flag/trash folder
  //this.rowCount = model.size() + 2;
  // AG: added category. Most subcode is reworked
  var nFeedCount = model.size();
  var nRowCount = nFeedCount;
  for (var i = 0; i < nFeedCount; i++ )
  {
    var feed = model.get(i);
		loadFeed(feed);
		if( feed.expanded )
			nRowCount += feed.getCategories().length;
  }
  this.rowCount = nRowCount;

  this.getCategoryIndex = function(row, nFeed)
  {
    var nCount = 0; //amount of rows for all feeds above nFeed
    for (var i = 0; i < nFeed; i++)
    {
      var feed = model.get(i);
      if( feed.expanded )
        nCount += feed.getCategories().length;
      nCount += 1; //count feed itself
    }
    return row - nCount;
  }

  this.isTopLevelElement = function(row)
  {
    var nFeed = getFeedIndex(row);
    var nCat = this.getCategoryIndex(row, nFeed);
    if( nCat > 0 ) return false;
    else return true;
  }

  this.getCellText = function(row,col)
  {
    nFeed = getFeedIndex(row);
    if (nFeed < model.size())
    {
      var feed = model.get(nFeed);
      var nCategory = this.getCategoryIndex(row, nFeed);
      var text = "";
      var unread = feed.getUnread(nCategory);
      if( nCategory )
      {
        var categories = feed.getCategories();
        text = entityDecode(categories[nCategory-1]);
      }
      else
        text =  entityDecode(feed.getDisplayName());
      if (unread > 0) text += " (" + unread + ")";
      return text;
    }
    else if (row - nFeed == 0) return "Flagged Items";
    else return "Trash"; 
  }
  this.setTree = function(treebox){ this.treebox = treebox; }
  this.isContainer = function(row)
  {
    return this.isTopLevelElement(row);
  }
  this.isContainerEmpty = function(row)
  {
    var nFeed = getFeedIndex(row);
    if( model.get(nFeed).getCategories().length ) return false;
    return true;
  }
  this.isContainerOpen = function(row)
  {
    var nFeed = getFeedIndex(row);
    return model.get(nFeed).expanded;
  }

  this.hasNextSibling = function(row, index)
  {
    if( this.isContainer(row) )
    {
      if( this.isContainerEmpty(row) && (row+1 != this.rowCount) ) return false;
      else return true;
    }
    else return !this.isContainer(row+1);
  }
  this.getParentIndex = function(row)
  {
    if (this.isContainer(row)) return -1;
    var nFeed = getFeedIndex(row);
    var index = 0; 
    for( var i = 0; i < nFeed; i++ )
      index += model.get(nFeed).getCategories().length + 1;

    return index;
  }


  this.isSeparator = function(row){ return false; }
  this.isEditable = function(row,col){ return false; }
  this.isSorted = function(row){ return false; }
  this.getLevel = function(row){ return this.isContainer(row) ? 0 : 1; }
  this.getImageSrc = function(row,col) 
  {
    nFeed = getFeedIndex(row);
		if (this.getLevel(row) == 1) return null;
		var feed = model.get(nFeed);
    if (nFeed < model.size())
      return (feed.error == ERROR_OK) ? feed.icon.src : iconErr; 
    else if (row - nFeed == 0) return flagIcon;
    else return trashIcon;
  }
  this.getRowProperties = function(row,props) {}
  this.getCellProperties = function(row,col,props) 
  {
    var nFeed = getFeedIndex(row);
    if ( nFeed >= model.size() ) return;
		if ( this.getCategoryIndex(row, nFeed) == 0 )
		{
			var aserv = Components.classes["@mozilla.org/atom-service;1"].
			getService(Components.interfaces.nsIAtomService);
			props.AppendElement(aserv.getAtom("faviconcol"));
		}
    if (model.get(nFeed).getUnread(this.getCategoryIndex(row,nFeed)) > 0)
    {
      var aserv = Components.classes["@mozilla.org/atom-service;1"].
        getService(Components.interfaces.nsIAtomService);
      props.AppendElement(aserv.getAtom("unread"));
    }
  }
  this.getColumnProperties = function(colid,col,props) {}
  this.toggleOpenState = function(row)
  {
    var nFeed = getFeedIndex(row);
    var feed = model.get(nFeed);
    feed.expanded = !feed.expanded;

    var tree = document.getElementById("newsfox.feedTree");
    tree.view = new FeedTreeModel();
  }
}

////////////////////////////////////////////////////////////////
// ArticleTreeModel
////////////////////////////////////////////////////////////////

var lastCol = null;
var lastColName = null;
var noToggleOrder = false;

function ArticleTreeModel() 
{
  var flagIcon = "chrome://newsfox/skin/images/flag.png";
  var readIcon = "chrome://newsfox/skin/images/read.png";
  var unreadIcon = "chrome://newsfox/skin/images/unread.png";

  this.rowCount = collect.size();
  this.getCellText = function(row,col)
  {
    // Try to handle both Firefox 1.0 and 1.1
    var colId = (col.id) ? col.id : col;
    switch (colId)
    {
      case "title": return entityDecode(collect.get(row).title);
      case "date":  return collect.get(row).date.toLocaleString();
      default: return "debug-" + col;
    }
  }
  this.setTree = function(treebox){ this.treebox = treebox; }
  this.isContainer = function(row){ return false; }
  this.isSeparator = function(row){ return false; }
  this.isSorted = function(row){ return false; }
  this.getLevel = function(row){ return 0; }
  this.getImageSrc = function(row,col)
  { 
    var read = collect.feed.isRead(collect.get(row));
    var flag = collect.feed.isFlagged(collect.get(row));

    // Try to handle both Firefox 1.0 and 1.1
    var colId = (col.id) ? col.id : col;
    switch (colId)
    {
      case "read": return read ? readIcon : unreadIcon;
      case "flag": return flag ? flagIcon : readIcon;
      default: return null;
    }
  }
  this.getRowProperties = function(row,props) {}
  this.getCellProperties = function(row,col,props) 
  {
    if (!collect.feed.isRead(collect.get(row)))
    {
      var aserv = Components.classes["@mozilla.org/atom-service;1"].
        getService(Components.interfaces.nsIAtomService);
      props.AppendElement(aserv.getAtom("unread"));
    }
  }
  this.getColumnProperties = function(colid,col,props) {}
  this.cycleHeader = function(col,elem)
  {
    /* TODO - disabled for now

    // Don't support sorting of flag/read yet
    if (col != "title" && col != "date") return;

    var array = collect.getArray();
    if (noToggleOrder)
    {
      var ascend = lastCol.getAttribute("sortDirection") == "ascending";
    }
    else
    {
      var ascend = true;    
      if (lastCol == elem && lastCol.getAttribute("sortDirection") == "ascending")
        ascend = false;
    }

    // TODO - Simple bubble sort, use
    // more effecient algoritm

    for (var i=0; i<array.length-1; i++)
      for (var j=array.length-1; j>i; j--)
      {
        if (col == "title")
        {
          var a = array[j].title.toLowerCase();
          var b = array[j-1].title.toLowerCase();
        }
        else
        {
          var a = array[j].date;
          var b = array[j-1].date;
        }

        if ((ascend && (a < b)) || (!ascend && (a > b)))
        {
          var temp = array[j];
          array[j] = array[j-1];
          array[j-1] = temp;
        }
      }

    if (lastCol != null) lastCol.setAttribute("sortDirection", "natural");
    elem.setAttribute("sortDirection", ascend ? "ascending" : "descending");
    lastCol = elem;
    lastColName = col;

    var tree = document.getElementById("newsfox.articleTree");
    tree.treeBoxObject.invalidate();
    */
  }
  this.cycleCell = function(row,col)
  {
    // Try to handle both Firefox 1.0 and 1.1
    var colId = (col.id) ? col.id : col;

    var art = collect.get(row);
    if (colId == "read") 
    {
      var read = collect.feed.isRead(art);
      collect.feed.setRead(art, !read);
      var tree = document.getElementById("newsfox.articleTree");
      tree.treeBoxObject.invalidateRow(row);
      tree = document.getElementById("newsfox.feedTree");
      //tree.treeBoxObject.invalidateRow(index);
      tree.treeBoxObject.invalidate();
    }
    else if (colId == "flag")
    {
      //collect.get(row).flag = !collect.get(row).flag;
      var flag = collect.feed.isFlagged(art);
      collect.feed.setFlagged(art, !flag);
      var tree = document.getElementById("newsfox.articleTree");
      //tree.treeBoxObject.invalidateRow(row);
      tree.treeBoxObject.invalidate();
    }
  }
}

////////////////////////////////////////////////////////////////

function manageLivemarks()
{
	var allLivemarks = liveBookmarks.getAll();
	var selected = new Array();
	for( var i=0; i < model.sizeTotal(); i++)
	{
		var feed = model.get(i);
		if( !feed.exclude )
			selected.push(feed.url);
	}
	var params = { ok:false, livemarks:allLivemarks, selected:selected };
  var win = window.openDialog("chrome://newsfox/content/livemarksDlg.xul",
    "newsfox-dialog","chrome,centerscreen,modal", params);

	if (params.ok)
	{
		model.updateLivemarks(allLivemarks, selected, false);
		refreshModel();
	}
}

function markAllArticles(read)
{
	var feedTree = document.getElementById("newsfox.feedTree");
	var curFeedTreeIndex = feedTree.currentIndex;
	if( curFeedTreeIndex != -1)
	{
		var article;
		for(var i=0; i < collect.size(); i++)
		{
			article = collect.get(i);
			collect.feed.setRead(article, read);
		}
		saveFeedModel();
		feedTree.treeBoxObject.invalidate();
		var articleTree = document.getElementById("newsfox.articleTree");
		articleTree.treeBoxObject.invalidate();
	}
}

function onFeedMenuShowing(menu)
{
	var tree = document.getElementById("newsfox.feedTree");
	var index = tree.currentIndex;
	if( index < 0 )
		return true;

	var children = menu.childNodes;
	var hide = (getCategoryNo(index) != 0);
	var nFeed = getFeedIndex(index);
	for (var i = 0; i < children.length; i++)
	{
		var id = children[i].getAttribute("id");
		switch (id)
		{
			case "menuMoveUp":
				if(nFeed > 0) children[i].setAttribute("disabled", false);
				else children[i].setAttribute("disabled", true);
				if(hide) children[i].setAttribute("hidden", true);
				else children[i].setAttribute("hidden", false);
				break;
			case "menuMoveDown":
				if(nFeed < model.size() - 1) children[i].setAttribute("disabled", false);
				else children[i].setAttribute("disabled", true);
				if(hide) children[i].setAttribute("hidden", true);
				else children[i].setAttribute("hidden", false);
				break;
			case "menuMoveSeparator":
				if(hide) children[i].setAttribute("hidden", true);
				else children[i].setAttribute("hidden", false);
				break;
		}
	}

	return true;
}

function moveFeed(movingUp)
{
	var tree = document.getElementById("newsfox.feedTree");
	var index = tree.currentIndex;
	if( index < 0  || (getCategoryNo(index) != 0) )
		return;
	var nFeed = getFeedIndex(index);
	if( (movingUp && (0 == nFeed)) ||
			(!movingUp && (model.size()-1 == nFeed)) )
		return;
	var feed = model.get(nFeed);
	var newIndexInModel = (movingUp) ? nFeed-1 : nFeed+1;
	model.set(nFeed, model.get(newIndexInModel));
	model.set(newIndexInModel, feed);
	saveFeedModel();

	refreshModel();

	index = getTreeIndexOf(newIndexInModel, 0);
	tree.view.selection.select(index);
}
