/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

////////////////////////////////////////////////////////////////
// Global
////////////////////////////////////////////////////////////////

var options = new AppOptions();

////////////////////////////////////////////////////////////////
// Model
////////////////////////////////////////////////////////////////

function AppOptions()
{
  // Control wether we display an article as simple text or
  // if we dislpay the actual webpage link.  Can be overrided
  // by individual feed.
  //
  // 1 Text
  // 2 Web page
  // 3 Newspaper
  this.globalStyle = 1;

  // Control if feeds should be automatically checked on startup
  this.checkOnStartup = false;

	// Auto-refresh flag
	this.autoRefresh = false;

	// Auto-refresh interval, minutes
	this.autoRefreshInterval = 30;

	this.notifyUponNew = false;

////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////

  this.load = function()
  {
    this.globalStyle = CommonFunc.getPrefValue("newsfox.global.style", "int", 1);
    this.checkOnStartup = CommonFunc.getPrefValue("newsfox.global.checkOnStartup", "bool", false);
		this.autoRefresh = CommonFunc.getPrefValue("newsfox.global.autoRefresh", "bool", false);
		this.autoRefreshInterval = CommonFunc.getPrefValue("newsfox.global.autoRefreshInterval", "int", 30);
		this.notifyUponNew = CommonFunc.getPrefValue("newsfox.global.notifyUponNew", "bool", false);
		this.favicons = CommonFunc.getPrefValue("newsfox.global.favicons", "bool", CommonFunc.getPrefValue("browser.chrome.favicons","bool",true));
		this.guessHomepage = CommonFunc.getPrefValue("newsfox.global.guessHomepage", "bool", true);
  }

  this.save = function()
  {
    CommonFunc.setPrefValue("newsfox.global.style", "int", this.globalStyle);
    CommonFunc.setPrefValue("newsfox.global.checkOnStartup", "bool", this.checkOnStartup);
		CommonFunc.setPrefValue("newsfox.global.autoRefresh", "bool", this.autoRefresh);
		CommonFunc.setPrefValue("newsfox.global.autoRefreshInterval", "int", this.autoRefreshInterval);
		CommonFunc.setPrefValue("newsfox.global.notifyUponNew", "bool", this.notifyUponNew);
		CommonFunc.setPrefValue("newsfox.global.favicons", "bool", this.favicons);
		CommonFunc.setPrefValue("newsfox.global.guessHomepage", "bool", this.guessHomepage);
  }
}

