/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

////////////////////////////////////////////////////////////////
// Export OPML
////////////////////////////////////////////////////////////////

function exportOpml()
{
  var picker = Components.classes["@mozilla.org/filepicker;1"].
    createInstance(Components.interfaces.nsIFilePicker);
  picker.init(window, "Export OPML", picker.modeSave);
  picker.appendFilter("OPML Files (*.xml, *.opml)", "*.xml;*.opml");
  picker.appendFilters(picker.filterAll);
  picker.defaultString = "newsfox.opml";
  
  var result = picker.show();
  if(result == picker.returnOK || result == picker.returnReplace) 
  {
    try 
    {
			var srcTemplate =  '<?xml version="1.0" encoding="UTF-8"?>';
			srcTemplate += "<opml version=\"1.0\">\n";
			srcTemplate += "<head>\n\t<title>NewsFox OPML Export</title>\n";
			var currentDate = new Date();
			srcTemplate += "\t<dateModified>" + currentDate.toString() + "</dateModified>\n";
			srcTemplate += "</head>\n";
			srcTemplate += "<body/>\n</opml>";

			var opmlDoc = new DOMParser().parseFromString(srcTemplate, "text/xml");
			var opmlBody = opmlDoc.getElementsByTagName("body")[0];

			var NewsFoxGroupCreated = false;
			var NewsFoxFeedsNode;
      for (var i=0; i<model.size(); i++)
      {
        var feed = model.get(i);
				if( feed.exclude )
					continue;

				if(!NewsFoxGroupCreated)
				{
					NewsFoxFeedsNode = opmlDoc.createElement("outline");
					NewsFoxFeedsNode.setAttribute("text", "NewsFox feeds");
					NewsFoxGroupCreated = true;
					opmlBody.appendChild(NewsFoxFeedsNode);
				} 
				var node = opmlDoc.createElement("outline");
				node.setAttribute("type", "rss");
				node.setAttribute("text", entityDecode(feed.defaultName));
				node.setAttribute("title", entityDecode(feed.defaultName));
				node.setAttribute("xmlUrl", entityDecode(feed.url));
				NewsFoxFeedsNode.appendChild(node);
      }  

			var opmlSource = new XMLSerializer().serializeToString(opmlDoc);
			opmlSource = CommonFunc.convertCharCodeFrom(opmlSource, "UTF-8");
      var file = Components.classes['@mozilla.org/file/local;1'].
        createInstance(Components.interfaces.nsILocalFile);
      file.initWithPath(picker.file.path);
      if(file.exists()) file.remove(true);
      
      file.create(file.NORMAL_FILE_TYPE, 0666);
      var out = Components.classes['@mozilla.org/network/file-output-stream;1'].
        createInstance(Components.interfaces.nsIFileOutputStream);
      out.init(file, 2, 0x200, false); // open as "write only"
      
			println(out, opmlSource);
      out.close();
      
      alert("Successfully exported OMPL.");
    } 
    catch (err) 
    {
      alert("Export failed: " + err);
    }
  }
}

////////////////////////////////////////////////////////////////
// Import OPML
////////////////////////////////////////////////////////////////

function importOpml()
{
  var picker = Components.classes["@mozilla.org/filepicker;1"].
    createInstance(Components.interfaces.nsIFilePicker);
  picker.init(window, "Import OPML", picker.modeOpen);
  picker.appendFilter("OPML Files (*.xml, *.opml)", "*.xml;*.opml");
  picker.appendFilters(picker.filterAll);

  if(picker.show() == picker.returnOK) 
  {
    try 
    {
      var fix = Components.classes['@mozilla.org/docshell/urifixup;1'].
        getService(Components.interfaces.nsIURIFixup);
      var url = fix.createFixupURI(picker.file.path, fix.FIXUP_FLAG_ALLOW_KEYWORD_LOOKUP);

      // Locks up browser - not sure why - same code as file.js
      //var xml = document.implementation.createDocument("","",null);
      //xml.async = false;
      //xml.load(url.spec);
      
      var req = new XMLHttpRequest();
      req.open("GET", url.spec, false);
      req.overrideMimeType("application/xml");
      req.send(null);
      var xml = req.responseXML;      
      
      var kids = xml.getElementsByTagName("outline");
      for (var i=0; i<kids.length; i++)
      {
        var url = kids[i].getAttribute("xmlUrl");
        if (url == null) continue;
        createNewFeed(model, url);
      }                 
      
      saveFeedModel();
      refreshModel();     
      alert("Successfully imported OPML.");
    }
    catch (err)
    {
      alert("Import failed: " + err);
    }
  }
}

