/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

////////////////////////////////////////////////////////////////
// Global
////////////////////////////////////////////////////////////////
const iconOk = "chrome://newsfox/skin/images/feed.png";
var model = new Model();

////////////////////////////////////////////////////////////////
// Model
////////////////////////////////////////////////////////////////

function Model()
{
  this.add  = function(feed)  { feeds.push(feed); }
  this.get  = function(index) { return feeds[index]; }
	this.set  = function(index, feed)
	{
		if(index < 0 || index > feeds.length - 1)
			return;
		feeds[index] = feed;
	}
  this.getFeedByURL  = function(url)
	{
		for(var i=0; i < feeds.length; i++)
			if(url == feeds[i].url)
				return feeds[i];

		return null;
	}

  this.size = function() // returns size without excluded feed(s)	
	{
		var size = 0;
		for( var i = 0; i < feeds.length; i++ )
			if( !feeds[i].exclude )
				size++;
		return size;
	}

  this.sizeTotal = function() // returns total size, i.e. with excluded from seeing feed(s)
	{
		return feeds.length;
	}

  var feeds = new Array();

  /**
   * Return a new unique uid.
   */
  this.makeUniqueUid = function(url)
  {
    var index  = url.indexOf("://");
		var body;
		if( index > -1 )
			body = url.substring(index+3);
		else
			body = url;
    var domain;
		if( body.indexOf("/") != -1 )
			domain = body.split("/")[0];
		if( domain.indexOf(":") != -1 )
			domain = domain.split(":")[0]; // there are cases when port number follows domain name
    var count = 1;
    var name = domain;
    for (var i=0; i<feeds.length; i++)
    {
      if (name == feeds[i].uid)
      {
        name = domain + (count++);
        i = -1; // reset loop
      }
    }
    return name;
  }

  /**
   * Remove the given feed from the model.
   */
  this.remove = function(feed)
  {
    for (var i=0; i < feeds.length; i++)
      if (feed.uid == feeds[i].uid)
      {
        feeds.splice(i,1);
        return;
      }
  }

  /**
   * Alphatbize list by display name.
   */
  this.sort = function()
  {
    // TODO - Simple bubble sort, use
    // more effecient algoritm

    for (var i=0; i<feeds.length-1; i++)
      for (var j=feeds.length-1; j>i; j--)
      {
        var a = feeds[j].getDisplayName().toLowerCase();
        var b = feeds[j-1].getDisplayName().toLowerCase();
				if( (feeds[j-1].exclude && !feeds[j].exclude) || (a < b && !feeds[j].exclude) )
        {
          var temp = feeds[j]
          feeds[j] = feeds[j-1];
          feeds[j-1] = temp;
        }
      }
  }
	/**
	 * Shift excluded feeds to the end of list
	 */
	this.shiftExcluded = function()
	{
		var k = feeds.length-1;
		while(feeds[k].exclude && k > 0) k--;
		var i = 0;
		while(i <= k && !feeds[i].exclude) i++;
		for(;i<=k;i++)
		{
			if(feeds[i].exclude)
			{
				var j = i+1;
				while(j <= k && feeds[j].exclude) j++;
				if( j <= k )
				{
					var temp = feeds[j];
					feeds[j] = feeds[i];
					feeds[i] = temp;
				}
				else break;
			}
		}
	}

	this.updateLivemarks = function(livemarks, selected, bNew)
	{
		for( var i=0; i < livemarks.length; i++ )
		{
			var isExcluded = true;
			for( var k = 0; k < selected.length; k++ )
				if( selected[k] == livemarks[i].URL )
				{
					isExcluded = false;
					break;
				}
			var feed;
			var isNew = false;
			if( bNew )
				isNew = true;
			else
			{
				feed = this.getFeedByURL(livemarks[i].URL);
				if( !feed ) isNew = true;
			}

			if( isNew )
			{
				feed = createNewFeed(this, livemarks[i].URL);
				feed.setDefaultName(livemarks[i].title);
			}
			feed.exclude = isExcluded;
		}

		saveFeedModel();
	}
}

////////////////////////////////////////////////////////////////
// Feed Model
////////////////////////////////////////////////////////////////

function Feed()
{
  this.uid = null;
  this.url = null;
  this.homepage = null;
	this.icon = new Image;
	this.icon.src = iconOk;
  this.defaultName = null;
  this.customeName = null;
  this.error = ERROR_OK;
  this.loaded = false;
  this.deleteOld = false;
  this.dontDeleteUnread = false;
  this.autoCheck = true;
  var categories = new Array();
  this.expanded = false;
	this.exclude = false;
	this.newItemsCount = 0;

  // 0 Use global setting
  // 1 Override to show as text
  // 2 Override to show as webpage
  // 3 Override to show as newspaper
  this.style = 0;
  this.getStyle = function()
  {
    if (this.style == 0)
      return options.globalStyle;
    return this.style;
  }

  /**
   * Return display name for feed.
   */
  this.getDisplayName = function()
  {
    return ((this.customName != null) && (this.customName.length > 0)) ? this.customName : this.defaultName;
  }

  this.setDefaultName = function(dname)
  {
    this.defaultName = encodeString(dname);
  }

  this.getCustomName = function()
  {
    return this.customName;
  }

  this.setCustomName = function(cname)
  {
    this.customName = encodeString(cname);
  }

  /**
   * Return the number of unread items for this feed.
   */
  this.getUnread = function(nCategory)
  {
    var unread = 0;
    for (var i=0; i<this.flags.length; i++)
      if ((this.flags[i] & 0x03) == 0) // unread/trash
      {
        if( nCategory == 0 )
          unread++;
        else if (articles[i].category == categories[nCategory-1])
          unread++;
      }
    return unread;
  }

  this.add = function(article)
  {
    // AG: uniform add
    // articles.push(article);
    this.addExisting(article);
    this.flags.push(0);
  }

  this.addExisting = function(article)
  {
    articles.push(article);
    // AG: added category
    if(article.category != "")
      this.addCategory(article.category);
  }

  this.get = function(index)
  {
    return articles[index];
  }

  this.remove = function(index)
  {
    articles.splice(index,1);
    this.flags.splice(index,1);
  }

  this.getIndexByURL = function(url)
  {
		for(var i=0; i < articles.length; i++)
			if(url == articles[i].link)
				return i;
		return -1;
  }

  this.removeByURL = function(url)
  {
    var index = this.getIndexByURL(url);
    if( index >= 0 && index < articles.length)
		{
			articles.splice(index,1);
			this.flags.splice(index,1);
		}
  }

  this.size = function() { return articles.length; }
  var articles = new Array();

  // Flags
  this.flags = new Array();

// TODO - make these directly off index
  this.isRead = function(article)
  {
    var index = getIndexOf(article);
    return ((this.flags[index] & 0x01) != 0);
  }
  this.setRead = function(article, value)
  {
    var index = getIndexOf(article);
    if (value) this.flags[index] |= 0x01;
    else this.flags[index] &= 0xFE;
  }

  this.isTrash = function(article)
  {
    var index = getIndexOf(article);
    return ((this.flags[index] & 0x02) != 0);
  }
  this.setTrash = function(article, value)
  {
    var index = getIndexOf(article);
    if (value) this.flags[index] |= 0x02;
    else this.flags[index] &= 0xFD;
  }

  this.isFlagged = function(article)
  {
    var index = getIndexOf(article);
    return ((this.flags[index] & 0x04) != 0);
  }
  this.setFlagged = function(article, value)
  {
    var index = getIndexOf(article);
    if (value) this.flags[index] |= 0x04;
    else this.flags[index] &= 0xFB;
  }

  function getIndexOf(article)
  {
    for (var i=0; i<articles.length; i++)
      if (article.link == articles[i].link)
        return i;
    return null;
  }

  /**
   * Sort articles by descending date.
   */
  this.sort = function()
  {
    // TODO - throw an exception?
    if (!this.loaded) return;

    // TODO - Simple bubble sort, use
    // more effecient algoritm

    for (var i=0; i<articles.length-1; i++)
      for (var j=articles.length-1; j>i; j--)
      {
        var a = articles[j].date;
        var b = articles[j-1].date;

        if (a > b)
        {
          var temp = articles[j];
          articles[j] = articles[j-1];
          articles[j-1] = temp;

          var temp = this.flags[j];
          this.flags[j] = this.flags[j-1];
          this.flags[j-1] = temp;
        }
      }
  }

  // AG: added categories
  this.addCategory = function(category)
  {
    // check if a category is already in the list
    for (var i=0; i<categories.length; i++)
      if (categories[i] == category) return;

    categories.push(category);
  }
  this.getCategories = function() { return categories; }
  this.sortCategories = function() { categories.sort(); }

	this.getNewItemsCount = function() { return this.newItemsCount; }
	this.setNewItemsCount = function(newCount) { this.newItemsCount = newCount; }
}

////////////////////////////////////////////////////////////////
// Article Model
////////////////////////////////////////////////////////////////

function Article()
{
  this.link  = null;
  this.title = null;
  this.body  = null;
  this.date  = null;
  // AG: added category
  this.category  = null;
  // TODO - going bye-bye
  this.read  = true;
  this.flag  = false;
  this.trash = false;
}

////////////////////////////////////////////////////////////////
// Collections
////////////////////////////////////////////////////////////////

// AG: categoryNo isn't an index. 0 means root (or whole feed)
function NormalCollection(feed, categoryNo)
{
  this.feed = feed;
  var items = new Array();
  var categoryName;
  var art;
  if (categoryNo > 0)
  {
    var categories = feed.getCategories();
    categoryName = categories[categoryNo - 1];
  }
  for (var i=0; i<feed.size(); i++)
    if (!feed.get(i).trash)
      if (categoryNo < 1)
        items.push(feed.get(i));
      else
      {
        art = feed.get(i);
        if( art.category == categoryName )
          items.push(art);
      }
  this.get  = function(index) { return items[index]; }
  this.size = function() { return items.length; }
  this.getArray = function() { return items; }
}

function FlaggedCollection()
{
  var items = new Array();
  for (var i=0; i<model.size(); i++)
  {
    var feed = model.get(i);
    for (var j=0; j<feed.size(); j++)
      if (feed.get(j).flag)
        items.push(feed.get(j));
  }
  this.get  = function(index) { return items[index]; }
  this.size = function() { return items.length; }
  this.getArray = function() { return items; }
}

function TrashCollection()
{
  var items = new Array();
  for (var i=0; i<model.size(); i++)
  {
    var feed = model.get(i);
    for (var j=0; j<feed.size(); j++)
      if (feed.get(j).trash)
        items.push(feed.get(j));
  }
  this.get  = function(index) { return items[index]; }
  this.size = function() { return items.length; }
  this.getArray = function() { return items; }
}

///////////////////////////////////////////////////////////
// AG: check model against livemarks. Returns an array, possibly empty.
function getNewLivemarks()
{
	var allLivemarks = liveBookmarks.getAll();
	var allLivemarksLen = allLivemarks.length;
	var newLivemarks = new Array();
	var modelTotalSize = model.sizeTotal();
	for( var k=0; k < allLivemarksLen; k++ )
	{
		var livemark = allLivemarks[k];
		var isNew = true;
		for( var i=0; i < modelTotalSize; i++ )
			if( model.get(i).url == livemark.URL)
			{
				isNew = false;
				break;
			}

		if( isNew )
			newLivemarks.push(livemark);
	}

	return newLivemarks;
}
