/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

////////////////////////////////////////////////////////////////
// Profile
////////////////////////////////////////////////////////////////

/**
 * Get the newsfox directory under the user profile
 * directory.  Create newsfox directory if it does
 * not exist. 
 */
function getProfileDir()
{
  var file = Components.classes["@mozilla.org/file/directory_service;1"].
    getService(Components.interfaces.nsIProperties).
    get("ProfD", Components.interfaces.nsIFile);
  file.append("newsfox");
  if (!file.exists()) file.create(0x01, 0750);
  return file;
}

function getTextViewFile(art)
{
	var file = getProfileDir();
	file.append("textview.html");
	var out = openOutputStream(file, 0x02 | 0x08 | 0x20);
	println(out, "<HTML>\n<HEAD>\n\t<META http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />\n</HEAD>");

	println(out, "<BODY style=\"font:10pt Verdana;background:white;\">");
	println(out, "<DIV style=\"background:#e3dfd9;padding:10px;overflow:hidden;\">");
	println(out, "<B>"+art.title+"</B><BR/>");
	if( art.category != "" )
 		println(out, art.category + ": ");
 	println(out, art.date.toLocaleString() + "<BR/>");
 	println(out, "<A HREF=\""+art.link+"\">"+art.link+"</A></DIV>");

	println(out, "<P>"+art.body+"</P>");
	println(out, "</BODY>\n</HTML>");
	out.close();

	return file;
}

////////////////////////////////////////////////////////////////
// File Util
////////////////////////////////////////////////////////////////

function openOutputStream(file, flags)
{
  var out = Components.classes["@mozilla.org/network/file-output-stream;1"]
    .createInstance(Components.interfaces.nsIFileOutputStream);
  out.init(file, flags, 0664, 0);
  return out;
}

function print(out, data)
{
  out.write(data, data.length);
}

function println(out, data)
{
  data += "\n";
  out.write(data, data.length);
}

////////////////////////////////////////////////////////////////
// Create new feed
////////////////////////////////////////////////////////////////

function createNewFeed(model, url)
{
	var feed;
  try
  {
    var uid  = model.makeUniqueUid(url); //makeUid(model, url);
    feed = new Feed();
    feed.uid = uid;
    feed.url = url;
    feed.defaultName = uid;
    model.add(feed);
  }
  catch (err) 
  { 
    var msg = "createNewFeed(): [" + uid + "] " + err
    alert(msg); 
  }

	return feed; 
}

////////////////////////////////////////////////////////////////
// Load feeds from disk
////////////////////////////////////////////////////////////////

function loadFeedModel()
{
  model = new Model();
  try
  {
    var file = getProfileDir();
    file.append("master.xml");

    var xml = document.implementation.createDocument("","",null);
    xml.async = false;
    xml.load("file:///" + file.path);

    // Get file version
    var root = xml.getElementsByTagName("newsfox-feedlist")[0];
    var version = root.getAttribute("version");

    var kids = xml.getElementsByTagName("feed");
    for (var i=0; i<kids.length; i++)
    {
      var feed = new Feed();
			feed.exclude = (kids[i].getAttribute("exclude") == "true");
      feed.uid = child(kids[i], "uid").childNodes[0].nodeValue;
      feed.url = child(kids[i], "url").childNodes[0].nodeValue;
      feed.defaultName = feed.uid; 
      var v = child(kids[i], "dname");
      if (v != null) feed.defaultName = v.childNodes[0].nodeValue;

      v = child(kids[i], "home");
      if (v != null && v.childNodes.length > 0) feed.homepage = v.childNodes[0].nodeValue;

			v = child(kids[i], "icon");
			if (v != null && v.childNodes.length > 0) feed.icon.src = v.childNodes[0].nodeValue;

      v = child(kids[i], "style");
      if (v != null && v.childNodes.length > 0) feed.style = parseInt(v.childNodes[0].nodeValue);

      v = child(kids[i], "deleteOld");
      if (v != null && v.childNodes.length > 0) 
        feed.deleteOld = (v.childNodes[0].nodeValue == "true");

      v = child(kids[i], "autoCheck");
      if (v != null && v.childNodes.length > 0)
        feed.autoCheck = (v.childNodes[0].nodeValue == "true");
      else feed.autoCheck = true;

      v = child(kids[i], "expanded");
      if (v != null && v.childNodes.length > 0) 
        feed.expanded = (v.childNodes[0].nodeValue == "true");

      v = child(kids[i], "customName");
      if (v != null && v.childNodes.length > 0) feed.customName = v.childNodes[0].nodeValue;

      v = child(kids[i], "dontDeleteUnread");
      if (v != null && v.childNodes.length > 0) feed.dontDeleteUnread = (v.childNodes[0].nodeValue == "true");

      var elem = child(kids[i], "flags");
      if (elem != null && elem.childNodes.length > 0)
      {
        var flags = elem.childNodes[0].nodeValue;
        for (var j=0; j<flags.length; j++)
          feed.flags.push(parseInt(flags.charAt(j)));
      }

      // Version 1.0 tried to encode body text. Version 1.1
      // just uses CDATA, so decode not necessary
      if (version == "1.0")
      {
        feed.url = decodeHTML(feed.url);
        feed.defaultName = decodeHTML(feed.defaultName);
        feed.homepage = decodeHTML(feed.homepage);
      }

      model.add(feed);
    }
  }
  catch (err) 
  { 
    var msg = "loadFeedModel(): " + "[" + feed.uid + "," + elem + "]\n" + err; 
    alert(msg);
  }
}

function loadFeed(feed)
{
	if (feed.loaded) return;
	downloadIcon(feed);
  try
  {
    var file = getProfileDir();
    file.append(feed.uid + ".xml");
    checkFeedFile(file);

    var xml = document.implementation.createDocument("","",null);
    xml.async = false;
    xml.load("file:///" + file.path);

    // Get file version
    var root = xml.getElementsByTagName("newsfox-feed")[0];
    var version = root.getAttribute("version");

    var kids = xml.getElementsByTagName("article");
    for (var i=0; i<kids.length; i++)
    {
      var link  = child(kids[i], "link").childNodes[0];
      var title = child(kids[i], "title").childNodes[0];
      var date  = child(kids[i], "date").childNodes[0];
      var body  = child(kids[i], "body").childNodes[0];

      // AG: added category
      var category  = child(kids[i], "category");
      if (category != null) category = category.childNodes[0];

      var art = new Article();
      art.link  = (link  == null) ? "" : link.nodeValue;
      art.title = (title == null) ? "" : title.nodeValue;
      art.body  = (body  == null) ? "" : body.nodeValue;
      art.date  = new Date();
      if (date != null) art.date.setTime(Date.parse(date.nodeValue));
      // AG: added category
      art.category  = (category  == null) ? "" : category.nodeValue;

      // Version 1.0 tried to encode body text. Version 1.1
      // just uses CDATA, so decode not necessary
      if (version == "1.0")
      {
        art.link  = decodeHTML(art.link);
        art.title = decodeHTML(art.title);
        art.body  = decodeHTML(art.body);
      }

      // Add feed
      feed.addExisting(art);
    }
    feed.sortCategories();
		feed.loaded = true;
  }
  catch (err) { alert("loadFeed(): " + feed.uid + "\n" + err); }
}

function checkFeedFile(file)
{
  try
  {
    if (!file.exists())
    {
      var out = openOutputStream(file, 0x02 | 0x08 | 0x20);
      println(out, "<newsfox-feed version=\"1.1\">");
      println(out, "</newsfox-feed>");
      out.close();
    }
  }
  catch (err) { alert(err); }
}


////////////////////////////////////////////////////////////////
// Save feeds to disk
////////////////////////////////////////////////////////////////

function saveFeedModel()
{
	model.shiftExcluded(); // to ensure excluded feeds to be at the end
  options.save();
  try
  {
    var file = getProfileDir();
    file.append("master.xml");

    var out = openOutputStream(file, 0x02 | 0x08 | 0x20);
    println(out, "<newsfox-feedlist version=\"1.1\">");
    for (var i=0; i<model.sizeTotal(); i++)
    {
      var feed = model.get(i);
      println(out, " <feed exclude=\"" + feed.exclude + "\">");
      println(out, "  <uid>" + feed.uid + "</uid>");
      println(out, "  <url><![CDATA[" + feed.url + "]]></url>");
      println(out, "  <dname><![CDATA[" + feed.defaultName + "]]></dname>");
      if (feed.homepage != null)
        println(out, "  <home><![CDATA[" + feed.homepage + "]]></home>");
			if (feed.icon.src != null)
				println(out, "  <icon><![CDATA[" + feed.icon.src + "]]></icon>");
			// Only save if property overrides global setting
      if (feed.style != 0)
        println(out, "  <style>" + feed.style + "</style>");
      println(out, "  <deleteOld>" + feed.deleteOld + "</deleteOld>");
      println(out, "  <autoCheck>" + feed.autoCheck + "</autoCheck>");
      println(out, "  <expanded>" + feed.expanded + "</expanded>");
			if( null != feed.customName )
	      println(out, "  <customName><![CDATA[" + feed.customName + "]]></customName>");
      println(out, "  <dontDeleteUnread>" + feed.dontDeleteUnread + "</dontDeleteUnread>");
      print(out, "  <flags>");
      for (var j=0; j<feed.flags.length; j++)
        print(out, "" + feed.flags[j]);
      println(out, "</flags>");
      println(out, " </feed>");
    }
    println(out, "</newsfox-feedlist>");
    out.close();
  }
  catch (err) { alert("saveFeedModel(): [" + feed.uid + "] " + err); }
}

function saveFeed(feed)
{
  var file = getProfileDir();
  file.append(feed.uid + ".xml");

  var out = openOutputStream(file, 0x02 | 0x08 | 0x20);
  println(out, "<newsfox-feed version=\"1.1\">");
  for (var i=0; i<feed.size(); i++)
  {
    var art = feed.get(i);
    println(out, " <article>");
    println(out, "  <link><![CDATA[" + art.link + "]]></link>");
    println(out, "  <title><![CDATA[" + art.title + "]]></title>");
    println(out, "  <date>" + art.date + "</date>");
    println(out, "  <body><![CDATA[" + art.body + "]]></body>");
    // AG: added category
    println(out, "  <category><![CDATA[" + art.category + "]]></category>");
    println(out, " </article>");
  }
  println(out, "</newsfox-feed>");
  out.close();
}

////////////////////////////////////////////////////////////////
// Delete feed
////////////////////////////////////////////////////////////////

function deleteFeedFromDisk(feed)
{
  try
  {
    var file = getProfileDir();
    file.append(feed.uid + ".xml");
    if (file.exists()) file.remove(false);
  }
  catch (err) { alert("deleteFeedFromDisk(): [" + feed.uid + "] " + err); }
}

////////////////////////////////////////////////////////////////
// Util
////////////////////////////////////////////////////////////////

function child(element, tagName)
{
  var kids = element.childNodes;
  for (var i=0; i<kids.length; i++)
    if (kids[i].nodeName == tagName) 
      return kids[i];
  return null;
}

////////////////////////////////////////////////////////////////
// Encode/Decode
////////////////////////////////////////////////////////////////

/**
 * Return XML-friendly HTML encoding.
 */
function encodeHTML(s) 
{
  s = s.replace(new RegExp('&','gi'), '&amp;');
  s = s.replace(new RegExp('<','gi'), '&lt;');
  s = s.replace(new RegExp('>','gi'), '&gt;');
  s = s.replace(new RegExp('"','gi'), '&quot;');
  return s;
}

/**
 * Return original HTML from encoding.
 */
function decodeHTML(s)
{
  s = s.replace(new RegExp('&amp;'  ,'gi'), '&');
  s = s.replace(new RegExp('&lt;'   ,'gi'), '<');
  s = s.replace(new RegExp('&gt;'   ,'gi'), '>');
  s = s.replace(new RegExp('&quot;' ,'gi'), '"');
  s = s.replace(new RegExp('&acute;','gi'), '');
  return s;
}

