config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config var/log/pgsql/serverlog.new
config etc/rc.d/rc.pgsql.new

# remove the serverlog.new file if it exists
rm -f var/log/pgsql/serverlog.new

# If the pgsql user/group don't exist, add them:
if grep "^pgsql:x:" etc/passwd 1> /dev/null 2> /dev/null ; then
  true
else
  echo "pgsql:x:73:73:pgsql:/:" >> etc/passwd
fi
if grep "^pgsql::" etc/group 1> /dev/null 2> /dev/null ; then
  true
else
  echo "pgsql::73:pgsql" >> etc/group
fi
if grep "^pgsql:" etc/shadow 1> /dev/null 2> /dev/null ; then
  true
else
  echo "pgsql:*:9797:0:::::" >> etc/shadow
fi

chown -R pgsql.pgsql /var/log/pgsql
( cd usr/lib ; rm -rf libpq.so.4 )
( cd usr/lib ; ln -sf libpq.so.4.1 libpq.so.4 )
( cd usr/lib ; rm -rf libpq.so )
( cd usr/lib ; ln -sf libpq.so.4.1 libpq.so )
( cd usr/lib ; rm -rf libecpg.so.5 )
( cd usr/lib ; ln -sf libecpg.so.5.1 libecpg.so.5 )
( cd usr/lib ; rm -rf libpgtypes.so.2 )
( cd usr/lib ; ln -sf libpgtypes.so.2.1 libpgtypes.so.2 )
( cd usr/lib ; rm -rf libpgtypes.so )
( cd usr/lib ; ln -sf libpgtypes.so.2.1 libpgtypes.so )
( cd usr/lib ; rm -rf libecpg.so )
( cd usr/lib ; ln -sf libecpg.so.5.1 libecpg.so )
( cd usr/lib ; rm -rf libecpg_compat.so.2 )
( cd usr/lib ; ln -sf libecpg_compat.so.2.1 libecpg_compat.so.2 )
( cd usr/lib ; rm -rf libecpg_compat.so )
( cd usr/lib ; ln -sf libecpg_compat.so.2.1 libecpg_compat.so )
( cd usr/bin ; rm -rf postmaster )
( cd usr/bin ; ln -sf postgres postmaster )
