/*
  ImageMagick Binary Large OBjects public methods.
*/
#ifndef _MAGICK_BLOB_H
#define _MAGICK_BLOB_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#include "magick/image.h"
#include "magick/stream.h"

#if !defined(MagickMaxBufferSize)
#define MagickMaxBufferSize  0x3c005UL
#endif

typedef enum
{
  ReadMode,
  WriteMode,
  IOMode
} MapMode;

extern MagickExport FILE
  *GetBlobFileHandle(const Image *);

extern MagickExport Image
  *BlobToImage(const ImageInfo *,const void *,const size_t,ExceptionInfo *),
  *PingBlob(const ImageInfo *,const void *,const size_t,ExceptionInfo *);

extern MagickExport  MagickBooleanType
  BlobToFile(char *,const void *,const size_t,ExceptionInfo *),
  GetBlobError(const Image *),
  ImageToFile(Image *,char *,ExceptionInfo *),
  IsBlobExempt(const Image *),
  IsBlobSeekable(const Image *),
  IsBlobTemporary(const Image *);

extern MagickExport MagickSizeType
  GetBlobSize(const Image *image);

extern MagickExport StreamHandler
  GetBlobStreamHandler(const Image *);

extern MagickExport unsigned char
  *FileToBlob(const char *,size_t *,ExceptionInfo *),
  *GetBlobStreamData(const Image *),
  *ImageToBlob(const ImageInfo *,Image *,size_t *,ExceptionInfo *);

extern MagickExport void
  DestroyBlob(Image *),
  SetBlobExempt(Image *,const MagickBooleanType);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
