
var gShowDescription = true;
var gData;
const kPrefSvcContractID = "@mozilla.org/preferences;1";
const kPrefSvcIID = Components.interfaces.nsIPref;
const kPrefSvc = Components.classes[kPrefSvcContractID].getService(kPrefSvcIID);

try {
  var chromeRegistry = Components.classes["@mozilla.org/chrome/chrome-registry;1"].getService();
  if (chromeRegistry)
    chromeRegistry = chromeRegistry.QueryInterface(Components.interfaces.nsIXULChromeRegistry);
}
catch(e) {}

function Startup()
{
  gData = parent.hPrefWindow.wsm.dataManager.pageData["chrome://communicator/content/pref/pref-themes.xul"];
  var list = document.getElementById( "skinsList" );
  if ("loaded" in gData && "themeIndex" in gData) {
    list.selectedIndex = gData.themeIndex;    
    return;
  }
  gData.loaded = true;
  parent.hPrefWindow.registerOKCallbackFunc(applyTheme);

  var theme = null;
  try {
    theme = kPrefSvc.getComplexValue("general.skins.selectedSkin",
                                     Components.interfaces.nsISupportsString).data;
  } catch (e) {
  }
  var matches;
  for (var i = 0; i < list.childNodes.length; ++i) {
    var child = list.childNodes[i];
    var name = child.getAttribute("name");
    if (!theme)
      matches = chromeRegistry.isSkinSelectedForPackage(name, "browser", true);
    else
      matches = name == theme;
    if (matches) {
      list.selectItem(child);
      break;
    }      
  }

  var navbundle = document.getElementById("bundle_navigator");
  var showSkinsDescription = navbundle.getString("showskinsdescription");
  if (showSkinsDescription == "false")
  {
    gShowDescription = false;
    var description = document.getElementById("description");
    while (description.hasChildNodes())
      description.removeChild(description.firstChild);
  }

  var extList = document.getElementById("extList");
  for (var i = 0; i < extList.childNodes.length; ++i) {
    if (extList.childNodes[i].getAttribute("name")) {
      extList.selectItem(extList.childNodes[i]);
      break;
    }
  }
}

function applyTheme()
{
  var data = parent.hPrefWindow.wsm.dataManager.pageData["chrome://communicator/content/pref/pref-themes.xul"];
  if (data.name == null)
    return;

  const kPrefSvcContractID = "@mozilla.org/preferences;1";
  const kPrefSvcIID = Components.interfaces.nsIPref;
  const kPrefSvc = Components.classes[kPrefSvcContractID].getService(kPrefSvcIID);

  var theme = null;
  try {
    theme = kPrefSvc.getComplexValue("general.skins.selectedSkin",
                                     Components.interfaces.nsISupportsString).data;
  } catch (e) {
  }

  if (theme == data.name) return;

  try {
    var reg = Components.classes["@mozilla.org/chrome/chrome-registry;1"].getService();
    if (reg)
      reg = reg.QueryInterface(Components.interfaces.nsIXULChromeRegistry);
  }
  catch(e) {}

  var inUse = reg.isSkinSelected(data.name, true);
  if (!theme && inUse == Components.interfaces.nsIChromeRegistry.FULL) return;

  var chromeRegistry = Components.classes["@mozilla.org/chrome/chrome-registry;1"]
    .getService(Components.interfaces.nsIXULChromeRegistry);

  var oldTheme = false;
  try {
    oldTheme = !chromeRegistry.checkThemeVersion(data.name);
  }
  catch(e) {
  }


  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
  if (oldTheme) {
    var title = gNavigatorBundle.getString("oldthemetitle");
    var message = gNavigatorBundle.getString("oldTheme");

    message = message.replace(/%theme_name%/, themeName.getAttribute("displayName"));
    message = message.replace(/%brand%/g, gBrandBundle.getString("brandShortName"));

    if (promptService.confirm(window, title, message)){
      var inUse = chromeRegistry.isSkinSelected(data.name, true);

      chromeRegistry.uninstallSkin(data.name, true);

      var str = Components.classes["@mozilla.org/supports-string;1"]
                          .createInstance(Components.interfaces.nsISupportsString);

      str.data = true;
      pref.setComplexValue("general.skins.removelist." + data.name,
                           Components.interfaces.nsISupportsString, str);
      
      if (inUse)
        chromeRegistry.refreshSkins();
    }

    return;
  }

var str = Components.classes["@mozilla.org/supports-string;1"]
                    .createInstance(Components.interfaces.nsISupportsString);
str.data = data.name;
kPrefSvc.setComplexValue("general.skins.selectedSkin", Components.interfaces.nsISupportsString, str);


chromeRegistry.selectSkin(data.name, true);                                        
chromeRegistry.refreshSkins();
}


function uninstallSkin()
{
  var list = document.getElementById("skinsList");
  var selectedSkinItem = list.selectedItems[0];
  var skinName = selectedSkinItem.getAttribute("name");
  var inUse = chromeRegistry.isSkinSelected(skinName, true);
  chromeRegistry.uninstallSkin(skinName, true);
  if (inUse)
    chromeRegistry.refreshSkins();
  list.selectedIndex = 0;
}

function themeSelect()
{
  var list = document.getElementById("skinsList");

  if (!list)
    return;

  var prefbundle = document.getElementById("bundle_prefutilities");

  var selectedItem = list.selectedItems.length ? list.selectedItems[0] : null;
  if (selectedItem && selectedItem.getAttribute("skin") == "true") {
    var themeName = selectedItem.getAttribute("displayName");
    var skinName = selectedItem.getAttribute("name");
    gData.name = skinName;
    gData.themeIndex = list.selectedIndex;

    var oldTheme;
    try {
      oldTheme = !chromeRegistry.checkThemeVersion(skinName);
    }
    catch(e) {
      oldTheme = false;
    }

    var nameField = document.getElementById("displayName");
    var author = document.getElementById("author");
    var image = document.getElementById("previewImage");
    var descText = document.createTextNode(selectedItem.getAttribute("description"));
    var description = document.getElementById("description");
    var uninstallButton = document.getElementById("uninstallSkin");
    var uninstallLabel = prefbundle.getString("uninstallThemePrefix");

    while (description.hasChildNodes())
      description.removeChild(description.firstChild);

    nameField.setAttribute("value", themeName);
    author.setAttribute("value", selectedItem.getAttribute("author"));
    image.setAttribute("src", selectedItem.getAttribute("image"));

    // XXX - this sucks and should only be temporary.
    var selectedSkin = "";
    try {
      selectedSkin = kPrefSvc.CopyCharPref("general.skins.selectedSkin");
    }
    catch (e) {
    }
    if (!oldTheme) {    
      if( gShowDescription ) 
        description.appendChild(descText);

      var locType = selectedItem.getAttribute("loctype");
      uninstallButton.disabled = (selectedSkin == skinName) || (locType == "install");
      
      uninstallLabel = uninstallLabel.replace(/%theme_name%/, themeName);
      uninstallButton.label = uninstallLabel;
    }
    else {
      var brandbundle = document.getElementById("bundle_brand");

      uninstallLabel = uninstallLabel.replace(/%theme_name%/, themeName);
      uninstallButton.label = uninstallLabel;

      uninstallButton.disabled = selectedSkin == skinName;

      var newText = prefbundle.getString("oldTheme");
      newText = newText.replace(/%theme_name%/, themeName);
      
      newText = newText.replace(/%brand%/g, brandbundle.getString("brandShortName"));

      if( gShowDescription )  {
        descText = document.createTextNode(newText);
        description.appendChild(descText);
      }
    }
  }
  else {
    uninstallButton.disabled = true;
    gData.name = null;
  }
}


function extensionSelect()
{
  var list = document.getElementById("extList");

  if (!list)
    return;

  var selectedItem = list.selectedItems.length ? list.selectedItems[0] : null;
  if (selectedItem) {
    var extName = selectedItem.getAttribute("displayName");
    var nameField = document.getElementById("extDisplayName");
    var author = document.getElementById("extAuthor");
    var descText = document.createTextNode(selectedItem.getAttribute("description"));
    var description = document.getElementById("extDescription");
    var uninstallButton = document.getElementById("uninstallExtension");
    
    while (description.hasChildNodes())
      description.removeChild(description.firstChild);

    nameField.setAttribute("value", extName);
    author.setAttribute("value", selectedItem.getAttribute("author"));
    
    description.appendChild(descText);

    updateDisableExtButton(selectedItem);
  }
}

function toggleExtension()
{
  var list = document.getElementById("extList");

  if (!list)
    return;

  var selectedItem = list.selectedItems.length ? list.selectedItems[0] : null;
  if (selectedItem) {
    var disabled = (selectedItem.getAttribute("disabledState") == "true");
    chromeRegistry.setAllowOverlaysForPackage(selectedItem.getAttribute("name"), disabled);
    updateDisableExtButton(selectedItem);
  }   
}

function updateDisableExtButton(item)
{
  var disableButton = document.getElementById("disableExtension");
  if (disableButton.disabled)
    disableButton.disabled = false;

  if (item.getAttribute("disabledState") == "true")
    disableButton.setAttribute("label", "Enable Extension"); // XXXdwh localize
  else
    disableButton.setAttribute("label", "Disable Extension"); // XXXdwh localize
}
