/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef KMEDIA2_H
#define KMEDIA2_H

#include "common.h"

namespace Arts {
enum poState {posIdle = 0, posPlaying = 1, posPaused = 2};
enum poCapabilities {capSeek = 1, capPause = 2};
};
namespace Arts {
class poTime : public Arts::Type {
public:
	poTime();
	poTime(long seconds, long ms, float custom, const std::string& customUnit);
	poTime(Arts::Buffer& stream);
	poTime(const poTime& copyType);
	poTime& operator=(const poTime& assignType);
	long seconds;
	long ms;
	float custom;
	std::string customUnit;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

};
namespace Arts {
class PlayObject_private;
class PlayObject;
class PlayObjectFactory;

class PlayObject_private_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static PlayObject_private_base *_create(const std::string& subClass = "Arts::PlayObject_private");
	static PlayObject_private_base *_fromString(std::string objectref);
	static PlayObject_private_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline PlayObject_private_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool loadMedia(const std::string& filename) = 0;
};

class PlayObject_private_stub : virtual public PlayObject_private_base, virtual public Arts::Object_stub {
protected:
	PlayObject_private_stub();

public:
	PlayObject_private_stub(Arts::Connection *connection, long objectID);

	bool loadMedia(const std::string& filename);
};

class PlayObject_private_skel : virtual public PlayObject_private_base, virtual public Arts::Object_skel {
public:
	PlayObject_private_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class PlayObject_private : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	PlayObject_private_base *_cache;
	inline PlayObject_private_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(PlayObject_private_base *)_pool->base->_cast(PlayObject_private_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline PlayObject_private(PlayObject_private_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef PlayObject_private_base _base_class;

	inline PlayObject_private() : Arts::Object(_Creator), _cache(0) {}
	inline PlayObject_private(const Arts::SubClass& s) :
		Arts::Object(PlayObject_private_base::_create(s.string())), _cache(0) {}
	inline PlayObject_private(const Arts::Reference &r) :
		Arts::Object(r.isString()?(PlayObject_private_base::_fromString(r.string())):(PlayObject_private_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline PlayObject_private(const Arts::DynamicCast& c) : Arts::Object(PlayObject_private_base::_fromString(c.object().toString())), _cache(0) {}
	inline PlayObject_private(const PlayObject_private& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline PlayObject_private(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static PlayObject_private null() {return PlayObject_private((PlayObject_private_base*)0);}
	inline static PlayObject_private _from_base(PlayObject_private_base* b) {return PlayObject_private(b);}
	inline PlayObject_private& operator=(const PlayObject_private& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline PlayObject_private_base* _base() {return _cache?_cache:_method_call();}

	inline bool loadMedia(const std::string& filename);
};

class PlayObject_base : virtual public Arts::PlayObject_private_base {
public:
	static unsigned long _IID; // interface ID

	static PlayObject_base *_create(const std::string& subClass = "Arts::PlayObject");
	static PlayObject_base *_fromString(std::string objectref);
	static PlayObject_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline PlayObject_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string description() = 0;
	virtual Arts::poTime currentTime() = 0;
	virtual Arts::poTime overallTime() = 0;
	virtual Arts::poCapabilities capabilities() = 0;
	virtual std::string mediaName() = 0;
	virtual Arts::poState state() = 0;
	virtual void play() = 0;
	virtual void seek(const Arts::poTime& newTime) = 0;
	virtual void pause() = 0;
	virtual void halt() = 0;
};

class PlayObject_stub : virtual public PlayObject_base, virtual public Arts::PlayObject_private_stub {
protected:
	PlayObject_stub();

public:
	PlayObject_stub(Arts::Connection *connection, long objectID);

	std::string description();
	Arts::poTime currentTime();
	Arts::poTime overallTime();
	Arts::poCapabilities capabilities();
	std::string mediaName();
	Arts::poState state();
	void play();
	void seek(const Arts::poTime& newTime);
	void pause();
	void halt();
};

class PlayObject_skel : virtual public PlayObject_base, virtual public Arts::PlayObject_private_skel {
public:
	PlayObject_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class PlayObject : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	PlayObject_base *_cache;
	inline PlayObject_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(PlayObject_base *)_pool->base->_cast(PlayObject_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline PlayObject(PlayObject_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef PlayObject_base _base_class;

	inline PlayObject() : Arts::Object(_Creator), _cache(0) {}
	inline PlayObject(const Arts::SubClass& s) :
		Arts::Object(PlayObject_base::_create(s.string())), _cache(0) {}
	inline PlayObject(const Arts::Reference &r) :
		Arts::Object(r.isString()?(PlayObject_base::_fromString(r.string())):(PlayObject_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline PlayObject(const Arts::DynamicCast& c) : Arts::Object(PlayObject_base::_fromString(c.object().toString())), _cache(0) {}
	inline PlayObject(const PlayObject& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline PlayObject(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static PlayObject null() {return PlayObject((PlayObject_base*)0);}
	inline static PlayObject _from_base(PlayObject_base* b) {return PlayObject(b);}
	inline PlayObject& operator=(const PlayObject& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::PlayObject_private() const { return Arts::PlayObject_private(*_pool); }
	inline PlayObject_base* _base() {return _cache?_cache:_method_call();}

	inline bool loadMedia(const std::string& filename);
	inline std::string description();
	inline Arts::poTime currentTime();
	inline Arts::poTime overallTime();
	inline Arts::poCapabilities capabilities();
	inline std::string mediaName();
	inline Arts::poState state();
	inline void play();
	inline void seek(const Arts::poTime& newTime);
	inline void pause();
	inline void halt();
};

class PlayObjectFactory_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static PlayObjectFactory_base *_create(const std::string& subClass = "Arts::PlayObjectFactory");
	static PlayObjectFactory_base *_fromString(std::string objectref);
	static PlayObjectFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline PlayObjectFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::PlayObject createPlayObject(const std::string& filename) = 0;
};

class PlayObjectFactory_stub : virtual public PlayObjectFactory_base, virtual public Arts::Object_stub {
protected:
	PlayObjectFactory_stub();

public:
	PlayObjectFactory_stub(Arts::Connection *connection, long objectID);

	Arts::PlayObject createPlayObject(const std::string& filename);
};

class PlayObjectFactory_skel : virtual public PlayObjectFactory_base, virtual public Arts::Object_skel {
public:
	PlayObjectFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class PlayObjectFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	PlayObjectFactory_base *_cache;
	inline PlayObjectFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(PlayObjectFactory_base *)_pool->base->_cast(PlayObjectFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline PlayObjectFactory(PlayObjectFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef PlayObjectFactory_base _base_class;

	inline PlayObjectFactory() : Arts::Object(_Creator), _cache(0) {}
	inline PlayObjectFactory(const Arts::SubClass& s) :
		Arts::Object(PlayObjectFactory_base::_create(s.string())), _cache(0) {}
	inline PlayObjectFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(PlayObjectFactory_base::_fromString(r.string())):(PlayObjectFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline PlayObjectFactory(const Arts::DynamicCast& c) : Arts::Object(PlayObjectFactory_base::_fromString(c.object().toString())), _cache(0) {}
	inline PlayObjectFactory(const PlayObjectFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline PlayObjectFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static PlayObjectFactory null() {return PlayObjectFactory((PlayObjectFactory_base*)0);}
	inline static PlayObjectFactory _from_base(PlayObjectFactory_base* b) {return PlayObjectFactory(b);}
	inline PlayObjectFactory& operator=(const PlayObjectFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline PlayObjectFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::PlayObject createPlayObject(const std::string& filename);
};

// Forward wrapper calls to _base classes:

inline bool Arts::PlayObject_private::loadMedia(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObject_private_base*>(_cache)->loadMedia(filename):static_cast<Arts::PlayObject_private_base*>(_method_call())->loadMedia(filename);
}

inline bool Arts::PlayObject::loadMedia(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObject_private_base*>(_cache)->loadMedia(filename):static_cast<Arts::PlayObject_private_base*>(_method_call())->loadMedia(filename);
}

inline std::string Arts::PlayObject::description()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->description():static_cast<Arts::PlayObject_base*>(_method_call())->description();
}

inline Arts::poTime Arts::PlayObject::currentTime()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->currentTime():static_cast<Arts::PlayObject_base*>(_method_call())->currentTime();
}

inline Arts::poTime Arts::PlayObject::overallTime()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->overallTime():static_cast<Arts::PlayObject_base*>(_method_call())->overallTime();
}

inline Arts::poCapabilities Arts::PlayObject::capabilities()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->capabilities():static_cast<Arts::PlayObject_base*>(_method_call())->capabilities();
}

inline std::string Arts::PlayObject::mediaName()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->mediaName():static_cast<Arts::PlayObject_base*>(_method_call())->mediaName();
}

inline Arts::poState Arts::PlayObject::state()
{
	return _cache?static_cast<Arts::PlayObject_base*>(_cache)->state():static_cast<Arts::PlayObject_base*>(_method_call())->state();
}

inline void Arts::PlayObject::play()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->play():static_cast<Arts::PlayObject_base*>(_method_call())->play();
}

inline void Arts::PlayObject::seek(const Arts::poTime& newTime)
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->seek(newTime):static_cast<Arts::PlayObject_base*>(_method_call())->seek(newTime);
}

inline void Arts::PlayObject::pause()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->pause():static_cast<Arts::PlayObject_base*>(_method_call())->pause();
}

inline void Arts::PlayObject::halt()
{
	 _cache?static_cast<Arts::PlayObject_base*>(_cache)->halt():static_cast<Arts::PlayObject_base*>(_method_call())->halt();
}

inline Arts::PlayObject Arts::PlayObjectFactory::createPlayObject(const std::string& filename)
{
	return _cache?static_cast<Arts::PlayObjectFactory_base*>(_cache)->createPlayObject(filename):static_cast<Arts::PlayObjectFactory_base*>(_method_call())->createPlayObject(filename);
}

};
#endif /* KMEDIA2_H */
