// Pspell implementation header file.
// Applications that just use the pspell library should not include 
// these files as they are subject to change.
// Pspell Modules MUST include some of the implementation files and
// spell checkers MAY include some of these files.
// If ANY of the implementation files are included you also link with
// libaspell-impl to protect you from changes in these files.

// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#ifndef PSPELL_ERROR_MESSAGES__HH
#define PSPELL_ERROR_MESSAGES__HH

#include "error.h"

class PspellAppendableString;

void unknown_key(int & num, PspellErrorExtraInfo * & extra,
		 PspellAppendableString & mesg, const char * key);

void cant_change_value(int & num, PspellErrorExtraInfo * & extra,
		       PspellAppendableString & mesg, 
		       const char * key);

void bad_value(int & num, PspellErrorExtraInfo * & extra,
	       PspellAppendableString & mesg, 
	       const char * key, const char * value, 
	       const char * accepted_value);

void bad_key(int & num, PspellErrorExtraInfo * & extra,
	     PspellAppendableString & mesg, 
	     const char * value, 
	     const char * accepted_value);

void duplicate(int & num, PspellErrorExtraInfo * & extra,
	       PspellAppendableString & mesg, 
	       const char * what,
	       const char * value);

void cant_read_file(int & num, PspellErrorExtraInfo * & extra,
		    PspellAppendableString & mesg, const char * file);

void cant_write_file(int & num, PspellErrorExtraInfo * & extra,
		     PspellAppendableString & mesg, const char * file);

void bad_file_format(int & num, PspellErrorExtraInfo * & extra,
		     PspellAppendableString & mesg, 
		     const char * file, const char * info);

void unknown_language(int & num, PspellErrorExtraInfo * & extra,
		      PspellAppendableString & mesg, 
		      const char * language);

void unknown_region(int & num, PspellErrorExtraInfo * & extra,
		    PspellAppendableString & mesg, 
		    const char * region);

void unknown_encoding(int & num, PspellErrorExtraInfo * & extra,
		      PspellAppendableString & mesg, 
		      const char * encoding);

void operation_not_supported(int & num, PspellErrorExtraInfo * & extra,
			     PspellAppendableString & mesg, 
			     const char * operation);

void process_died(int & num, PspellErrorExtraInfo * & extra,
		  PspellAppendableString & mesg, 
		  const char * program);

void cant_load_module(int & num, PspellErrorExtraInfo * & extra,
		      PspellAppendableString & mesg, 
		      const char * module);

#endif
