// Pspell implementation header file.
// Applications that just use the pspell library should not include 
// these files as they are subject to change.
// Pspell Modules MUST include some of the implementation files and
// spell checkers MAY include some of these files.
// If ANY of the implementation files are included you also link with
// libaspell-impl to protect you from changes in these files.

// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#ifndef PSPELL_CONVERT__HH
#define PSPELL_CONVERT__HH

#include "config.h"

#include "error_impl.hh"
#include "app_string.hh"
#include "string.hh"

class PspellConvert : public PspellCanHaveError {
private:
  PspellString in_code_;
  PspellString out_code_;

protected:
  PspellCanHaveErrorImpl error_;
  PspellConvert(const char * incode, const char * outcode);

public:
  int          error_number()  const {return error_.error_number();}
  const char * error_message() const {return error_.error_message();}
  const PspellErrorExtraInfo * error_extra_info() const
    {return error_.error_extra_info();}


  const char * in_code() const   {return in_code_.c_str();}
  const char * out_code() const  {return out_code_.c_str();}
  
  virtual void convert           (const char * in, 
				  PspellAppendableString & out) const;

  virtual const char * convert_until (const char * in, const char * stop,
				      PspellAppendableString & out) const;
  
  virtual bool convert_next_char (const char * & in, 
				  PspellAppendableString & out) const = 0;
  // converts the next char. Advances "in" to the location of the next
  // string
};

bool operator== (const PspellConvert & rhs, const PspellConvert & lhs);

PspellCanHaveError * new_pspell_convert(PspellConfig &,
					const char * in, const char * out);

#endif
