#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use Test::More tests => 6;

### use VASM::Tree
BEGIN { use_ok('VASM::Tree') }

### Ability test
can_ok('VASM::Tree', qw/new store retrieve children/);

### new
# Do not confuse with my($ek, $to)!
my $tree = VASM::Tree->new;
# ...and is a member of the appropriate class?
isa_ok($tree, 'VASM::Tree', '$tree is a VASM::Tree');

### store and retrieve
# Store some things to test later
$tree->store(qw/foo bar baz/, 'nonsense names');
$tree->store(qw/foo fighters/, [ qw/UFO music/ ]);
# Not to be confused with a Chinese penis, but only a pedantic dipshit would
# suggest that anyway
$tree->store('hanumizzle', 'Monkey God');

# Now retrieve some stuff and check it
is($tree->retrieve(qw/foo bar baz/), 'nonsense names',
   q(Datum at qw/foo bar baz/ is string 'nonsense names'));
is_deeply($tree->retrieve(qw/foo fighters/), [ qw/UFO music/ ],
          q(Datum at qw/foo fighters/ contains qw/UFO music/));

### children
# This is actually more of a check that Tie::Hash::Indexed is working! 
is_deeply([ $tree->children ], [ qw/foo hanumizzle/ ],
          'Order of children preserved properly in tree');
