#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use Test::More tests => 3;
use File::Spec::Functions;
use VASM::Resource;

# Set up $ENV{XDG_CONFIG_HOME} and $ENV{XDG_DATA_HOME} to the working
# directory (the same directory as the test script) in '.config' and '.data'
$ENV{XDG_CONFIG_HOME} = catdir($ENV{PWD}, '.config');
$ENV{XDG_DATA_HOME} = catdir($ENV{PWD}, '.data');

### use VASM::Resource::Catalog::Menu + ability test
### (VASM::Resource::Catalog::Menu is not a class, and can therefore not use
### can_ok)
BEGIN { 
  use_ok(
    'VASM::Resource::Catalog::XorgConfig',
    qw/xorgConfigCatalogFind xorgConfigCatalogWrite/)
}

### xorgConfigCatalogFind
my $catalog = xorgConfigCatalogFind;
# Catalog is a member of the appropriate class?
isa_ok($catalog, 'VASM::Catalog::XorgConfig',
       'Catalog is a VASM::Catalog::XorgConfig');

### xorgConfigCatalogWrite
# Made up locale: Qzrzhczakyz language for the country of Foobaristan
$ENV{LC_ALL} = 'qz_FO';
# Write out the menu catalog
xorgConfigCatalogWrite($catalog);
# Is the filename correct?
is(scalar configResourceFind(qw/xorgconfig qz FO config.xml/),
   "$ENV{XDG_CONFIG_HOME}/vasm/xorgconfig/qz/FO/config.xml",
   'xorgConfigCatalogWrite wrote to the right place');
