#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use encoding 'utf8';
use VASM::Resource;
use Test::More tests => 6;
use File::Spec::Functions;

# Set up $ENV{XDG_CONFIG_HOME} and $ENV{XDG_DATA_HOME} to the working
# directory (the same directory as the test script) in '.config' and '.data'
$ENV{XDG_CONFIG_HOME} = catdir($ENV{PWD}, '.config');
$ENV{XDG_DATA_HOME} = catdir($ENV{PWD}, '.data');

### use VASM::Resource::Catalog::Message + ability test
### (VASM::Resource::Catalog::Message is not a class, and can therefore not
### use can_ok)
BEGIN { 
  use_ok(
    'VASM::Resource::Catalog::Message', 
    qw/messageCatalogFind
       errorCatalogFind
       messageCatalogWrite/)
}

### messageCatalogFind
# Set locale for Hindi
$ENV{LC_ALL} = 'hi_IN.UTF-8';

my $hindiCatalog = messageCatalogFind(qw/some message/);
# Catalog is a member of the appropriate class?
isa_ok($hindiCatalog, 'VASM::Catalog::Message',
       'Hindi catalog is a VASM::Catalog::Message');
# Render some things from it and check them
is($hindiCatalog->render('greetings'), 'नमस्ते',
   'Namaste valid');
is($hindiCatalog->render('inquiry of welfare'), 'आप कैसे हैँ?', 
   'Ap kaise hai? valid');

### errorCatalogFind
# $ENV{LC_ALL} = ''; # Revert locale
# (Don't revert the locale; errorCatalogFind should find the correct file
# without our help)

# Load the error catalog
my $errorCatalog = errorCatalogFind(qw/some error/);
# Catalog is a member of the appropriate class?
isa_ok(
  $errorCatalog, 'VASM::Catalog::Error',
  'Error catalog is a VASM::Catalog::Error'
);

### messageCatalogWrite
# Write out the Hindi catalog
messageCatalogWrite($hindiCatalog, qw/some other message/);
# Is the filename correct?
is(
  scalar dataResourceFind(qw/some other message hi IN message.xml/),
  "$ENV{XDG_DATA_HOME}/vasm/some/other/message/hi/IN/message.xml",
  'messageCatalogWrite wrote to the right place'
);
