#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use Test::More tests => 4;
use File::Spec::Functions;
use VASM::Resource;

# Set up $ENV{XDG_CONFIG_HOME} and $ENV{XDG_DATA_HOME} to the working
# directory (the same directory as the test script) in '.config' and '.data'
$ENV{XDG_CONFIG_HOME} = catdir($ENV{PWD}, '.config');
$ENV{XDG_DATA_HOME} = catdir($ENV{PWD}, '.data');

### use VASM::Resource::Catalog::Menu + ability test
### (VASM::Resource::Catalog::Menu is not a class, and can therefore not use
### can_ok)
BEGIN { use_ok('VASM::Resource::Catalog::Menu',
               qw/menuFind menuWrite menuTranslate/) }

### menuFind
# $ENV{LC_ALL} = 'en_US'; # Set U.S. English locale
my $catalog = menuFind;
# Catalog is a member of the appropriate class?
isa_ok($catalog, 'VASM::Catalog::Menu', 'Catalog is a VASM::Catalog::Menu');

### menuWrite
# Made up locale: Qzrzhczakyz language for the country of Foobaristan
$ENV{LC_ALL} = 'qz_FO';
# Write out the menu catalog
menuWrite($catalog);
# Is the filename correct?
is(scalar configResourceFind(qw/menu source qz FO menu.xml/),
   "$ENV{XDG_CONFIG_HOME}/vasm/menu/source/qz/FO/menu.xml",
   'menuWrite wrote to the right place');

### menuTranslate
# Write out a translation for WindowMaker, just to make sure this works (there
# is a separate test unit for the translators)
menuTranslate($catalog, 'windowmaker');
# Is the filename correct?
is(
  scalar configResourceFind(qw/menu translation source windowmaker/),
  "$ENV{XDG_CONFIG_HOME}/vasm/menu/translation/source/windowmaker",
  'actionCatalogWrite wrote to the right place'
);

