#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use Test::More tests => 7;
use IO::Scalar;

# XML::Writer seems to think it is dealing with a tied handle?
BEGIN { package IO::Scalar; sub BINMODE {} } # UGLY HACK

### use VASM::Catalog::XorgConfig
BEGIN { use_ok('VASM::Catalog::XorgConfig') }

### Ability test
can_ok('VASM::Catalog::XorgConfig', qw/new store retrieve list parse write/);

### new
my $catalog = VASM::Catalog::XorgConfig->new;
# The catalog is a member of the appropriate class?
isa_ok($catalog, 'VASM::Catalog::XorgConfig');

### store and retrieve
# Store some things to test later
$catalog->store(foo => qw/bar baz/);
$catalog->store(bar => qw/foo baz/);
$catalog->store(baz => qw/foo bar/);

# Now retrieve some stuff and check it
is_deeply([ $catalog->retrieve('foo') ], [ qw/bar baz/ ],
          q(Datum at 'foo' contains qw/bar baz/));

### list
# Are the catalog contents valid?
is_deeply([ $catalog->list ], [ qw/foo bar baz/ ], 'Catalog contents valid');

### parse
# Instantiate an IO::Scalar containing an XML description of a catalog and
# parse it
my $xmlParseString = q{<?xml version="1.0" encoding="utf-8"?>

<xorgconfig>
  <!-- Generated by VASM -->
  <foo>
    <value>bar</value>
    <value>baz</value>
  </foo>
  <bar>
    <value>foo</value>
    <value>baz</value>
  </bar>
  <baz>
    <value>foo</value>
    <value>bar</value>
  </baz>
</xorgconfig>
};
my $xmlParseHandle = IO::Scalar->new(\$xmlParseString);
my $catalogParse = VASM::Catalog::XorgConfig->new($xmlParseHandle);

# Do $catalogParse and $catalog hold the same values?
is_deeply($catalogParse, $catalog, 'Parsed catalog valid');

### write
my $xmlWriteString; my $xmlWriteHandle = IO::Scalar->new(\$xmlWriteString);
$catalog->write($xmlWriteHandle);

# Is the written XML the same as the XML parse string? 
is($xmlWriteString, $xmlParseString, 'Written XML valid');
