#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use Test::More tests => 8;
use IO::Scalar;

# XML::Writer seems to think it is dealing with a tied handle?
BEGIN { package IO::Scalar; sub BINMODE {} } # UGLY HACK

### use VASM::Catalog::Message
BEGIN { use_ok('VASM::Catalog::Message') }

### Ability test
can_ok('VASM::Catalog::Message', qw/new store render list parse write/);

### new
my $catalog = VASM::Catalog::Message->new;
# The catalog is a member of the appropriate class?
isa_ok($catalog, 'VASM::Catalog::Message');

### store and render

# Store a few messages
$catalog->store('foo' => 'Bar!');
$catalog->store('bar' => 'Something else: %s');

# Will they render properly?
is($catalog->render('foo'), 'Bar!', 'foo message OK');
is($catalog->render('bar', 'nut'), 'Something else: nut', 'bar message OK');

### list
# Are the catalog contents valid?
is_deeply([ $catalog->list ], [ qw/foo bar/ ], 'Catalog contents valid');

### parse
# Instantiate an IO::Scalar containing an XML description of a catalog and
# parse it
my $xmlParseString = q{<?xml version="1.0" encoding="utf-8"?>

<catalog>
  <!-- Generated by VASM -->
  <message id="foo">Bar!</message>
  <message id="bar">Something else: %s</message>
</catalog>
};
my $xmlParseHandle = IO::Scalar->new(\$xmlParseString);
my $catalogParse = VASM::Catalog::Message->new(handle => $xmlParseHandle);

# Do $catalogParse and $catalog hold the same values?
is_deeply($catalogParse, $catalog, 'Parsed catalog valid');

### write
my $xmlWriteString; my $xmlWriteHandle = IO::Scalar->new(\$xmlWriteString);
$catalog->write($xmlWriteHandle);

# Is the written XML the same as the XML parse string? 
is($xmlWriteString, $xmlParseString, 'Written XML valid');
