#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use Test::More tests => 8;
use IO::Scalar;

# XML::Writer seems to think it is dealing with a tied handle?
BEGIN { package IO::Scalar; sub BINMODE {} } # UGLY HACK

### use VASM::Catalog::Action
BEGIN { use_ok('VASM::Catalog::Action') }

### Ability test
can_ok('VASM::Catalog::Action', qw/new push unshift dump exec parse write/);

### new
my $catalog = VASM::Catalog::Action->new;
# The catalog is a member of the appropriate class?
isa_ok($catalog, 'VASM::Catalog::Action');

### push, unshift, and dump
$catalog->push('emacs');
$catalog->push('terminal');
$catalog->push('seamonkey');
$catalog->unshift('true');

# The catalog contents are preserved in the right order?
is_deeply([ $catalog->dump ], [ qw/true emacs terminal seamonkey/ ],
          'Catalog contents valid');

### exec
# Does simple execution of true work?
is($catalog->exec, 0, 'exec seems to be working');
# unshift cat onto the catalog  
$catalog->unshift('cat %s 2> /dev/null');
# Give cat some bullshit options; will it exit with 1?
is($catalog->exec('-gdfdfg') >> 8, 1, 'exec IS working');

### parse
# Instantiate an IO::Scalar containing an XML description of a catalog and
# parse it
my $xmlParseString = q{<?xml version="1.0" encoding="utf-8"?>

<catalog>
  <!-- Generated by VASM -->
  <command>cat %s 2&gt; /dev/null</command>
  <command>true</command>
  <command>emacs</command>
  <command>terminal</command>
  <command>seamonkey</command>
</catalog>
};
my $xmlParseHandle = IO::Scalar->new(\$xmlParseString);
my $catalogParse = VASM::Catalog::Action->new($xmlParseHandle);

# Do $catalogParse and $catalog hold the same values?
is_deeply($catalogParse, $catalog, 'Parsed catalog valid');

### write
my $xmlWriteString; my $xmlWriteHandle = IO::Scalar->new(\$xmlWriteString);
$catalog->write($xmlWriteHandle);

# Is the wriiten XML the same as the XML parse string?
is($xmlWriteString, $xmlParseString, 'Written XML valid');
