#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use constant { false => 0, true => 1 };
use POSIX;
use VASM::Resource::Catalog::Message;
use VASM::Utility::FileSystem::WindowManager;
use UI::Dialog::Backend::CDialog;

# Message files
my $commonMsg = messageCatalogFind(qw/common message/);
my $uiMsg = messageCatalogFind(qw/xwmset ui cdialog/);
my $errorMsg = errorCatalogFind(qw/xwmset ui error/);

# Dialog instance
my $d = UI::Dialog::Backend::CDialog->new(
  backtitle => $commonMsg->render('vasm backtitle'),
  title => $uiMsg->render('title'),
  'ok-label' => $commonMsg->render('ok'),
  'cancel-label' => $commonMsg->render('exit'),
  'yes-label' => $commonMsg->render('yes'),
  'no-label' => $commonMsg->render('no'),
  width => 75,
  height => 20,
  menuheight => 10
);

sub mainMenu {
  my $directory = windowManagerDirectory;
  # Choices for main menu -- constant
  my $choices = [ 
    map { 
      $directory->_recodeString($_), $directory->render($_)
    } $directory->list
  ];

  # Prompt choice
  my $windowManager = $d->menu(
    text => $uiMsg->render('main menu description'),
    list => $choices
  );

  if ($d->state eq 'OK') {
    windowManagerAskIsGlobal($windowManager);
  } elsif ($d->state eq 'CANCEL') {
    exit EXIT_SUCCESS;
  }
}

sub windowManagerAskIsGlobal {
  my ($windowManager) = @_;

  DIALOG: {
    my $isGlobal = $d->yesno(
      text => $uiMsg->render('is global?'),
      'yes-label' => $uiMsg->render('local'),
      'no-label' => $uiMsg->render('global'),
    );
    
    # 'Local' will probably be the most common choice. In that case, I want it
    # as the 'yes' option, because it will come first. The problem with that
    # is $isGlobal goes the other way, so I will flip the value around here 
    $isGlobal = not $isGlobal;

    # Check for root identity if needs be
    if ($isGlobal) {
      unless (getpwuid $> eq 'root') {
        $d->msgbox(text => $errorMsg->render('global selection for root only'));
        redo DIALOG;
      }
    }

    # Now try to set the window manager
    windowManagerSet($windowManager, $isGlobal);
    # Confirm it
    $d->msgbox(text => $uiMsg->render('installation complete'));
  }

  return;
}

mainMenu();
