#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use POSIX;
use constant { false => 0, true => 1, pad => 2 };
use VASM::Resource::Catalog::Message;
use VASM::Utility::Gtk2::MessageDialog;
use VASM::Utility::Expect::Super;
use Gtk2 '-init';
use Expect;

# Message files
my $uiMsg = messageCatalogFind(qw/super ui gtk2/);
my $errorMsg = errorCatalogFind(qw/super ui error/);

# Localized strings from passwd will screw up my Expect patterns
$ENV{LANG} = 'C';

unless (@ARGV) {
  errorMessage($errorMsg->render('null command', $0));
  exit EXIT_FAILURE;
}

# Prompt for password (see vsuper-dialog.pl for commentary on empty passwords)
my $dialog = Gtk2::Dialog->new_with_buttons(
  $uiMsg->render('title'), undef, [],
  'gtk-cancel' => 'cancel',
  'gtk-ok' => 'ok'
);
$dialog->set_position('center');
# When user hits 'Enter', the OK button will be activated 
$dialog->set_default_response('ok');

# The actual password entry box
my $passwordEntry = Gtk2::Entry->new;
# Wouldn't want a sucka jockin' yo' password. Word.
$passwordEntry->set_visibility(false);
# Hitting Enter will activate OK button (see above)
$passwordEntry->set_activates_default(true);
$dialog->vbox->pack_start($passwordEntry, false, false, pad);

# Expander with detailed description
my $shortDescription = Gtk2::Expander->new(
  $uiMsg->render('password prompt short description')
);
my $longDescription = Gtk2::Label->new(
  $uiMsg->render('password prompt long description')
);
$longDescription->set_line_wrap(true);
$shortDescription->add($longDescription);
$dialog->vbox->pack_start($shortDescription, false, false, pad);

$dialog->show_all;
my $response = $dialog->run;
my $password = $passwordEntry->get_text;
$dialog->hide_all;
$dialog->destroy;

if ($response eq 'ok') {
  unless (super(join(' ', @ARGV), $password)) {
    errorMessage($errorMsg->carp('spawn error', $!));
    exit EXIT_FAILURE;
  }
}

exit EXIT_SUCCESS;
