#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use POSIX;
use VASM::Resource::Catalog::Message;
use VASM::Utility::Expect::Super;
use UI::Dialog::Backend::CDialog;

# Message files
my $commonMsg = messageCatalogFind(qw/common message/);
my $uiMsg = messageCatalogFind(qw/super ui cdialog/);
my $errorMsg = errorCatalogFind(qw/super ui error/);

# Dialog instance
my $d = UI::Dialog::Backend::CDialog->new(
  backtitle => $commonMsg->render('vasm backtitle'),
  title => $uiMsg->render('title'),
  'ok-label' => $commonMsg->render('ok'),
  'cancel-label' => $commonMsg->render('exit'),
  'yes-label' => $commonMsg->render('yes'),
  'no-label' => $commonMsg->render('no'),
  width => 75,
  height => 12,
  menuheight => 10
);

unless (@ARGV) {
  # Report error and exit
  $d->msgbox(text => $errorMsg->render('null command', $0));

  exit EXIT_FAILURE;
}

# Prompt for password...don't worry about blank entries; some people set
# up their root account like that. Their indiscretion is not taken into
# account here, though. Heh.
my $password = $d->password(text => $uiMsg->render('password prompt'));

# Act on the input
if ($d->state eq 'OK') {
  unless (super(join(' ', @ARGV), $password)) {
    # Report error and exit
    $d->msgbox(text => $errorMsg->carp('spawn error', $!));

    exit EXIT_FAILURE;
  }
}

exit EXIT_SUCCESS;
