#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use constant { false => 0, true => 1 };
use VASM::Utility::FileSystem::Skeleton;
use VASM::Resource::Catalog::Message;
use UI::Dialog::Backend::CDialog;
use POSIX;

# Message files
my $commonMsg = messageCatalogFind(qw/common message/);
my $uiMsg = messageCatalogFind(qw/skel ui cdialog/);
my $errorMsg = errorCatalogFind(qw/skel ui error/);

# Dialog instance
my $d = UI::Dialog::Backend::CDialog->new(
  backtitle => $commonMsg->render('vasm backtitle'),
  title => $uiMsg->render('title'),
  'ok-label' => $commonMsg->render('ok'),
  'cancel-label' => $commonMsg->render('exit'),
  'yes-label' => $commonMsg->render('yes'),
  'no-label' => $commonMsg->render('no'),
  width => 75,
  height => 20,
  menuheight => 10
);

sub mainMenu {
  # Get the directory of skeleton components
  my $directory = skeletonDirectory;

  # Choices for checklist below
  my $choices = [
    map {
      $directory->_recodeString($_), [ $directory->render($_), false ]
    } $directory->list
  ];
  
  my @components = $d->checklist(
    text => $uiMsg->render('main menu description'),
    list => $choices
  );

  if ($d->state eq 'OK') {
    # Try to install these components
    my $successful = skeletonInstall(@components);

    if ($successful) {
      $d->msgbox(text => $uiMsg->render('installation complete'));
      exit EXIT_SUCCESS;
    } else {
      $d->msgbox(text => $errorMsg->render('installation failed'));
      exit EXIT_FAILURE;
    }
  }
  
  exit EXIT_SUCCESS;
}

mainMenu();
