#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use POSIX;
use constant { false => 0, true => 1, pad => 2 };
use VASM::Resource::Catalog::Message;
use VASM::Utility::Expect::Password;
use VASM::Utility::Gtk2::MessageDialog;
use Gtk2 '-init';
use Expect;

# Message files
my $commonMsg = messageCatalogFind(qw/common message/);
my $uiMsg = messageCatalogFind(qw/passwd ui gtk2/);
my $errorMsg = messageCatalogFind(qw/passwd ui error/);

sub passwordChange {
  # If user argument be given, check if user is root; otherwise flag error
  if (defined $ARGV[0] and not getpwuid $> eq 'root') {
    errorMessage($errorMsg->render('user selection for root only'));
    exit EXIT_FAILURE;
  }

  # Generate an instance of passwd
  my $passwdProcess = VASM::Utility::Expect::Password->new($ARGV[0]);

  # In the event that there user does not exist
  unless (defined $passwdProcess) {
    errorMessage($errorMsg->render('user does not exist'));
    exit EXIT_FAILURE;
  }

  my @promptMessages = qw/old new confirm/;
  my $passwdErrors = [
    [ 'incorrect password' ],
    [ 'too many tries', 'new password unsatisfactory' ],
    [ 'too many tries', 'passwords do not match' ]
  ];

  my $status = $passwdProcess->status;
  
  until ($status == success) {
    my $lastStatus = $status;
    my $password = passwordAsk(
      $passwdProcess->username, "$promptMessages[$status] password prompt"
    );
    $status = $passwdProcess->submit($password);

    # Unless the new value of $status is larger than $lastStatus, an error has
    # occured; we can find this error with the values of $lastStatus and
    # $status
    errorMessage($errorMsg->render($passwdErrors->[$lastStatus][$status]))
      unless $status > $lastStatus;
  }

  # Confirm password installation
  infoMessage($uiMsg->render('password changed'));

  exit EXIT_SUCCESS;
}

sub passwordAsk {
  my ($username, $message) = @_;
  
  # Prompt for password of user %s
  my $dialog = Gtk2::Dialog->new_with_buttons(
    $uiMsg->render('title'), undef, [],
    'gtk-cancel' => 'cancel',
    'gtk-ok' => 'ok'
  );
  $dialog->set_position('center');
  # When user hits 'Enter', the OK button will be activated 
  $dialog->set_default_response('ok');

  # The actual password entry box
  my $passwordEntry = Gtk2::Entry->new;
  # Wouldn't want a sucka jockin' yo' password. Word.
  $passwordEntry->set_visibility(false);
  # Hitting Enter will activate OK button (see above)
  $passwordEntry->set_activates_default(true);
  $dialog->vbox->pack_start($passwordEntry, false, false, pad);

  # Description of dialog
  my $description = Gtk2::Label->new($uiMsg->render($message, $username));
  $description->set_line_wrap(true);
  $dialog->vbox->pack_start($description, false, false, pad);

  $dialog->show_all;
  my $response = $dialog->run;
  my $password = $passwordEntry->get_text;
  $dialog->destroy;

  $response eq 'ok' ? return $password : exit EXIT_SUCCESS;
}

passwordChange();
