#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use POSIX;
use constant { false => 0 };
use VASM::Resource::Catalog::Message;
use VASM::Utility::Expect::Password;
use UI::Dialog::Backend::CDialog;
use Expect;

# Don't show the stdout of programs; it looks sloppy.
$Expect::Log_Stdout = false;

# Message files
my $commonMsg = messageCatalogFind(qw/common message/);
my $uiMsg = messageCatalogFind(qw/passwd ui cdialog/);
my $errorMsg = messageCatalogFind(qw/passwd ui error/);

# Dialog instance
my $d = UI::Dialog::Backend::CDialog->new(
  backtitle => $commonMsg->render('vasm backtitle'),
  title => $uiMsg->render('title'),
  'ok-label' => $commonMsg->render('ok'),
  'cancel-label' => $commonMsg->render('exit'),
  'yes-label' => $commonMsg->render('yes'),
  'no-label' => $commonMsg->render('no'),
  width => 75,
  height => 10,
  menuheight => 10
);

sub passwordChange {
  # If user argument be given, check if user is root; otherwise flag error
  if (defined $ARGV[0] and not getpwuid $> eq 'root') {
    $d->msgbox(text => $errorMsg->render('user selection for root only'));
    exit EXIT_FAILURE;
  }

  # Generate an instance of passwd
  my $passwdProcess = VASM::Utility::Expect::Password->new($ARGV[0]);
  
  # In the event that there user does not exist
  unless (defined $passwdProcess) {
    $d->msgbox(text => $errorMsg->render('user does not exist'));
    exit EXIT_FAILURE;
  }

  my @promptMessages = qw/old new confirm/;
  my $passwdErrors = [
    [ 'incorrect password' ],
    [ 'too many tries', 'new password unsatisfactory' ],
    [ 'too many tries', 'passwords do not match' ]
  ];

  my $status = $passwdProcess->status;
  
  until ($status == success) {
    my $lastStatus = $status;
    my $password = passwordAsk(
      $passwdProcess->username, "$promptMessages[$status] password prompt"
    );
    $status = $passwdProcess->submit($password);

    # Unless the new value of $status is larger than $lastStatus, an error has
    # occured; we can find this error with the values of $lastStatus and
    # $status
    $d->msgbox(
      text => $errorMsg->render($passwdErrors->[$lastStatus][$status])
    ) unless $status > $lastStatus;
  }

  # Confirm password installation
  $d->msgbox(text => $uiMsg->render('password changed'));

  exit EXIT_SUCCESS;
}

sub passwordAsk {
  my ($username, $message) = @_;
  
  my $password = $d->password(text => $uiMsg->render($message, $username));
  
  exit EXIT_SUCCESS unless $d->state eq 'OK'; # Cancelled
  return $password; # Otherwise...
}

passwordChange(); 
