#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use constant { false => 0, true => 1 };
use POSIX;
use VASM::Resource::Navigator;
use VASM::Resource::Catalog::Message;
use VASM::Utility::FileSystem::Which;
use UI::Dialog::Backend::CDialog;

# Message files
my $commonMsg = messageCatalogFind(qw/common message/);
my $uiMsg = messageCatalogFind(qw/navigator ui cdialog/);
my $errorMsg = errorCatalogFind(qw/navigator ui error/);

# Dialog instance
my $d = UI::Dialog::Backend::CDialog->new(
  backtitle => $commonMsg->render('vasm backtitle'),
  title => $uiMsg->render('title'),
  'ok-label' => $commonMsg->render('ok'),
  'cancel-label' => $commonMsg->render('exit'),
  'yes-label' => $commonMsg->render('yes'),
  'no-label' => $commonMsg->render('no'),
  width => 75,
  height => 20,
  menuheight => 10
);

## If program can't run, it may be DISPLAY

sub navigatorMenu {
  my $navigatorTree = navigatorTree;
  my $navigatorDirectory = navigatorDirectory;

  _navigatorMenu($navigatorTree, $navigatorDirectory, true);
}

sub _navigatorMenu {
  # Notice the subtle difference between navigatorTree and navigatorMenu, when
  # they (initially) refer to exactly the same thing
  my ($navigatorMenu, $navigatorDirectory, $topLevel) = @_;

  # This was big enough to be factored out. Ouch.
  my $choices = navigatorMenuChoicesGenerate(
    $navigatorMenu, $navigatorDirectory
  );
  
  my @buttonBack; @buttonBack = (
    'extra-button' => true, 
    'extra-label' => $commonMsg->render('back')
  ) if not $topLevel;

  while (true) {
    my $choice = $d->menu(
      text => $uiMsg->render('navigator menu description'),
      list => $choices,
      @buttonBack
    );

    if ($d->state eq 'OK') {
      # If the user selected a folder
      if (ref $navigatorMenu->{$choice} eq 'HASH') {
        # Recurse here
        _navigatorMenu($navigatorMenu->{$choice}, $navigatorDirectory);
      }
      # If the user selected an item
      else {
        my $commandString = whichVasm($choice);
        if (defined $commandString) {
          exit system $commandString;
        } else {
          $d->msgbox(
            text => $errorMsg->render('vasm command not found')
          );
          exit EXIT_FAILURE;
        }
      }
    } elsif ($d->state eq 'EXTRA') {
      return;
    } elsif ($d->state eq 'CANCEL') {
      exit EXIT_SUCCESS;
    }
  }
}

sub navigatorMenuChoicesGenerate {
  my ($navigatorMenu, $navigatorDirectory) = @_;

  # Generate menu -- first, do the folders
  my @choicesFolders = map {
    $navigatorDirectory->_recodeString($_), 
    $navigatorDirectory->render($_)
  } grep {
    ref $navigatorMenu->{$_} eq 'HASH'
  } keys %{ $navigatorMenu };

  # Items next, also sorted
  my @choicesItems = map {
    $navigatorDirectory->_recodeString($_), 
    $navigatorDirectory->render($_)
  } grep {
    not ref $navigatorMenu->{$_}
  } sort keys %{ $navigatorMenu };
  
  return [ @choicesFolders, @choicesItems ];
}

navigatorMenu();
