#!/usr/bin/perl

use strict;
use warnings;
use VASM::Resource::Catalog::Menu;
use VASM::Resource::Catalog::Message;

my $errorMsg = errorCatalogFind(qw/menu ui error/);

# Dig up the catalog
my $catalog = menuFind;

# Make sure it exists
unless (defined $catalog) {
  print $errorMsg->render('no menu catalog'), "\n";
  exit 1;
}

# If it does, produce a translation for each known window manager
for my $wm (qw/fluxbox icewm windowmaker xfce4/) {
  menuTranslate($catalog, $wm);
}

exit 0;
