#!/usr/bin/perl
# -*- project-name: VASM -*-

# Consider restricting $PATH
use strict;
use warnings;
use POSIX;
use VASM::Resource::Catalog::Message;
use VASM::Utility::FileSystem::Which;

my $errorMsg = errorCatalogFind(qw/launch ui error/);
local $\ = "\n";

# Make sure a program to be launched was given as an argument -- cannot be
# vlaunch itself
unless (defined $ARGV[0]) {
  print $errorMsg->render('no command given', $0);
  exit EXIT_FAILURE;
}

if ($ARGV[0] eq 'vlaunch') {
  print $errorMsg->render('spurious vlaunch recursion');
  exit EXIT_FAILURE;
}

# Let whichVasm do its thing
my $commandLine = whichVasm($ARGV[0]);
# Exit with the same exit code as program, if at all possible
exit system $commandLine; # Pass args?
